#include <stdio.h>

#include <iostream>
#include <iomanip>
#include <conio.h>
#include <vector>
#include <fstream>
#include <sstream>
#include "dll_app.h"

/*#include <boost/program_options.hpp>
namespace po = boost::program_options;
#include <boost/program_options/value_semantic.hpp>*/
#include <cstdlib>

// PT2 DLL header file

#include "..\APIHeader\PT2_DLL.h"

using namespace std;

extern HMODULE gLoadLib ;

//GPIO 
pfMchpUsbConfigureGPIO libMchpUsbConfigureGPIO;
pfMchpUsbGpioGet libMchpUsbGpioGet;
pfMchpUsbGpioSet libMchpUsbGpioSet;

/**************** GPIO Bridging PSEUDO CODE ****************************************************
 *	1. GET List of Hubs connected to system by using MchpUsbGetAllHubs API
 *	IF hubcount
 *		Display connected hub list
 *	ELSE
 *		Zero Hub connected
 *	ENDIF
 *
 * 2. OPEN Hub using either MchpUsbOpen or MchpUsbOpenID or  MchpUsbHCEOpen
 *	IF INVALID_HANDLE_VALUE
 *		Return ErrorCode
 *	ENDIF
 * 3. CONFIGURE PIO line for General Purpose input/output using MchpUsbConfigureGPIO API
 *	IF ValidPIO
 *		Configure as GPIO
 *	ELSE	
 *		Return ErrorCode
 *	ENDIF
 *
 * 4. GET state of Specified GPIO Number using MchpUsbGpioGet API
 * 5. SET state of GPIO pin as low/high using MchpUsbGpioSet API
*************************************************************************************************/

BOOL RUNGPIOTests(HANDLE hDevice)
{
	printf("***************************************************\n");
	printf("\t\tGPIO Bridging\t\t\t\t\n");
	printf("***************************************************\n");
	
	libMchpUsbConfigureGPIO		=	(pfMchpUsbConfigureGPIO) GetProcAddress ( gLoadLib ,"MchpUsbConfigureGPIO");
	libMchpUsbGpioGet			=	(pfMchpUsbGpioGet) GetProcAddress ( gLoadLib ,"MchpUsbGpioGet");
	libMchpUsbGpioSet			=	(pfMchpUsbGpioSet) GetProcAddress ( gLoadLib ,"MchpUsbGpioSet");
	
	//Configure pin number 11 as GPIO
	//configures the specified PIO line for general purpose input/output
	int PIONumber=11;
	if (FALSE ==libMchpUsbConfigureGPIO(hDevice,PIONumber))
	{
			printf ("Failed to Configure Specified PIO Line for GPIO \n");
			return FALSE;
	}

	//GPIO get
	//gets the state of the specified GPIO pin
 
	int PINState=0;
 
	if (FALSE == libMchpUsbGpioGet (hDevice,PIONumber,&PINState))
 	{
		printf ("Failed to get state of specified GPIO Pin \n");
		return FALSE;
	}

	//GPIO set
	//sets the state of the specified GPIO pin with the state mentioned in Pinstate
	PINState=1;
	if (FALSE == libMchpUsbGpioSet (hDevice,PIONumber,PINState))
	{
		printf ("Failed to set the state of specified GPIO Pin \n");
		return FALSE;
	}
	printf ("GPIO Tests : PASS\n");
	return TRUE;
}