#include <stdio.h>

#include <iostream>
#include <iomanip>
#include <conio.h>
#include <vector>
#include <fstream>
#include <sstream>
#include "dll_app.h"

/*#include <boost/program_options.hpp>
namespace po = boost::program_options;
#include <boost/program_options/value_semantic.hpp>*/
#include <cstdlib>

// PT2 DLL header file

#include "..\APIHeader\PT2_DLL.h"



using namespace std;

extern HMODULE gLoadLib;

pfMchpUsbSpiSetConfig libMchpUsbSpiSetConfig;
pfMchpUsbSpiFlashWrite libMchpUsbSpiFlashWrite;
pfMchpUsbSpiFlashRead libMchpUsbSpiFlashRead;
pfMchpUsbSpiTransfer libMchpUsbSpiTransfer;

BOOL RUNSPITests(HANDLE hDevice)
{
	printf("***************************************************\n");
	printf("\t\tSPI Bridging\t\t\t\t\n");
	printf("***************************************************\n");

	libMchpUsbSpiSetConfig = (pfMchpUsbSpiSetConfig)  GetProcAddress ( gLoadLib ,"MchpUsbSpiSetConfig");
	libMchpUsbSpiFlashWrite	=(pfMchpUsbSpiFlashWrite) GetProcAddress ( gLoadLib ,"MchpUsbSpiFlashWrite");
	libMchpUsbSpiFlashRead =(pfMchpUsbSpiFlashRead) GetProcAddress ( gLoadLib ,"MchpUsbSpiFlashRead");
	libMchpUsbSpiTransfer = (pfMchpUsbSpiTransfer) GetProcAddress ( gLoadLib ,"MchpUsbSpiTransfer");

	HANDLE hBinFile;
    UINT8 byFirmwareData[64*1024];
    UINT8 byReadFirmwareData[64*1024];
    UINT32 dwActualSize = 0;


	//Mention bin file
	hBinFile = CreateFile ("spi_firmware.bin", GENERIC_READ, FILE_SHARE_READ,
                        NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if (INVALID_HANDLE_VALUE == hBinFile)
    {
        return FALSE;
	}
	// Allow maxm_fw_size or dwActualsize whichever is small
    if (FALSE == ReadFile (hBinFile, &byFirmwareData[0], sizeof(byFirmwareData) ,(LPDWORD) &dwActualSize, NULL))
    {
        CloseHandle (hBinFile);
	}

	CloseHandle (hBinFile);
    if (FALSE  == libMchpUsbSpiFlashWrite(hDevice,0x0,&byFirmwareData[0],dwActualSize))
    {
        printf ("Failed to Write SPI Error \n");
        return FALSE;
	}
	if (FALSE  == libMchpUsbSpiFlashRead(hDevice,0x0,&byReadFirmwareData[0],dwActualSize))
    {
        printf ("Failed to Write SPI Error\n");
        return FALSE;
    }
	if (memcmp(byReadFirmwareData,byFirmwareData,10))
    {
        printf ("Read and write comparison failed");
		return FALSE;
 	}
	
	//enables/disables the SPI interface
	//Enter into SPI Pass thru
    if (FALSE == libMchpUsbSpiSetConfig(hDevice,1))
	{
		printf ("MchpUsbSpiSetConfig failed \n");
	    return FALSE;
	}

	UINT8 bySPIBuffer[4];
    UINT8 byOpcodeGetJEDECID = 0x9f;

    //Write 0x9f to get JEDEC ID, Datalen is 1
    //Totally 4 bytes will be retrived as jedec id, give total length as 4
    if(FALSE == libMchpUsbSpiTransfer(hDevice,0,&byOpcodeGetJEDECID,1,4))
    {
        printf ("MchpUsbSpiTransfer failed\n");
		return FALSE;
    }

	//Read 4 bytes of JEDEC ID
    if(FALSE == libMchpUsbSpiTransfer(hDevice,1,&bySPIBuffer[0],4,4))
    {
        printf ("MchpUsbSpiTransfer failed\n");
		return FALSE;
 
    }
    //exit from spi config
    if (FALSE == libMchpUsbSpiSetConfig(hDevice,0))
    {
        printf ("MchpUsbSpiSetConfig failed\n");
		return FALSE;
	}
	printf ("SPI Test : PASS\n");
	return TRUE;
}