#include <stdio.h>

#include <iostream>
#include <iomanip>
#include <conio.h>
#include <vector>
#include <fstream>
#include <sstream>
#include "dll_app.h"

/*#include <boost/program_options.hpp>
namespace po = boost::program_options;
#include <boost/program_options/value_semantic.hpp>*/
#include <cstdlib>

// PT2 DLL header file

#include "..\APIHeader\PT2_DLL.h"


using namespace std;

extern HMODULE gLoadLib;

pfMchpUsbUartReadTimeOut libMchpUsbUartReadTimeOut;
pfMchpUsbUartRead libMchpUsbUartRead;
pfMchpUsbUartWrite libMchpUsbUartWrite;
pfMchpUsbSetUARTBaudrate libMchpUsbSetUARTBaudrate;
pfMchpUsbEnableUARTBridging libMchpUsbEnableUARTBridging;



BOOL RUNUARTTests(HANDLE hDevice)
{

	libMchpUsbUartReadTimeOut = (pfMchpUsbUartReadTimeOut) GetProcAddress ( gLoadLib ,"MchpUsbUartReadTimeOut");
	libMchpUsbUartRead = (pfMchpUsbUartRead) GetProcAddress ( gLoadLib ,"MchpUsbUartRead");
	libMchpUsbUartWrite  = (pfMchpUsbUartWrite ) GetProcAddress ( gLoadLib ,"MchpUsbUartWrite");
	libMchpUsbSetUARTBaudrate = (pfMchpUsbSetUARTBaudrate) GetProcAddress ( gLoadLib ,"MchpUsbSetUARTBaudrate");
	libMchpUsbEnableUARTBridging = (pfMchpUsbEnableUARTBridging) GetProcAddress ( gLoadLib ,"MchpUsbEnableUARTBridging");

	printf("***************************************************\n");
	printf("\t\tUART Bridging\t\t\t\t\n");
	printf("***************************************************\n");

	//Enable UART Bridging
	if (FALSE == libMchpUsbEnableUARTBridging(hDevice,TRUE))
    {
        printf ("Failed to Enable UART\n");
		return FALSE;
	}

	// configure the baud rate for serial communication.
	if (FALSE == libMchpUsbSetUARTBaudrate(hDevice,9600))
    {
        printf ("Failed to set Braud rate\n");
		return FALSE;
    }

	UINT8 byDataUART [4] = {0x60,0x61,0x62,0x64};
	//transfer data through serial port to the connected serial peripheral.
    if (FALSE == libMchpUsbUartWrite(hDevice,4,&byDataUART[0]))
    {
        printf ("Uart Write failed \n");
       return FALSE;
    }
	UINT8 byDataUART1 [5];
	//receives data through serial port from the connected serial peripheral
    if (FALSE == libMchpUsbUartReadTimeOut(hDevice,4,&byDataUART1[0],5000))
    {
        printf ("Uart Read failed\n");
		return FALSE;
    }
 
	//Disable UART bridging
    if (FALSE == libMchpUsbEnableUARTBridging(hDevice,FALSE))
    {
        printf ("Failed to Disable UART\n");
		return FALSE;
	}
	printf ("UART test: Pass\n");
	return TRUE;
}
