#pragma once

#include "../APIHeader/PT2_DLL.h"


/*******************************************************************************************************************/
/*												Common															  */
/*****************************************************************************************************************/
typedef void  (*pfMchpEnableLogging) (INT);
typedef BOOL (*pfMchpUsbGetVersion) (PCHAR );

/*******************************************************************************************************************/ 
/*												USB																   */
/*******************************************************************************************************************/
//Device OPEN/CLOSE
typedef INT (*pfMchpUsbGetAllHubs) (PCHAR);
typedef HANDLE (*pfMchpUsbOpenID) (UINT16,UINT16);
typedef HANDLE (*pfMchpUsbOpen) (CONST UINT);
typedef BOOL (*pfMchpUsbClose) (HANDLE);
typedef HANDLE  (*pfMchpUsbHCEOpen) (UINT16,UINT16);

//Miscellaneous
typedef UINT32  (*pfMchpUsbGetLastErr) (HANDLE);
typedef BOOL (*pfMchpVerifyWidgetValues) (HANDLE,PCHAR,PCHAR);
typedef BOOL (*pfMchpUsbVSMTransfer)(CONST UINT,UINT8,UINT8*,UINT8,UINT16,UINT16,UINT16);
typedef BOOL (*pfMchpUsbHCETransfer) (HANDLE,UINT8,UINT8*,UINT8,UINT16,UINT16,UINT16);
typedef BOOL (*pfMchpUsbDeviceReset) (HANDLE);

//Flexconnect
typedef BOOL (*pfMchpUsbFlexConnect) (HANDLE, UINT16);

//GPIO
typedef BOOL (*pfMchpUsbConfigureGPIO) (HANDLE,INT);
typedef BOOL (*pfMchpUsbGpioGet) (HANDLE, INT, INT*);
typedef BOOL (*pfMchpUsbGpioSet) (HANDLE, INT, INT);

//I2C
typedef BOOL (*pfMchpUsbI2CSetConfig) (HANDLE,INT, INT);
typedef BOOL (*pfMchpUsbI2CRead) (HANDLE, INT, UINT8*, UINT8);
typedef BOOL (*pfMchpUsbI2CWrite) (HANDLE, INT, UINT8*, UINT8);
typedef BOOL (*pfMchpUsbI2CTransfer) (HANDLE, BOOL , UINT8*, UINT16, UINT8,BOOL,BOOL,BOOL);

//OTP
typedef BOOL  (*pfMchpUsbOtpWrite) ( HANDLE , UINT, UINT8*);
typedef BOOL (*pfMchpUsbOtpRead) ( HANDLE , UINT, UINT , UINT8*);

//Program
typedef BOOL (*pfMchpProgramFile) (HANDLE,PCHAR);
typedef BOOL (*pfMchpProgramFileWithSerial) (HANDLE,PCHAR,PCHAR);
typedef BOOL (*pfMchpProgramSPIFile) (HANDLE,PCHAR,BOOL);
typedef BOOL (*pfMchpProgramSPIFirmwareWithConfig)(HANDLE,BOOL,PCHAR,PCHAR);
typedef BOOL (*pfMchpUsbProgramFileWithUsb3Serial) (HANDLE,PCHAR, PCHAR,PCHAR);
typedef BOOL (*pfMchpProgramSpiFwCfgFileWithSerial) (HANDLE,BOOL,PCHAR,PCHAR,PCHAR);


//SPI
typedef BOOL (*pfMchpUsbSpiSetConfig) (HANDLE, INT);
typedef BOOL (*pfMchpUsbSpiFlashWrite)(HANDLE,UINT32 ,UINT8*, UINT32 );
typedef BOOL (*pfMchpUsbSpiFlashRead)(HANDLE,UINT32 ,UINT8*, UINT32 );
typedef BOOL (*pfMchpUsbSpiTransfer)(HANDLE,INT,UINT8*, UINT16,UINT32);


//UART
typedef BOOL (*pfMchpUsbUartReadTimeOut)  (HANDLE, UINT32,UINT8*, UINT32);
typedef BOOL (*pfMchpUsbUartRead)  (HANDLE, UINT32,UINT8* );
typedef BOOL (*pfMchpUsbUartWrite) (HANDLE ,UINT32, UINT8 *);
typedef BOOL (*pfMchpUsbSetUARTBaudrate)(HANDLE, UINT32 );
typedef BOOL (*pfMchpUsbEnableUARTBridging) (HANDLE , BOOL );

//Xdata Bridging
typedef BOOL  (*pfMchpUsbRegisterRead) ( HANDLE ,UINT16 , UINT16 , UINT8* );
typedef BOOL  (*pfMchpUsbRegisterWrite) ( HANDLE,UINT16, UINT16, UINT8* );


/***********************************************************************************************************************/
/*														LAN															  */
/*********************************************************************************************************************/
//Open/Close
typedef INT (*pfMchpLanGetDevices) (PCHAR);
typedef HANDLE (*pfMchpLanOpen) (UINT32);
typedef HANDLE (*pfMchpLanOpenID) (UINT16,UINT16,UINT8*);
typedef void (*pfMchpLanClose) (HANDLE);
typedef void (*pfMchpLanCloseAllHandles)();


//Program
typedef BOOL (*pfMchpLanProgramFile)(HANDLE,UINT,PCHAR,PCHAR);
typedef BOOL (*pfMchpLanProgramFileWithSerial)(HANDLE,UINT,PCHAR,PCHAR,PCHAR);

//ReadMem
typedef BOOL (*pfMchpLanReadMemory)(HANDLE,UINT,UINT8*,UINT16,UINT);

//Read/write 
typedef BOOL (*pfMchpLanRegisterRead)(HANDLE,UINT32, UINT32, UINT32*);
typedef BOOL (*pfMchpLanRegisterWrite)(HANDLE,UINT32, UINT32, UINT32*);
typedef BOOL (*pfMchpLanPhyRegisterRead)(HANDLE,UINT32, UINT32, UINT16*);
typedef BOOL (*pfMchpLanPhyRegisterWrite)(HANDLE,UINT32, UINT32, UINT16*);

//Verify
typedef BOOL (*pfMchpLanVerifyParameters)(HANDLE,PCHAR,PCHAR);

//Miscellaneous
typedef BOOL (*pfMchpLanGetDriverVersion)(void*);
typedef BOOL (*pfMchpLanGetAdapterBits)(void*);
typedef BOOL (*pfMchpLanGetAdapterKey)(HANDLE,void*);
typedef BOOL (*pfMchpLanGetAdapterPort)(HANDLE,void*);
typedef BOOL (*pfMchpLanGetAdapterPDO)(HANDLE, void*);
typedef BOOL (*pfMchpLanReadTxRxStat)(HANDLE, void*);
typedef BOOL (*pfMchpLanReadUsbPhyStat)(HANDLE, void*);
typedef BOOL (*pfMchpLanEepromConfigureCommand)(HANDLE, UINT32);
typedef BOOL (*pfMchpLanReadEepromByte)(HANDLE,UINT16, UINT8*);
typedef BOOL (*pfMchpLanWriteEepromByte)(HANDLE, UINT16, UINT8*);
typedef BOOL (*pfMchpLanEraseEeprom)(HANDLE);
typedef BOOL (*pfMchpLanGetEepromSize)(HANDLE, INT*);
typedef BOOL (*pfMchpLanOtpConfigureCommand)(HANDLE, UINT32); 
typedef UINT32 (*pfMchpLanGetLastErr)(HANDLE);

//To Run Sample application for LAN 
void MchpLanSampleApp();

//To Run Sample application for USB
void MchpUsbSampleApp();

//USB: Flexconnect
BOOL RUNFLEXCONNECT(HANDLE hDevice);

//USB: GPIO
BOOL RUNGPIOTests(HANDLE hDevice);

//USB: I2C
BOOL RUNI2CTests(HANDLE hDevice);

//USB: OTP
BOOL RUNOTPTests(HANDLE hDevice);

//USB: Program config file
BOOL ProgramFile(HANDLE hDevice,char *InputFileName);

//USB: Program SPI Firmware
BOOL ProgramSPIFile(HANDLE hDevice,char *SPIFileName);

//USB: Program Config + serial
BOOL ProgramFileWithSerial(HANDLE hDevice,char *InputFileName,char *pchSerialNo);

//USB: Program config + USB2, USB3 serial
BOOL ProgramFileWithUsb3Serial(HANDLE hDevice,char *InputFileName,char *pchSerialNo,char *pchusb3SerialNo);

//USB: Program SPI firmware + config 
BOOL ProgramSPIFirmwareWithConfig(HANDLE hDevice,char *SPIFileName,char *InputFileName);

//USB: Program SPI Firmware + config + serial
BOOL ProgramSPIFirmwareCfgWithSerial(HANDLE hDevice,char *SPIFileName,char *InputFileName,char *pchSerialNo);

//USB: SPI
BOOL RUNSPITests(HANDLE hDevice);

//USB: UART
BOOL RUNUARTTests(HANDLE hDevice);

//USB: XDATA 
BOOL RUNXDATATests(HANDLE hDevice);

