#include <stdio.h>

#include <iostream>
#include <iomanip>
#include <conio.h>
#include <vector>
#include <fstream>
#include <sstream>

/*#include <boost/program_options.hpp>
namespace po = boost::program_options;
#include <boost/program_options/value_semantic.hpp>*/
#include <cstdlib>
#include <string>
#include "dll_app.h"

// PT2 DLL header file
#include "../APIHeader/PT2_DLL.h"

extern HMODULE gLoadLib ;

//Device Open/Close
pfMchpUsbGetAllHubs libMchpUsbGetAllHubs;
pfMchpUsbOpen libMchpUsbOpen;
pfMchpUsbOpenID libMchpUsbOpenID;
pfMchpUsbClose libMchpUsbClose;
pfMchpUsbHCEOpen libMchpUsbHCEOpen;

//Miscellaneous
pfMchpUsbGetLastErr libMchpUsbGetLastErr;
pfMchpVerifyWidgetValues libMchpVerifyWidgetValues;
pfMchpUsbDeviceReset libMchpUsbDeviceReset;
pfMchpUsbVSMTransfer libMchpUsbVSMTransfer;
pfMchpUsbHCETransfer libMchpUsbHCETransfer;

void MchpUsbSampleApp()
{
	 try
	 {
		CHAR sztext[2048];
		UINT32 dwError = Error_Success;

		//Device Open/close
		libMchpUsbGetAllHubs		= (pfMchpUsbGetAllHubs) GetProcAddress ( gLoadLib ,"MchpUsbGetAllHubs");
		libMchpUsbOpen				= (pfMchpUsbOpen) GetProcAddress ( gLoadLib ,"MchpUsbOpen");
		libMchpUsbOpenID			= (pfMchpUsbOpenID) GetProcAddress ( gLoadLib ,"MchpUsbOpenID");
		libMchpUsbHCEOpen			= (pfMchpUsbHCEOpen) GetProcAddress ( gLoadLib ,"MchpUsbHCEOpen");
		libMchpUsbClose				= (pfMchpUsbClose) GetProcAddress ( gLoadLib ,"MchpUsbClose");


		//Miscellaneous
		libMchpUsbGetLastErr		= (pfMchpUsbGetLastErr) GetProcAddress ( gLoadLib ,"MchpUsbGetLastErr");
		libMchpVerifyWidgetValues	= (pfMchpVerifyWidgetValues)  GetProcAddress ( gLoadLib ,"MchpVerifyWidgetValues");
		libMchpUsbDeviceReset		= (pfMchpUsbDeviceReset) GetProcAddress ( gLoadLib ,"MchpUsbDeviceReset");
		libMchpUsbVSMTransfer		= (pfMchpUsbVSMTransfer) GetProcAddress ( gLoadLib ,"MchpUsbVSMTransfer");
		libMchpUsbHCETransfer		= (pfMchpUsbHCETransfer) GetProcAddress ( gLoadLib ,"MchpUsbHCETransfer");

		int hub_count = 0;

		//hub index to process
		UINT HubIndex=0;

		//get all hubs
		hub_count =  libMchpUsbGetAllHubs(sztext);

		// open device
		if(hub_count)
		{
			printf ("Connected usb hubs are ..");
			printf ("%s",sztext);
			printf("Selected hub_index is %d", HubIndex );
		}
		else
		{
			printf ("zero hubs found \n");
			printf ("\n Press any key to exit....");
			_getch ();
			exit (EXIT_FAILURE);
		}
		HANDLE hDevice =  INVALID_HANDLE_VALUE;

		hDevice = libMchpUsbOpen(HubIndex);

		if(INVALID_HANDLE_VALUE == hDevice)
		{
			dwError = libMchpUsbGetLastErr((HANDLE)HubIndex);
			printf ("Error,%04xn",dwError);
			printf ("nPress any key to exit....");
			_getch ();
			exit (EXIT_FAILURE);
		}
		printf("Device Opened successfully \n");

		int ch = 'n';
		printf("USB - Flexconnect Test: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//Flexconnect
		while (1) 
		{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					if(!RUNFLEXCONNECT(hDevice))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Flexconnect Test Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("Flexconnect Test PASS \n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}else {
					printf("Invalid input.Flexconnect Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
		}
		
		printf("USB - GPIO Test: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//GPIO
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
				if(!RUNGPIOTests(hDevice))
				{
					dwError = libMchpUsbGetLastErr(hDevice);
					printf("GPIO Test Failed \n");
					printf ("nPress any key to exit....");
					_getch ();
					exit (EXIT_FAILURE);
				}
				else
				{
					printf("GPIO Test PASS \n");
					break;
				}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			}else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.GPIO Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - I2C Test:Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//I2C
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!RUNI2CTests(hDevice))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("I2C Test Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("I2C Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.I2C Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}

		printf("USB - OTP Test:Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
		//OTP
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!RUNOTPTests(hDevice))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("OTP Test Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("OTP Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.OTP Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - Program Config file: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//Program config file
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!ProgramFile(hDevice,"bConfig.cfg"))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Program Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("ProgramFile Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.Program Config file: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		

		printf("USB - Program SPI Firmware: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//Program SPI Firmware
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!ProgramSPIFile(hDevice,"SPIFirmware.bin"))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Program Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("ProgramSPIFile Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.Program SPI Firmware: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - Program Config + serial: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
		//Program Config + serial
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!ProgramFileWithSerial(hDevice,"bConfig.cfg","1234"))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Program Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("ProgramFileWithSerial Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.Program Config + serial: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - Program Config + USB2, USB3 serial: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//Program config + USB2, USB3 serial"
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!ProgramFileWithUsb3Serial(hDevice,"config.bin","1234","5678"))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Program Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("ProgramFileWithUsb3Serial Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.Program Config + USB2, USB3 serial: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - Program SPI + Config: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
		//Program SPI firmware + config 
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!ProgramSPIFirmwareWithConfig(hDevice,"SPIFirmware.bin","config.cfg"))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Program Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("ProgramSPIFirmwareWithConfig Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} 
			else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.Program Config + USB2, USB3 serial: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - Program SPI + Config + Serial: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		// Program SPI Firmware + config + serial
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!ProgramSPIFirmwareCfgWithSerial(hDevice,"SPIFirmware.bin","config.cfg","1234"))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("Program Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("ProgramSPIFirmwareCfgWithSerial Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input. Program SPI + Config + Serial: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - SPI Test: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//SPI
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!RUNSPITests(hDevice))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("SPI Test Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("SPI Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.SPI Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		printf("USB - XDATA Test: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//XDATA
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!RUNXDATATests(hDevice))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("XDATA Test Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("XDATA Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} 
			else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.XDATA Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}

		printf("USB - UART Test: Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
		//UART
		while (1) 
		{
			ch = _getch();
			if ((ch == 'y') || (ch == 'Y'))	{
					if(!RUNUARTTests(hDevice))
					{
						dwError = libMchpUsbGetLastErr(hDevice);
						printf("UART Test Failed \n");
						printf ("nPress any key to exit....");
						_getch ();
						exit (EXIT_FAILURE);
					}
					else
					{
						printf("UART Test PASS \n");
						break;
					}
			} else if ((ch == 'n') || (ch == 'N')) {
				break;
			} 
			else if((ch == 'x') || (ch == 'X'))
			{
				exit (EXIT_FAILURE);
			}
			else {
				printf("Invalid input.XDATA Test: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
			}
		}
		
		
		//Close the device
		if (FALSE == libMchpUsbClose(hDevice))
		{
			dwError = libMchpUsbGetLastErr(hDevice);
			printf ("Error,%04x",dwError);
			printf ("nPress any key to exit....");
			_getch ();
			exit (EXIT_FAILURE);
		}
	 }

	 //Try catch implementation 
	catch(...)
	{
		printf ( "Oops... There is a problem with previous command\n");
		printf ("See log for more details in the application directory\n");
		printf ("nPress any key to exit....");
		_getch ();
		exit (EXIT_FAILURE);
	}
}