#include <stdio.h>

#include <iostream>
#include <iomanip>
#include <conio.h>
#include <vector>
#include <fstream>
#include <sstream>

/*#include <boost/program_options.hpp>
namespace po = boost::program_options;
#include <boost/program_options/value_semantic.hpp>*/
#include <cstdlib>
#include <string>
#include "dll_app.h"

// PT2 DLL header file
#include "../APIHeader/PT2_DLL.h"


#define E2P_CMD_ERAL 0x60000000UL // Erase All


using namespace std;

extern HMODULE gLoadLib ;


pfMchpLanGetDevices libMchpLanGetDevices;
pfMchpLanOpen libMchpLanOpen;
pfMchpLanOpenID libMchpLanOpenID;
pfMchpLanClose libMchpLanClose;
pfMchpLanCloseAllHandles libMchpLanCloseAllHandles;

pfMchpLanProgramFile libMchpLanProgramFile;
pfMchpLanProgramFileWithSerial libMchpLanProgramFileWithSerial;

pfMchpLanReadMemory libMchpLanReadMemory;

pfMchpLanRegisterRead libMchpLanRegisterRead;
pfMchpLanRegisterWrite libMchpLanRegisterWrite;
pfMchpLanPhyRegisterRead libMchpLanPhyRegisterRead;
pfMchpLanPhyRegisterWrite libMchpLanPhyRegisterWrite;

pfMchpLanVerifyParameters libMchpLanVerifyParameters;

pfMchpLanGetDriverVersion libMchpLanGetDriverVersion;
pfMchpLanGetAdapterBits libMchpLanGetAdapterBits;
pfMchpLanGetAdapterKey libMchpLanGetAdapterKey;
pfMchpLanGetAdapterPort libMchpLanGetAdapterPort;
pfMchpLanGetAdapterPDO libMchpLanGetAdapterPDO;
pfMchpLanReadTxRxStat libMchpLanReadTxRxStat;
pfMchpLanReadUsbPhyStat libMchpLanReadUsbPhyStat;
pfMchpLanEepromConfigureCommand libMchpLanEepromConfigureCommand;
pfMchpLanReadEepromByte libMchpLanReadEepromByte;
pfMchpLanWriteEepromByte libMchpLanWriteEepromByte;
pfMchpLanEraseEeprom libMchpLanEraseEeprom;
pfMchpLanGetEepromSize libMchpLanGetEepromSize;
pfMchpLanOtpConfigureCommand libMchpLanOtpConfigureCommand;

pfMchpLanGetLastErr libMchpLanGetLastErr;

//Main Function
void MchpLanSampleApp()
{
    try
	{
		CHAR sztext[2048];
		UINT LanID = 0 ;
		UINT32 dwError = Error_Success;

		libMchpLanGetDevices		= (pfMchpLanGetDevices) GetProcAddress ( gLoadLib ,"MchpLanGetDevices");
		libMchpLanOpen				= (pfMchpLanOpen) GetProcAddress ( gLoadLib ,"MchpLanOpen");
		libMchpLanOpenID				= (pfMchpLanOpenID) GetProcAddress ( gLoadLib ,"MchpLanOpenID");
		libMchpLanClose				= (pfMchpLanClose) GetProcAddress ( gLoadLib ,"MchpLanClose");
		libMchpLanCloseAllHandles			= (pfMchpLanCloseAllHandles) GetProcAddress ( gLoadLib ,"MchpLanCloseAllHandles");


		libMchpLanProgramFile			= (pfMchpLanProgramFile) GetProcAddress ( gLoadLib ,"MchpLanProgramFile");
		libMchpLanProgramFileWithSerial = (pfMchpLanProgramFileWithSerial)GetProcAddress (gLoadLib, "MchpLanProgramFileWithSerial");

		libMchpLanReadMemory = (pfMchpLanReadMemory)GetProcAddress(gLoadLib,"MchpLanReadMemory");

		libMchpLanRegisterRead = (pfMchpLanRegisterRead)GetProcAddress(gLoadLib,"MchpLanRegisterRead");
		libMchpLanRegisterWrite = (pfMchpLanRegisterWrite)GetProcAddress(gLoadLib,"MchpLanRegisterWrite");
		libMchpLanPhyRegisterRead = (pfMchpLanPhyRegisterRead)GetProcAddress(gLoadLib,"MchpLanPhyRegisterRead");
		libMchpLanPhyRegisterWrite = (pfMchpLanPhyRegisterWrite)GetProcAddress(gLoadLib,"MchpLanPhyRegisterWrite");

		libMchpLanVerifyParameters = (pfMchpLanVerifyParameters)GetProcAddress(gLoadLib,"MchpLanVerifyParameters");

		libMchpLanGetDriverVersion = (pfMchpLanGetDriverVersion)GetProcAddress(gLoadLib,"MchpLanGetDriverVersion");
		libMchpLanGetAdapterBits = (pfMchpLanGetAdapterBits)GetProcAddress(gLoadLib,"MchpLanGetAdapterBits");
		libMchpLanGetAdapterKey = (pfMchpLanGetAdapterKey)GetProcAddress(gLoadLib,"MchpLanGetAdapterKey");
		libMchpLanGetAdapterPort = (pfMchpLanGetAdapterPort)GetProcAddress(gLoadLib,"MchpLanGetAdapterPort");
		libMchpLanGetAdapterPDO = (pfMchpLanGetAdapterPDO)GetProcAddress(gLoadLib,"MchpLanGetAdapterPDO");
		libMchpLanReadTxRxStat = (pfMchpLanReadTxRxStat)GetProcAddress(gLoadLib,"MchpLanReadTxRxStat");
		libMchpLanReadUsbPhyStat = (pfMchpLanReadUsbPhyStat)GetProcAddress(gLoadLib,"MchpLanReadUsbPhyStat");
		libMchpLanEepromConfigureCommand = (pfMchpLanEepromConfigureCommand)GetProcAddress(gLoadLib,"MchpLanEepromConfigureCommand");
		libMchpLanReadEepromByte = (pfMchpLanReadEepromByte)GetProcAddress(gLoadLib,"MchpLanReadEepromByte");
		libMchpLanWriteEepromByte = (pfMchpLanWriteEepromByte)GetProcAddress(gLoadLib,"MchpLanWriteEepromByte");
		libMchpLanEraseEeprom = (pfMchpLanEraseEeprom)GetProcAddress(gLoadLib,"MchpLanEraseEeprom");
		libMchpLanGetEepromSize = (pfMchpLanGetEepromSize)GetProcAddress(gLoadLib,"MchpLanGetEepromSize");
		libMchpLanOtpConfigureCommand = (pfMchpLanOtpConfigureCommand)GetProcAddress(gLoadLib, "MchpLanOtpConfigureCommand");

		libMchpLanGetLastErr = (pfMchpLanGetLastErr) GetProcAddress ( gLoadLib ,"MchpLanGetLastErr");
	

		//Get List of LAN Devices
		int lan_count =0;
		lan_count =  libMchpLanGetDevices(sztext);

		if(lan_count)
		{
			cout<<"Connected LAN Devices are ..\n\n";
			cout<<"LAN Count" << lan_count << endl;
			cout<<sztext<<endl;
			cout<<"Selected LAN Adapter is "<< LanID <<endl;
		}
		else
		{
			printf ("zero LAN78XX devices found\n");
			//LetGetDevices error can be retrieved using MchpLanGetLastErr() using lan index zero
			//Lan index zero must be used for this API alone
			//For all other API's, should use HANDLE of lan adapter
			dwError = libMchpLanGetLastErr(0);
			printf ("\nPress any key to exit....");
			_getch ();
			exit (1);
		}
		do
		{
			// Open LAN Device based on Index
			HANDLE hDevice =  INVALID_HANDLE_VALUE;
			hDevice = libMchpLanOpen(LanID);
			if(hDevice ==  INVALID_HANDLE_VALUE)
			{
				printf ("\nPress any key to exit....");
				_getch ();
				exit (1);
			}
			printf("Device Opened successfully\n");

			//Open LAN Device based on VID, PID, MAC Address
			BYTE curMacAddr[6]  ={0x00,0x80,0x0F,0x78,0x00,0x00};
			/*hDevice = libMchpLanOpenID(0x0424,0x7800,curMacAddr);
			if(hDevice ==  INVALID_HANDLE_VALUE)
			{
				printf ("\nPress any key to exit....");
				_getch ();
				exit (1);
			}
			printf("Device Opened successfully\n");*/

			int ch= 'n';
			printf("LAN - Program file. Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			//Program File
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					if (FALSE == libMchpLanProgramFile(hDevice,1,"7800eep.bin",(PCHAR)curMacAddr))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Device Program Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					else
					{
						printf ("Device Programmed Successfully \n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Program file: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}
			
			printf("LAN - Program file + serial. Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			//Program file with serial
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					if (FALSE == libMchpLanProgramFileWithSerial(hDevice,1,"7800eep.bin","1234",(PCHAR)curMacAddr))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Device Program Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					else
					{
						printf ("Device Programmed Successfully \n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Program file + serial: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}

			//Read Memory
			printf("LAN -Read Memory. Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					UINT8 *byReadData = (UINT8 *) malloc(512);
					if(FALSE == libMchpLanReadMemory(hDevice,1,(UINT8 *)byReadData,0x0,256))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Read memory Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					else
					{
						printf ("Read Memory Successfully\n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Read memory: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}
			

			//Lan Regsiter Read
			printf("LAN -Read/write . Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					UINT32 Data;
					if(FALSE == libMchpLanRegisterRead(hDevice,0x080,1,&Data))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Register read Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					//Lan Register Write
					Data = 0x00000001;
					if(FALSE == libMchpLanRegisterWrite(hDevice,0x030,1,&Data))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Lan Register write Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					else
					{
						printf ("Read/Write Register Successfully\n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Read/Write memory: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}
				
			printf("LAN -Phy Read/write . Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			//Phy register Read
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					UINT16 PhyData;
					if(FALSE == libMchpLanPhyRegisterRead(hDevice,0x01,1,&PhyData))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Phy Register read Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					//Phy register Write
					PhyData = 0x00;
					if(FALSE == libMchpLanPhyRegisterWrite(hDevice,0x00,1,&PhyData))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Phy Register write Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					else
					{
						printf ("Phy Read/Write Register Successfully\n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Read/Write memory: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}
			//Verify widgets
			printf("LAN -Verify widgets . Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					char widget_buffer_names[4098];
					char widget_buffer_values[4098];
					memset(widget_buffer_names,0x00,sizeof(widget_buffer_names));
					string verifyParams [] = {"langid",
											  "usb2vid",
											  "usb2pid",
											   "END"};
					for (int i=0;verifyParams[i] != "END"; i++)
					{
						strcat(widget_buffer_names,verifyParams[i].c_str());
						strcat(widget_buffer_names,",");
					}
 
					if(FALSE == libMchpLanVerifyParameters(hDevice,widget_buffer_names,widget_buffer_values))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Verify Parameters Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					else
					{
						printf ("Verify parameters Successfully\n");
						break;
					}
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Read memory: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}

			//Get driver handle
			printf("LAN - General test. Press 'y' to Run or 'n' to skip or 'x' to exit... \n");
			while (1) 
			{
				ch = _getch();
				if ((ch == 'y') || (ch == 'Y'))	{
					char DisplayBuffer[256];
					if(FALSE == libMchpLanGetDriverVersion(DisplayBuffer))
					{
						printf ("Failed to Get driver version");
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout <<"GetDriverversion: Success\n";

					//Get Adapter Bits
					if(FALSE == libMchpLanGetAdapterBits(DisplayBuffer))
					{
						printf ("Failed to Get Adapter bits");
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout <<"GetAdapterBits: Success\n";
			 
					//Get Adapter Key
					if(FALSE == libMchpLanGetAdapterKey(hDevice,DisplayBuffer))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Get adapter key Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout <<"GetAdapterKey: Success\n";

					//Get Adapter Port
					if(FALSE == libMchpLanGetAdapterPort(hDevice,DisplayBuffer))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Get adapter port Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout <<"GetAdapterPOrt: Success\n";

					//Get Adapter PDO
					if(FALSE == libMchpLanGetAdapterPDO(hDevice, DisplayBuffer))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Get adapter PDO Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"GetAdapterPDO: Success\n";

					//Read Rx Tx Status
					if(FALSE == libMchpLanReadTxRxStat(hDevice,DisplayBuffer))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Read Rx Tx Status Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"ReadTxRxStat: Success\n";

					//Read Phy Status
					if(FALSE == libMchpLanReadUsbPhyStat(hDevice,DisplayBuffer))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Read Phy Status Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"ReadPhyStatus: Success\n";

					//EEprom configure command
					if(FALSE == libMchpLanEepromConfigureCommand(hDevice, E2P_CMD_ERAL))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("EEPROM Configure Command Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"EEPROM Configure Command: Success\n";

					//Read EEPROM Byte
					UINT8 Val;
					if(FALSE == libMchpLanReadEepromByte(hDevice,0x00,&Val))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Read EEPROM Byte Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"Read EEPROM Byte: Success\n";

					//Write EEPROM Byte
					Val = 0x71;
					if(FALSE == libMchpLanWriteEepromByte(hDevice,0x06,&Val))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Write EEPROM Byte Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"Write EEPROM Byte: Success\n";

					//EEPROM Erase 
					if(FALSE == libMchpLanEraseEeprom(hDevice))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("EEPROM Erase Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"EEPROM Erase: Success\n";

					//Get EEPROM Size
					int e2psize;
					if(FALSE == libMchpLanGetEepromSize(hDevice,&e2psize))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("Failed to get EEPROM Size, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"Get EEPROM Size: Success\n";


					//OTP configure command
					if(FALSE == libMchpLanOtpConfigureCommand(hDevice,0x01000000UL))
					{
						dwError = libMchpLanGetLastErr(hDevice);
						printf ("OTP configure command Failed, Error %04xn",dwError);
						printf ("nPress any key to exit....");
						_getch ();
						exit (1);
					}
					cout<<"OTP Configure command: Success\n";
				} else if ((ch == 'n') || (ch == 'N')) {
					break;
				} 
				else if((ch == 'x') || (ch == 'X'))
				{
					exit (EXIT_FAILURE);
				}
				else {
					printf("Invalid input.Read memory: Press 'y' to Run or 'n' to skip or 'x' to exit...\n");
				}
			}
			
			//Close device handle
			libMchpLanClose(hDevice);

			//Close all handle
			libMchpLanCloseAllHandles();

		}while(TRUE);
	}
	//Try catch implementation 
	catch(...)
	{
		cout << "Oops... There is a problem with previous command\n"<<endl;
		cout << "See log for more details in the application directory\n"<<endl;
		printf ("nPress any key to exit....");
		_getch ();
		exit (1);
	}
}

