#include <stdio.h>

#include <iostream>
#include <iomanip>
#include <conio.h>
#include <vector>
#include <fstream>
#include <sstream>
#include "dll_app.h"

/*#include <boost/program_options.hpp>
namespace po = boost::program_options;
#include <boost/program_options/value_semantic.hpp>*/
#include <cstdlib>

// PT2 DLL header file

#include "..\APIHeader\PT2_DLL.h"

using namespace std;

extern HMODULE gLoadLib ;
pfMchpUsbI2CSetConfig libMchpUsbI2CSetConfig;
pfMchpUsbI2CRead libMchpUsbI2CRead;
pfMchpUsbI2CWrite libMchpUsbI2CWrite;
pfMchpUsbI2CTransfer libMchpUsbI2CTransfer;

BOOL RUNI2CTests(HANDLE hDevice)
{
	HMODULE LoadLib = LoadLibrary ("pt2lib.dll");
	
	libMchpUsbI2CSetConfig		=	(pfMchpUsbI2CSetConfig) GetProcAddress ( gLoadLib ,"MchpUsbI2CSetConfig");
	libMchpUsbI2CRead			=	(pfMchpUsbI2CRead) GetProcAddress ( gLoadLib ,"MchpUsbI2CRead");
	libMchpUsbI2CWrite			=	(pfMchpUsbI2CWrite) GetProcAddress ( gLoadLib ,"MchpUsbI2CWrite");
	libMchpUsbI2CTransfer		=	(pfMchpUsbI2CTransfer) GetProcAddress ( gLoadLib ,"libMchpUsbI2CTransfer");


	printf("***************************************************\n");
	printf("\t\tI2C Bridging\t\t\t\t\n");
	printf("***************************************************\n");

	//To Read EEPROM AT24C04
	//Set desired value in clock
	//enables I2C pass-through and the clock rate of the I2C Master device
	if (FALSE == libMchpUsbI2CSetConfig (hDevice, 30, 0))
	{
		printf ("Failed to enable I2C pass_through & clock rate of I2C Master Device \n");
		return FALSE;
	}
	
	//Write start address
	//performs an I2C write through the I2C pass-through interface of USB device.
	UINT8 byAddr = 00;
	if (FALSE == libMchpUsbI2CWrite (hDevice,1,&byAddr,0x50))
	{
		printf ("Failed to perform an I2C write \n");
		return FALSE;
	}

	//Read 512 bytes
	//performs an I2C read through the I2C pass-through interface of USB device.
	UINT8 byReadData[512];
	if (FALSE == libMchpUsbI2CRead (hDevice,512,&byReadData[0],0x50))
	{
		printf ("Failed to perform an I2C read \n");
		return FALSE;
	}
	
	//performs an I2C read and write through the I2C pass-through interface of USB device
	//For i2c eeprom at24c04 ,read 10 bytes
	UINT8 byData[512];
	UINT8 byBytetoWrite = 0x00; //Write address first
	if(FALSE == libMchpUsbI2CTransfer(hDevice,0,&byBytetoWrite,1,0x50,1,1,0))
	{
		printf ("I2CTransfer : Failed \n");
		return FALSE;
	}
	//Read 10 bytes
	if(FALSE == libMchpUsbI2CTransfer(hDevice,1,&byData[0],10,0x50,1,1,1))
	{
		printf ("I2CTransfer : Failed \n");
		return FALSE;
	}
	printf ("I2C Tests : Pass \n");
	return TRUE;

}