/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license
*/
//Global variables
var offlineConfFile = "";
var LoadConfigFile = "";
var LAN_FAMILY_INDEX = "1";
var noselect = false;
var dummyLANID = "1";
var stringnullvalue = "NULL STRING - NOT PROGRAMMED YET";

var checkbox_checked_value = "1";
var checkbox_unchecked_value = "0";

// values returned if a value is 1 from the backend
var checkbox_checked_value = "1";
var checkbox_unchecked_value = "0";

var enableApplyButton = false;
var CurrentLANProgrammed = "";

var gArrConfigFilelist = [];
var gArrConfigIndex = 0;

//Widget IDs of String fields in the GUI
var GwidgetlistString = [
	"macaddr",
	"manufacturer",
	"product",
	"serial",
	"configstring",
	"interfacestring"
];

//Widget IDs of Hex fields in the GUI
var GwidgetlistHex = [
	"usb2vid",
	"usb2pid",
	"usb2did",
	"eepromconfigflag1",
	"eepromconfigflag0",
	"eepromconfigflag2",
	"eepromconfigflag3",
	"eepromconfigflag4",
	"eepromconfigflag5",
	"langid"
	
];

//Widget IDs of Int fields in the GUI
var GwidgetlistInt = [
	"FSmaxpower",
	"HSmaxpower",
	"SSmaxpower",
	"FSinterruptEPinterval",
	"HSinterruptEPinterval",
	"SSinterruptEPinterval"
];

//Widget IDs of Checkbox fields in the GUI
var GwidgetCheckbox = [
	"enremwakeup",
	"enselfpower",
	"LED0Enable",
	"LED1Enable",
	"LED2Enable",
	"LED3Enable"
];

var GwidgetlistDropDown = [
	"LED0Function",
	"LED1Function",
	"LED2Function",
	"LED3Function"
];

var DropDownLEDListFunction = [
	"Link/Activity",
	"Link1000/Activity",
	"Link100/Activity",
	"Link10/Activity",
	"Link100/1000/Activity",
	"Link10/1000/Activity",
	"Link10/100/Activity",
	"Reserved",
	"Duplex/Collision",
	"Collision",
	"Activity",
	"Reserved",
	"Auto-Negotiation Fault",
	"Serial Mode",
	"Force LED Off",
	"Force LED On"
];

//Widget IDs of Radio fields in the GUI
var GwidgetlistRadio = [
	"GPIOPMEEnable",
	"GPIOPMEConfiguration",
	"GPIOPMELength",
	"GPIOPMEPolarity",
	"GPIOBufferType",
	"GPIOPMEWOLSelect",
	"PMEMagicPacketEnable",
	"PMEPerfectDAEnable",
	"PMEWUFFEnable"
];

//They are handled separately
/*"GPIOEnable",
"GPIOBuffer",
"GPIODirection",
"GPIOData"*/

//Have been hidden as they make sense only for HSIC 
/*"GPIOConnectEnable",
"GPIOConnectBufferType",
"GPIOConnectPolarity"*/

//They are checkboxes for each GPIO which is handled separately.
/*"GPIOWake",
"GPIOWakePolarity",*/

//Mapping Hex widgets to the meaningful elaborations to print while in error
var Mapping = {
	"macaddr": "MAC Address",
	"manufacturer": "Manufacturer",
	"product": "Product",
	"serial": "Serial",
	"configstring": "Configuration String",
	"interfacestring": "Interface String",
	"usb2vid": "Vendor ID",
	"usb2pid": "Product ID",
	"usb2did": "Device ID",
	"langid": "Language ID",
	"eepromconfigflag0" : "Config Flag 0",
	"eepromconfigflag1" : "Config Flag 1",
	"eepromconfigflag2" : "Config Flag 2",
	"eepromconfigflag3" : "Config Flag 3",
	"eepromconfigflag4" : "Config Flag 4",
	"eepromconfigflag5" : "Config Flag 5",
	"LED0Function": "LED 0 Function",
	"LED1Function": "LED 1 Function",
	"LED2Function": "LED 2 Function",
	"LED3Function": "LED 3 Function",
	"LEDBehavior": "LED Behavior",
	"FSmaxpower": "Full Speed Max Power",
	"HSmaxpower": "High Speed Max Power",
	"SSmaxpower": "Super Speed Max Power",
	"FSinterruptEPinterval": "Full Speed Interrupt bInterval",
	"HSinterruptEPinterval": "High Speed Interrupt bInterval",
	"SSinterruptEPinterval": "Super Speed Interrupt bInterval",
	"enremwakeup": "Enable Remote Wakeup",
	"enselfpower": "Enable Self Power",
	"enbuspower": "Enable Bus Power",
	"LED0Enable": "LED 0 Enable",
	"LED1Enable": "LED 1 Enable",
	"LED2Enable": "LED 2 Enable",
	"LED3Enable": "LED 3 Enable",
	"GPIOPMEEnable": "GPIO PME Enable",
	"GPIOPMEConfiguration": "GPIO PME Configuration",
	"GPIOPMELength": "GPIO PME Length",
	"GPIOPMEPolarity": "GPIO PME Polarity",
	"GPIOBufferType": "GPIO Buffer Type",
	"GPIOPMEWOLSelect": "GPIO PME WOL Select",
	"PMEMagicPacketEnable": "PME Magic Packet Enable",
	"PMEPerfectDAEnable": "PME Perfect DA Enable",
	"PMEWUFFEnable":"PME WUFF Enable",
	"GPIOEnable": "GPIO Enable",
	"GPIOBuffer": "GPIO Buffer",
	"GPIODirection": "GPIO Direction",
	"GPIOData": "GPIO Data",
	"GPIOWake": "GPIO Wakeup",
	"GPIOWakePolarity": "GPIO Wakeup Polarity"
};

function getOfflineConf() {
	offlineConfFile = "";
	var file = document.getElementById("offlineConfFileID").files[0];
	var fileSize = file.size;
	update_status_message("The size of the Configuration file selected is " + fileSize + " Bytes");
	if (file) {
		$("#offlineConfFileID").css({
			background: "white",
			border: "0px"
		});
		offlineConfFile = file.name;
		var saveextension = offlineConfFile.substr(offlineConfFile.lastIndexOf('.') + 1);
		if(saveextension === offlineConfFile)
		{
			offlineConfFile = offlineConfFile + ".bin";
		}
		else if(saveextension === "bin")
		{
			var mesg = ("Selected .bin file to save is :" + offlineConfFile);
			update_status_message(mesg);
		}else{
			alert("Selected File Type is not supported. Please Select File type : .bin");
			update_status_message("Selected File Type is not supported.Supported File type is .bin");
			$("#offlineConfFileID").val('');
			$("#offlineConfFileID").css({
			background: "white",
			border: "0px"
			});
			offlineConfFile="";
			return;
		}
	} else {
		$("#offlineConfFileID").css({
			background: "yellow",
			border: "3px red solid"
		});
		update_status_message("No configuration file(.bin) is selected.");
		offlineConfFile = "";
		alert("No configuration file(.bin) is selected.");
	}
}

function startReadcfg() {
	clearLANWidgetMap();
	setLoadAction(true);
	LoadConfFile = "";
	var fileextension;
	var file = document.getElementById("offlineConfload").files[0];
	var fileSize = file.size;
	var Filelist = "";
	var canAllow = false;
	var fileSize = file.size;
	LoadConfFile = file.name;
	fileextension = LoadConfFile.substr(LoadConfFile.lastIndexOf('.') + 1);
	if(fileextension == "bin" || fileextension == "ini")
	{
		update_status_message("The size of the Configuration file selected is " + fileSize + " Bytes.");
	} else {
		alert("Selected File Type is not supported. Please Select File type : .bin/.ini");
		//reset_file_input();
		$("#offlineConfload").val('');
		$("#offlineConfload").css({
			background: "white",
			border: "0px"
			});
		LoadConfFile ="";
		return;
	}

	if (file) {
		if (fileextension == "ini") {
			if (fileSize > 0) {
				canAllow = true;
			} else {
				update_status_message("The size of configuration file \"" + file.name + "\" is empty.");
				LoadConfFile = "";
				alert("The size of configuration file \"" + file.name + "\" is empty.");
				return;
			}
		} else if (fileextension == "bin") {
			if (fileSize <= 512) {
				canAllow = true;
			} else {
				update_status_message("The size of configuration file \"" + file.name + "\" cannot exceed 512 bytes.");
				LoadConfFile = "";
				alert("The size of configuration file \"" + file.name + "\" cannot exceed 512 bytes.");
				return;
			}
		} else {
			//Do nothing	
		}
	}
	
	if (canAllow) {
		$("#offlineConfload").css({
			background: "white",
			border: "0px"
		});
	}
	if (gArrConfigIndex > 15)
	{
		alert("Max configuration file count is 15");
		return;
	}
	gArrConfigFilelist[gArrConfigIndex++] = LoadConfFile;
	var Texttodisplay = "Loaded Configuration files are ";
	for(var i = 0; i < gArrConfigIndex; i++)
	{
		Filelist = Filelist + gArrConfigFilelist[i] + ",";
	}
	update_status_message(Texttodisplay + Filelist);
	//overrideDefaultOfflineConfig function will return strap values in LoadConfFile
	//Return string format is "widget:value###widget:value.."
	populateDefaultValues();
}

//Document START
$(document).ready(function () {
	$("#Apply").attr('disabled', true);
	$("#Reset").attr('disabled', true);
	
	$('#SaveFileField').hide();
	$('#SaveFileField').attr('disabled', 'disabled');
	$('#LoadFileField').removeAttr('disabled');
	$("#LoadFileField").attr('disabled', true);
	$('#LoadFileField').show();
	$("#LoadFileField").attr('disabled', true);

	update_status_message("Offline Configuration");
	clearLANWidgetMap();
});
//Document END

var sku;
$('#selectsku_lan li').on('click', function() {
	sku = $(this).text();
	update_status_message("Selected SKU is :" + sku);
	
	if ((sku == "LAN7800")) {
		
		$("#gpio8fieldset").attr('disabled', true);
		$("#gpio9fieldset").attr('disabled', true);
		$("#gpio10fieldset").attr('disabled', true);
		$("#gpio11fieldset").attr('disabled', true);


		//$("#NotForLAN7800").hide();
		$("#gpio8fieldset").hide();
		$("#gpio9fieldset").hide();
		$("#gpio10fieldset").hide();
		$("#gpio11fieldset").hide();
		
		
		$("#ssPowerSection").removeAttr('disabled', false);
		$("#ssIntervalSection").removeAttr('disabled', false);
			
		$("#ssPowerSection").show();
		$("#ssIntervalSection").show();
	} else if((sku == "LAN7850")){
		//$("#NotForLAN7800").show();
		$("#gpio8fieldset").show();
		$("#gpio9fieldset").show();
		$("#gpio10fieldset").show();
		$("#gpio11fieldset").show();
		
		$("#gpio8fieldset").removeAttr('disabled', false);
		$("#gpio9fieldset").removeAttr('disabled', false);
		$("#gpio10fieldset").removeAttr('disabled', false);
		$("#gpio11fieldset").removeAttr('disabled', false);	
			
		
		$("#ssPowerSection").attr('disabled', true);
		$("#ssIntervalSection").attr('disabled', true);
		
		$("#ssPowerSection").hide();
		$("#ssIntervalSection").hide();
	}
	else if ((sku == "LAN7801")) {
		
		$("#ssPowerSection").removeAttr('disabled', false);
		$("#ssIntervalSection").removeAttr('disabled', false);
			
		$("#ssPowerSection").show();
		$("#ssIntervalSection").show();
	}
	clearLANWidgetMap();
	gArrConfigIndex = 0;
	//LoadConfFile = "";
	changecount = 0;
	$("#Reset").attr('disabled', false);
	reset_file_input();

	offlineConfFile="";
	enable_all_fields();
	set_changed_fields_border_default();
	populateDefaultValues();
	
	//Hiding the GPIO Data with respect to the current value of the GPIO
	var gpioDirTemp = $("#gpio0DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio0DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio0DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio1DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio1DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio1DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio2DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio2DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio2DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio3DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio3DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio3DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio4DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio4DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio4DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio5DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio5DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio5DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio6DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio6DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio6DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio7DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio7DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio7DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio8DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio8DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio8DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio9DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio9DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio9DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio10DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio10DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio10DataSection").show();
	} else {
		//Do nothing
	}
	
	gpioDirTemp = $("#gpio11DirectionGroup").find(':checked').val();
	
	if (gpioDirTemp == 0) {
		$("#gpio11DataSection").hide();
	} else if (gpioDirTemp == 1) {
		$("#gpio11DataSection").show();
	} else {
		//Do nothing
	}
	
	var gpioEnableTemp = $("#gpio0EnableGroup").find(':checked').val();
				
	if (gpioEnableTemp == 1) {
		$("#GPIO0_WUSection").attr('disabled', true);
		$("#GPIO0_WUPSection").attr('disabled', true);
		$("#GPIO0_set").attr('disabled', true);
		
		$("#GPIO0_WUSection").hide();
		$("#GPIO0_WUPSection").hide();
		$("#GPIO0_set").hide();
	} else {
		$("#GPIO0_WUSection").show();
		$("#GPIO0_WUPSection").show();
		$("#GPIO0_set").show();

		$("#GPIO0_WUSection").removeAttr('disabled', false);
		$("#GPIO0_WUPSection").removeAttr('disabled', false);
		$("#GPIO0_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio1EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO1_WUSection").attr('disabled', true);
		$("#GPIO1_WUPSection").attr('disabled', true);
		$("#GPIO1_set").attr('disabled', true);
		
		$("#GPIO1_WUSection").hide();
		$("#GPIO1_WUPSection").hide();
		$("#GPIO1_set").hide();
	} else {
		$("#GPIO1_WUSection").show();
		$("#GPIO1_WUPSection").show();
		$("#GPIO1_set").show();

		$("#GPIO1_WUSection").removeAttr('disabled', false);
		$("#GPIO1_WUPSection").removeAttr('disabled', false);
		$("#GPIO1_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio2EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO2_WUSection").attr('disabled', true);
		$("#GPIO2_WUPSection").attr('disabled', true);
		$("#GPIO2_set").attr('disabled', true);
		
		$("#GPIO2_WUSection").hide();
		$("#GPIO2_WUPSection").hide();
		$("#GPIO2_set").hide();
	} else {
		$("#GPIO2_WUSection").show();
		$("#GPIO2_WUPSection").show();
		$("#GPIO2_set").show();

		$("#GPIO2_WUSection").removeAttr('disabled', false);
		$("#GPIO2_WUPSection").removeAttr('disabled', false);
		$("#GPIO2_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio3EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO3_WUSection").attr('disabled', true);
		$("#GPIO3_WUPSection").attr('disabled', true);
		$("#GPIO3_set").attr('disabled', true);
		
		$("#GPIO3_WUSection").hide();
		$("#GPIO3_WUPSection").hide();
		$("#GPIO3_set").hide();
	} else {
		$("#GPIO3_WUSection").show();
		$("#GPIO3_WUPSection").show();
		$("#GPIO3_set").show();

		$("#GPIO3_WUSection").removeAttr('disabled', false);
		$("#GPIO3_WUPSection").removeAttr('disabled', false);
		$("#GPIO3_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio4EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO4_WUSection").attr('disabled', true);
		$("#GPIO4_WUPSection").attr('disabled', true);
		$("#GPIO4_set").attr('disabled', true);
		
		$("#GPIO4_WUSection").hide();
		$("#GPIO4_WUPSection").hide();
		$("#GPIO4_set").hide();
	} else {
		$("#GPIO4_WUSection").show();
		$("#GPIO4_WUPSection").show();
		$("#GPIO4_set").show();

		$("#GPIO4_WUSection").removeAttr('disabled', false);
		$("#GPIO4_WUPSection").removeAttr('disabled', false);
		$("#GPIO4_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio5EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO5_WUSection").attr('disabled', true);
		$("#GPIO5_WUPSection").attr('disabled', true);
		$("#GPIO5_set").attr('disabled', true);
		
		$("#GPIO5_WUSection").hide();
		$("#GPIO5_WUPSection").hide();
		$("#GPIO5_set").hide();
	} else {
		$("#GPIO5_WUSection").show();
		$("#GPIO5_WUPSection").show();
		$("#GPIO5_set").show();

		$("#GPIO5_WUSection").removeAttr('disabled', false);
		$("#GPIO5_WUPSection").removeAttr('disabled', false);
		$("#GPIO5_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio6EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO6_WUSection").attr('disabled', true);
		$("#GPIO6_WUPSection").attr('disabled', true);
		$("#GPIO6_set").attr('disabled', true);
		
		$("#GPIO6_WUSection").hide();
		$("#GPIO6_WUPSection").hide();
		$("#GPIO6_set").hide();
	} else {
		$("#GPIO6_WUSection").show();
		$("#GPIO6_WUPSection").show();
		$("#GPIO6_set").show();

		$("#GPIO6_WUSection").removeAttr('disabled', false);
		$("#GPIO6_WUPSection").removeAttr('disabled', false);
		$("#GPIO6_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio7EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO7_WUSection").attr('disabled', true);
		$("#GPIO7_WUPSection").attr('disabled', true);
		$("#GPIO7_set").attr('disabled', true);
		
		$("#GPIO7_WUSection").hide();
		$("#GPIO7_WUPSection").hide();
		$("#GPIO7_set").hide();
	} else {
		$("#GPIO7_WUSection").show();
		$("#GPIO7_WUPSection").show();
		$("#GPIO7_set").show();

		$("#GPIO7_WUSection").removeAttr('disabled', false);
		$("#GPIO7_WUPSection").removeAttr('disabled', false);
		$("#GPIO7_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio8EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO8_WUSection").attr('disabled', true);
		$("#GPIO8_WUPSection").attr('disabled', true);
		$("#GPIO8_set").attr('disabled', true);
		
		$("#GPIO8_WUSection").hide();
		$("#GPIO8_WUPSection").hide();
		$("#GPIO8_set").hide();
	} else {
		$("#GPIO8_WUSection").show();
		$("#GPIO8_WUPSection").show();
		$("#GPIO8_set").show();

		$("#GPIO8_WUSection").removeAttr('disabled', false);
		$("#GPIO8_WUPSection").removeAttr('disabled', false);
		$("#GPIO8_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio9EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO9_WUSection").attr('disabled', true);
		$("#GPIO9_WUPSection").attr('disabled', true);
		$("#GPIO9_set").attr('disabled', true);
		
		$("#GPIO9_WUSection").hide();
		$("#GPIO9_WUPSection").hide();
		$("#GPIO9_set").hide();
	} else {
		$("#GPIO9_WUSection").show();
		$("#GPIO9_WUPSection").show();
		$("#GPIO9_set").show();

		$("#GPIO9_WUSection").removeAttr('disabled', false);
		$("#GPIO9_WUPSection").removeAttr('disabled', false);
		$("#GPIO9_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio10EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO10_WUSection").attr('disabled', true);
		$("#GPIO10_WUPSection").attr('disabled', true);
		$("#GPIO10_set").attr('disabled', true);
		
		$("#GPIO10_WUSection").hide();
		$("#GPIO10_WUPSection").hide();
		$("#GPIO10_set").hide();
	} else {
		$("#GPIO10_WUSection").show();
		$("#GPIO10_WUPSection").show();
		$("#GPIO10_set").show();

		$("#GPIO10_WUSection").removeAttr('disabled', false);
		$("#GPIO10_WUPSection").removeAttr('disabled', false);
		$("#GPIO10_set").removeAttr('disabled', false);
	}
	
	gpioEnableTemp = $("#gpio11EnableGroup").find(':checked').val();
	
	if (gpioEnableTemp == 1) {
		$("#GPIO11_WUSection").attr('disabled', true);
		$("#GPIO11_WUPSection").attr('disabled', true);
		$("#GPIO11_set").attr('disabled', true);
		
		$("#GPIO11_WUSection").hide();
		$("#GPIO11_WUPSection").hide();
		$("#GPIO11_set").hide();
	} else {
		$("#GPIO11_WUSection").show();
		$("#GPIO11_WUPSection").show();
		$("#GPIO11_set").show();

		$("#GPIO11_WUSection").removeAttr('disabled', false);
		$("#GPIO11_WUPSection").removeAttr('disabled', false);
		$("#GPIO11_set").removeAttr('disabled', false);
	}
});

(function ($) {
    set_changed_fields_border_default = function () {
        $("input[type='text']").each(function() {
            $(this).css('border-color', 'LightGray');
        });

        $("input[type='number']").each(function() {
            $(this).css('border-color', 'LightGray');
        });

        $("input[type='checkbox']").each(function() {
            $(this).parent().removeClass("highlight");
        });

        $("input[type='radio']").each(function() {
            $(this).parent().removeClass("highlight");
        });
		
		var wid;
		//GPIO Enable for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "EnableGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Buffer for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "BufferGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Direction for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "DirectionGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Data for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "DataGroup";
			$(wid).parent().removeClass("highlight");
		}

        $(".dropdown li a").each(function () {
            var parent = $(this).closest('div');
            $(parent).css('border-color', 'transparent');
        });
    };
})(jQuery);

(function ($) {
    reset_file_input = function () {
        $("input[type='file']").val('');
		$("input[type='file']").css({
						background: "white",
						border: "0px"
						});
    };
})(jQuery);

function enable_all_fields() {
	$("#MAC_Section").attr('disabled', false);
	$("#DI_Hex_Section").attr('disabled', false);
	$("#DI_String_Section").attr('disabled', false);
	$("#RWPnP_Section").attr('disabled', false);
	$("#IEbI_Section").attr('disabled', false);
	$("#LED0_Section").attr('disabled', false);
	$("#LED1_Section").attr('disabled', false);
	$("#LED2_Section").attr('disabled', false);
	$("#LED3_Section").attr('disabled', false);
	$("#LEDBehavior_Section").attr('disabled', false);
	$("#GPIO0_section").attr('disabled', false);
	$("#GPIO1_section").attr('disabled', false);
	$("#GPIO2_section").attr('disabled', false);
	$("#GPIO3_section").attr('disabled', false);
	$("#GPIO4_section").attr('disabled', false);
	$("#GPIO5_section").attr('disabled', false);
	$("#GPIO6_section").attr('disabled', false);
	$("#GPIO7_section").attr('disabled', false);
	$("#GPIO8_section").attr('disabled', false);
	$("#GPIO9_section").attr('disabled', false);
	$("#GPIO10_section").attr('disabled', false);
	$("#GPIO11_section").attr('disabled', false);
	$("#PM_Section").attr('disabled', false);
}

//Onclick event for dropdown STARTS
$(document).on('click', '.dropdown li a', function (event) {
	// this code is for making the current selection appear with caret
	var $target = $(event.currentTarget);

	$target.closest('.btn-group')
	.find('[data-bind]').text($target.text())
	.end()
	.children('.dropdown-toggle').dropdown('toggle');
	var selop = $(this).text();
	console.log("Selected Option - All dropdowns:" + selop);
});
//Onclick event for dropdown ENDS

function setOfflineConf() {
	setFileType("bin", 1);
}
function getOfflineConftype() {
	setFileType("bin_ini", 0);
}

// Reset all fields
$("#Reset").click(function() {
	clearLANWidgetMap();
	setConfigMode(true, sku);
	setLoadAction(false);
	populateDefaultValues();
	offlineConfFile="";
	LoadConfFile = "";
	gArrConfigIndex = 0;
	changecount =0;
	$("input[type='file']").val('');	
	$("#Apply").attr('disabled',true);
	reset_file_input();
	// Change border back to default color from red
	//set_changed_fields_border_default();
	resetVariables();
	show_GPIO_status();
});
// End of Reset all fields

//Populating the default widget values based on the SKU
function populateDefaultValues() {
	
	var skuName = sku; //Get from the dropdown
	
	//Setting the configuration mode to offline in the backend
	setConfigMode(true, skuName);
	
	// Updating GwidgetlistHex
	$.each(GwidgetlistHex, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getLANWidgetValue(LAN_ID, value);
		
		if (widgetValue) {
			
			var disp = "";
			var vallength;
			var varlength_calc;
			var tempvalToShow = "";
			
			if ((value == "eepromconfigflag0") || (value == "eepromconfigflag1") || (value == "eepromconfigflag2") ||
			(value == "eepromconfigflag3") || (value == "eepromconfigflag4") || (value == "eepromconfigflag5")) {
				
				vallength = widgetValue.length;

				varlength_calc = 8-vallength;
				tempvalToShow = widgetValue;
				 
				if (varlength_calc > 0) {
					for (var k=varlength_calc; k>0; k--) {
						tempvalToShow = "0" + tempvalToShow;
					}
				} 
				disp = tempvalToShow;
				tempvalToShow = "";
				$(widgetid).val(disp);
				
			} else { 
				var decvalue = parseInt(widgetValue,10);
				var hexstring = decvalue.toString(16);
				$(widgetid).val(hexstring);
			}
		}
	});

	// Updating GwidgetlistString
	$.each(GwidgetlistString, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getLANWidgetValue(LAN_ID, value);
		if(widgetValue === "") {
			$(widgetid).val(stringnullvalue);
		} else {
			$(widgetid).val(widgetValue);
		}
	});

	// Updating GwidgetlistInt
	$.each(GwidgetlistInt, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = "" + getLANWidgetValue(LAN_ID, value);
		var Val = parseInt(widgetValue, 10);

		if(widgetValue === "") {
			$(widgetid).val("");
		} else {
			if ((value == "FSmaxpower") || (value == "HSmaxpower")) {
				Val = Val * 2;
				//hexstring = Val.toString(16);
			}
			
			if (value == "SSmaxpower") {
				Val = Val * 8;
				//hexstring = Val.toString(16);
			}
			$(widgetid).val(Val);
		}
	});

	// Updating GwidgetlistCheckbox
	$.each(GwidgetCheckbox, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getLANWidgetValue(LAN_ID, value);
		
		if ( widgetValue == checkbox_checked_value )
		{
			$(widgetid).prop('checked',true);     
			// If there are corresponding fieldsets - enable them 
			$(widgetid).trigger("change"); 
			set_changed_fields_border_default();
		}
		else {
			$(widgetid).prop('checked',false);
			// If there are corresponding fieldsets - disable them 
			$(widgetid).trigger("change"); 
			set_changed_fields_border_default();
		}
	});

	// Updating GwidgetlistRadio
	$.each(GwidgetlistRadio, function( index, value ) {
		var groupname = value +"Group";
		var widgetValue = getLANWidgetValue(LAN_ID, value);
		var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		set_changed_fields_border_default();
	});

	// Updating GwidgetlistDropDown
	$.each(GwidgetlistDropDown, function( index, value ) {
		var widgetValue = getLANWidgetValue(LAN_ID, value);
		var decval = parseInt(widgetValue,10);
		var nameofcontrol = "." + value;
		var nameofcontrol1 = "[data-bind=\"" + value + "label\"]";
		var selText = "None";

		if ((value == "LED0Function") || (value == "LED1Function") ||
		(value == "LED2Function") || (value == "LED3Function"))
		{
			$.each(DropDownLEDListFunction, function( index, valuelist ) {
				if ( index == decval)
				{
					selText = valuelist;
				}
			});
		}
		// Update fields based on obtained value
		$(nameofcontrol)
	   .find(nameofcontrol1).text(selText)
		.children('.dropdown-toggle').dropdown('toggle');
	});
	
	//Handling "GPIOEnable","GPIOBuffer","GPIODirection" and "GPIOData"
	//Updating GPIO Enable parameter
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	
	var groupname;
	var widVal;
	var controlName;

	//Start of GPIO 0
	//Updating for GPIO 0
	//GPIO Enable
	groupname = "gpio0EnableGroup";
	if ((gpio_enableVal & 1) == 1) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio0BufferGroup";
	if ((gpio_bufferVal & 1) == 1) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio0DirectionGroup";
	if ((gpio_directionVal & 1) == 1) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio0DataGroup";
	if ((gpio_dataVal & 1) == 1) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 0
	
	//Start of GPIO 1
	//Updating for GPIO 1
	//GPIO Enable
	groupname = "gpio1EnableGroup";
	if ((gpio_enableVal & 2) == 2) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio1BufferGroup";
	if ((gpio_bufferVal & 2) == 2) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio1DirectionGroup";
	if ((gpio_directionVal & 2) == 2) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio1DataGroup";
	if ((gpio_dataVal & 2) == 2) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 1
	
	//Start of GPIO 2
	//Updating for GPIO 2
	//GPIO Enable
	groupname = "gpio2EnableGroup";
	if ((gpio_enableVal & 4) == 4) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio2BufferGroup";
	if ((gpio_bufferVal & 4) == 4) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio2DirectionGroup";
	if ((gpio_directionVal & 4) == 4) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio2DataGroup";
	if ((gpio_dataVal & 4) == 4) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 2
	
	//Start of GPIO 3
	//Updating for GPIO 3
	//GPIO Enable
	groupname = "gpio3EnableGroup";
	if ((gpio_enableVal & 8) == 8) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio3BufferGroup";
	if ((gpio_bufferVal & 8) == 8) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio3DirectionGroup";
	if ((gpio_directionVal & 8) == 8) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio3DataGroup";
	if ((gpio_dataVal & 8) == 8) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 3
	
	//Start of GPIO 4
	//Updating for GPIO 4
	//GPIO Enable
	groupname = "gpio4EnableGroup";
	if ((gpio_enableVal & 16) == 16) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio4BufferGroup";
	if ((gpio_bufferVal & 16) == 16) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio4DirectionGroup";
	if ((gpio_directionVal & 16) == 16) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio4DataGroup";
	if ((gpio_dataVal & 16) == 16) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 4
	
	//Start of GPIO 5
	//Updating for GPIO 5
	//GPIO Enable
	groupname = "gpio5EnableGroup";
	if ((gpio_enableVal & 32) == 32) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio5BufferGroup";
	if ((gpio_bufferVal & 32) == 32) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio5DirectionGroup";
	if ((gpio_directionVal & 32) == 32) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio5DataGroup";
	if ((gpio_dataVal & 32) == 32) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 5
	
	//Start of GPIO 6
	//Updating for GPIO 6
	//GPIO Enable
	groupname = "gpio6EnableGroup";
	if ((gpio_enableVal & 64) == 64) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio6BufferGroup";
	if ((gpio_bufferVal & 64) == 64) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio6DirectionGroup";
	if ((gpio_directionVal & 64) == 64) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio6DataGroup";
	if ((gpio_dataVal & 64) == 64) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 6
	
	//Start of GPIO 7
	//Updating for GPIO 7
	//GPIO Enable
	groupname = "gpio7EnableGroup";
	if ((gpio_enableVal & 128) == 128) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio7BufferGroup";
	if ((gpio_bufferVal & 128) == 128) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio7DirectionGroup";
	if ((gpio_directionVal & 128) == 128) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio7DataGroup";
	if ((gpio_dataVal & 128) == 128) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 7
	
	//Start of GPIO 8
	//Updating for GPIO 8
	//GPIO Enable
	groupname = "gpio8EnableGroup";
	if ((gpio_enableVal & 256) == 256) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio8BufferGroup";
	if ((gpio_bufferVal & 256) == 256) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio8DirectionGroup";
	if ((gpio_directionVal & 256) == 256) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio8DataGroup";
	if ((gpio_dataVal & 256) == 256) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 8
	
	//Start of GPIO 9
	//Updating for GPIO 9
	//GPIO Enable
	groupname = "gpio9EnableGroup";
	if ((gpio_enableVal & 512) == 512) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio9BufferGroup";
	if ((gpio_bufferVal & 512) == 512) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio9DirectionGroup";
	if ((gpio_directionVal & 512) == 512) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio9DataGroup";
	if ((gpio_dataVal & 512) == 512) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 9
	
	//Start of GPIO 10
	//Updating for GPIO 10
	//GPIO Enable
	groupname = "gpio10EnableGroup";
	if ((gpio_enableVal & 1024) == 1024) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio10BufferGroup";
	if ((gpio_bufferVal & 1024) == 1024) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio10DirectionGroup";
	if ((gpio_directionVal & 1024) == 1024) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio10DataGroup";
	if ((gpio_dataVal & 1024) == 1024) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 10
	
	//Start of GPIO 11
	//Updating for GPIO 11
	//GPIO Enable
	groupname = "gpio11EnableGroup";
	if ((gpio_enableVal & 2048) == 2048) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Buffer
	groupname = "gpio11BufferGroup";
	if ((gpio_bufferVal & 2048) == 2048) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Direction
	groupname = "gpio11DirectionGroup";
	if ((gpio_directionVal & 2048) == 2048) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	
	//GPIO Data
	groupname = "gpio11DataGroup";
	if ((gpio_dataVal & 2048) == 2048) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	controlName = "input[name=" + groupname + "][value=" + widVal + "]";
	$(controlName).prop("checked", true);
	//End of GPIO 11
	
	//"GPIOWake" and "GPIOWakePolarity"
	//"GPIOWake" and "GPIOWakePolarity"
	var GPIOWake_val = getLANWidgetValue(LAN_ID, "GPIOWake");
	var GPIOWP_val = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var widgetValue;
	var nameofcontrol;
	
	if ((GPIOWake_val & 1) == 1) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio0Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 1) == 1) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio0Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 2) == 2) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio1Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 2) == 2) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio1Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 4) == 4) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio2Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 4) == 4) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio2Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 8) == 8) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio3Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 8) == 8) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio3Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 16) == 16) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio4Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 16) == 16) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio4Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 32) == 32) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio5Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 32) == 32) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio5Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 64) == 64) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio6Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 64) == 64) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio6Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 128) == 128) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio7Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 128) == 128) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio7Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 256) == 256) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio8Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 256) == 256) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio8Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 512) == 512) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio9Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 512) == 512) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio9Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 1024) == 1024) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio10Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 1024) == 1024) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio10Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWake_val & 2048) == 2048) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUgpio11Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
	if ((GPIOWP_val & 2048) == 2048) {
		widgetValue = 1;
	} else {
		widgetValue = 0;
	}
	nameofcontrol = "input[name=\"WUPgpio11Group\"][value=" + widgetValue + "]";
	$(nameofcontrol).prop("checked", true);
	
		//LED0combine
		groupname = "LED0CombineEnableGroup";
		if ((led1_behaviour & 1) == 1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED1combine
		groupname = "LED1CombineEnableGroup";
		if ((led1_behaviour & 2) == 2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED2combine
		groupname = "LED2CombineEnableGroup";
		if ((led1_behaviour & 4) == 4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED3combine
		groupname = "LED3CombineEnableGroup";
		if ((led1_behaviour & 8) == 8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED0
		groupname = "LED0Group";
		if ((led1_behaviour & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED1
		groupname = "LED1Group";
		if ((led1_behaviour & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED2
		groupname = "LED2Group";
		if ((led1_behaviour & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED3
		groupname = "LED3Group";
		if ((led2_behaviour & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LEDRateGroup
		groupname = "LEDRateGroup";
		if ((led2_behaviour & 12) == 12) {
			widVal = 3;
		} 
		else if((led2_behaviour & 0x8) == 0x8){
			widVal = 2;
		}
		else if((led2_behaviour & 0x4) == 0x4){
			widVal = 1;
		}
		else if((led2_behaviour & 0) == 0x0){
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED Pulsing
		groupname = "LEDPulsingGroup";
		if ((led2_behaviour & 0x10) == 0x10) {
			widVal = 1;
		} 
		else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
}

//Apply changes function
$("#Apply").click(function() {
	//Array to save the widgets and their values which were changed.
	var deltaobj = [];
	
	//List of widgets to display on the alert
	var widgetsToDisplay = [];
	var modifiedWidgets = [];
	
	//flag for alert message
	var errorFlag = false;
	
	if (offlineConfFile == "") {
		update_status_message("Please select a file to save the offline Configuration.");
		alert("Please select a file to save the offline Configuration.");
		return;
	}

	var memType = $("#Memgroup").find(':checked').val();
	
	if ((memType == "") || (typeof memType == 'undefined')) {
		update_status_message("Please select the appropriate memory(OTP/EEPROM) for which configuration file must be generated.");
		alert("Please select the appropriate memory(OTP/EEPROM) for which configuration file must be generated.");
		return;
	}
	
	if (memType == 1) {
		var eepromsizeChosen = $("#eepromchoicegroup").find(':checked').val();

		if ((eepromsizeChosen == "") || (typeof eepromsizeChosen == 'undefined')) {
			update_status_message("Please select the EEPROM size for which the configuration file is to be generated.");
			alert("Please select the EEPROM size for which the configuration file is to be generated.");
			return;
		}
	}
	
	//TO DO: String length constraint check and coding
	//String Descriptors
	var StringList = [];
	var stringsChanged = false;
	var totalStringLength = 0;
	$.each(GwidgetlistString, function( index1, value1 ) {
		var widgetid = "#" + value1;
		var oldval = getLANWidgetValue(LAN_ID, value1);
		if((typeof oldval== 'undefined') || (oldval =="undefined"))
		{
			errorFlag = true;
			return;
		}
		var newval = $(widgetid).val();
		
		if (value1 == "macaddr") {
			//Ignore as this is not part of the string descriptor
			
			//Validate the new MAC address entered
			var isMACok = ValidateMac(newval);

			if (!isMACok) {
				//update_status_message("Please enter a valid MAC address.");
				//alert("Please enter a valid MAC address.");
				errorFlag = true;
				return;
			}
		} else {
			if (newval == stringnullvalue) {
				newval = "";
			}
			StringList.push(value1, newval);
		}
		var that = $( widgetid ), parent = that.closest('fieldset');
		var checkdisabled = $(parent).prop( "disabled" );
		if ((newval == stringnullvalue) || (newval == oldval))
		{
			// do nothing no change detected.
		}
		else if (checkdisabled)
		{
			// Change detected but field is disabled - So do nothing
		}
		else {
			if (jQuery.isEmptyObject(newval)) {
				newval = "";
			}
			if ((value1 == "manufacturer") || (value1 == "product") || (value1 == "serial")
				|| (value1 == "configstring") || (value1 == "interfacestring")) {
				stringsChanged = true;
			}

			if ((value1 == "macaddr") && isMACok) {
				deltaobj.push(value1, newval);
				modifiedWidgets.push(value1);
			}
			if (value1 == "macaddr") {
				//MAC address is not a string descriptor. So it is not considered for length calculation.
			} else {
				totalStringLength = totalStringLength + newval.length;
			}
		}
	}); //End of $.each(GwidgetlistString, function( index1, value1 )*/

	var mem = $("#Memgroup").find(':checked').val();
	var eepromSize;
	if (mem == 1) {
		eepromSize = $("#eepromchoicegroup").find(':checked').val();
		
		if (eepromSize == 256) {
			if (totalStringLength > 29) {
				alert("Current EEPROM size is 256 and the total length of all the string descriptos should not exceed 29 characters.");
				update_status_message("Current EEPROM size is 256 and the total length of all the string descriptos should not exceed 29 characters.");
				errorFlag = true;
				return;
			}
		} else if (eepromSize == 512) {
			if (totalStringLength > 157) {
				alert("Current EEPROM size is 512 and the total length of all the string descriptos should not exceed 157 characters.");
				update_status_message("Current EEPROM size is 512 and the total length of all the string descriptos should not exceed 157 characters.");
				errorFlag = true;
				return;
			}
		} else {
			//Do nothing
		}
	} else if (mem == 2) {
		if (totalStringLength > 29) {
			alert("The total length of all the string descriptos should not exceed 29 characters.");
			update_status_message("The total length of all the string descriptos should not exceed 29 characters.");
			errorFlag = true;
			return;
		}
	}
	
	var K;
	var V;
	var F = 0;
	var newStringList = [];
	
	if (stringsChanged) {
		for (var i = 0; i < StringList.length; i = (i + 2)) {
			K = StringList[i];
			V = StringList[i+1];
			deltaobj.push(K, V);
			modifiedWidgets.push(K);
		}
	}

	//Hex Descriptors
	$.each(GwidgetlistHex, function( index1, value1 ) {
		var widgetid = "#" + value1;
			var oldval;
			var newval;
			var isOk;
			var valTOShow;
			var vallength;
			var varlength_calc;
			var tempvalToShow = "";
			var flagval;
			
			if ((value1 == "eepromconfigflag0") || (value1 == "eepromconfigflag1") || (value1 == "eepromconfigflag2") ||
			(value1 == "eepromconfigflag3") || (value1 == "eepromconfigflag4") || (value1 == "eepromconfigflag5")) {
			
				oldval =  getLANWidgetValue(LAN_ID, value1);
				vallength = oldval.length;
				varlength_calc = 8-vallength;
				tempvalToShow = oldval;
				
				if (varlength_calc > 0) {
					for (var k=varlength_calc; k>0; k--) {
						tempvalToShow = "0" + tempvalToShow;
					}
				} 
				oldval = tempvalToShow;
				newval = $(widgetid).val();
				isOk = /^[0-9A-Fa-f]{1,8}$/i.test($(widgetid).val());
				tempvalToShow = "";
				flagval = newval;
				oldval = parseInt(oldval, 16);
				newval = parseInt(newval, 16);
			} else {
			
				oldval = parseInt(getLANWidgetValue(LAN_ID, value1), 10);
				newval = parseInt($(widgetid).val(), 16);
				isOk = /^[0-9A-Fa-f]{1,4}$/i.test($(widgetid).val());
			}
			
			if (!isOk) {
				update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a hexadecimal value.");
				alert("The value entered for \"" + Mapping[value1] + "\" must be a hexadecimal value.");
				errorFlag = true;
			}
			
		if (!isOk) {
			update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a hexadecimal value.");
			alert("The value entered for \"" + Mapping[value1] + "\" must be a hexadecimal value.");
			errorFlag = true;
		}
		
		if (!isOk) {
			// Do nothing. The value entered does not meet the expected pattern.
		} else {
			if ((oldval === newval) || isNaN(newval)) {
				//Do nothing
			} else {
				//Check for language ID
				if (value1 == "langid") {
					if (newval == 0) {
						alert("Language ID cannot be zero.");// Setting it to default value (0x409)");
						//newval = parseInt("0x409", 16);
					}
				}

				// convert string to number                                        
				var decvalue;
				var valueToSet;
					
				if ((value1 == "eepromconfigflag0") || (value1 == "eepromconfigflag1") || (value1 == "eepromconfigflag2") ||
				(value1 == "eepromconfigflag3") || (value1 == "eepromconfigflag4") || (value1 == "eepromconfigflag5")) {
					valueToSet = "0x" + flagval;
					//debugAlert("valueToSet"+valueToSet);
				} else {
					decvalue = parseInt(newval,10);
				
					// convert number to string and then string to hex
					valueToSet = "0x" + (decvalue.toString(16));
				}
				var that = $( widgetid ), parent = that.closest('fieldset');
				var checkdisabled = $(parent).prop( "disabled" );
				if (checkdisabled)
				{
					// Change detected but field is disabled - So do nothing
				}
				else {
					var skuName = sku; //Get from the dropdown
					
					
					if ((value1 == "usb2vid") || (value1 == "usb2pid")) {
						var op = confirm("Modifying the " + Mapping[value1] + " requires a driver that supports it. Do you want to proceed?");
						
						if (!op) {
							//alert("User has chosen not to program " + Mapping[value1] + ". ");
							update_status_message("User has chosen not to program " + Mapping[value1] + ".");
						} else {
							//alert("User has chosen to program " + Mapping[value1] + ". Adding it to the list of change");
							update_status_message("User has chosen to program " + Mapping[value1] + ". Addind it to the list of change.");
							
							var skuName = sku;
							
							if((value1 == "usb2vid") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
									
									deltaobj.push(value1,valueToSet);
									deltaobj.push("usb3vid",valueToSet);
									modifiedWidgets.push(value1);
								}
								else if((value1 == "usb2pid") && ((skuName == "LAN7800") || (skuName == "LAN7801")))
								{
									deltaobj.push(value1,valueToSet);
									deltaobj.push("usb3pid",valueToSet);
									modifiedWidgets.push(value1);
								}
								
							}
						} else {
							
							if((value1 == "usb2did") && ((skuName == "LAN7800") || (skuName == "LAN7801"))){
							
							deltaobj.push(value1,valueToSet);
							deltaobj.push("usb3did",valueToSet);
							modifiedWidgets.push(value1);
							
							}
							else
							{
								deltaobj.push(value1,valueToSet);
								modifiedWidgets.push(value1);
							}
						}
					}
				}
			}
		});


	$.each(GwidgetlistInt, function(index1, value1) {
		var widgetid = "#" + value1;
		var oldval = getLANWidgetValue(LAN_ID, value1);
		var that = $(widgetid), parent = that.closest('fieldset');
		var checkdisabled = $(parent).prop("disabled");
		if ((value1 == "FSmaxpower") || (value1 == "HSmaxpower")) {
			oldval = oldval * 2;
		}
		
		if (value1 == "SSmaxpower") {
			oldval = oldval * 8;
		}
		
		var newval = $(widgetid).val();
		var newdecvalue = parseInt(newval,10);
		
		if ((oldval == newval) || isNaN(newval)) {
			// do nothing - no change in value
		} 
		else if (checkdisabled)
		{
			// Change detected but field is disabled - So do nothing
		}
		else {
			if ((value1 == "FSmaxpower") || (value1 == "HSmaxpower")) {
				if (newdecvalue > 500) {
					alert("Full speed max power and High Speed max power cannot exceed 500");
					update_status_message("Full speed max power and High Speed max power cannot exceed 500");
					errorFlag = true;
					return;
				}
				newdecvalue = newdecvalue/2;
			}
			
			if (value1 == "SSmaxpower") {
				if (newdecvalue > 900) {
					alert("Super speed max power cannot exceed 900");
					update_status_message("Super speed max power cannot exceed 900");
					errorFlag = true;
					return;
				}
				newdecvalue = newdecvalue/8;
			}
			
			if (value1 == "FSinterruptEPinterval") {
				
				if (newdecvalue > 255) {
				  alert("Interrupt Endpoint bInterval for Full Speed power cannot exceed 255");
				  update_status_message("Interrupt Endpoint bInterval for Full Speed power cannot exceed 255");
				  errorFlag = true;
				  return;
				 }
			}
				
			if (value1 == "HSinterruptEPinterval") {
				if (newdecvalue > 255) {
				  alert("Interrupt Endpoint bInterval for High Speed power cannot exceed 255");
				  update_status_message("Interrupt Endpoint bInterval for High Speed power cannot exceed 255");
				  errorFlag = true;
				  return;
				 }
			}
				
			if (value1 == "SSinterruptEPinterval") {
				if (newdecvalue > 255) {
				  alert("Interrupt Endpoint bInterval for Super Speed power cannot exceed 255");
				  update_status_message("Interrupt Endpoint bInterval for Super Speed power cannot exceed 255");
				  errorFlag = true;
				  return;
				 }
			}
				
			var hexDec = newdecvalue.toString(16);
			deltaobj.push(value1, hexDec);
			modifiedWidgets.push(value1);
		}
	});

	///Radio buttons
	$.each(GwidgetlistRadio, function(index2, value1) {
		var widgetgroupname = '#' + value1 +"Group";
		var oldval = getLANWidgetValue(LAN_ID, value1);
		var newval = $(widgetgroupname).find(':checked').val();
		var that = $( widgetgroupname ), parent = that.closest('fieldset');
		var checkdisabled = $(parent).prop( "disabled" );
		if ((oldval === newval) || jQuery.isEmptyObject(newval))
		{
			// do nothing
		}
		else if (checkdisabled)
		{
			// Change detected but field is disabled - So do nothing
		}
		else
		{
			deltaobj.push(value1, newval);
			modifiedWidgets.push(value1);
		}
	});

	//Checkbox
	$.each(GwidgetCheckbox, function( index2, value1 ) {
		var widgetid = "#" + value1;
		var oldval = getLANWidgetValue(LAN_ID, value1);
		var newval = checkbox_unchecked_value;
		var that = $( widgetid ), parent = that.closest('fieldset');
		var checkdisabled = $(parent).prop( "disabled" );
		if($(widgetid).is(':checked'))
		{
			newval = checkbox_checked_value;
		}
		
		// Enabled - check the previous value and determine delta                              
		if (oldval == newval) {
			// do nothing - no change in value
		} else if (checkdisabled) {
			// Change detected but field is disabled - So do nothing
		} else {
			deltaobj.push(value1, newval);
			modifiedWidgets.push(value1);
		}
	});

	$.each(GwidgetlistDropDown, function(index2, value1) {
		var nameofcontrol = "." + value1;
		var nameofcontrol1 = "[data-bind=\"" + value1 + "label\"]";
		var selText = $(nameofcontrol).find(nameofcontrol1).text();
		var newindexofdropdownlist;
		var that = $( nameofcontrol ), parent = that.closest('fieldset');
		var checkdisabled = $(parent).prop( "disabled" );

		if ((value1 == "LED0Function") || (value1 == "LED1Function") ||
		(value1 == "LED2Function") || (value1 == "LED3Function"))
		{
			$.each(DropDownLEDListFunction, function(index, valuelist) {
				if ( selText === valuelist)
				{
					newindexofdropdownlist = index;
				}
			});
		}
		
		var oldval = getLANWidgetValue(LAN_ID, value1);

		if (newindexofdropdownlist || newindexofdropdownlist == 0) {
			if ((newindexofdropdownlist == oldval))
			{
				// no change
			} else if (checkdisabled) {
				// Change detected but field is disabled - So do nothing
			} else {
				var dummyNewindexofdropdownlist = newindexofdropdownlist.toString(16);
				deltaobj.push(value1, dummyNewindexofdropdownlist);
				modifiedWidgets.push(value1);
			}
		}
	});
	// Start of Special Checkbox widgets
	//Handling "GPIOEnable","GPIOBuffer","GPIODirection" and "GPIOData"
	//Updating GPIO Enable parameter
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	
	var groupname;
	var widVal;
	var controlName;
	
	//Current values
	var gpio0Enable = $("#gpio0EnableGroup").find(':checked').val();
	var gpio1Enable = $("#gpio1EnableGroup").find(':checked').val();
	var gpio2Enable = $("#gpio2EnableGroup").find(':checked').val();
	var gpio3Enable = $("#gpio3EnableGroup").find(':checked').val();
	var gpio4Enable = $("#gpio4EnableGroup").find(':checked').val();
	var gpio5Enable = $("#gpio5EnableGroup").find(':checked').val();
	var gpio6Enable = $("#gpio6EnableGroup").find(':checked').val();
	var gpio7Enable = $("#gpio7EnableGroup").find(':checked').val();
	var gpio8Enable = $("#gpio8EnableGroup").find(':checked').val();
	var gpio9Enable = $("#gpio9EnableGroup").find(':checked').val();
	var gpio10Enable = $("#gpio10EnableGroup").find(':checked').val();
	var gpio11Enable = $("#gpio11EnableGroup").find(':checked').val();
	
	var gpio0Buffer = $("#gpio0BufferGroup").find(':checked').val();
	var gpio1Buffer = $("#gpio1BufferGroup").find(':checked').val();
	var gpio2Buffer = $("#gpio2BufferGroup").find(':checked').val();
	var gpio3Buffer = $("#gpio3BufferGroup").find(':checked').val();
	var gpio4Buffer = $("#gpio4BufferGroup").find(':checked').val();
	var gpio5Buffer = $("#gpio5BufferGroup").find(':checked').val();
	var gpio6Buffer = $("#gpio6BufferGroup").find(':checked').val();
	var gpio7Buffer = $("#gpio7BufferGroup").find(':checked').val();
	var gpio8Buffer = $("#gpio8BufferGroup").find(':checked').val();
	var gpio9Buffer = $("#gpio9BufferGroup").find(':checked').val();
	var gpio10Buffer = $("#gpio10BufferGroup").find(':checked').val();
	var gpio11Buffer = $("#gpio11BufferGroup").find(':checked').val();
	
	var gpio0Direction = $("#gpio0DirectionGroup").find(':checked').val();
	var gpio1Direction = $("#gpio1DirectionGroup").find(':checked').val();
	var gpio2Direction = $("#gpio2DirectionGroup").find(':checked').val();
	var gpio3Direction = $("#gpio3DirectionGroup").find(':checked').val();
	var gpio4Direction = $("#gpio4DirectionGroup").find(':checked').val();
	var gpio5Direction = $("#gpio5DirectionGroup").find(':checked').val();
	var gpio6Direction = $("#gpio6DirectionGroup").find(':checked').val();
	var gpio7Direction = $("#gpio7DirectionGroup").find(':checked').val();
	var gpio8Direction = $("#gpio8DirectionGroup").find(':checked').val();
	var gpio9Direction = $("#gpio9DirectionGroup").find(':checked').val();
	var gpio10Direction = $("#gpio10DirectionGroup").find(':checked').val();
	var gpio11Direction = $("#gpio11DirectionGroup").find(':checked').val();
	
	var gpio0Data = $("#gpio0DataGroup").find(':checked').val();
	var gpio1Data = $("#gpio1DataGroup").find(':checked').val();
	var gpio2Data = $("#gpio2DataGroup").find(':checked').val();
	var gpio3Data = $("#gpio3DataGroup").find(':checked').val();
	var gpio4Data = $("#gpio4DataGroup").find(':checked').val();
	var gpio5Data = $("#gpio5DataGroup").find(':checked').val();
	var gpio6Data = $("#gpio6DataGroup").find(':checked').val();
	var gpio7Data = $("#gpio7DataGroup").find(':checked').val();
	var gpio8Data = $("#gpio8DataGroup").find(':checked').val();
	var gpio9Data = $("#gpio9DataGroup").find(':checked').val();
	var gpio10Data = $("#gpio10DataGroup").find(':checked').val();
	var gpio11Data = $("#gpio11DataGroup").find(':checked').val();
	
	var LED0CombineEnable = $("#LED0CombineEnableGroup").find(':checked').val();
	var LED1CombineEnable = $("#LED1CombineEnableGroup").find(':checked').val();
	var LED2CombineEnable = $("#LED2CombineEnableGroup").find(':checked').val();
	var LED3CombineEnable = $("#LED3CombineEnableGroup").find(':checked').val();
	var LED0 = $("#LED0Group").find(':checked').val();
	var LED1 = $("#LED1Group").find(':checked').val();
	var LED2 = $("#LED2Group").find(':checked').val();
	var LED3 = $("#LED3Group").find(':checked').val();
	var LEDRate = $("#LEDRateGroup").find(':checked').val();
	var LEDPulsing = $("#LEDPulsingGroup").find(':checked').val();

	var gpio_EnTemp = gpio_enableVal;
	var gpio_BufTemp = gpio_bufferVal;
	var gpio_DirTemp = gpio_directionVal;
	var gpio_DataTemp = gpio_dataVal;
	var led1_Tempbehaviour = led1_behaviour;
	var led2_Tempbehaviour = led2_behaviour;
	
	var En_flag = false;
	var Buf_flag = false;
	var Dir_flag = false;
	var Data_flag = false;
	var Led1_flag = false;
	var Led2_flag = false;

	var mType = $("#Memgroup").find(':checked').val();
	var lanMem = "";
	if (mType == 1) {
		lanMem = "EEPROM";
	}
	//Start of GPIO 0
	//Updating for GPIO 0
	//GPIO Enable
	var skuName = sku;
	
	groupname = "gpio0EnableGroup";
	if ((gpio_enableVal & 0x1) == 0x1) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio0Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Enable/Disable cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Enable/Disable cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x1;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFFE;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
	}
	//GPIO Buffer
	var skuName = sku;
	
	groupname = "gpio0BufferGroup";
	if ((gpio_bufferVal & 0x1) == 0x1) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio0Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Buffer cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Buffer cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x1;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFFE;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
	}
	
	//GPIO Direction
	var skuName = sku;
	
	groupname = "gpio0DirectionGroup";
	if ((gpio_directionVal & 0x1) == 0x1) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio0Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Direction cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Direction cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x1;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFFE;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
	}
	
	//GPIO Data
	var skuName = sku;
	groupname = "gpio0DataGroup";
	if ((gpio_dataVal & 0x1) == 0x1) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio0Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Data cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Data cannot be programmed.");
			return;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x1;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFFE;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
	}
	//End of GPIO 0
	
	//Start of GPIO 1
	//Updating for GPIO 1
	//GPIO Enable
	var skuName = sku;
	groupname = "gpio1EnableGroup";
	if ((gpio_enableVal & 0x2) == 0x2) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio1Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Enable/Disable cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Enable/Disable cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x2;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFFD;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
	}
	
	//GPIO Buffer
	
	groupname = "gpio1BufferGroup";
	if ((gpio_bufferVal & 0x2) == 0x2) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio1Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Buffer cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Buffer cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x2;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFFD;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
	}
	
	//GPIO Direction
	
	groupname = "gpio1DirectionGroup";
	if ((gpio_directionVal & 0x2) == 0x2) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio1Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Direction cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Direction cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x2;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFFD;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
	}
	
	//GPIO Data
	
	groupname = "gpio1DataGroup";
	if ((gpio_dataVal & 0x2) == 0x2) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio1Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if(lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Data cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Data cannot be programmed.");
			return;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x2;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFFD;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
	}
	//End of GPIO 1
	
	//Start of GPIO 2
	//Updating for GPIO 2
	//GPIO Enable
	groupname = "gpio2EnableGroup";
	if ((gpio_enableVal & 0x4) == 0x4) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio2Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Enable/Disable cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Enable/Disable cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x4;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFFB;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
	}
	
	//GPIO Buffer
	
	groupname = "gpio2BufferGroup";
	if ((gpio_bufferVal & 0x4) == 0x4) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio2Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Buffer cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Buffer cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x4;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFFB;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
	}
	
	//GPIO Direction
	groupname = "gpio2DirectionGroup";
	if ((gpio_directionVal & 0x4) == 0x4) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio2Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Direction cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Direction cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x4;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFFB;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
	}
	
	//GPIO Data
	
	groupname = "gpio2DataGroup";
	if ((gpio_dataVal & 0x4) == 0x4) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio2Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Data cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Data cannot be programmed.");
			return;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x4;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFFB;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
	}
	//End of GPIO 2
	
	//Start of GPIO 3
	//Updating for GPIO 3
	//GPIO Enable
	
	groupname = "gpio3EnableGroup";
	if ((gpio_enableVal & 0x8) == 0x8) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio3Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Enable/Disable cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Enable/Disable cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x8;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFF7;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
	}
	
	//GPIO Buffer
	
	groupname = "gpio3BufferGroup";
	if ((gpio_bufferVal & 0x8) == 0x8) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio3Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Buffer cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Buffer cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x8;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFF7;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
	}
	
	//GPIO Direction
	
	groupname = "gpio3DirectionGroup";
	if ((gpio_directionVal & 0x8) == 0x8) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio3Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Direction cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Direction cannot be programmed.");
			return;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x8;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFF7;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
	}
	
	//GPIO Data
	
	groupname = "gpio3DataGroup";
	if ((gpio_dataVal & 0x8) == 0x8) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio3Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (lanMem == "EEPROM") {
			// Do nothing
			alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Data cannot be programmed.");
			update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Data cannot be programmed.");
			return;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x8;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFF7;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
	}
	//End of GPIO 3
	
	//Start of GPIO 4
	//Updating for GPIO 4
	//GPIO Enable
	groupname = "gpio4EnableGroup";
	if ((gpio_enableVal & 0x10) == 0x10) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	var skuName = sku;
	
	if (gpio4Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Enable/Disable cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Enable/Disable cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{
				if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x10;
				} else  if (widVal == 1) {
					gpio_EnTemp = gpio_EnTemp & 0xFEF;
				} else {
				//Do nothing
				}
				En_flag = true;
			}
	}
	
	//GPIO Buffer
	groupname = "gpio4BufferGroup";
	if ((gpio_bufferVal & 0x10) == 0x10) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	var skuName = sku;
	
	if (gpio4Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Buffer cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Buffer cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{
				if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x10;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFEF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
			}
	}
	
	//GPIO Direction
	groupname = "gpio4DirectionGroup";
	if ((gpio_directionVal & 0x10) == 0x10) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio4Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Direction cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Direction cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x10;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xFEF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
			}
	}
	
	//GPIO Data
	groupname = "gpio4DataGroup";
	if ((gpio_dataVal & 0x10) == 0x10) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio4Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Data cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Data cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else{
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x10;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xFEF;
		} else {
			//Do nothing
		}
		Data_flag = true;
			}
	}
	//End of GPIO 4
	
	//Start of GPIO 5
	//Updating for GPIO 5
	//GPIO Enable
	groupname = "gpio5EnableGroup";
	if ((gpio_enableVal & 0x20) == 0x20) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio5Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x20;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0xFDF;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio5BufferGroup";
	if ((gpio_bufferVal & 0x20) == 0x20) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio5Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x20;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0xFDF;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio5DirectionGroup";
	if ((gpio_directionVal & 0x20) == 0x20) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio5Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x20;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xFDF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio5DataGroup";
	if ((gpio_dataVal & 0x20) == 0x20) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio5Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x20;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xFDF;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 5
	
	//Start of GPIO 6
	//Updating for GPIO 6
	//GPIO Enable
	groupname = "gpio6EnableGroup";
	if ((gpio_enableVal & 0x40) == 0x40) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio6Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x40;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0xFBF;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio6BufferGroup";
	if ((gpio_bufferVal & 0x40) == 0x40) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio6Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x40;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0xFBF;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio6DirectionGroup";
	if ((gpio_directionVal & 0x40) == 0x40) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio6Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x40;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xFBF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio6DataGroup";
	if ((gpio_dataVal & 0x40) == 0x40) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio6Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x40;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xFBF;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 6
	
	//Start of GPIO 7
	//Updating for GPIO 7
	//GPIO Enable
	groupname = "gpio7EnableGroup";
	if ((gpio_enableVal & 0x80) == 0x80) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio7Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x80;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0xF7F;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio7BufferGroup";
	if ((gpio_bufferVal & 0x80) == 0x80) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio7Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x80;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0xF7F;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio7DirectionGroup";
	if ((gpio_directionVal & 0x80) == 0x80) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio7Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x80;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xF7F;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio7DataGroup";
	if ((gpio_dataVal & 0x80) == 0x80) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio7Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x80;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xF7F;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 7
	
	//Start of GPIO 8
	//Updating for GPIO 8
	//GPIO Enable
	groupname = "gpio8EnableGroup";
	if ((gpio_enableVal & 0x100) == 0x100) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio8Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x100;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0xEFF;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio8BufferGroup";
	if ((gpio_bufferVal & 0x100) == 0x100) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio8Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x100;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0xEFF;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio8DirectionGroup";
	if ((gpio_directionVal & 0x100) == 0x100) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio8Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x100;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xEFF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio8DataGroup";
	if ((gpio_dataVal & 0x100) == 0x100) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio8Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x100;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xEFF;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 8
	
	//Start of GPIO 9
	//Updating for GPIO 9
	//GPIO Enable
	groupname = "gpio9EnableGroup";
	if ((gpio_enableVal & 0x200) == 0x200) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio9Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x200;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0xDFF;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio9BufferGroup";
	if ((gpio_bufferVal & 0x200) == 0x200) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio9Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x200;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0xDFF;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio9DirectionGroup";
	if ((gpio_directionVal & 0x200) == 0x200) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio9Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x200;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xDFF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio9DataGroup";
	if ((gpio_dataVal & 0x200) == 0x200) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio9Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x200;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xDFF;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 9
	
	//Start of GPIO 10
	//Updating for GPIO 10
	//GPIO Enable
	groupname = "gpio10EnableGroup";
	if ((gpio_enableVal & 0x400) == 0x400) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio10Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x400;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0xBFF;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio10BufferGroup";
	if ((gpio_bufferVal & 0x400) == 0x400) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio10Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x400;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0xBFF;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio10DirectionGroup";
	if ((gpio_directionVal & 0x400) == 0x400) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio10Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x400;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0xBFF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio10DataGroup";
	if ((gpio_dataVal & 0x400) == 0x400) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio10Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x400;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0xBFF;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 10
	
	//Start of GPIO 11
	//Updating for GPIO 11
	//GPIO Enable
	groupname = "gpio11EnableGroup";
	if ((gpio_enableVal & 0x800) == 0x800) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio11Enable == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_EnTemp = gpio_EnTemp | 0x800;
		} else  if (widVal == 1) {
			gpio_EnTemp = gpio_EnTemp & 0x7FF;
		} else {
			//Do nothing
		}
		En_flag = true;
	}
	
	//GPIO Buffer
	groupname = "gpio11BufferGroup";
	if ((gpio_bufferVal & 0x800) == 0x800) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio11Buffer == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_BufTemp = gpio_BufTemp | 0x800;
		} else  if (widVal == 1) {
			gpio_BufTemp = gpio_BufTemp & 0x7FF;
		} else {
			//Do nothing
		}
		Buf_flag = true;
	}
	
	//GPIO Direction
	groupname = "gpio11DirectionGroup";
	if ((gpio_directionVal & 0x800) == 0x800) {
		widVal = 1;
	} else {
		widVal = 0;
	}
	if (gpio11Direction == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 0) {
			gpio_DirTemp = gpio_DirTemp | 0x800;
		} else  if (widVal == 1) {
			gpio_DirTemp = gpio_DirTemp & 0x7FF;
		} else {
			//Do nothing
		}
		Dir_flag  = true;
	}
	
	//GPIO Data
	groupname = "gpio11DataGroup";
	if ((gpio_dataVal & 0x800) == 0x800) {
		widVal = 0;
	} else {
		widVal = 1;
	}
	if (gpio11Data == widVal) {
		//Do nothing. The new and old value are the same;
	} else {
		if (widVal == 1) {
			gpio_DataTemp = gpio_DataTemp | 0x800;
		} else  if (widVal == 0) {
			gpio_DataTemp = gpio_DataTemp & 0x7FF;
		} else {
			//Do nothing
		}
		Data_flag = true;
	}
	//End of GPIO 11
	
	//LED0CombineEnable
		groupname = "LED0CombineEnableGroup";
		if ((led1_behaviour & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED0CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x1;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xFE;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED1CombineEnable
		groupname = "LED1CombineEnableGroup";
		if ((led1_behaviour & 0x2) == 0x2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED1CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x2;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xFD;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED2CombineEnable
		groupname = "LED2CombineEnableGroup";
		if ((led1_behaviour & 0x4) == 0x4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED2CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x4;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xFB;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED3CombineEnable
		groupname = "LED3CombineEnableGroup";
		if ((led1_behaviour & 0x8) == 0x8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED3CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x8;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xF7;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED0Group
		groupname = "LED0Group";
		if ((led1_behaviour & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED0 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x20;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xDF;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED1Group
		groupname = "LED1Group";
		if ((led1_behaviour & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED1 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x40;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xBF;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED2Group
		groupname = "LED2Group";
		if ((led1_behaviour & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED2 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x80;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0x7F;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED3Group
		groupname = "LED3Group";
		if ((led2_behaviour & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED3 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led2_Tempbehaviour = led2_Tempbehaviour | 0x1;
				} else  if (widVal == 1) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xFE;
				} else {
					//Do nothing
				}
				Led2_flag = true;
			
		}
		
		
		//LEDRateGroup
		groupname = "LEDRateGroup";
		if ((led2_behaviour & 12) == 12) {
			widVal = 3;
		} 
		else if((led2_behaviour & 0x8) == 0x8){
			widVal = 2;
		}
		else if((led2_behaviour & 0x4) == 0x4){
			widVal = 1;
		}
		else if((led2_behaviour & 0) == 0){
			widVal = 0;
		}
		
		if (LEDRate == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (LEDRate == 0) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xF3;
				} else  if (LEDRate == 1) {
					led2_Tempbehaviour = led2_Tempbehaviour | 0x4 ;
					led2_Tempbehaviour = led2_Tempbehaviour & 0xEF ;
				} else  if (LEDRate == 2) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xFB;
					led2_Tempbehaviour = led2_Tempbehaviour | 0x8;
				} else  if (LEDRate == 3) {
					led2_Tempbehaviour = led2_Tempbehaviour | 12;
				} else {
					//Do nothing
				}
				Led2_flag = true;
			
		}
		
		//LEDPulsingGroup
		groupname = "LEDPulsingGroup";
		if ((led2_behaviour & 0x10) == 0x10) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LEDPulsing == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led2_Tempbehaviour = led2_Tempbehaviour | 0x1;
				} else  if (widVal == 1) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xEF;
				} else {
					//Do nothing
				}
				Led2_flag = true;
			
		}
		
	if (En_flag) {
		var temp_gpio_EnTemp ;
		temp_gpio_EnTemp =  gpio_EnTemp.toString(16);
		deltaobj.push("GPIOEnable", temp_gpio_EnTemp);
		modifiedWidgets.push("GPIOEnable");
	}
	
	if (Led1_flag) {
		var temp_LED1_EnTemp ;
		temp_LED1_EnTemp =  led1_Tempbehaviour.toString(16);
		deltaobj.push("LED1Behavior", temp_LED1_EnTemp);
		
	}

	if (Led2_flag) {
		var temp_LED2_EnTemp ;
		temp_LED2_EnTemp =  led2_Tempbehaviour.toString(16);
		deltaobj.push("LED2Behavior", temp_LED2_EnTemp);
		
	}

	if(Led1_flag || Led2_flag)
	{
		modifiedWidgets.push("LEDBehavior");
	}
		
	if (Buf_flag) {
		var temp_gpio_BufTemp ;
		temp_gpio_BufTemp =  gpio_BufTemp.toString(16);
		deltaobj.push("GPIOBuffer", temp_gpio_BufTemp);
		modifiedWidgets.push("GPIOBuffer");
	}
	
	if (Dir_flag) {
		var temp_gpio_DirTemp ;
		temp_gpio_DirTemp =  gpio_DirTemp.toString(16);
		deltaobj.push("GPIODirection", temp_gpio_DirTemp);
		modifiedWidgets.push("GPIODirection");
	}
	
	if (Data_flag) {
		var temp_gpio_DataTemp ;
		temp_gpio_DataTemp =  gpio_DataTemp.toString(16);
		deltaobj.push("GPIOData", temp_gpio_DataTemp);
		modifiedWidgets.push("GPIOData");
	}
	
	
	//"GPIOWake" and "GPIOWakePolarity"
	var GPIOWake_val = getLANWidgetValue(LAN_ID, "GPIOWake");
	var GPIOWP_val = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldVal;
	var newVal;
	
	var WU_Temp = GPIOWake_val;
	var WUP_Temp = GPIOWP_val;
	
	var WU_flag = false;
	var WUP_flag = false;
	
	newVal = $("#WUgpio0Group").find(':checked').val();
	if ((GPIOWake_val & 0x1) == 0x1) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}

	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x1;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFFE;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}
	
	newVal = $("#WUPgpio0Group").find(':checked').val();
	if ((GPIOWP_val & 0x1) == 0x1) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x1;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFFE;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	newVal = $("#WUgpio1Group").find(':checked').val();
	if ((GPIOWake_val & 0x2) == 0x2) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x2;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFFD;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio1Group").find(':checked').val();
	if ((GPIOWP_val & 0x2) == 0x2) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x2;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFFD;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio2Group").find(':checked').val();
	if ((GPIOWake_val & 0x4) == 0x4) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x4;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFFB;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio2Group").find(':checked').val();
	if ((GPIOWP_val & 0x4) == 0x4) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x4;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFFB;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio3Group").find(':checked').val();
	if ((GPIOWake_val & 0x8) == 0x8) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x8;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFF7;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio3Group").find(':checked').val();
	if ((GPIOWP_val & 0x8) == 0x8) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x8;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFF7;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}

	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio4Group").find(':checked').val();
	if ((GPIOWake_val & 0x10) == 0x10) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x10;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFEF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio4Group").find(':checked').val();
	if ((GPIOWP_val & 0x10) == 0x10) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x10;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFEF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio5Group").find(':checked').val();
	if ((GPIOWake_val & 0x20) == 0x20) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x20;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFDF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio5Group").find(':checked').val();
	if ((GPIOWP_val & 0x20) == 0x20) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x20;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFDF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio6Group").find(':checked').val();
	if ((GPIOWake_val & 0x40) == 0x40) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x40;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xFBF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio6Group").find(':checked').val();
	if ((GPIOWP_val & 0x40) == 0x40) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x40;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xFBF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio7Group").find(':checked').val();
	if ((GPIOWake_val & 0x80) == 0x80) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x80;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xF7F;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio7Group").find(':checked').val();
	if ((GPIOWP_val & 0x80) == 0x80) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x80;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xF7F;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio8Group").find(':checked').val();
	if ((GPIOWake_val & 0x100) == 0x100) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x100;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xEFF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio8Group").find(':checked').val();
	if ((GPIOWP_val & 0x100) == 0x100) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x100;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xEFF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio9Group").find(':checked').val();
	if ((GPIOWake_val & 0x200) == 0x200) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x200;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xDFF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio9Group").find(':checked').val();
	if ((GPIOWP_val & 0x200) == 0x200) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x200;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xDFF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio10Group").find(':checked').val();
	if ((GPIOWake_val & 0x400) == 0x400) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x400;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0xBFF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}

	newVal = $("#WUPgpio10Group").find(':checked').val();
	if ((GPIOWP_val & 0x400) == 0x400) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x400;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0xBFF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	newVal = $("#WUgpio11Group").find(':checked').val();
	if ((GPIOWake_val & 0x800) == 0x800) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WU_Temp = WU_Temp | 0x800;
		} else  if (oldVal == 1) {
			WU_Temp = WU_Temp & 0x7FF;
		} else {
			//Do nothing
		}
		WU_flag = true;
	}
	
	newVal = $("#WUPgpio11Group").find(':checked').val();
	if ((GPIOWP_val & 0x800) == 0x800) {
		oldVal = 1;
	} else {
		oldVal = 0;
	}
	
	if (oldVal == newVal) {
		//Do nothing.
	} else {
		if (oldVal == 0) {
			WUP_Temp = WUP_Temp | 0x800;
		} else  if (oldVal == 1) {
			WUP_Temp = WUP_Temp & 0x7FF;
		} else {
			//Do nothing
		}
		WUP_flag = true;
	}
	///////////////////////////////////////////////////
	
	if (WU_flag) {
		WU_Temp = WU_Temp.toString(16);
		deltaobj.push("GPIOWake", WU_Temp);
		modifiedWidgets.push("GPIOWake");
	}
	
	if (WUP_flag) {
		WUP_Temp = WUP_Temp.toString(16);
		deltaobj.push("GPIOWakePolarity", WUP_Temp);
		modifiedWidgets.push("GPIOWakePolarity");
	}
	///////////////////////////////////////////////////
	
	//End of Special Checkbox widgets
	var stringToSet = "";
	var wKey;
	var wVal;
	var flag = 0;

	if (deltaobj.length != 0) {
		for (var i = deltaobj.length; i >= 0; i = i - 2) {
			wKey = deltaobj[i];
			wVal = deltaobj[i+1];
			if ((typeof wKey === 'undefined') || (typeof wVal === 'undefined')) {
				// Do nothing
			} else {
				stringToSet = wKey + ",,," + wVal + ";;;" + stringToSet;
				flag++;
			}
		}
	}

	if (flag == 0 && errorFlag == false)
	{
		alert("No changes detected for offline configuration.");
		update_status_message("No changes detected for offline configuration.");
	} else {
		if(errorFlag == false)
		{
			var displayChange = "";
			for (var i = 0; i < modifiedWidgets.length; i++) {
				if(i%4 == 0)
				{
					if (displayChange) {
						displayChange = "\n" + Mapping[modifiedWidgets[i]] + ", " + displayChange;
					} else {
						displayChange = Mapping[modifiedWidgets[i]];
					}
				} else {
					if (displayChange) {
						displayChange = Mapping[modifiedWidgets[i]] + ", " + displayChange;
					}
				}
			}
			//Configuration must be generated for which type of memory
			var memType = $("#Memgroup").find(':checked').val();
			var eepromSize = $("#eepromchoicegroup").find(':checked').val();
			var memorytypeChoosen;
			
			if(memType == "1") {
				if(eepromSize == "256") {
					memorytypeChoosen = "1";
				}
				else {
					memorytypeChoosen = "3";
				}
			}
			else if(memType == "2") {
				memorytypeChoosen = "2";
			}
			
			var option = confirm("Configuration file will be generated with the following device settings\n" + displayChange);
			
			
			if (option) {
				var result = setLANOfflineConfiguration(sku, memorytypeChoosen, stringToSet);
				
				if (result) {
					alert("Offline configuration was created successfully");
					update_status_message("Offline configuration was created successfully for the following widgets.\n" + displayChange);
				} else {
					alert("Offline configuration failed.");
					update_status_message("Offline configuration failed.");		
				}
			} else {
				update_status_message("Generation of configuration file was terminated by the user.");
			}
		}
	}
	
	//Required clean up action
	errorFlag = false;
	resetVariables();
});

(function ($) {
    update_status_message = function (mesg) {
        var currentdate = new Date(); 
        currentdate+''; 
        var datetime = currentdate.toLocaleString();
        $("#DSStatusMessage").append( datetime +":"+ mesg + "\n");
        $("#DSStatusMessage").animate({
            scrollTop:$("#DSStatusMessage")[0].scrollHeight - $("#DSStatusMessage").height()
            },400,function(){
          })
        };
})(jQuery);

function resetVariables () {
 macaddr_check = 0;
 usb2vid_check = 0;
 usb2pid_check = 0;
 usb2did_check = 0;
 langid_check = 0;
 eepromconfigflag0_check = 0;
 eepromconfigflag1_check = 0;
 eepromconfigflag2_check = 0;
 eepromconfigflag3_check = 0;
 eepromconfigflag4_check = 0;
 eepromconfigflag5_check = 0;
 manufacturer_check = 0;
 product_check = 0;
 serial_check = 0;
 configstring_check = 0;
 interfacestring_check = 0;
 enremwakeup_check = 0;
 enbuspower_check = 0;
 enselfpower_check = 0;
 HSmaxpower_check = 0;
 FSmaxpower_check = 0;
 SSmaxpower_check = 0;
 FSinterruptEPinterval_check = 0;
 HSinterruptEPinterval_check = 0;
 SSinterruptEPinterval_check = 0;
 LED0Enable_check = 0;
 LED1Enable_check = 0;
 LED2Enable_check = 0;
 LED3Enable_check = 0;
 LED0Function_check = 0;
 LED1Function_check = 0;
 LED2Function_check = 0;
 LED3Function_check = 0;
 LED0Combine_check = 0;
 LED1Combine_check = 0;
 LED2Combine_check = 0;
 LED3Combine_check = 0;
 LED0_check = 0;
 LED1_check = 0;
 LED2_check = 0;
 LED3_check = 0;
 LEDRate_check = 0;
 LEDPulsing_check = 0;
 gpio0EnableGroup_check = 0;
 gpio1EnableGroup_check = 0;
 gpio2EnableGroup_check = 0;
 gpio3EnableGroup_check = 0;
 gpio4EnableGroup_check = 0;
 gpio5EnableGroup_check = 0;
 gpio6EnableGroup_check = 0;
 gpio7EnableGroup_check = 0;
 gpio8EnableGroup_check = 0;
 gpio9EnableGroup_check = 0;
 gpio10EnableGroup_check = 0;
 gpio11EnableGroup_check = 0;
 gpio0BufferGroup_check = 0;
 gpio1BufferGroup_check = 0;
 gpio2BufferGroup_check = 0;
 gpio3BufferGroup_check = 0;
 gpio4BufferGroup_check = 0;
 gpio5BufferGroup_check = 0;
 gpio6BufferGroup_check = 0;
 gpio7BufferGroup_check = 0;
 gpio8BufferGroup_check = 0;
 gpio9BufferGroup_check = 0;
 gpio10BufferGroup_check = 0;
 gpio11BufferGroup_check = 0;
 gpio0DirectionGroup_check = 0;
 gpio1DirectionGroup_check = 0;
 gpio2DirectionGroup_check = 0;
 gpio3DirectionGroup_check = 0;
 gpio4DirectionGroup_check = 0;
 gpio5DirectionGroup_check = 0;
 gpio6DirectionGroup_check = 0;
 gpio7DirectionGroup_check = 0;
 gpio8DirectionGroup_check = 0;
 gpio9DirectionGroup_check = 0;
 gpio10DirectionGroup_check = 0;
 gpio11DirectionGroup_check = 0;
 gpio0DataGroup_check = 0;
 gpio1DataGroup_check = 0;
 gpio2DataGroup_check = 0;
 gpio3DataGroup_check = 0;
 gpio4DataGroup_check = 0;
 gpio5DataGroup_check = 0;
 gpio6DataGroup_check = 0;
 gpio7DataGroup_check = 0;
 gpio8DataGroup_check = 0;
 gpio9DataGroup_check = 0;
 gpio10DataGroup_check = 0;
 gpio11DataGroup_check = 0;
 GPIOPMEEnableGroup_check = 0;
 GPIOPMEConfigurationGroup_check = 0;
 GPIOPMELengthGroup_check = 0;
 GPIOPMEPolarityGroup_check = 0;
 GPIOBufferTypeGroup_check = 0;
 GPIOPMEWOLSelectGroup_check = 0;
 PMEMagicPacketEnableGroup_check = 0;
 PMEPerfectDAEnableGroup_check = 0;
 PMEWUFFEnableGroup_check = 0;
 WUgpio0Group_check = 0;
 WUgpio1Group_check = 0;
 WUgpio2Group_check = 0;
 WUgpio3Group_check = 0;
 WUgpio4Group_check = 0;
 WUgpio5Group_check = 0;
 WUgpio6Group_check = 0;
 WUgpio7Group_check = 0;
 WUgpio8Group_check = 0;
 WUgpio9Group_check = 0;
 WUgpio10Group_check = 0;
 WUgpio11Group_check = 0;
 WUPgpio0Group_check = 0;
 WUPgpio1Group_check = 0;
 WUPgpio2Group_check = 0;
 WUPgpio3Group_check = 0;
 WUPgpio4Group_check = 0;
 WUPgpio5Group_check = 0;
 WUPgpio6Group_check = 0;
 WUPgpio7Group_check = 0;
 WUPgpio8Group_check = 0;
 WUPgpio9Group_check = 0;
 WUPgpio10Group_check = 0;
 WUPgpio11Group_check = 0;
 }
 
 function ValidateMac(currMac) {
	var macflag = true;
	
	MacValue = currMac.split(":");
	
	var maclength = MacValue.length;
	
	if(maclength < 6 || maclength > 6)
	{
		alert("The Given MAC Address is not valid.Mac Address should be for Example = 00:80:0F:10:20:01");
		return false;
	}
	
	for (var i = 0; i < 6; i++) {
	
	var isMacOKAddr= /^[0-9a-fA-F]{1,2}$/i.test(MacValue[i]);

	if(!isMacOKAddr)
	{
		alert("The Given MAC Address is not a valid Hexa decimal");
		return false;
	}

	if((MacValue[i] == 00) || (MacValue[i] == 255))
	{
		//will continue loop.Do nothing
	}
	else
	{
		macflag = false;
		
	}
	if( i == 5 && macflag == true)
	{
		alert("The Given MAC Address is not valid.Mac Address should be for Example = 00:80:0F:10:20:01");
		return false;
	}
}
	return true;
}
