/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license
*/
//Variables to know which page has been selected: USB2.0 or USB3.1 Gen1
//var Product = getProduct();
//var ConfigType = getConfigType();
var LAN_ID = "";
var lansFound = false;
var stringnullvalue = "NULL STRING - NOT PROGRAMMED YET";

// values returned if a value is 1 from the backend
var checkbox_checked_value = "1";
var checkbox_unchecked_value = "0";

var enableApplyButton = false;
var CurrentLANProgrammed = "";
var disableWhenEEPROMLess = false;

//Widget IDs of String fields in the GUI
var GwidgetlistString = [
	"macaddr",
	"manufacturer",
	"product",
	"serial",
	"configstring",
	"interfacestring"
];

//Widget IDs of Hex fields in the GUI
var GwidgetValuelistHex = [
	"usb2vid",
	"usb2pid",
	"usb2did",
	"langid",
	"eepromconfigflag1",
	"eepromconfigflag0",
	"eepromconfigflag2",
	"eepromconfigflag3",
	"eepromconfigflag4",
	"eepromconfigflag5"
	
	
];

//Widget IDs of Int fields in the GUI
var GwidgetlistInt = [
	"FSmaxpower",
	"HSmaxpower",
	"SSmaxpower",
	"FSinterruptEPinterval",
	"HSinterruptEPinterval",
	"SSinterruptEPinterval"
];

//Widget IDs of Checkbox fields in the GUI
var GwidgetCheckbox = [
	"enremwakeup",
	"enselfpower",
	"LED0Enable",
	"LED1Enable",
	"LED2Enable",
	"LED3Enable"
];

var GwidgetlistDropDown = [
	"LED0Function",
	"LED1Function",
	"LED2Function",
	"LED3Function"
];

var DropDownLEDListFunction = [
	"Link/Activity",
	"Link1000/Activity",
	"Link100/Activity",
	"Link10/Activity",
	"Link100/1000/Activity",
	"Link10/1000/Activity",
	"Link10/100/Activity",
	"Reserved",
	"Duplex/Collision",
	"Collision",
	"Activity",
	"Reserved",
	"Auto-Negotiation Fault",
	"Serial Mode",
	"Force LED Off",
	"Force LED On"
];

//Widget IDs of Radio fields in the GUI
var GwidgetlistRadio = [
	"GPIOPMEEnable",
	"GPIOPMEConfiguration",
	"GPIOPMELength",
	"GPIOPMEPolarity",
	"GPIOBufferType",
	"GPIOPMEWOLSelect",
	"PMEMagicPacketEnable",
	"PMEPerfectDAEnable",
	"PMEWUFFEnable"
];

//They are handled separately
/*"GPIOEnable",
"GPIOBuffer",
"GPIODirection",
"GPIOData"*/

//Have been hidden as they make sense only for HSIC 
/*"GPIOConnectEnable",
"GPIOConnectBufferType",
"GPIOConnectPolarity"*/

//They are checkboxes for each GPIO which is handled separately.
/*"GPIOWake",
"GPIOWakePolarity",*/

//Mapping Hex widgets to the meaningful elaborations to print while in error
var Mapping = {
	"macaddr": "MAC Address",
	"manufacturer": "Manufacturer",
	"product": "Product",
	"serial": "Serial",
	"configstring": "Configuration String",
	"interfacestring": "Interface String",
	"usb2vid": "Vendor ID",
	"usb2pid": "Product ID",
	"usb2did": "Device ID",
	"langid": "Language ID",
	"LED0Function": "LED 0 Function",
	"LED1Function": "LED 1 Function",
	"LED2Function": "LED 2 Function",
	"LED3Function": "LED 3 Function",
	"FSmaxpower": "Full Speed Max Power",
	"HSmaxpower": "High Speed Max Power",
	"SSmaxpower": "Super Speed Max Power",
	"FSinterruptEPinterval": "Full Speed Interrupt bInterval",
	"HSinterruptEPinterval": "High Speed Interrupt bInterval",
	"SSinterruptEPinterval": "Super Speed Interrupt bInterval",
	"enremwakeup": "Enable Remote Wakeup",
	"enselfpower": "Enable Self Power",
	"LED0Enable": "LED 0 Enable",
	"LED1Enable": "LED 1 Enable",
	"LED2Enable": "LED 2 Enable",
	"LED3Enable": "LED 3 Enable",
	"LEDBehavior": "LED Behavior",
	"eepromconfigflag0" : "Config Flag 0",
	"eepromconfigflag1" : "Config Flag 1",
	"eepromconfigflag2" : "Config Flag 2",
	"eepromconfigflag3" : "Config Flag 3",
	"eepromconfigflag4" : "Config Flag 4",
	"eepromconfigflag5" : "Config Flag 5",
	"GPIOPMEEnable": "GPIO PME Enable",
	"GPIOPMEConfiguration": "GPIO PME Configuration",
	"GPIOPMELength": "GPIO PME Length",
	"GPIOPMEPolarity": "GPIO PME Polarity",
	"GPIOBufferType": "GPIO Buffer Type",
	"GPIOPMEWOLSelect": "GPIO PME WOL Select",
	"PMEMagicPacketEnable": "PME Magic Packet Enable",
	"PMEPerfectDAEnable": "PME Perfect DA Enable",
	"PMEWUFFEnable":"PME WUFF Enable",
	"GPIOEnable": "GPIO Enable",
	"GPIOBuffer": "GPIO Buffer",
	"GPIODirection": "GPIO Direction",
	"GPIOData": "GPIO Data",
	"GPIOWake": "GPIO Wakeup",
	"GPIOWakePolarity": "GPIO Wakeup Polarity"
};

(function ($) {
    get_LAN_list = function () {
		//Close All LAN instances
		closeAll_lan_devices();
		set_changed_fields_border_default();

        // Populate the List of LANs		
		clearLANWidgetMap();
		setConfigMode(false, "NULL");
		var i = 0;
		update_status_message("Fetching the LAN list...");
		var data = "";
		data = getLANList();
		$("#dropDownUL").empty();

		if (data) {
			enable_fields();
			$("#Apply").attr('disabled', false);
			$("#Preview").attr('disabled', false);
			$("#Factory").attr('disabled', false);
			$("#eepromErase").attr('disabled', false);
			enableApplyButton = true;
			var lan_list = data.split("###");
			
			for (var k = (lan_list.length - 1); k >= 0; k--) {
				if (lan_list[k]) {
					update_status_message(lan_list[k]);
					$("#dropDownUL").append("<li> <a tabindex=\"-1\" href=\"javascript:void(0)\" align=\"left\">" + lan_list[k] + "</a> </li>");
				}
			}

			$("#selectedLANinput").val(lan_list[(lan_list.length - 2)]);
					$('.selectLAN1')
					.find('[data-bind="SelectLAN78XX"]').text(lan_list[(lan_list.length - 2)])
					.children('.dropdown-toggle').dropdown('toggle');

			var btnValue = $("#selectedLANinput").val();
			var colonIndex = btnValue.indexOf(":");
			LAN_ID = "" + btnValue.charAt(colonIndex + 1);
			lansFound = true;
		} else {
			var errorCode = getMchpLANLastError("0");
			
			if (errorCode == 24576) {
				alert(errorMap[Dec2Hex(errorCode)] + " Please open the application as Administrator.");
				update_status_message(errorMap[Dec2Hex(errorCode)] + " Please open the application as Administrator.");
			} else {
				if(errorCode == -1){ 
					window.alert("No LAN78XX Ethernet Bridging Device found");
					update_status_message("No LAN78XX Ethernet Bridging Device found");
				} else {
					window.alert(errorMap[Dec2Hex(errorCode)] + "No LAN78XX Ethernet Bridging Device found");
					update_status_message(errorMap[Dec2Hex(errorCode)] + "No LAN78XX Ethernet Bridging Device found");
				}
				
			}
			reset_fields();
			$("#Apply").attr('disabled', true);
			$("#Preview").attr('disabled', true);
			$("#Factory").attr('disabled', true);
			$("#eepromErase").attr('disabled', true);
			enableApplyButton = false;
			disable_fields();
			lansFound = false;
		}
    };
})(jQuery);

(function ($) {
    update_status_message = function (mesg) {
        var currentdate = new Date(); 
        currentdate+''; 
        var datetime = currentdate.toLocaleString();
        $("#DSStatusMessage").append( datetime +":"+ mesg + "\n");
        $("#DSStatusMessage").animate({
            scrollTop:$("#DSStatusMessage")[0].scrollHeight - $("#DSStatusMessage").height()
            },400,function(){
          })
        };
})(jQuery);


(function ($) {
    get_LAN_list_set_LAN_index_zero = function () {

		get_LAN_list();
		
		
		if (lansFound) {
			set_selected_lan_get_widgets();
		}
		
		//Hiding the GPIO Data with respect to the current value of the GPIO
		var gpioDirTemp = $("#gpio0DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio0DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio0DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio1DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio1DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio1DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio2DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio2DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio2DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio3DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio3DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio3DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio4DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio4DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio4DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio5DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio5DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio5DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio6DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio6DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio6DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio7DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio7DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio7DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio8DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio8DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio8DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio9DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio9DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio9DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio10DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio10DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio10DataSection").show();
		} else {
			//Do nothing
		}
		
		gpioDirTemp = $("#gpio11DirectionGroup").find(':checked').val();
		
		if (gpioDirTemp == 0) {
			$("#gpio11DataSection").hide();
		} else if (gpioDirTemp == 1) {
			$("#gpio11DataSection").show();
		} else {
			//Do nothing
		}
		
		
    };
})(jQuery);

(function ($) {
    get_LAN_list_set_LAN_index = function () {
        get_LAN_list();
		$("#selectedLANinput").val(CurrentLANProgrammed);
		var colonIndex = CurrentLANProgrammed.indexOf(":");
		LAN_ID = "" + CurrentLANProgrammed.charAt(colonIndex + 1);
		$('.selectLAN1')
			.find('[data-bind="SelectLAN78XX"]').text(CurrentLANProgrammed)
			.children('.dropdown-toggle').dropdown('toggle');
		set_selected_lan_get_widgets();
    };
})(jQuery);

/*function isMACok(mac) {
	return (/^([0-9A-Fa-f]{2}[:]{5}([0-9A-Fa-f]{2}))$/i.test(mac));
}*/

var lanMemory;
(function ($) {
    set_selected_lan_get_widgets = function () {
		var skuName = get_sku(LAN_ID);
		
		if ((skuName == "LAN7800")) {
		
			$("#gpio8fieldset").attr('disabled', true);
			$("#gpio9fieldset").attr('disabled', true);
			$("#gpio10fieldset").attr('disabled', true);
			$("#gpio11fieldset").attr('disabled', true);

			//$("#NotForLAN7800").hide();
			$("#gpio8fieldset").hide();
			$("#gpio9fieldset").hide();
			$("#gpio10fieldset").hide();
			$("#gpio11fieldset").hide();
			
			
			$("#ssPowerSection").removeAttr('disabled', false);
			$("#ssIntervalSection").removeAttr('disabled', false);
				
			$("#ssPowerSection").show();
			$("#ssIntervalSection").show();
		} else if((skuName == "LAN7850")){
			//$("#NotForLAN7800").show();
			$("#gpio8fieldset").show();
			$("#gpio9fieldset").show();
			$("#gpio10fieldset").show();
			$("#gpio11fieldset").show();
			
			$("#gpio8fieldset").removeAttr('disabled', false);
			$("#gpio9fieldset").removeAttr('disabled', false);
			$("#gpio10fieldset").removeAttr('disabled', false);
			$("#gpio11fieldset").removeAttr('disabled', false);	
				
			
			$("#ssPowerSection").attr('disabled', true);
			$("#ssIntervalSection").attr('disabled', true);
			
			$("#ssPowerSection").hide();
			$("#ssIntervalSection").hide();
		}
		else if ((skuName == "LAN7801")) {
		
			$("#ssPowerSection").removeAttr('disabled', false);
			$("#ssIntervalSection").removeAttr('disabled', false);
				
			$("#ssPowerSection").show();
			$("#ssIntervalSection").show();
		}

		if (skuName == "") {
			skuName = "not identified";
		}

		update_status_message("The skuName for the LAN78XX Ethernet Briding Device of Index: " + LAN_ID + " is " + skuName + ".");

		if (skuName) {
			//enable_fields();
			$("#AIPNInput").val(skuName);
			
			if ((skuName === "NOT MICROCHIP") || (skuName === "NOT IMPLEMENTED"))
			{
				alert("LAN78XX is not a Microchip LAN.Please select a Microchip LAN");
				update_status_message("LAN78XX is not a Microchip LAN.Please select a Microchip LAN");

			} else {
				update_status_message ("The selected LAN part number is " + skuName);

				// LAN Memory Information
				lanMemory = get_lan_memory(LAN_ID);
		
				var otpConfLoc;
				var otpMem;
				if ((lanMemory == "EEPROM") || (lanMemory == "")){
					$("#OTPConfigLoadSection").hide();
				} else {
					$("#OTPConfigLoadSection").show();
					otpMem = lanMemory.split("_");
					lanMemory = otpMem[0];
					otpConfLoc = otpMem[1];
					
				}
				
				if (lanMemory != "") {
					
					var nameofcontrol = "input[name=ConfigLocationGroup][value=" + lanMemory + "]";
					$(nameofcontrol).prop("checked", true);
					
					if (lanMemory == "OTP") {
						$("#OTPConfigProgrammed").val(otpConfLoc);
					}
				} else {
					var errorCode = getMchpLANLastError(LAN_ID);
					if (errorCode == 24579) {
						alert(errorMap[Dec2Hex(errorCode)]);
						update_status_message(errorMap[Dec2Hex(errorCode)]);
						disableWhenEEPROMLess = true;
					} else if(errorCode == 24580){
						window.alert(errorMap[Dec2Hex(errorCode)]);
						update_status_message(errorMap[Dec2Hex(errorCode)]);
					} else if(errorCode == 24581){
						window.alert(errorMap[Dec2Hex(errorCode)]);
						update_status_message(errorMap[Dec2Hex(errorCode)]);
						disableWhenEEPROMLess = true;
					} else if(errorCode == 24582){
						window.alert(errorMap[Dec2Hex(errorCode)]);
						update_status_message(errorMap[Dec2Hex(errorCode)]);
						disableWhenEEPROMLess = true;
					} else if(errorCode == 24583){
						window.alert(errorMap[Dec2Hex(errorCode)]);
						update_status_message(errorMap[Dec2Hex(errorCode)]);
						disableWhenEEPROMLess = true;
					}
					
					if(disableWhenEEPROMLess) {
						reset_fields();
						$("#Apply").attr('disabled', true);
						$("#Preview").attr('disabled', true);
						$("#Factory").attr('disabled', true);
						$("#eepromErase").attr('disabled', true);
						$('#myprogress').hide();
						enableApplyButton = false;
						disable_fields();
						lansFound = false;
						return;
					}
					
				}
			}
		}
		//getLANWidgetValue(LAN_ID);
		
		//Updating String widgets
		$.each(GwidgetlistString, function( index, value ) {
			var widgetid = "#" + value;
			var widgetValue = getLANWidgetValue(LAN_ID, value);
			if(widgetValue === "") {
				$(widgetid).val(stringnullvalue);
			} else {
				$(widgetid).val(widgetValue);
			}
		});
		
		// Updating GwidgetlistHex
		$.each(GwidgetValuelistHex, function( index, value ) {
			var widgetid = "#" + value;
			var widgetValue = getLANWidgetValue(LAN_ID, value);
			
			var disp = "";
			var vallength;
			var varlength_calc;
			var tempvalToShow = "";
			
			if ((value == "eepromconfigflag0") || (value == "eepromconfigflag1") || (value == "eepromconfigflag2") ||
			(value == "eepromconfigflag3") || (value == "eepromconfigflag4") || (value == "eepromconfigflag5")) {
			
				vallength = widgetValue.length;

				varlength_calc = 8-vallength;
				tempvalToShow = widgetValue;
				 
				if (varlength_calc > 0) {
					for (var k=varlength_calc; k>0; k--) {
						tempvalToShow = "0" + tempvalToShow;
					}
				} 
				disp = tempvalToShow;
				tempvalToShow = "";
				$(widgetid).val(disp);

			} else {
				var decvalue = parseInt(widgetValue,10);
				var hexstring = decvalue.toString(16);
				$(widgetid).val(hexstring);
			}
		});
		
		// Updating GwidgetlistInt
		$.each(GwidgetlistInt, function( index, value ) {
			var widgetid = "#" + value;
			var widgetValue = "" + getLANWidgetValue(LAN_ID, value);
			var Val = parseInt(widgetValue, 10);

			if(widgetValue === "") {
				$(widgetid).val("");
			} else {
				if ((value == "FSmaxpower") || (value == "HSmaxpower")) {
					Val = Val * 2;
					//hexstring = Val.toString(16);
				}
				
				if (value == "SSmaxpower") {
					Val = Val * 8;
					//hexstring = Val.toString(16);
				}
				$(widgetid).val(Val);
			}
		});
		
		// Updating GwidgetlistCheckbox
		$.each(GwidgetCheckbox, function( index, value ) {
			var widgetid = "#" + value;
			var widgetValue = getLANWidgetValue(LAN_ID, value);
			
			if ( widgetValue == checkbox_checked_value )
			{
				$(widgetid).prop('checked',true);     
				// If there are corresponding fieldsets - enable them 
				$(widgetid).trigger("change"); 
				set_changed_fields_border_default();
			}
			else {
				$(widgetid).prop('checked',false);
				// If there are corresponding fieldsets - disable them 
				$(widgetid).trigger("change"); 
				set_changed_fields_border_default();
			}
		});
		
		// Updating GwidgetlistRadio
		$.each(GwidgetlistRadio, function( index, value ) {
			var groupname = value +"Group";
			var widgetValue = getLANWidgetValue(LAN_ID, value);
			var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
			$(nameofcontrol).prop("checked", true);
			set_changed_fields_border_default();
		});
		
		// Updating GwidgetlistDropDown
		$.each(GwidgetlistDropDown, function( index, value ) {
			var widgetValue = getLANWidgetValue(LAN_ID, value);
			var decval = parseInt(widgetValue,10);
			var nameofcontrol = "." + value;
			var nameofcontrol1 = "[data-bind=\"" + value + "label\"]";
			var selText = "None";

			if ((value == "LED0Function") || (value == "LED1Function") ||
			(value == "LED2Function") || (value == "LED3Function"))
			{
				$.each(DropDownLEDListFunction, function( index, valuelist ) {
					if ( index == decval)
					{
						selText = valuelist;
					}
				});
			}
			// Update fields based on obtained value
			$(nameofcontrol)
		   .find(nameofcontrol1).text(selText)
			.children('.dropdown-toggle').dropdown('toggle');
		});
		//Handling "GPIOEnable","GPIOBuffer","GPIODirection" and "GPIOData"
		//Updating GPIO Enable parameter
		var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
		var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
		var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
		var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
		var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
		var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
		
		
		var groupname;
		var widVal;
		var controlName;

		//Start of GPIO 0
		//Updating for GPIO 0
		//GPIO Enable
		groupname = "gpio0EnableGroup";
		if ((gpio_enableVal & 1) == 1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio0BufferGroup";
		if ((gpio_bufferVal & 1) == 1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio0DirectionGroup";
		if ((gpio_directionVal & 1) == 1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio0DataGroup";
		if ((gpio_dataVal & 1) == 1) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 0
		
		//Start of GPIO 1
		//Updating for GPIO 1
		//GPIO Enable
		groupname = "gpio1EnableGroup";
		if ((gpio_enableVal & 2) == 2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio1BufferGroup";
		if ((gpio_bufferVal & 2) == 2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio1DirectionGroup";
		if ((gpio_directionVal & 2) == 2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio1DataGroup";
		if ((gpio_dataVal & 2) == 2) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 1
		
		//Start of GPIO 2
		//Updating for GPIO 2
		//GPIO Enable
		groupname = "gpio2EnableGroup";
		if ((gpio_enableVal & 4) == 4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio2BufferGroup";
		if ((gpio_bufferVal & 4) == 4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio2DirectionGroup";
		if ((gpio_directionVal & 4) == 4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio2DataGroup";
		if ((gpio_dataVal & 4) == 4) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 2
		
		//Start of GPIO 3
		//Updating for GPIO 3
		//GPIO Enable
		groupname = "gpio3EnableGroup";
		if ((gpio_enableVal & 8) == 8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio3BufferGroup";
		if ((gpio_bufferVal & 8) == 8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio3DirectionGroup";
		if ((gpio_directionVal & 8) == 8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio3DataGroup";
		if ((gpio_dataVal & 8) == 8) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 3
		
		//Start of GPIO 4
		//Updating for GPIO 4
		//GPIO Enable
		groupname = "gpio4EnableGroup";
		if ((gpio_enableVal & 16) == 16) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio4BufferGroup";
		if ((gpio_bufferVal & 16) == 16) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio4DirectionGroup";
		if ((gpio_directionVal & 16) == 16) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio4DataGroup";
		if ((gpio_dataVal & 16) == 16) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 4
		
		//Start of GPIO 5
		//Updating for GPIO 5
		//GPIO Enable
		groupname = "gpio5EnableGroup";
		if ((gpio_enableVal & 32) == 32) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio5BufferGroup";
		if ((gpio_bufferVal & 32) == 32) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio5DirectionGroup";
		if ((gpio_directionVal & 32) == 32) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio5DataGroup";
		if ((gpio_dataVal & 32) == 32) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 5
		
		//Start of GPIO 6
		//Updating for GPIO 6
		//GPIO Enable
		groupname = "gpio6EnableGroup";
		if ((gpio_enableVal & 64) == 64) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio6BufferGroup";
		if ((gpio_bufferVal & 64) == 64) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio6DirectionGroup";
		if ((gpio_directionVal & 64) == 64) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio6DataGroup";
		if ((gpio_dataVal & 64) == 64) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 6
		
		//Start of GPIO 7
		//Updating for GPIO 7
		//GPIO Enable
		groupname = "gpio7EnableGroup";
		if ((gpio_enableVal & 128) == 128) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio7BufferGroup";
		if ((gpio_bufferVal & 128) == 128) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio7DirectionGroup";
		if ((gpio_directionVal & 128) == 128) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio7DataGroup";
		if ((gpio_dataVal & 128) == 128) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 7
		
		//Start of GPIO 8
		//Updating for GPIO 8
		//GPIO Enable
		groupname = "gpio8EnableGroup";
		if ((gpio_enableVal & 256) == 256) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio8BufferGroup";
		if ((gpio_bufferVal & 256) == 256) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio8DirectionGroup";
		if ((gpio_directionVal & 256) == 256) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio8DataGroup";
		if ((gpio_dataVal & 256) == 256) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 8
		
		//Start of GPIO 9
		//Updating for GPIO 9
		//GPIO Enable
		groupname = "gpio9EnableGroup";
		if ((gpio_enableVal & 512) == 512) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio9BufferGroup";
		if ((gpio_bufferVal & 512) == 512) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio9DirectionGroup";
		if ((gpio_directionVal & 512) == 512) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio9DataGroup";
		if ((gpio_dataVal & 512) == 512) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 9
		
		//Start of GPIO 10
		//Updating for GPIO 10
		//GPIO Enable
		groupname = "gpio10EnableGroup";
		if ((gpio_enableVal & 1024) == 1024) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio10BufferGroup";
		if ((gpio_bufferVal & 1024) == 1024) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio10DirectionGroup";
		if ((gpio_directionVal & 1024) == 1024) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio10DataGroup";
		if ((gpio_dataVal & 1024) == 1024) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 10
		
		//Start of GPIO 11
		//Updating for GPIO 11
		//GPIO Enable
		groupname = "gpio11EnableGroup";
		if ((gpio_enableVal & 2048) == 2048) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Buffer
		groupname = "gpio11BufferGroup";
		if ((gpio_bufferVal & 2048) == 2048) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Direction
		groupname = "gpio11DirectionGroup";
		if ((gpio_directionVal & 2048) == 2048) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//GPIO Data
		groupname = "gpio11DataGroup";
		if ((gpio_dataVal & 2048) == 2048) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		//End of GPIO 11
		
		//"GPIOWake" and "GPIOWakePolarity"
		var GPIOWake_val = getLANWidgetValue(LAN_ID, "GPIOWake");
		var GPIOWP_val = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
		var widgetValue;
		var nameofcontrol;
		
		if ((GPIOWake_val & 1) == 1) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio0Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 1) == 1) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio0Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 2) == 2) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio1Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 2) == 2) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio1Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 4) == 4) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio2Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 4) == 4) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio2Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 8) == 8) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio3Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 8) == 8) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio3Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		//alert("GPIOWake_val"+GPIOWake_val);
		if ((GPIOWake_val & 16) == 16) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		//alert("widgetValue"+widgetValue);
		nameofcontrol = "input[name=\"WUgpio4Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 16) == 16) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio4Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 32) == 32) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio5Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 32) == 32) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio5Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 64) == 64) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio6Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 64) == 64) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio6Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 128) == 128) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio7Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 128) == 128) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio7Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 256) == 256) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio8Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 256) == 256) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio8Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 512) == 512) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio9Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 512) == 512) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio9Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 1024) == 1024) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio10Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 1024) == 1024) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio10Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWake_val & 2048) == 2048) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUgpio11Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		if ((GPIOWP_val & 2048) == 2048) {
			widgetValue = 1;
		} else {
			widgetValue = 0;
		}
		nameofcontrol = "input[name=\"WUPgpio11Group\"][value=" + widgetValue + "]";
		$(nameofcontrol).prop("checked", true);
		
		//LED0combine
		groupname = "LED0CombineEnableGroup";
		if ((led1_behaviour & 1) == 1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED1combine
		groupname = "LED1CombineEnableGroup";
		if ((led1_behaviour & 2) == 2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED2combine
		groupname = "LED2CombineEnableGroup";
		if ((led1_behaviour & 4) == 4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED3combine
		groupname = "LED3CombineEnableGroup";
		if ((led1_behaviour & 8) == 8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED0
		groupname = "LED0Group";
		if ((led1_behaviour & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED1
		groupname = "LED1Group";
		if ((led1_behaviour & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED2
		groupname = "LED2Group";
		if ((led1_behaviour & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED3
		groupname = "LED3Group";
		if ((led2_behaviour & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LEDRateGroup
		groupname = "LEDRateGroup";
		if ((led2_behaviour & 12) == 12) {
			widVal = 3;
		} 
		else if((led2_behaviour & 0x8) == 0x8){
			widVal = 2;
		}
		else if((led2_behaviour & 0x4) == 0x4){
			widVal = 1;
		}
		else if((led2_behaviour & 0) == 0x0){
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
		
		//LED Pulsing
		groupname = "LEDPulsingGroup";
		if ((led2_behaviour & 0x10) == 0x10) {
			widVal = 1;
		} 
		else {
			widVal = 0;
		}
		controlName = "input[name=" + groupname + "][value=" + widVal + "]";
		$(controlName).prop("checked", true);
	};
})(jQuery);

(function ($) {
    set_changed_widget_list = function () {
		
		
		//Array to save the widgets and their values which were changed.
		var deltaobj = [];
		
		//List of widgets to display on the alert
		var widgetsToDisplay = [];
		var modifiedWidgets = [];
		
		//flag for alert message
		var errorFlag = false;
		
		var totalStringLength = 0;
		
		//TO DO: String length constraint check and coding
		//String Descriptors
		var StringList = [];
		var stringsChanged = false;
		
		
		$.each(GwidgetlistString, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getLANWidgetValue(LAN_ID, value1);
			if((typeof oldval== 'undefined') || (oldval =="undefined"))
			{
				errorFlag = true;
				return;
			}
			var newval = $(widgetid).val();
			if (value1 == "macaddr") {
				//Ignore as this is not part of the string descriptor
				
				//Validate the new MAC address entered
				var isMACok = ValidateMac(newval);
	
				if (!isMACok) {
					//update_status_message("Please enter a valid MAC address.");
					//alert("Please enter a valid MAC address.");
					errorFlag = true;
					return;
				}
			} else {
				if (newval == stringnullvalue) {
					newval = "";
				}
				StringList.push(value1, newval);
			}
			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if ((newval === stringnullvalue) || (newval === oldval))
			{
				// do nothing no change detected.
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
			}
			else {
				if (jQuery.isEmptyObject(newval)) {
					newval = "";
				}

				if ((value1 == "manufacturer") || (value1 == "product") || (value1 == "serial")
					|| (value1 == "configstring") || (value1 == "interfacestring")) {
					stringsChanged = true;
				}

				if ((value1 == "macaddr") && isMACok) {
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
				}
				if (value1 == "macaddr") {
					//MAC address is not a string descriptor. So it is not considered for length calculation.
				} else {
					totalStringLength = totalStringLength + newval.length;
				}
			}
		}); //End of $.each(GwidgetlistString, function( index1, value1 )*/
		
		if (lanMemory == "EEPROM") {
			var eepromSize = GetEepromSize(LAN_ID);
			
			if (eepromSize == 256) {
				if (totalStringLength > 29) {
					alert("Current EEPROM size is 256 and the total length of all the string descriptos should not exceed 29 characters.");
					update_status_message("Current EEPROM size is 256 and the total length of all the string descriptos should not exceed 29 characters.");
					errorFlag = true;
					return;
				}
			} else if (eepromSize == 512) {
				if (totalStringLength > 157) {
					alert("Current EEPROM size is 512 and the total length of all the string descriptos should not exceed 157 characters.");
					update_status_message("Current EEPROM size is 512 and the total length of all the string descriptos should not exceed 157 characters.");
					errorFlag = true;
					return;
				}
			} else {
				//Do nothing
			}
		} else if (lanMemory == "OTP") {
			if (totalStringLength > 29) {
				alert("The total length of all the string descriptos should not exceed 29 characters.");
				update_status_message("The total length of all the string descriptos should not exceed 29 characters.");
				errorFlag = true;
				return;
			}
		} else {
			//Do nothing
		}
		
		var K;
		var V;
		var F = 0;
		var newStringList = [];
		
		if (stringsChanged) {
			for (var i = 0; i < StringList.length; i = (i + 2)) {
				K = StringList[i];
				V = StringList[i+1];
				deltaobj.push(K, V);
				modifiedWidgets.push(K);
			}
		}

		//Hex Descriptors
		$.each(GwidgetValuelistHex, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval;
			var newval;
			var isOk;
			var valTOShow;
			var vallength;
			var varlength_calc;
			var tempvalToShow = "";
			var flagval;
			
			if ((value1 == "eepromconfigflag0") || (value1 == "eepromconfigflag1") || (value1 == "eepromconfigflag2") ||
			(value1 == "eepromconfigflag3") || (value1 == "eepromconfigflag4") || (value1 == "eepromconfigflag5")) {
			
				oldval =  getLANWidgetValue(LAN_ID, value1);
				vallength = oldval.length;
				varlength_calc = 8-vallength;
				tempvalToShow = oldval;
				
				if (varlength_calc > 0) {
					for (var k=varlength_calc; k>0; k--) {
						tempvalToShow = "0" + tempvalToShow;
					}
				} 
				oldval = tempvalToShow;
				newval = $(widgetid).val();
				isOk = /^[0-9A-Fa-f]{1,8}$/i.test($(widgetid).val());
				tempvalToShow = "";
				flagval = newval;
				oldval = parseInt(oldval, 16);
				newval = parseInt(newval, 16);
				//debugAlert("newval"+newval);
				
			} else {
			
				oldval = parseInt(getLANWidgetValue(LAN_ID, value1), 10);
				newval = parseInt($(widgetid).val(), 16);
				isOk = /^[0-9A-Fa-f]{1,4}$/i.test($(widgetid).val());
			}
			
			if (!isOk) {
				update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a hexadecimal value.");
				alert("The value entered for \"" + Mapping[value1] + "\" must be a hexadecimal value.");
				errorFlag = true;
			}
			
			if (!isOk) {
				// Do nothing. The value entered does not meet the expected pattern.
			} else {
				
				if ((oldval === newval) || isNaN(newval)) {
						//Do nothing
				} else {
					
					//Check for language ID
					if (value1 == "langid") {
						if (newval == 0) {
							alert("Language ID cannot be zero.");// Setting it to default value (0x409)");
							//newval = parseInt("0x409", 16);
						}
					}

					// convert string to number                                        
					var decvalue;
					var valueToSet;
					
					if ((value1 == "eepromconfigflag0") || (value1 == "eepromconfigflag1") || (value1 == "eepromconfigflag2") ||
					(value1 == "eepromconfigflag3") || (value1 == "eepromconfigflag4") || (value1 == "eepromconfigflag5")) {
						valueToSet = "0x" + flagval;
						
					} else {
						decvalue = parseInt(newval,10);
					
						// convert number to string and then string to hex
						valueToSet = "0x" + (decvalue.toString(16));
					}
					
					
				
					var that = $( widgetid ), parent = that.closest('fieldset');
					var checkdisabled = $(parent).prop( "disabled" );
					if (checkdisabled)
					{
						// Change detected but field is disabled - So do nothing
					}
					else {
						
						var skuName = get_sku(LAN_ID);
						
						if ((value1 == "usb2vid") || (value1 == "usb2pid")) {
							var op = confirm("Modifying the " + Mapping[value1] + " requires a driver that supports it. Do you want to proceed?");
							
							if (!op) {
								//alert("User has chosen not to program " + Mapping[value1] + ". ");
								update_status_message("User has chosen not to program " + Mapping[value1] + ".");
							} else {
								//alert("User has chosen to program " + Mapping[value1] + ". Adding it to the list of change");
								update_status_message("User has chosen to program " + Mapping[value1] + ". Addind it to the list of change.");
								
								if((value1 == "usb2vid") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
									deltaobj.push(value1,valueToSet);
									deltaobj.push("usb3vid",valueToSet);
									modifiedWidgets.push(value1);
								}
								else((value1 == "usb2pid") && ((skuName == "LAN7800") || (skuName == "LAN7801")))
								{
									deltaobj.push(value1,valueToSet);
									deltaobj.push("usb3pid",valueToSet);
									modifiedWidgets.push(value1);
								}
								
								
							}
						} else {
							
							if((value1 == "usb2did") && ((skuName == "LAN7800") || (skuName == "LAN7801"))){
							
							deltaobj.push(value1,valueToSet);
							deltaobj.push("usb3did",valueToSet);
							modifiedWidgets.push(value1);
							
							}
							else
							{
								//debugAlert("value1:valueToSet"+value1+":"+valueToSet)
								deltaobj.push(value1,valueToSet);
								modifiedWidgets.push(value1);
							}
						}
					}
				}
			}
		});

		$.each(GwidgetlistInt, function(index1, value1) {
			var widgetid = "#" + value1;
			var oldval = getLANWidgetValue(LAN_ID, value1);
			var that = $(widgetid), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop("disabled");
			if ((value1 == "FSmaxpower") || (value1 == "HSmaxpower")) {
				oldval = oldval * 2;
			}
			
			if (value1 == "SSmaxpower") {
				oldval = oldval * 8;
			}
			
			var newval = $(widgetid).val();
			var newdecvalue = parseInt(newval,10);
			
			if ((oldval == newval) || isNaN(newval)) {
				// do nothing - no change in value
			} 
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
			}
			else {
				if ((value1 == "FSmaxpower") || (value1 == "HSmaxpower")) {
					if (newdecvalue > 500) {
						alert("Full speed max power and High Speed max power cannot exceed 500");
						update_status_message("Full speed max power and High Speed max power cannot exceed 500");
						return;
					}
					newdecvalue = newdecvalue/2;
				}
				
				if (value1 == "SSmaxpower") {
					if (newdecvalue > 900) {
						alert("Super speed max power cannot exceed 900");
						update_status_message("Super speed max power cannot exceed 900");
						return;
					}
					newdecvalue = newdecvalue/8;
				}
				
				if (value1 == "FSinterruptEPinterval") {
				 if (newdecvalue > 255) {
				  alert("Interrupt Endpoint bInterval for Full Speed power cannot exceed 255");
				  update_status_message("Interrupt Endpoint bInterval for Full Speed power cannot exceed 255");
				  return;
				 }
				}
				
				if (value1 == "HSinterruptEPinterval") {
				 if (newdecvalue > 255) {
				  alert("Interrupt Endpoint bInterval for High Speed power cannot exceed 255");
				  update_status_message("Interrupt Endpoint bInterval for High Speed power cannot exceed 255");
				  return;
				 }
				}
				
				if (value1 == "SSinterruptEPinterval") {
				 if (newdecvalue > 255) {
				  alert("Interrupt Endpoint bInterval for Super Speed power cannot exceed 255");
				  update_status_message("Interrupt Endpoint bInterval for Super Speed power cannot exceed 255");
				  return;
				 }
				}
    
				var hexDec = newdecvalue.toString(16);
				deltaobj.push(value1, hexDec);
				modifiedWidgets.push(value1);
			}
		});

		///Radio buttons
		$.each(GwidgetlistRadio, function(index2, value1) {
			var widgetgroupname = '#' + value1 +"Group";
			var oldval = getLANWidgetValue(LAN_ID, value1);
			var newval = $(widgetgroupname).find(':checked').val();
			var that = $( widgetgroupname ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if ((oldval === newval) || jQuery.isEmptyObject(newval))
			{
				// do nothing
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
			}
			else
			{
				deltaobj.push(value1, newval);
				modifiedWidgets.push(value1);
			}
		});

		//Checkbox
		$.each(GwidgetCheckbox, function( index2, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getLANWidgetValue(LAN_ID, value1);
			var newval = checkbox_unchecked_value;
			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if($(widgetid).is(':checked'))
			{
				newval = checkbox_checked_value;
			}
			
			// Enabled - check the previous value and determine delta                              
			if (oldval == newval) {
				// do nothing - no change in value
			} else if (checkdisabled) {
				// Change detected but field is disabled - So do nothing
			} else {
				deltaobj.push(value1, newval);
				modifiedWidgets.push(value1);
			}
		});

		$.each(GwidgetlistDropDown, function(index2, value1) {
			var nameofcontrol = "." + value1;
			var nameofcontrol1 = "[data-bind=\"" + value1 + "label\"]";
			var selText = $(nameofcontrol).find(nameofcontrol1).text();
			var newindexofdropdownlist;
			var that = $( nameofcontrol ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );

			if ((value1 == "LED0Function") || (value1 == "LED1Function") ||
			(value1 == "LED2Function") || (value1 == "LED3Function"))
			{
				$.each(DropDownLEDListFunction, function(index, valuelist) {
					if ( selText === valuelist)
					{
						newindexofdropdownlist = index;
					}
				});
			}
			
			var oldval = getLANWidgetValue(LAN_ID, value1);

			if (newindexofdropdownlist || newindexofdropdownlist == 0) {
				if ((newindexofdropdownlist == oldval))
				{
					// no change
				} else if (checkdisabled) {
					// Change detected but field is disabled - So do nothing
				} else {
					var dummyNewindexofdropdownlist = newindexofdropdownlist.toString(16);
					deltaobj.push(value1, dummyNewindexofdropdownlist);
					modifiedWidgets.push(value1);
				}
			}
		});
		// Start of Special Checkbox widgets
		//Handling "GPIOEnable","GPIOBuffer","GPIODirection" and "GPIOData"
		//Updating GPIO Enable parameter
		var skuName = get_sku(LAN_ID);
		var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
		var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
		var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
		var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
		var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
		var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
		
		
		var groupname;
		var widVal;
		var controlName;
		
		var lanMem = get_lan_memory(LAN_ID);
		//Current values
		var gpio0Enable = $("#gpio0EnableGroup").find(':checked').val();
		var gpio1Enable = $("#gpio1EnableGroup").find(':checked').val();
		var gpio2Enable = $("#gpio2EnableGroup").find(':checked').val();
		var gpio3Enable = $("#gpio3EnableGroup").find(':checked').val();
		var gpio4Enable = $("#gpio4EnableGroup").find(':checked').val();
		var gpio5Enable = $("#gpio5EnableGroup").find(':checked').val();
		var gpio6Enable = $("#gpio6EnableGroup").find(':checked').val();
		var gpio7Enable = $("#gpio7EnableGroup").find(':checked').val();
		var gpio8Enable = $("#gpio8EnableGroup").find(':checked').val();
		var gpio9Enable = $("#gpio9EnableGroup").find(':checked').val();
		var gpio10Enable = $("#gpio10EnableGroup").find(':checked').val();
		var gpio11Enable = $("#gpio11EnableGroup").find(':checked').val();
		
		var gpio0Buffer = $("#gpio0BufferGroup").find(':checked').val();
		var gpio1Buffer = $("#gpio1BufferGroup").find(':checked').val();
		var gpio2Buffer = $("#gpio2BufferGroup").find(':checked').val();
		var gpio3Buffer = $("#gpio3BufferGroup").find(':checked').val();
		var gpio4Buffer = $("#gpio4BufferGroup").find(':checked').val();
		var gpio5Buffer = $("#gpio5BufferGroup").find(':checked').val();
		var gpio6Buffer = $("#gpio6BufferGroup").find(':checked').val();
		var gpio7Buffer = $("#gpio7BufferGroup").find(':checked').val();
		var gpio8Buffer = $("#gpio8BufferGroup").find(':checked').val();
		var gpio9Buffer = $("#gpio9BufferGroup").find(':checked').val();
		var gpio10Buffer = $("#gpio10BufferGroup").find(':checked').val();
		var gpio11Buffer = $("#gpio11BufferGroup").find(':checked').val();
		
		var gpio0Direction = $("#gpio0DirectionGroup").find(':checked').val();
		var gpio1Direction = $("#gpio1DirectionGroup").find(':checked').val();
		var gpio2Direction = $("#gpio2DirectionGroup").find(':checked').val();
		var gpio3Direction = $("#gpio3DirectionGroup").find(':checked').val();
		var gpio4Direction = $("#gpio4DirectionGroup").find(':checked').val();
		var gpio5Direction = $("#gpio5DirectionGroup").find(':checked').val();
		var gpio6Direction = $("#gpio6DirectionGroup").find(':checked').val();
		var gpio7Direction = $("#gpio7DirectionGroup").find(':checked').val();
		var gpio8Direction = $("#gpio8DirectionGroup").find(':checked').val();
		var gpio9Direction = $("#gpio9DirectionGroup").find(':checked').val();
		var gpio10Direction = $("#gpio10DirectionGroup").find(':checked').val();
		var gpio11Direction = $("#gpio11DirectionGroup").find(':checked').val();
		
		var gpio0Data = $("#gpio0DataGroup").find(':checked').val();
		var gpio1Data = $("#gpio1DataGroup").find(':checked').val();
		var gpio2Data = $("#gpio2DataGroup").find(':checked').val();
		var gpio3Data = $("#gpio3DataGroup").find(':checked').val();
		var gpio4Data = $("#gpio4DataGroup").find(':checked').val();
		var gpio5Data = $("#gpio5DataGroup").find(':checked').val();
		var gpio6Data = $("#gpio6DataGroup").find(':checked').val();
		var gpio7Data = $("#gpio7DataGroup").find(':checked').val();
		var gpio8Data = $("#gpio8DataGroup").find(':checked').val();
		var gpio9Data = $("#gpio9DataGroup").find(':checked').val();
		var gpio10Data = $("#gpio10DataGroup").find(':checked').val();
		var gpio11Data = $("#gpio11DataGroup").find(':checked').val();
		
		var LED0CombineEnable = $("#LED0CombineEnableGroup").find(':checked').val();
		var LED1CombineEnable = $("#LED1CombineEnableGroup").find(':checked').val();
		var LED2CombineEnable = $("#LED2CombineEnableGroup").find(':checked').val();
		var LED3CombineEnable = $("#LED3CombineEnableGroup").find(':checked').val();
		var LED0 = $("#LED0Group").find(':checked').val();
		var LED1 = $("#LED1Group").find(':checked').val();
		var LED2 = $("#LED2Group").find(':checked').val();
		var LED3 = $("#LED3Group").find(':checked').val();
		var LEDRate = $("#LEDRateGroup").find(':checked').val();
		var LEDPulsing = $("#LEDPulsingGroup").find(':checked').val();
		
		var gpio_EnTemp = gpio_enableVal;
		var gpio_BufTemp = gpio_bufferVal;
		var gpio_DirTemp = gpio_directionVal;
		var gpio_DataTemp = gpio_dataVal;
		var led1_Tempbehaviour = led1_behaviour;
		var led2_Tempbehaviour = led2_behaviour;
		
		
		var En_flag = false;
		var Buf_flag = false;
		var Dir_flag = false;
		var Data_flag = false;
		var Led1_flag = false;
		var Led2_flag = false;

		
		
		//Start of GPIO 0
		//Updating for GPIO 0
		//GPIO Enable
		groupname = "gpio0EnableGroup";
		if ((gpio_enableVal & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (gpio0Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Enable/Disable cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Enable/Disable cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_EnTemp = gpio_EnTemp | 0x1;
				} else  if (widVal == 1) {
					gpio_EnTemp = gpio_EnTemp & 0xFFE;
				} else {
					//Do nothing
				}
				En_flag = true;
			}
		}
		//GPIO Buffer
		groupname = "gpio0BufferGroup";
		if ((gpio_bufferVal & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio0Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Buffer cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Buffer cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_BufTemp = gpio_BufTemp | 0x1;
				} else  if (widVal == 1) {
					gpio_BufTemp = gpio_BufTemp & 0xFFE;
				} else {
					//Do nothing
				}
				Buf_flag = true;
			}
		}
		
		//GPIO Direction
		groupname = "gpio0DirectionGroup";
		if ((gpio_directionVal & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio0Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && ((skuName == "LAN7800") || (skuName == "LAN7801"))) {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Direction cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Direction cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_DirTemp = gpio_DirTemp | 0x1;
				} else  if (widVal == 1) {
					gpio_DirTemp = gpio_DirTemp & 0xFFE;
				} else {
					//Do nothing
				}
				Dir_flag  = true;
			}
		}
		
		//GPIO Data
		groupname = "gpio0DataGroup";
		if ((gpio_dataVal & 0x1) == 0x1) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio0Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && (skuName == "LAN7800")) {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Data cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 0 Data cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 1) {
					gpio_DataTemp = gpio_DataTemp | 0x1;
				} else  if (widVal == 0) {
					gpio_DataTemp = gpio_DataTemp & 0xFFE;
				} else {
					//Do nothing
				}
				Data_flag = true;
			}
		}
		//End of GPIO 0
		
		//Start of GPIO 1
		//Updating for GPIO 1
		//GPIO Enable
		groupname = "gpio1EnableGroup";
		if ((gpio_enableVal & 0x2) == 0x2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio1Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Enable/Disable cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Enable/Disable cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_EnTemp = gpio_EnTemp | 0x2;
				} else  if (widVal == 1) {
					gpio_EnTemp = gpio_EnTemp & 0xFFD;
				} else {
					//Do nothing
				}
				En_flag = true;
			}
		}
		
		//GPIO Buffer
		groupname = "gpio1BufferGroup";
		if ((gpio_bufferVal & 0x2) == 0x2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio1Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Buffer cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Buffer cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_BufTemp = gpio_BufTemp | 0x2;
				} else  if (widVal == 1) {
					gpio_BufTemp = gpio_BufTemp & 0xFFD;
				} else {
					//Do nothing
				}
				Buf_flag = true;
			}
		}
		
		//GPIO Direction
		groupname = "gpio1DirectionGroup";
		if ((gpio_directionVal & 0x2) == 0x2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio1Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Direction cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Direction cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_DirTemp = gpio_DirTemp | 0x2;
				} else  if (widVal == 1) {
					gpio_DirTemp = gpio_DirTemp & 0xFFD;
				} else {
					//Do nothing
				}
				Dir_flag  = true;
			}
		}
		
		//GPIO Data
		groupname = "gpio1DataGroup";
		if ((gpio_dataVal & 0x2) == 0x2) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio1Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Data cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 1 Data cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 1) {
					gpio_DataTemp = gpio_DataTemp | 0x2;
				} else  if (widVal == 0) {
					gpio_DataTemp = gpio_DataTemp & 0xFFD;
				} else {
					//Do nothing
				}
				Data_flag = true;
			}
		}
		//End of GPIO 1
		
		//Start of GPIO 2
		//Updating for GPIO 2
		//GPIO Enable
		groupname = "gpio2EnableGroup";
		if ((gpio_enableVal & 0x4) == 0x4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio2Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Enable/Disable cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Enable/Disable cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_EnTemp = gpio_EnTemp | 0x4;
				} else  if (widVal == 1) {
					gpio_EnTemp = gpio_EnTemp & 0xFFB;
				} else {
					//Do nothing
				}
				En_flag = true;
			}
		}
		
		//GPIO Buffer
		groupname = "gpio2BufferGroup";
		if ((gpio_bufferVal & 0x4) == 0x4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio2Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Buffer cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Buffer cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_BufTemp = gpio_BufTemp | 0x4;
				} else  if (widVal == 1) {
					gpio_BufTemp = gpio_BufTemp & 0xFFB;
				} else {
					//Do nothing
				}
				Buf_flag = true;
			}
		}
		
		//GPIO Direction
		groupname = "gpio2DirectionGroup";
		if ((gpio_directionVal & 0x4) == 0x4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio2Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Direction cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Direction cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_DirTemp = gpio_DirTemp | 0x4;
				} else  if (widVal == 1) {
					gpio_DirTemp = gpio_DirTemp & 0xFFB;
				} else {
					//Do nothing
				}
				Dir_flag  = true;
			}
		}
		
		//GPIO Data
		groupname = "gpio2DataGroup";
		if ((gpio_dataVal & 0x4) == 0x4) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio2Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Data cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 2 Data cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 1) {
					gpio_DataTemp = gpio_DataTemp | 0x4;
				} else  if (widVal == 0) {
					gpio_DataTemp = gpio_DataTemp & 0xFFB;
				} else {
					//Do nothing
				}
				Data_flag = true;
			}
		}
		//End of GPIO 2
		
		//Start of GPIO 3
		//Updating for GPIO 3
		//GPIO Enable
		groupname = "gpio3EnableGroup";
		if ((gpio_enableVal & 0x8) == 0x8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio3Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Enable/Disable cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Enable/Disable cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_EnTemp = gpio_EnTemp | 0x8;
				} else  if (widVal == 1) {
					gpio_EnTemp = gpio_EnTemp & 0xFF7;
				} else {
					//Do nothing
				}
				En_flag = true;
			}
		}
		
		//GPIO Buffer
		groupname = "gpio3BufferGroup";
		if ((gpio_bufferVal & 0x8) == 0x8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio3Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Buffer cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Buffer cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_BufTemp = gpio_BufTemp | 0x8;
				} else  if (widVal == 1) {
					gpio_BufTemp = gpio_BufTemp & 0xFF7;
				} else {
					//Do nothing
				}
				Buf_flag = true;
			}
		}
		
		//GPIO Direction
		groupname = "gpio3DirectionGroup";
		if ((gpio_directionVal & 0x8) == 0x8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio3Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Direction cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Direction cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 0) {
					gpio_DirTemp = gpio_DirTemp | 0x8;
				} else  if (widVal == 1) {
					gpio_DirTemp = gpio_DirTemp & 0xFF7;
				} else {
					//Do nothing
				}
				Dir_flag  = true;
			}
		}
		
		//GPIO Data
		groupname = "gpio3DataGroup";
		if ((gpio_dataVal & 0x8) == 0x8) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio3Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (lanMem == "EEPROM") {
				// Do nothing
				alert("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Data cannot be programmed.");
				update_status_message("LAN78XX Ethernet bridging device has booted from EEPROM. GPIO 3 Data cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			} else {
				if (widVal == 1) {
					gpio_DataTemp = gpio_DataTemp | 0x8;
				} else  if (widVal == 0) {
					gpio_DataTemp = gpio_DataTemp & 0xFF7;
				} else {
					//Do nothing
				}
				Data_flag = true;
			}
		}
		//End of GPIO 3
		
		//Start of GPIO 4
		//Updating for GPIO 4
		//GPIO Enable
	
		groupname = "gpio4EnableGroup";
		if ((gpio_enableVal & 0x10) == 0x10) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		var skuName = get_sku(LAN_ID);
		
		if (gpio4Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Enable/Disable cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Enable/Disable cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{
				if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x10;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFEF;
			} else {
				//Do nothing
			}
				En_flag = true;
			}
		}
		
		//GPIO Buffer
		groupname = "gpio4BufferGroup";
		if ((gpio_bufferVal & 0x10) == 0x10) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		var skuName = get_sku(LAN_ID);
		
		if (gpio4Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Buffer cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Buffer cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{
				if (widVal == 0) {
					gpio_BufTemp = gpio_BufTemp | 0x10;
				} else  if (widVal == 1) {
					gpio_BufTemp = gpio_BufTemp & 0xFEF;
				} else {
					//Do nothing
				}
				Buf_flag = true;
			}
		}
		
		//GPIO Direction
		groupname = "gpio4DirectionGroup";
		if ((gpio_directionVal & 0x10) == 0x10) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		var skuName = get_sku(LAN_ID);
		if (gpio4Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Direction cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Direction cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x10;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFEF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
			}
		}
		
		//GPIO Data
		groupname = "gpio4DataGroup";
		if ((gpio_dataVal & 0x10) == 0x10) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		
		var skuName = get_sku(LAN_ID);
		if (gpio4Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if ((lanMem == "EEPROM") && (skuName == "LAN7850")) {
				// Do nothing
				alert("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Data cannot be programmed.");
				update_status_message("LAN7850 Ethernet bridging device has booted from EEPROM. GPIO 4 Data cannot be programmed.");
				window.setTimeout(function() {
				$("#myprogress").hide();
				},100);
				return;
			}
			else
			{	if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x10;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFEF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		}
		//End of GPIO 4
		
		//Start of GPIO 5
		//Updating for GPIO 5
		//GPIO Enable
		groupname = "gpio5EnableGroup";
		if ((gpio_enableVal & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio5Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x20;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFDF;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio5BufferGroup";
		if ((gpio_bufferVal & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio5Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x20;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFDF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio5DirectionGroup";
		if ((gpio_directionVal & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio5Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x20;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFDF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio5DataGroup";
		if ((gpio_dataVal & 0x20) == 0x20) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio5Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x20;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFDF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 5
		
		//Start of GPIO 6
		//Updating for GPIO 6
		//GPIO Enable
		groupname = "gpio6EnableGroup";
		if ((gpio_enableVal & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio6Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x40;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xFBF;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio6BufferGroup";
		if ((gpio_bufferVal & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio6Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x40;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xFBF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio6DirectionGroup";
		if ((gpio_directionVal & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio6Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x40;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xFBF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio6DataGroup";
		if ((gpio_dataVal & 0x40) == 0x40) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio6Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x40;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xFBF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 6
		
		//Start of GPIO 7
		//Updating for GPIO 7
		//GPIO Enable
		groupname = "gpio7EnableGroup";
		if ((gpio_enableVal & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio7Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x80;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xF7F;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio7BufferGroup";
		if ((gpio_bufferVal & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio7Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x80;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xF7F;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio7DirectionGroup";
		if ((gpio_directionVal & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio7Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x80;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xF7F;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio7DataGroup";
		if ((gpio_dataVal & 0x80) == 0x80) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio7Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x80;	
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xF7F;	
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 7
		
		//Start of GPIO 8
		//Updating for GPIO 8
		//GPIO Enable
		groupname = "gpio8EnableGroup";
		if ((gpio_enableVal & 0x100) == 0x100) {
			widVal = 1;
		} else {
			widVal = 0;
		}

		if (gpio8Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x100;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xEFF;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio8BufferGroup";
		if ((gpio_bufferVal & 0x100) == 0x100) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio8Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x100;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xEFF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio8DirectionGroup";
		if ((gpio_directionVal & 0x100) == 0x100) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio8Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x100;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xEFF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio8DataGroup";
		if ((gpio_dataVal & 0x100) == 0x100) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio8Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x100;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xEFF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 8
		
		//Start of GPIO 9
		//Updating for GPIO 9
		//GPIO Enable
		groupname = "gpio9EnableGroup";
		if ((gpio_enableVal & 0x200) == 0x200) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio9Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x200;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xDFF;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio9BufferGroup";
		if ((gpio_bufferVal & 0x200) == 0x200) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio9Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x200;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xDFF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio9DirectionGroup";
		if ((gpio_directionVal & 0x200) == 0x200) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio9Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x200;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xDFF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio9DataGroup";
		if ((gpio_dataVal & 0x200) == 0x200) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio9Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x200;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xDFF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 9
		
		//Start of GPIO 10
		//Updating for GPIO 10
		//GPIO Enable
		groupname = "gpio10EnableGroup";
		if ((gpio_enableVal & 0x400) == 0x400) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio10Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x400;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0xBFF;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio10BufferGroup";
		if ((gpio_bufferVal & 0x400) == 0x400) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio10Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x400;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0xBFF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio10DirectionGroup";
		if ((gpio_directionVal & 0x400) == 0x400) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio10Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x400;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0xBFF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio10DataGroup";
		if ((gpio_dataVal & 0x400) == 0x400) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio10Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x400;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0xBFF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 10
		
		//Start of GPIO 11
		//Updating for GPIO 11
		//GPIO Enable
		groupname = "gpio11EnableGroup";
		if ((gpio_enableVal & 0x800) == 0x800) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio11Enable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_EnTemp = gpio_EnTemp | 0x800;
			} else  if (widVal == 1) {
				gpio_EnTemp = gpio_EnTemp & 0x7FF;
			} else {
				//Do nothing
			}
			En_flag = true;
		}
		
		//GPIO Buffer
		groupname = "gpio11BufferGroup";
		if ((gpio_bufferVal & 0x800) == 0x800) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio11Buffer == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_BufTemp = gpio_BufTemp | 0x800;
			} else  if (widVal == 1) {
				gpio_BufTemp = gpio_BufTemp & 0x7FF;
			} else {
				//Do nothing
			}
			Buf_flag = true;
		}
		
		//GPIO Direction
		groupname = "gpio11DirectionGroup";
		if ((gpio_directionVal & 0x800) == 0x800) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		if (gpio11Direction == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 0) {
				gpio_DirTemp = gpio_DirTemp | 0x800;
			} else  if (widVal == 1) {
				gpio_DirTemp = gpio_DirTemp & 0x7FF;
			} else {
				//Do nothing
			}
			Dir_flag  = true;
		}
		
		//GPIO Data
		groupname = "gpio11DataGroup";
		if ((gpio_dataVal & 0x800) == 0x800) {
			widVal = 0;
		} else {
			widVal = 1;
		}
		if (gpio11Data == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
			if (widVal == 1) {
				gpio_DataTemp = gpio_DataTemp | 0x800;
			} else  if (widVal == 0) {
				gpio_DataTemp = gpio_DataTemp & 0x7FF;
			} else {
				//Do nothing
			}
			Data_flag = true;
		}
		//End of GPIO 11
		
		//LED0CombineEnable
		groupname = "LED0CombineEnableGroup";
		if ((led1_behaviour & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED0CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x1;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xFE;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED1CombineEnable
		groupname = "LED1CombineEnableGroup";
		if ((led1_behaviour & 0x2) == 0x2) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED1CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x2;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xFD;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED2CombineEnable
		groupname = "LED2CombineEnableGroup";
		if ((led1_behaviour & 0x4) == 0x4) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED2CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x4;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xFB;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED3CombineEnable
		groupname = "LED3CombineEnableGroup";
		if ((led1_behaviour & 0x8) == 0x8) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED3CombineEnable == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x8;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xF7;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED0Group
		groupname = "LED0Group";
		if ((led1_behaviour & 0x20) == 0x20) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED0 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x20;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xDF;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED1Group
		groupname = "LED1Group";
		if ((led1_behaviour & 0x40) == 0x40) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED1 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led1_Tempbehaviour = led1_Tempbehaviour | 0x40;
				} else  if (widVal == 1) {
					led1_Tempbehaviour = led1_Tempbehaviour & 0xBF;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED2Group
		groupname = "LED2Group";
		if ((led1_behaviour & 0x80) == 0x80) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED2 == widVal) {
			//Do nothing. The new and old value are the same;
			
		} else {
				if (widVal == 0) {
			
			led1_Tempbehaviour = led1_Tempbehaviour | 0x80;
				} else  if (widVal == 1) {
			
			led1_Tempbehaviour = led1_Tempbehaviour & 0x7F;
				} else {
					//Do nothing
				}
				Led1_flag = true;
			
		}
		
		//LED3Group
		groupname = "LED3Group";
		if ((led2_behaviour & 0x1) == 0x1) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LED3 == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					led2_Tempbehaviour = led2_Tempbehaviour | 0x1;
				} else  if (widVal == 1) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xFE;
				} else {
					//Do nothing
				}
				Led2_flag = true;
			
		}
		
		
		//LEDRateGroup
		groupname = "LEDRateGroup";
		if ((led2_behaviour & 12) == 12) {
			widVal = 3;
		} 
		else if((led2_behaviour & 0x8) == 0x8){
			widVal = 2;
		}
		else if((led2_behaviour & 0x4) == 0x4){
			widVal = 1;
		}
		else if((led2_behaviour & 0) == 0){
			widVal = 0;
		}
		
		if (LEDRate == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (LEDRate == 0) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xF3;
				} else  if (LEDRate == 1) {
					led2_Tempbehaviour = led2_Tempbehaviour | 0x4 ;
					led2_Tempbehaviour = led2_Tempbehaviour & 0xEF ;
				} else  if (LEDRate == 2) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xFB;
					led2_Tempbehaviour = led2_Tempbehaviour | 0x8;
				} else  if (LEDRate == 3) {
					led2_Tempbehaviour = led2_Tempbehaviour | 12;
				} else {
					//Do nothing
				}
				Led2_flag = true;
			
		}
		
		//LEDPulsingGroup
		groupname = "LEDPulsingGroup";
		if ((led2_behaviour & 0x10) == 0x10) {
			widVal = 1;
		} else {
			widVal = 0;
		}
		
		if (LEDPulsing == widVal) {
			//Do nothing. The new and old value are the same;
		} else {
				if (widVal == 0) {
					
					led2_Tempbehaviour = led2_Tempbehaviour | 0x10;
					
				} else  if (widVal == 1) {
					led2_Tempbehaviour = led2_Tempbehaviour & 0xEF;
				} else {
					//Do nothing
				}
				Led2_flag = true;
			
		}
		
		if (En_flag) {
			var temp_gpio_EnTemp ;
			temp_gpio_EnTemp =  gpio_EnTemp.toString(16);
			deltaobj.push("GPIOEnable", temp_gpio_EnTemp);
			modifiedWidgets.push("GPIOEnable");
		}
		
		if (Led1_flag) {
			var temp_LED1_EnTemp ;
			temp_LED1_EnTemp =  led1_Tempbehaviour.toString(16);
			deltaobj.push("LED1Behavior", temp_LED1_EnTemp);
			
		}
		
		if (Led2_flag) {
			var temp_LED2_EnTemp ;
			temp_LED2_EnTemp =  led2_Tempbehaviour.toString(16);
			deltaobj.push("LED2Behavior", temp_LED2_EnTemp);
			
		}
		
		
		if(Led1_flag || Led2_flag)
		{
			modifiedWidgets.push("LEDBehavior");
		}
		
		if (Buf_flag) {
			var temp_gpio_BufTemp ;
			temp_gpio_BufTemp =  gpio_BufTemp.toString(16);
			deltaobj.push("GPIOBuffer", temp_gpio_BufTemp);
			modifiedWidgets.push("GPIOBuffer");
		}
		
		if (Dir_flag) {
			var temp_gpio_DirTemp ;
			temp_gpio_DirTemp =  gpio_DirTemp.toString(16);
			deltaobj.push("GPIODirection", temp_gpio_DirTemp);
			modifiedWidgets.push("GPIODirection");
		}
		
		if (Data_flag) {
			var temp_gpio_DataTemp ;
			temp_gpio_DataTemp =  gpio_DataTemp.toString(16);
			deltaobj.push("GPIOData", temp_gpio_DataTemp);
			modifiedWidgets.push("GPIOData");
		}
		
		
		//"GPIOWake" and "GPIOWakePolarity"
		var GPIOWake_val = getLANWidgetValue(LAN_ID, "GPIOWake");
		var GPIOWP_val = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
		//alert("GPIOWake_val"+GPIOWake_val);
		var oldVal;
		var newVal;
		
		var WU_Temp = GPIOWake_val;
		var WUP_Temp = GPIOWP_val;
		
		var WU_flag = false;
		var WUP_flag = false;
		
		newVal = $("#WUgpio0Group").find(':checked').val();
		if ((GPIOWake_val & 0x1) == 0x1) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}

		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x1;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFFE;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}
		
		newVal = $("#WUPgpio0Group").find(':checked').val();
		if ((GPIOWP_val & 0x1) == 0x1) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x1;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFFE;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		newVal = $("#WUgpio1Group").find(':checked').val();
		if ((GPIOWake_val & 0x2) == 0x2) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x2;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFFD;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio1Group").find(':checked').val();
		if ((GPIOWP_val & 0x2) == 0x2) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x2;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFFD;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio2Group").find(':checked').val();
		if ((GPIOWake_val & 0x4) == 0x4) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x4;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFFB;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio2Group").find(':checked').val();
		if ((GPIOWP_val & 0x4) == 0x4) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x4;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFFB;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio3Group").find(':checked').val();
		if ((GPIOWake_val & 0x8) == 0x8) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x8;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFF7;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio3Group").find(':checked').val();
		if ((GPIOWP_val & 0x8) == 0x8) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x8;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFF7;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}

		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio4Group").find(':checked').val();
		if ((GPIOWake_val & 0x10) == 0x10) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x10;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFEF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio4Group").find(':checked').val();
		//alert("newVal"+newVal);
		//alert("GPIOWP_val"+GPIOWP_val);
		if ((GPIOWP_val & 0x10) == 0x10) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		//alert("oldVal"+oldVal);
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x10;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFEF;
			} else {
				//Do nothing
			}
			//alert("WUP_Temp"+WUP_Temp);
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio5Group").find(':checked').val();
		if ((GPIOWake_val & 0x20) == 0x20) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x20;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFDF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio5Group").find(':checked').val();
		if ((GPIOWP_val & 0x20) == 0x20) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x20;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFDF;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio6Group").find(':checked').val();
		if ((GPIOWake_val & 0x40) == 0x40) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x40;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xFBF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio6Group").find(':checked').val();
		if ((GPIOWP_val & 0x40) == 0x40) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x40;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xFBF;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio7Group").find(':checked').val();
		if ((GPIOWake_val & 0x80) == 0x80) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x80;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xF7F;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio7Group").find(':checked').val();
		if ((GPIOWP_val & 0x80) == 0x80) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x80;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xF7F;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio8Group").find(':checked').val();
		if ((GPIOWake_val & 0x100) == 0x100) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x100;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xEFF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio8Group").find(':checked').val();
		if ((GPIOWP_val & 0x100) == 0x100) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x100;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xEFF;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio9Group").find(':checked').val();
		if ((GPIOWake_val & 0x200) == 0x200) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x200;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xDFF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio9Group").find(':checked').val();
		if ((GPIOWP_val & 0x200) == 0x200) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x200;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xDFF;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio10Group").find(':checked').val();
		if ((GPIOWake_val & 0x400) == 0x400) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x400;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0xBFF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}

		newVal = $("#WUPgpio10Group").find(':checked').val();
		if ((GPIOWP_val & 0x400) == 0x400) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x400;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0xBFF;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		///////////////////////////////////////////////////
		
		newVal = $("#WUgpio11Group").find(':checked').val();
		if ((GPIOWake_val & 0x800) == 0x800) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WU_Temp = WU_Temp | 0x800;
			} else  if (oldVal == 1) {
				WU_Temp = WU_Temp & 0x7FF;
			} else {
				//Do nothing
			}
			WU_flag = true;
		}
		
		newVal = $("#WUPgpio11Group").find(':checked').val();
		if ((GPIOWP_val & 0x800) == 0x800) {
			oldVal = 1;
		} else {
			oldVal = 0;
		}
		
		if (oldVal == newVal) {
			//Do nothing.
		} else {
			if (oldVal == 0) {
				WUP_Temp = WUP_Temp | 0x800;
			} else  if (oldVal == 1) {
				WUP_Temp = WUP_Temp & 0x7FF;
			} else {
				//Do nothing
			}
			WUP_flag = true;
		}
		
		///////////////////////////////////////////////////
		
		if (WU_flag) {
			WU_Temp = WU_Temp.toString(16);
			deltaobj.push("GPIOWake", WU_Temp);
			modifiedWidgets.push("GPIOWake");
		}
		
		if (WUP_flag) {
			WUP_Temp = WUP_Temp.toString(16);
			deltaobj.push("GPIOWakePolarity", WUP_Temp);
			modifiedWidgets.push("GPIOWakePolarity");
		}
		
		
		//End of Special Checkbox widgets
		var stringToSet = "";
		var wKey;
		var wVal;
		var flag = 0;

		if (deltaobj.length != 0) {
			for (var i = 0; i < deltaobj.length; i = (i + 2)) {
				wKey = deltaobj[i];
				wVal = deltaobj[i+1];
				if ((typeof wKey === 'undefined') || (typeof wVal === 'undefined')) {
					// Do nothing
				} else {
					if (stringToSet == "") {
						stringToSet = wKey + ",,," + wVal;
					} else {
						stringToSet = stringToSet + ";;;" + wKey + ",,," + wVal;
					}
					flag++;
				}
			}
		}

		if (showPreview) {
			showPreview = false;
			if (flag != 0) {
				var result = previewLANWidgetValue(LAN_ID, stringToSet);
				$('#previewChangesField').show();
			} else {
				alert("No Changes detected. Cannot show preview.");
			}
		} else {
			if (flag == 0 && errorFlag == false)
			{
				window.setTimeout(function() {
				  $('#myprogress .progress-bar').css('width', 100+'%').attr('aria-valuenow', 100);
				}, 500); 
				alert("Device configuration will not be changed ; No changes detected");
				update_status_message("Device configuration will not be changed ; No changes detected");
			} else {
				if(errorFlag == false)
				{
					var displayChange = "";
					
					for (var i = 0; i < modifiedWidgets.length; i++) {
						if(i%4 == 0)
						{
							if (displayChange) {
								displayChange = "\n" + Mapping[modifiedWidgets[i]] + ", " + displayChange;
								
							} else {
								displayChange = Mapping[modifiedWidgets[i]];
								
							}
						} else {
							if (displayChange) {
								displayChange = Mapping[modifiedWidgets[i]] + ", " + displayChange;
								
							}
						}
					}
					
					var memType = $("#ConfigLocationGroup").find(':checked').val();
					var userSelection;
					
					if(memType == "EEPROM")
					{
						userSelection = "1";
					} else {
						userSelection = "2";
					}
					$('#myprogress').show();
					$('#myprogress .progress-bar').css('width', 5+'%').attr('aria-valuenow', 5);
					
					var option = confirm("The following device settings will be changed ; Previously created JSON and Configuration files will be removed ; Do you want to continue?\n" + displayChange);
				
					if (option) {
						
						
						//$('#myprogress').show();				
						$('#myprogress .progress-bar').css('width', 20+'%').attr('aria-valuenow', 20);
						
						
						update_status_message("JSON and cfg files will be overwritten; and hub will be programmed with the following.\n " + displayChange);
						update_status_message("Programming in progress...Please wait");
						// call the service
						
						//Disable apply and preview buttons before making a java call
						
						$("#Preview").attr('disabled', true);
						$("#Apply").attr('disabled', true);
						$("#Factory").attr('disabled', true);
						$("#eepromErase").attr('disabled', true);
						
						var memresult = User_Lan_Memory_Selection(LAN_ID, userSelection);
						
						$('#myprogress .progress-bar').css('width', 40+'%').attr('aria-valuenow', 40);
						
						var result = setLANWidgetValue(LAN_ID, stringToSet);
						
						$('#myprogress .progress-bar').css('width', 50+'%').attr('aria-valuenow', 50);
						
						if (result && memresult) {
							update_status_message("LAN is successfully programmed");
						
							
							$('#myprogress .progress-bar').css('width', 70+'%').attr('aria-valuenow', 70);		
							
							// Change border back to default color from red
							set_changed_fields_border_default();

							update_status_message("Waiting for device reset to finish.....");

							CurrentLANProgrammed = $("#selectedLANinput").val();
							var colonIndex = CurrentLANProgrammed.indexOf(":");
							LAN_ID = "" + CurrentLANProgrammed.charAt(colonIndex + 1);

							$('#myprogress .progress-bar').css('width', 80+'%').attr('aria-valuenow', 80);		
							
							setTimeout(function() {
								// Do something after 5 seconds
								update_status_message("Refreshing LAN List....");
								// refresh hub list and set selected device
								window.setTimeout(function() {
									$('.panel-collapse').each(function () {
										if ($(this).hasClass('in')) {
											$(this).collapse('toggle');
										}
									});
									close_lan_device(LAN_ID);
									refresh();
									get_LAN_list_set_LAN_index_zero();
									//$("#myprogress").hide();
								},100);
								//$("body").css("cursor", "default");
								window.setTimeout(function(){
								  //your code to be executed after 1 seconds
								  $('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
								  $('#myprogress').hide();
								}, 1000);
							}, 5000);
						}
						else {
							errorCode = getMchpLANLastError(LAN_ID);
							alert("Programming Failed." + errorMap[Dec2Hex(errorCode)]);
							update_status_message("Programming Failed."+ errorMap[Dec2Hex(errorCode)]);
							window.setTimeout(function() {
								$("#myprogress").hide();
							},10);
						}
					} else {
						update_status_message("Programming of the device was terminated by the user.");
						window.setTimeout(function() {
							$("#myprogress").hide();
						},10);
					}
				}
			}
		}
		
		//Required clean up action
		errorFlag = false;
		// Enable apply and preview buttons after programming is done
		$("#Preview").removeAttr('disabled', false);
		$("#Apply").removeAttr('disabled', false);
		//$("#myprogress").hide();
	
	};
})(jQuery);

(function ($) {
    set_dropdown_selected_option = function () {
        
        // Ordering is important - dont change code
        // Click of any field in  any drop down menu
        $(document).on('click', '.dropdown li a', function (event) {
            // this code is for making the current selection appear with caret
            var $target = $(event.currentTarget);

            $target.closest('.btn-group')
            .find('[data-bind]').text($target.text())
            .end()
            .children('.dropdown-toggle').dropdown('toggle');
            var selop = $(this).text();
            console.log("Selected Option - All dropdowns:" + selop);
        });

        // Click of Any hub in Select HUB drop down menu
        $(document).on('click', '.dropdown-selectLAN li a', function (event) {
			var selop = $(this).text();
			$("#selectedLANinput").val(selop);
			var btnValue = $("#selectedLANinput").val();
			var colonIndex = btnValue.indexOf(":");
			var currentLANSelected = btnValue.charAt(colonIndex + 1);

			if (currentLANSelected == LAN_ID) {
				setTimeout(function() {
					//Do nothing as the same hub is selected.
					get_LAN_list_set_LAN_index_zero();
				}, 200);
			} else {
				setTimeout(function() {
					close_lan_device(LAN_ID);
					refresh();
					LAN_ID = "" + currentHubSelected;
					set_selected_lan_get_widgets();
				}, 200);
			}
			return false;
        });
	};
})(jQuery);

function ValidateMac(currMac) {
	var macflag = true;
	
	MacValue = currMac.split(":");
	
	var maclength = MacValue.length;
	
	if(maclength < 6 || maclength > 6)
	{
		alert("The Given MAC Address is not valid.Mac Address should be for Example = 00:80:0F:10:20:01");
		return false;
	}
	
	for (var i = 0; i < 6; i++) {
	
	var isMacOKAddr= /^[0-9a-fA-F]{1,2}$/i.test(MacValue[i]);

	if(!isMacOKAddr)
	{
		alert("The Given MAC Address is not a valid Hexa decimal");
		return false;
	}

	if((MacValue[i] == 00) || (MacValue[i] == 255))
	{
		//will continue loop.Do nothing
	}
	else
	{
		macflag = false;
		
	}
	if( i == 5 && macflag == true)
	{
		alert("The Given MAC Address is not valid.Mac Address should be for Example = 00:80:0F:10:20:01");
		return false;
	}
}
	return true;
}
