var LAN_ID = "0";
var changecount = 0;
var Product = getProduct();

//Widget IDs of String fields in the GUI
var GwidgetlistString = [
	"macaddr",
	"manufacturer",
	"product",
	"serial",
	"configstring",
	"interfacestring"
];

//Widget IDs of Hex fields in the GUI
var GwidgetlistHex = [
	"usb2vid",
	"usb2pid",
	"usb2did",
	"langid",
	"eepromconfigflag0",
	"eepromconfigflag1",
	"eepromconfigflag2",
	"eepromconfigflag3",
	"eepromconfigflag4",
	"eepromconfigflag5"
	
	
];

//Widget IDs of Int fields in the GUI
var GwidgetlistInt = [
	"FSmaxpower",
	"HSmaxpower",
	"SSmaxpower",
	"FSinterruptEPinterval",
	"HSinterruptEPinterval",
	"SSinterruptEPinterval"
];

//Widget IDs of Checkbox fields in the GUI
var GwidgetlistCheckbox = [
	"enremwakeup",
	"enselfpower",
	"enbuspower",
	"LED0Enable",
	"LED1Enable",
	"LED2Enable",
	"LED3Enable"
];

var GwidgetlistDropDown = [
	"LED0Function",
	"LED1Function",
	"LED2Function",
	"LED3Function"
];

var DropDownLEDFunction = [
	"Link/Activity",
	"Link1000/Activity",
	"Link100/Activity",
	"Link10/Activity",
	"Link100/1000/Activity",
	"Link10/1000/Activity",
	"Link10/100/Activity",
	"Reserved",
	"Duplex/Collision",
	"Collision",
	"Activity",
	"Reserved",
	"Auto-Negotiation Fault",
	"Serial Mode",
	"Force LED Off",
	"Force LED On"
];

//Widget IDs of Radio fields in the GUI
var GwidgetlistRadio = [
	"GPIOPMEEnable",
	"GPIOPMEConfiguration",
	"GPIOPMELength",
	"GPIOPMEPolarity",
	"GPIOBufferType",
	"GPIOPMEWOLSelect",
	"PMEMagicPacketEnable",
	"PMEPerfectDAEnable",
	"PMEWUFFEnable"
];

(function ($) {
    disable_fields = function () {
		$("#MAC_Section").attr('disabled', true);
		$("#config_Section").attr('disabled', true);
		$("#DI_Hex_Section").attr('disabled', true);
		$("#DI_String_Section").attr('disabled', true);
		$("#RWPnP_Section").attr('disabled', true);
		$("#IEbI_Section").attr('disabled', true);
		$("#LED0_Section").attr('disabled', true);
		$("#LED1_Section").attr('disabled', true);
		$("#LED2_Section").attr('disabled', true);
		$("#LED3_Section").attr('disabled', true);
		$("#LEDBehavior_Section").attr('disabled', true);
		$("#GPIO0_section").attr('disabled', true);
		$("#GPIO1_section").attr('disabled', true);
		$("#GPIO2_section").attr('disabled', true);
		$("#GPIO3_section").attr('disabled', true);
		$("#GPIO4_section").attr('disabled', true);
		$("#GPIO5_section").attr('disabled', true);
		$("#GPIO6_section").attr('disabled', true);
		$("#GPIO7_section").attr('disabled', true);
		$("#GPIO8_section").attr('disabled', true);
		$("#GPIO9_section").attr('disabled', true);
		$("#GPIO10_section").attr('disabled', true);
		$("#GPIO11_section").attr('disabled', true);
		$("#PM_Section").attr('disabled', true);
		$("#LU_Section").attr('disabled', true);
		$("#MemDump_Section").attr('disabled', true);
    };
})(jQuery);

(function ($) {
    enable_fields = function () {
		$("#MAC_Section").attr('disabled', false);
		$("#config_Section").attr('disabled', false);
		$("#DI_Hex_Section").attr('disabled', false);
		$("#DI_String_Section").attr('disabled', false);
		$("#RWPnP_Section").attr('disabled', false);
		$("#IEbI_Section").attr('disabled', false);
		$("#LED0_Section").attr('disabled', false);
		$("#LED1_Section").attr('disabled', false);
		$("#LED2_Section").attr('disabled', false);
		$("#LED3_Section").attr('disabled', false);
		$("#LEDBehavior_Section").attr('disabled', false);
		$("#GPIO0_section").attr('disabled', false);
		$("#GPIO1_section").attr('disabled', false);
		$("#GPIO2_section").attr('disabled', false);
		$("#GPIO3_section").attr('disabled', false);
		$("#GPIO4_section").attr('disabled', false);
		$("#GPIO5_section").attr('disabled', false);
		$("#GPIO6_section").attr('disabled', false);
		$("#GPIO7_section").attr('disabled', false);
		$("#GPIO8_section").attr('disabled', false);
		$("#GPIO9_section").attr('disabled', false);
		$("#GPIO10_section").attr('disabled', false);
		$("#GPIO11_section").attr('disabled', false);
		$("#PM_Section").attr('disabled', false);
		$("#LU_Section").attr('disabled', false);
		$("#MemDump_Section").attr('disabled', false);
    };
})(jQuery);

//Function to switch load and save Preference
function switchloadsave(changecount) {
	if(changecount!=0)
	{
		$('#LoadFileField').hide();
		$('#LoadFileField').attr('disabled', 'disabled');
		$('#SaveFileField').removeAttr('disabled');
		$('#SaveFileField').show();
		$("#Apply").attr('disabled', false);	
	}else{
		$('#SaveFileField').hide();
		$('#SaveFileField').attr('disabled', 'disabled');
		$('#LoadFileField').removeAttr('disabled');
		$('#LoadFileField').show();
		$("#Apply").attr('disabled', true);	
	}
}
$("#macaddr").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "macaddr");
	var newval = $("#macaddr").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (macaddr_check > 0) {
			macaddr_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (macaddr_check == 0) {
			changecount = changecount+1;
		}
		macaddr_check++;
	}
	switchloadsave(changecount);
});

$("#usb2vid").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "usb2vid"), 10);
	var newval = parseInt($("#usb2vid").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (usb2vid_check > 0) {
			usb2vid_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (usb2vid_check == 0) {
			changecount = changecount+1;
		}
		usb2vid_check++;
	}
	switchloadsave(changecount);
});

$("#usb2pid").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "usb2pid"), 10);
	var newval = parseInt($("#usb2pid").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (usb2pid_check > 0) {
			usb2pid_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (usb2pid_check == 0) {
			changecount = changecount+1;
		}
		usb2pid_check++;
	}
	switchloadsave(changecount);
});

$("#usb2did").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "usb2did"), 10);
	var newval = parseInt($("#usb2did").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (usb2did_check > 0) {
			usb2did_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (usb2did_check == 0) {
			changecount = changecount+1;	
		}
		usb2did_check++;
	}
	switchloadsave(changecount);
});

$("#langid").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "langid"), 10);
	var newval = parseInt($("#langid").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (langid_check > 0) {
			langid_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (langid_check == 0) {
			changecount = changecount+1;
		}
		langid_check++;
	}
	switchloadsave(changecount);
});

$("#eepromconfigflag0").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag0");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	
	var newval = $("#eepromconfigflag0").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (eepromconfigflag0_check > 0) {
			eepromconfigflag0_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (eepromconfigflag0_check == 0) {
			changecount = changecount+1;
		}
		eepromconfigflag0_check++;
	}
	switchloadsave(changecount);
});

$("#eepromconfigflag1").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag1");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	
	var newval = $("#eepromconfigflag1").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (eepromconfigflag1_check > 0) {
			eepromconfigflag1_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (eepromconfigflag1_check == 0) {
			changecount = changecount+1;
		}
		eepromconfigflag1_check++;
	}
	switchloadsave(changecount);
});

$("#eepromconfigflag2").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag2");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	
	var newval = $("#eepromconfigflag2").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (eepromconfigflag2_check > 0) {
			eepromconfigflag2_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (eepromconfigflag2_check == 0) {
			changecount = changecount+1;
		}
		eepromconfigflag2_check++;
	}
	switchloadsave(changecount);
});

$("#eepromconfigflag3").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag3");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	
	var newval = $("#eepromconfigflag3").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (eepromconfigflag3_check > 0) {
			eepromconfigflag3_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (eepromconfigflag3_check == 0) {
			changecount = changecount+1;
		}
		eepromconfigflag3_check++;
	}
	switchloadsave(changecount);
});

$("#eepromconfigflag4").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag4");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	
	var newval = $("#eepromconfigflag4").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (eepromconfigflag4_check > 0) {
			eepromconfigflag4_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (eepromconfigflag4_check == 0) {
			changecount = changecount+1;
		}
		eepromconfigflag4_check++;
	}
	switchloadsave(changecount);
});

$("#eepromconfigflag5").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag5");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	
	var newval = $("#eepromconfigflag5").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (eepromconfigflag5_check > 0) {
			eepromconfigflag5_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (eepromconfigflag5_check == 0) {
			changecount = changecount+1;
		}
		eepromconfigflag5_check++;
	}
	switchloadsave(changecount);
});

//GwidgetlistHex Ends

//GwidgetlistString Starts
$("#manufacturer").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "manufacturer");
	var newval = $("#manufacturer").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (manufacturer_check > 0) {
			manufacturer_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (manufacturer_check == 0) {
			changecount = changecount+1;
		}
		manufacturer_check++;
	}
	switchloadsave(changecount);
});

$("#product").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "product");
	var newval = $("#product").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (product_check > 0) {
			product_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (product_check == 0) {
			changecount = changecount+1;
		}
		product_check++;
	}
	switchloadsave(changecount);
});

$("#serial").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "serial");
	var newval = $("#serial").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (serial_check > 0) {
			serial_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (serial_check == 0) {
			changecount = changecount+1;
		}	
		serial_check++;
	}
	switchloadsave(changecount);
});

$("#configstring").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "configstring");
	var newval = $("#configstring").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (configstring_check > 0) {
			configstring_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (configstring_check == 0) {
			changecount = changecount+1;
		}
		configstring_check++;
	}
	switchloadsave(changecount);
});

$("#interfacestring").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "interfacestring");
	var newval = $("#interfacestring").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (interfacestring_check > 0) {
			interfacestring_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (interfacestring_check == 0) {
			changecount = changecount+1;	
		}
		interfacestring_check++;
	}
	switchloadsave(changecount);
});
//GwidgetlistString Ends

//GwidgetlistInt Starts
$("#HSmaxpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "HSmaxpower");
	oldval = parseInt(oldval,10) * 2;
	var newval = parseInt($("#HSmaxpower").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (HSmaxpower_check > 0) {
			HSmaxpower_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (HSmaxpower_check == 0) {
			changecount = changecount+1;	
		}
		HSmaxpower_check++;
	}
	switchloadsave(changecount);
});

$("#FSmaxpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "FSmaxpower");
	oldval = parseInt(oldval,10);
	var newval = parseInt($("#FSmaxpower").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (FSmaxpower_check > 0) {
			FSmaxpower_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (FSmaxpower_check == 0) {
			changecount = changecount+1;
		}
		FSmaxpower_check++;
	}
	switchloadsave(changecount);
});

$("#SSmaxpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "SSmaxpower");
	oldval = parseInt(oldval,10) * 2;
	var newval = parseInt($("#SSmaxpower").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (SSmaxpower_check > 0) {
			SSmaxpower_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (SSmaxpower_check == 0) {
			changecount = changecount+1;
		}
		SSmaxpower_check++;
	}
	switchloadsave(changecount);
});

$("#FSinterruptEPinterval").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "FSinterruptEPinterval");
	oldval = parseInt(oldval,10);
	var newval = parseInt($("#FSinterruptEPinterval").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (FSinterruptEPinterval_check > 0) {
			FSinterruptEPinterval_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (FSinterruptEPinterval_check == 0) {
			changecount = changecount+1;
		}
		FSinterruptEPinterval_check++;
	}
	switchloadsave(changecount);
});

$("#HSinterruptEPinterval").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "HSinterruptEPinterval");
	oldval = parseInt(oldval,10) * 8;
	var newval = parseInt($("#HSinterruptEPinterval").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (HSinterruptEPinterval_check > 0) {
			HSinterruptEPinterval_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (HSinterruptEPinterval_check == 0) {
			changecount = changecount+1;	
		}
		HSinterruptEPinterval_check++;
	}
	switchloadsave(changecount);
});

$("#SSinterruptEPinterval").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "SSinterruptEPinterval");
	oldval = parseInt(oldval,10) * 8;
	var newval = parseInt($("#SSinterruptEPinterval").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (SSinterruptEPinterval_check > 0) {
			SSinterruptEPinterval_check = 0;
		}
	} else {
		$(this).css('border-color', 'red');
		if (SSinterruptEPinterval_check == 0) {
			changecount = changecount+1;	
		}
		SSinterruptEPinterval_check++;
	}
	switchloadsave(changecount);
});
//GwidgetlistInt Ends

//GwidgetlistCheckbox Starts
$("#enremwakeup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "enremwakeup");
	var newval = checkbox_unchecked_value;
	if($("#enremwakeup").is(':checked'))
	{
		newval = checkbox_checked_value;
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (enremwakeup_check > 0) {
			enremwakeup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (enremwakeup_check == 0) {
			changecount = changecount+1;
		}
		enremwakeup_check++;
	}
	switchloadsave(changecount);
});

$("#enbuspower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "enbuspower");
	var newval = checkbox_unchecked_value;
	if($("#enbuspower").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (enbuspower_check > 0) {
			enbuspower_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (enbuspower_check == 0) {
			changecount = changecount+1;
		}
		enbuspower_check++;
	}
	switchloadsave(changecount);
});

$("#enselfpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "enselfpower");
	var newval = checkbox_unchecked_value;
	if($("#enselfpower").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (enselfpower_check > 0) {
			enselfpower_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (enselfpower_check == 0) {
			changecount = changecount+1;
		}
		enselfpower_check++;
	}
	switchloadsave(changecount);
});


$("#LED0Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED0Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED0Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED0Enable_check > 0) {
			LED0Enable_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED0Enable_check == 0) {
			changecount = changecount+1;
		}
		LED0Enable_check++;
	}
	switchloadsave(changecount);
});

$("#LED1Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED1Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED1Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED1Enable_check > 0) {
			LED1Enable_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED1Enable_check == 0) {
			changecount = changecount+1;
		}
		LED1Enable_check++;
	}
	switchloadsave(changecount);
});

$("#LED2Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED2Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED2Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED2Enable_check > 0) {
			LED2Enable_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED2Enable_check == 0) {
			changecount = changecount+1;
		}
		LED2Enable_check++;
	}
	switchloadsave(changecount);
});

$("#LED3Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED3Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED3Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED3Enable_check > 0) {
			LED3Enable_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED3Enable_check == 0) {
			changecount = changecount+1;
		}
		LED3Enable_check++;
	}
	switchloadsave(changecount);
});
/////////Polarity///////
//GwidgetlistCheckbox Ends

//GwidgetlistRadio Starts
$("#gpio0EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#gpio0EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO0_WUSection").attr('disabled', true);
		$("#GPIO0_WUPSection").attr('disabled', true);
		$("#GPIO0_set").attr('disabled', true);
		
		$("#GPIO0_WUSection").hide();
		$("#GPIO0_WUPSection").hide();
		$("#GPIO0_set").hide();
	} else {
		$("#GPIO0_WUSection").show();
		$("#GPIO0_WUPSection").show();
		$("#GPIO0_set").show();

		$("#GPIO0_WUSection").removeAttr('disabled', false);
		$("#GPIO0_WUPSection").removeAttr('disabled', false);
		$("#GPIO0_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio0EnableGroup_check > 0) {
			gpio0EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio0EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio0EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio1EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#gpio1EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO1_WUSection").attr('disabled', true);
		$("#GPIO1_WUPSection").attr('disabled', true);
		$("#GPIO1_set").attr('disabled', true);
		
		$("#GPIO1_WUSection").hide();
		$("#GPIO1_WUPSection").hide();
		$("#GPIO1_set").hide();
	} else {
		$("#GPIO1_WUSection").show();
		$("#GPIO1_WUPSection").show();
		$("#GPIO1_set").show();

		$("#GPIO1_WUSection").removeAttr('disabled', false);
		$("#GPIO1_WUPSection").removeAttr('disabled', false);
		$("#GPIO1_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio1EnableGroup_check > 0) {
			gpio1EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio1EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio1EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio2EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#gpio2EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO2_WUSection").attr('disabled', true);
		$("#GPIO2_WUPSection").attr('disabled', true);
		$("#GPIO2_set").attr('disabled', true);
		
		$("#GPIO2_WUSection").hide();
		$("#GPIO2_WUPSection").hide();
		$("#GPIO2_set").hide();
	} else {
		$("#GPIO2_WUSection").show();
		$("#GPIO2_WUPSection").show();
		$("#GPIO2_set").show();

		$("#GPIO2_WUSection").removeAttr('disabled', false);
		$("#GPIO2_WUPSection").removeAttr('disabled', false);
		$("#GPIO2_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio2EnableGroup_check > 0) {
			gpio2EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio2EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio2EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio3EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#gpio3EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO3_WUSection").attr('disabled', true);
		$("#GPIO3_WUPSection").attr('disabled', true);
		$("#GPIO3_set").attr('disabled', true);
		
		$("#GPIO3_WUSection").hide();
		$("#GPIO3_WUPSection").hide();
		$("#GPIO3_set").hide();
	} else {
		$("#GPIO3_WUSection").show();
		$("#GPIO3_WUPSection").show();
		$("#GPIO3_set").show();

		$("#GPIO3_WUSection").removeAttr('disabled', false);
		$("#GPIO3_WUPSection").removeAttr('disabled', false);
		$("#GPIO3_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio3EnableGroup_check > 0) {
			gpio3EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio3EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio3EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio4EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#gpio4EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO4_WUSection").attr('disabled', true);
		$("#GPIO4_WUPSection").attr('disabled', true);
		$("#GPIO4_set").attr('disabled', true);
		
		$("#GPIO4_WUSection").hide();
		$("#GPIO4_WUPSection").hide();
		$("#GPIO4_set").hide();
	} else {
		$("#GPIO4_WUSection").show();
		$("#GPIO4_WUPSection").show();
		$("#GPIO4_set").show();

		$("#GPIO4_WUSection").removeAttr('disabled', false);
		$("#GPIO4_WUPSection").removeAttr('disabled', false);
		$("#GPIO4_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio4EnableGroup_check > 0) {
			gpio4EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio4EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio4EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio5EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#gpio5EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO5_WUSection").attr('disabled', true);
		$("#GPIO5_WUPSection").attr('disabled', true);
		$("#GPIO5_set").attr('disabled', true);
		
		$("#GPIO5_WUSection").hide();
		$("#GPIO5_WUPSection").hide();
		$("#GPIO5_set").hide();
	} else {
		$("#GPIO5_WUSection").show();
		$("#GPIO5_WUPSection").show();
		$("#GPIO5_set").show();

		$("#GPIO5_WUSection").removeAttr('disabled', false);
		$("#GPIO5_WUPSection").removeAttr('disabled', false);
		$("#GPIO5_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio5EnableGroup_check > 0) {
			gpio5EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio5EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio5EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio6EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#gpio6EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO6_WUSection").attr('disabled', true);
		$("#GPIO6_WUPSection").attr('disabled', true);
		$("#GPIO6_set").attr('disabled', true);
		
		$("#GPIO6_WUSection").hide();
		$("#GPIO6_WUPSection").hide();
		$("#GPIO6_set").hide();
	} else {
		$("#GPIO6_WUSection").show();
		$("#GPIO6_WUPSection").show();
		$("#GPIO6_set").show();

		$("#GPIO6_WUSection").removeAttr('disabled', false);
		$("#GPIO6_WUPSection").removeAttr('disabled', false);
		$("#GPIO6_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio6EnableGroup_check > 0) {
			gpio6EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio6EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio6EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio7EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#gpio7EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO7_WUSection").attr('disabled', true);
		$("#GPIO7_WUPSection").attr('disabled', true);
		$("#GPIO7_set").attr('disabled', true);
		
		$("#GPIO7_WUSection").hide();
		$("#GPIO7_WUPSection").hide();
		$("#GPIO7_set").hide();
	} else {
		$("#GPIO7_WUSection").show();
		$("#GPIO7_WUPSection").show();
		$("#GPIO7_set").show();

		$("#GPIO7_WUSection").removeAttr('disabled', false);
		$("#GPIO7_WUPSection").removeAttr('disabled', false);
		$("#GPIO7_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio7EnableGroup_check > 0) {
			gpio7EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio7EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio7EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio8EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#gpio8EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO8_WUSection").attr('disabled', true);
		$("#GPIO8_WUPSection").attr('disabled', true);
		$("#GPIO8_set").attr('disabled', true);
		
		$("#GPIO8_WUSection").hide();
		$("#GPIO8_WUPSection").hide();
		$("#GPIO8_set").hide();
	} else {
		$("#GPIO8_WUSection").show();
		$("#GPIO8_WUPSection").show();
		$("#GPIO8_set").show();

		$("#GPIO8_WUSection").removeAttr('disabled', false);
		$("#GPIO8_WUPSection").removeAttr('disabled', false);
		$("#GPIO8_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio8EnableGroup_check > 0) {
			gpio8EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio8EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio8EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio9EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#gpio9EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO9_WUSection").attr('disabled', true);
		$("#GPIO9_WUPSection").attr('disabled', true);
		$("#GPIO9_set").attr('disabled', true);
		
		$("#GPIO9_WUSection").hide();
		$("#GPIO9_WUPSection").hide();
		$("#GPIO9_set").hide();
	} else {
		$("#GPIO9_WUSection").show();
		$("#GPIO9_WUPSection").show();
		$("#GPIO9_set").show();

		$("#GPIO9_WUSection").removeAttr('disabled', false);
		$("#GPIO9_WUPSection").removeAttr('disabled', false);
		$("#GPIO9_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio9EnableGroup_check > 0) {
			gpio9EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio9EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio9EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio10EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#gpio10EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO10_WUSection").attr('disabled', true);
		$("#GPIO10_WUPSection").attr('disabled', true);
		$("#GPIO10_set").attr('disabled', true);
		
		$("#GPIO10_WUSection").hide();
		$("#GPIO10_WUPSection").hide();
		$("#GPIO10_set").hide();
	} else {
		$("#GPIO10_WUSection").show();
		$("#GPIO10_WUPSection").show();
		$("#GPIO10_set").show();

		$("#GPIO10_WUSection").removeAttr('disabled', false);
		$("#GPIO10_WUPSection").removeAttr('disabled', false);
		$("#GPIO10_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio10EnableGroup_check > 0) {
			gpio10EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio10EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio10EnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio11EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#gpio11EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO11_WUSection").attr('disabled', true);
		$("#GPIO11_WUPSection").attr('disabled', true);
		$("#GPIO11_set").attr('disabled', true);
		
		$("#GPIO11_WUSection").hide();
		$("#GPIO11_WUPSection").hide();
		$("#GPIO11_set").hide();
	} else {
		$("#GPIO11_WUSection").show();
		$("#GPIO11_WUPSection").show();
		$("#GPIO11_set").show();
		
		$("#GPIO11_WUSection").removeAttr('disabled', false);
		$("#GPIO11_WUPSection").removeAttr('disabled', false);
		$("#GPIO11_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio11EnableGroup_check > 0) {
			gpio11EnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio11EnableGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio11EnableGroup_check++;
	}
	switchloadsave(changecount);
});

/////GPIO Enable//////
$("#gpio0BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#gpio0BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio0BufferGroup_check > 0) {
			gpio0BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio0BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio0BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio1BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#gpio1BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio1BufferGroup_check > 0) {
			gpio1BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio1BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio1BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio2BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#gpio2BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio2BufferGroup_check > 0) {
			gpio2BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio2BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio2BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio3BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#gpio3BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio3BufferGroup_check > 0) {
			gpio3BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio3BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio3BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio4BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#gpio4BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio4BufferGroup_check > 0) {
			gpio4BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio4BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio4BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio5BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#gpio5BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio5BufferGroup_check > 0) {
			gpio5BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio5BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio5BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio6BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#gpio6BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio6BufferGroup_check > 0) {
			gpio6BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio6BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio6BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio7BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#gpio7BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio7BufferGroup_check > 0) {
			gpio7BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio7BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio7BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio8BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#gpio8BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio8BufferGroup_check > 0) {
			gpio8BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio8BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio8BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio9BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#gpio9BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio9BufferGroup_check > 0) {
			gpio9BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio9BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio9BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio10BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#gpio10BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio10BufferGroup_check > 0) {
			gpio10BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio10BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio10BufferGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio11BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#gpio11BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio11BufferGroup_check > 0) {
			gpio11BufferGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio11BufferGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio11BufferGroup_check++;
	}
	switchloadsave(changecount);
});

///// GPIO Buffer ///////
$("#gpio0DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#gpio0DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio0DirectionGroup_check > 0) {
			gpio0DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio0DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio0DirectionGroup_check++;
	}
	switchloadsave(changecount);
	
	if (newval == 0) {
		$("#gpio0DataSection").hide();
	} else if (newval == 1) {
		$("#gpio0DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio1DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#gpio1DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio1DirectionGroup_check > 0) {
			gpio1DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio1DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio1DirectionGroup_check++;
	}
	switchloadsave(changecount);
	
	if (newval == 0) {
		$("#gpio1DataSection").hide();
	} else if (newval == 1) {
		$("#gpio1DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio2DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#gpio2DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio2DirectionGroup_check > 0) {
			gpio2DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio2DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio2DirectionGroup_check++;
	}
	switchloadsave(changecount);

	if (newval == 0) {
		$("#gpio2DataSection").hide();
	} else if (newval == 1) {
		$("#gpio2DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio3DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#gpio3DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio3DirectionGroup_check > 0) {
			gpio3DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio3DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio3DirectionGroup_check++;
	}
	switchloadsave(changecount);
	
	if (newval == 0) {
		$("#gpio3DataSection").hide();
	} else if (newval == 1) {
		$("#gpio3DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio4DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#gpio4DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio4DirectionGroup_check > 0) {
			gpio4DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio4DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio4DirectionGroup_check++;
	}
	switchloadsave(changecount);
	
	if (newval == 0) {
		$("#gpio4DataSection").hide();
	} else if (newval == 1) {
		$("#gpio4DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio5DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#gpio5DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio5DirectionGroup_check > 0) {
			gpio5DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio5DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio5DirectionGroup_check++;
	}
	switchloadsave(changecount);
	if (newval == 0) {
		$("#gpio5DataSection").hide();
	} else if (newval == 1) {
		$("#gpio5DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio6DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#gpio6DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio6DirectionGroup_check > 0) {
			gpio6DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio6DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio6DirectionGroup_check++;
	}
	switchloadsave(changecount);
	if (newval == 0) {
		$("#gpio6DataSection").hide();
	} else if (newval == 1) {
		$("#gpio6DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio7DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#gpio7DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio7DirectionGroup_check > 0) {
			gpio7DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio7DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio7DirectionGroup_check++;
	}
	switchloadsave(changecount);
	if (newval == 0) {
		$("#gpio7DataSection").hide();
	} else if (newval == 1) {
		$("#gpio7DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio8DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#gpio8DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio8DirectionGroup_check > 0) {
			gpio8DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio8DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio8DirectionGroup_check++;
	}
	switchloadsave(changecount);
	if (newval == 0) {
		$("#gpio8DataSection").hide();
	} else if (newval == 1) {
		$("#gpio8DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio9DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#gpio9DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio9DirectionGroup_check > 0) {
			gpio9DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio9DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio9DirectionGroup_check++;
	}
	switchloadsave(changecount);
	
	if (newval == 0) {
		$("#gpio9DataSection").hide();
	} else if (newval == 1) {
		$("#gpio9DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio10DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#gpio10DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio10DirectionGroup_check > 0) {
			gpio10DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio10DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio10DirectionGroup_check++;
	}
	switchloadsave(changecount);
	if (newval == 0) {
		$("#gpio10DataSection").hide();
	} else if (newval == 1) {
		$("#gpio10DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio11DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#gpio11DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio11DirectionGroup_check > 0) {
			gpio11DirectionGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio11DirectionGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio11DirectionGroup_check++;
	}
	switchloadsave(changecount);
	
	if (newval == 0) {
		$("#gpio11DataSection").hide();
	} else if (newval == 1) {
		$("#gpio11DataSection").show();
	} else {
		//Do nothing
	}
});
////// GPIO Direction //////
$("#gpio0DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 1) == 1) {
		oldval = 0;
	}
	
	var newval = $("#gpio0DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio0DataGroup_check > 0) {
			gpio0DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio0DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio0DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio1DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 2) == 2) {
		oldval = 0;
	}
	
	var newval = $("#gpio1DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio1DataGroup_check > 0) {
			gpio1DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio1DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio1DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio2DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 4) == 4) {
		oldval = 0;
	}
	
	var newval = $("#gpio2DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio2DataGroup_check > 0) {
			gpio2DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio2DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio2DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio3DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 8) == 8) {
		oldval = 0;
	}
	
	var newval = $("#gpio3DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio3DataGroup_check > 0) {
			gpio3DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio3DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio3DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio4DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 16) == 16) {
		oldval = 0;
	}
	
	var newval = $("#gpio4DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio4DataGroup_check > 0) {
			gpio4DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio4DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio4DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio5DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 32) == 32) {
		oldval = 0;
	}
	
	var newval = $("#gpio5DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio5DataGroup_check > 0) {
			gpio5DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio5DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio5DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio6DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 64) == 64) {
		oldval = 0;
	}
	
	var newval = $("#gpio6DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio6DataGroup_check > 0) {
			gpio6DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio6DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio6DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio7DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 128) == 128) {
		oldval = 0;
	}
	
	var newval = $("#gpio7DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio7DataGroup_check > 0) {
			gpio7DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio7DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio7DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio8DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 256) == 256) {
		oldval = 0;
	}
	
	var newval = $("#gpio8DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio8DataGroup_check > 0) {
			gpio8DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio8DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio8DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio9DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 512) == 512) {
		oldval = 0;
	}
	
	var newval = $("#gpio9DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio9DataGroup_check > 0) {
			gpio9DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio9DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio9DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio10DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 1024) == 1024) {
		oldval = 0;
	}
	
	var newval = $("#gpio10DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio10DataGroup_check > 0) {
			gpio10DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio10DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio10DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#gpio11DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 2048) == 2048) {
		oldval = 0;
	}
	
	var newval = $("#gpio11DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (gpio11DataGroup_check > 0) {
			gpio11DataGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (gpio11DataGroup_check == 0) {
		changecount = changecount+1;
		}
		gpio11DataGroup_check++;
	}
	switchloadsave(changecount);
});

$("#GPIOPMEEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEEnable");
	var newval = $("#GPIOPMEEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (GPIOPMEEnableGroup_check > 0) {
			GPIOPMEEnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (GPIOPMEEnableGroup_check == 0) {
		changecount = changecount+1;
		}
		GPIOPMEEnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#GPIOPMEConfigurationGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEConfiguration");
	var newval = $("#GPIOPMEConfigurationGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (GPIOPMEConfigurationGroup_check > 0) {
			GPIOPMEConfigurationGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (GPIOPMEConfigurationGroup_check == 0) {
		changecount = changecount+1;
		}
		GPIOPMEConfigurationGroup_check++;
	}
	switchloadsave(changecount);
});

$("#GPIOPMELengthGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMELength");
	var newval = $("#GPIOPMELengthGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (GPIOPMELengthGroup_check > 0) {
			GPIOPMELengthGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (GPIOPMELengthGroup_check == 0) {
		changecount = changecount+1;
		}
		GPIOPMELengthGroup_check++;
	}
	switchloadsave(changecount);
});

$("#GPIOPMEPolarityGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEPolarity");
	var newval = $("#GPIOPMEPolarityGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (GPIOPMEPolarityGroup_check > 0) {
			GPIOPMEPolarityGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (GPIOPMEPolarityGroup_check == 0) {
		changecount = changecount+1;
		}
		GPIOPMEPolarityGroup_check++;
	}
	switchloadsave(changecount);
});

$("#GPIOBufferTypeGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOBufferType");
	var newval = $("#GPIOBufferTypeGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (GPIOBufferTypeGroup_check > 0) {
			GPIOBufferTypeGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (GPIOBufferTypeGroup_check == 0) {
		changecount = changecount+1;
		}
		GPIOBufferTypeGroup_check++;
	}
	switchloadsave(changecount);
});

$("#GPIOPMEWOLSelectGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEWOLSelect");
	var newval = $("#GPIOPMEWOLSelectGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (GPIOPMEWOLSelectGroup_check > 0) {
			GPIOPMEWOLSelectGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (GPIOPMEWOLSelectGroup_check == 0) {
		changecount = changecount+1;
		}
		GPIOPMEWOLSelectGroup_check++;
	}
	switchloadsave(changecount);
});

$("#PMEMagicPacketEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "PMEMagicPacketEnable");
	var newval = $("#PMEMagicPacketEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (PMEMagicPacketEnableGroup_check > 0) {
			PMEMagicPacketEnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (PMEMagicPacketEnableGroup_check == 0) {
		changecount = changecount+1;
		}
		PMEMagicPacketEnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#PMEPerfectDAEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "PMEPerfectDAEnable");
	var newval = $("#PMEPerfectDAEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (PMEPerfectDAEnableGroup_check > 0) {
			PMEPerfectDAEnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (PMEPerfectDAEnableGroup_check == 0) {
		changecount = changecount+1;
		}
		PMEPerfectDAEnableGroup_check++;
	}
	switchloadsave(changecount);
});

$("#PMEWUFFEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "PMEWUFFEnable");
	var newval = $("#PMEWUFFEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (PMEWUFFEnableGroup_check > 0) {
			PMEWUFFEnableGroup_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (PMEWUFFEnableGroup_check == 0) {
		changecount = changecount+1;
		}
		PMEWUFFEnableGroup_check++;
	}
	switchloadsave(changecount);
});

//GPIO Wake up Starts
$("#WUgpio0Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio0Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio0Group_check > 0) {
			WUgpio0Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio0Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio0Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio1Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio1Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio1Group_check > 0) {
			WUgpio1Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio1Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio1Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio2Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio2Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio2Group_check > 0) {
			WUgpio2Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio2Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio2Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio3Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio3Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio3Group_check > 0) {
			WUgpio3Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio3Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio3Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio4Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio4Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio4Group_check > 0) {
			WUgpio4Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio4Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio4Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio5Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio5Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio5Group_check > 0) {
			WUgpio5Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio5Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio5Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio6Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio6Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio6Group_check > 0) {
			WUgpio6Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio6Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio6Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio7Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio7Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio7Group_check > 0) {
			WUgpio7Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio7Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio7Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio8Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio8Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio8Group_check > 0) {
			WUgpio8Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio8Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio8Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio9Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio9Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio9Group_check > 0) {
			WUgpio9Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio9Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio9Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio10Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio10Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio10Group_check > 0) {
			WUgpio10Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio10Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio10Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUgpio11Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio11Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUgpio11Group_check > 0) {
			WUgpio11Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUgpio11Group_check == 0) {
		changecount = changecount+1;
		}
		WUgpio11Group_check++;
	}
	switchloadsave(changecount);
});
//GPIO Wake up Ends

//GPIO Wake up Polarity Starts
$("#WUPgpio0Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio0Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio0Group_check > 0) {
			WUPgpio0Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio0Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio0Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio1Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio1Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio1Group_check > 0) {
			WUPgpio1Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio1Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio1Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio2Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio2Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio2Group_check > 0) {
			WUPgpio2Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio2Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio2Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio3Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio3Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio3Group_check > 0) {
			WUPgpio3Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio3Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio3Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio4Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio4Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio4Group_check > 0) {
			WUPgpio4Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio4Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio4Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio5Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio5Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio5Group_check > 0) {
			WUPgpio5Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio5Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio5Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio6Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio6Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio6Group_check > 0) {
			WUPgpio6Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio6Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio6Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio7Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio7Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio7Group_check > 0) {
			WUPgpio7Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio7Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio7Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio8Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio8Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio8Group_check > 0) {
			WUPgpio8Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio8Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio8Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio9Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio9Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio9Group_check > 0) {
			WUPgpio9Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio9Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio9Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio10Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio10Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio10Group_check > 0) {
			WUPgpio10Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio10Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio10Group_check++;
	}
	switchloadsave(changecount);
});

$("#WUPgpio11Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio11Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (WUPgpio11Group_check > 0) {
			WUPgpio11Group_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (WUPgpio11Group_check == 0) {
		changecount = changecount+1;
		}
		WUPgpio11Group_check++;
	}
	switchloadsave(changecount);
});
//GPIO Wake up Polarity Ends

$("#LED0CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 1) == 1) {
		oldval = 1;
	}
	
	
	var newval = $("#LED0CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED0Combine_check > 0) {
			LED0Combine_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED0Combine_check == 0) {
		changecount = changecount+1;
		}
		LED0Combine_check++;
	}
	switchloadsave(changecount);
});


$("#LED1CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#LED1CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED1Combine_check > 0) {
			LED1Combine_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED1Combine_check == 0) {
		changecount = changecount+1;
		}
		LED1Combine_check++;
	}
	switchloadsave(changecount);
});

$("#LED2CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#LED2CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED2Combine_check > 0) {
			LED2Combine_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED2Combine_check == 0) {
		changecount = changecount+1;
		}
		LED2Combine_check++;
	}
	switchloadsave(changecount);
});

$("#LED3CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#LED3CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED3Combine_check > 0) {
			LED3Combine_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED3Combine_check == 0) {
		changecount = changecount+1;
		}
		LED3Combine_check++;
	}
	switchloadsave(changecount);
});

$("#LED0Group").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#LED0Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED0_check > 0) {
			LED0_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED0_check == 0) {
		changecount = changecount+1;
		}
		LED0_check++;
	}
	switchloadsave(changecount);
});

$("#LED1Group").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#LED1Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED1_check > 0) {
			LED1_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED1_check == 0) {
		changecount = changecount+1;
		}
		LED1_check++;
	}
	switchloadsave(changecount);
});

$("#LED2Group").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#LED2Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED2_check > 0) {
			LED2_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED2_check == 0) {
		changecount = changecount+1;
		}
		LED2_check++;
	}
	switchloadsave(changecount);
});


$("#LED3Group").change(function () {
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	var oldval = 0;
	if ((led2_behaviour & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#LED3Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED3_check > 0) {
			LED3_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LED3_check == 0) {
		changecount = changecount+1;
		}
		LED3_check++;
	}
	switchloadsave(changecount);
});

$("#LEDRateGroup").change(function () {
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	var oldval;
	
	if ((led2_behaviour & 12) == 12) {
		oldval = 3;
	} 
	else if((led2_behaviour & 0x8) == 0x8){
		oldval = 2;
	}
	else if((led2_behaviour & 0x4) == 0x4){
		oldval = 1;
	}
	else if((led2_behaviour & 0) == 0){
		oldval = 0;
	}
	
	var newval = $("#LEDRateGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LEDRate_check > 0) {
			LEDRate_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LEDRate_check == 0) {
		changecount = changecount+1;
		}
		LEDRate_check++;
	}
	switchloadsave(changecount);
});


$("#LEDPulsingGroup").change(function () {
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	var oldval = 0;
	if ((led2_behaviour & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#LEDPulsingGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LEDPulsing_check > 0) {
			LEDPulsing_check = 0;
		}
	} else {
		$(this).parent().addClass("highlight");
		if (LEDPulsing_check == 0) {
		changecount = changecount+1;
		}
		LEDPulsing_check++;
	}
	switchloadsave(changecount);
});

///////Dropdown part/////
$('#LED0FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED0Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED0Function_check > 0) {
			LED0Function_check = 0;
		}
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
		if (LED0Function_check == 0) {
		changecount=changecount+1;
		}
		LED0Function_check++;
	}
	switchloadsave(changecount);
});

$('#LED1FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED1Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED1Function_check > 0) {
			LED1Function_check = 0;
		}
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
		if (LED1Function_check == 0) {
			changecount=changecount+1;
		}
		LED1Function_check++;
	}
	switchloadsave(changecount);
});

$('#LED2FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED2Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED2Function_check > 0) {
			LED2Function_check = 0;
		}
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
		if (LED2Function_check == 0) {
		changecount=changecount+1;
		}
		LED2Function_check++;
	}
	switchloadsave(changecount);
});

$('#LED3FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED3Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
		if(changecount!=0)
		{
			changecount = changecount-1;
		}
		if (LED3Function_check > 0) {
			LED3Function_check = 0;
		}
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
		if (LED3Function_check == 0) {
		changecount=changecount+1;
		}
		LED3Function_check++;
	}
	switchloadsave(changecount);
});

(function ($) {
    set_changed_fields_border_default = function () {
        $("input[type='text']").each(function() {
            $(this).css('border-color', 'LightGray');
        });

        $("input[type='number']").each(function() {
            $(this).css('border-color', 'LightGray');
        });

        $("input[type='checkbox']").each(function() {
            $(this).parent().removeClass("highlight");
        });

        $("input[type='radio']").each(function() {
            $(this).parent().removeClass("highlight");
        });
		
		var wid;
		//GPIO Enable for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "EnableGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Buffer for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "BufferGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Direction for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "DirectionGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Data for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "DataGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Wake up for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#WUgpio" + i + "Group";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Wake up Polarity for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#WUPgpio" + i + "Group";
			$(wid).parent().removeClass("highlight");
		}

        $(".dropdown li a").each(function () {
            var parent = $(this).closest('div');
            $(parent).css('border-color', 'transparent');
        });
		
		  $(LED0Group).parent().removeClass("highlight");
		  $(LED1Group).parent().removeClass("highlight");
		  $(LED2Group).parent().removeClass("highlight");
		  $(LED3Group).parent().removeClass("highlight");
		  $(LEDPulsingGroup).parent().removeClass("highlight");
		  $(LEDRateGroup).parent().removeClass("highlight");
		  
		  $(LED0CombineEnableGroup).parent().removeClass("highlight");
		  $(LED1CombineEnableGroup).parent().removeClass("highlight");
		  $(LED2CombineEnableGroup).parent().removeClass("highlight");
		  $(LED3CombineEnableGroup).parent().removeClass("highlight");
		  
		  $(GPIOPMEEnableGroup).parent().removeClass("highlight");
		  $(GPIOPMEConfigurationGroup).parent().removeClass("highlight");
		  $(GPIOPMELengthGroup).parent().removeClass("highlight");
		  $(GPIOPMEPolarityGroup).parent().removeClass("highlight");
		  $(GPIOBufferTypeGroup).parent().removeClass("highlight");
		  $(GPIOPMEWOLSelectGroup).parent().removeClass("highlight");
		  $(PMEMagicPacketEnableGroup).parent().removeClass("highlight");
		  $(PMEPerfectDAEnableGroup).parent().removeClass("highlight");
		  $(PMEWUFFEnableGroup).parent().removeClass("highlight");
    };
})(jQuery);
(function ($) {
    reset_file_input = function () {
        $("input[type='file']").val('');
		$("input[type='file']").css({
						background: "white",
						border: "0px"
						});
    };
})(jQuery);

function enableSaveButton() {
	switchloadsave(changecount);
}