/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license
*/
var stringnullvalue = "NULL STRING - NOT PROGRAMMED YET";
//Widget IDs of String fields in the GUI
var GwidgetlistString = [
	"macaddr",
	"manufacturer",
	"product",
	"serial",
	"configstring",
	"interfacestring"
];

//Widget IDs of Hex fields in the GUI
var GwidgetValuelistHex = [
	"usb2vid",
	"usb2pid",
	"usb2did",
	"eepromconfigflag0",
	"eepromconfigflag1",
	"eepromconfigflag2",
	"eepromconfigflag3",
	"eepromconfigflag4",
	"eepromconfigflag5",
	"langid"
	
];

//Widget IDs of Int fields in the GUI
var GwidgetlistInt = [
	"FSmaxpower",
	"HSmaxpower",
	"SSmaxpower",
	"FSinterruptEPinterval",
	"HSinterruptEPinterval",
	"SSinterruptEPinterval"
];

//Widget IDs of Checkbox fields in the GUI
var GwidgetlistCheckbox = [
	"enremwakeup",
	"enselfpower",
	"enbuspower",
	"LED0Enable",
	"LED1Enable",
	"LED2Enable",
	"LED3Enable"
];

var GwidgetlistDropDown = [
	"LED0Function",
	"LED1Function",
	"LED2Function",
	"LED3Function"
];

var DropDownLEDFunction = [
	"Link/Activity",
	"Link1000/Activity",
	"Link100/Activity",
	"Link10/Activity",
	"Link100/1000/Activity",
	"Link10/1000/Activity",
	"Link10/100/Activity",
	"Reserved",
	"Duplex/Collision",
	"Collision",
	"Activity",
	"Reserved",
	"Auto-Negotiation Fault",
	"Serial Mode",
	"Force LED Off",
	"Force LED On"
];

//Widget IDs of Radio fields in the GUI
var GwidgetlistRadio = [
	"GPIOPMEEnable",
	"GPIOPMEConfiguration",
	"GPIOPMELength",
	"GPIOPMEPolarity",
	"GPIOBufferType",
	"GPIOPMEWOLSelect",
	"PMEMagicPacketEnable",
	"PMEPerfectDAEnable",
	"PMEWUFFEnable"
];

(function ($) {
    set_changed_fields_border_red = function () {

        $("input[type='text']").change(function () {
            // Check input( $( this ).val() ) for validity here
            $(this).css('border-color', 'red');
        });

        $("input[type='number']").change(function () {
            // Check input( $( this ).val() ) for validity here
            $(this).css('border-color', 'red');
        });

        $("input[type='checkbox']").change(function () {
            // Check input( $( this ).val() ) for validity here
            $(this).parent().addClass("highlight");
        });

        $("input[type='radio']").change(function () {
            // Check input( $( this ).val() ) for validity here
            $(this).parent().addClass("highlight");
        });

        $('#xdataaddress').change(function () {
            // dont change color
            $(this).css('border-color', 'LightGray');
        });

        $('#xdatavalue').change(function () {
            // dont change color
            $(this).css('border-color', 'LightGray');
        });

        $(".dropdown li a").click(function () {
            var parent = $(this).closest('div');
            $(parent).css('border-color', 'red');
        });
    };
})(jQuery);

(function ($) {
    reset_fields = function () {
        $("input[type='text']").val('');
        $("input[type='number']").val('');
        $("input[type='checkbox']").removeAttr("checked");
        $("input[type='radio']").removeAttr("checked");
		$("input[type='file']").val('');
		$('textarea#xdatavalue').val(" ");
		
		
	};
})(jQuery);

(function ($) {
    reset_file_input = function () {
        $("input[type='file']").val('');
		$("input[type='file']").css({
						background: "white",
						border: "0px"
						});
		$("#eraseFW").removeAttr("checked");
    };
})(jQuery);

(function ($) {
    disable_fields = function () {
		$("#MAC_Section").attr('disabled', true);
		$("#config_Section").attr('disabled', true);
		$("#DI_Hex_Section").attr('disabled', true);
		$("#DI_String_Section").attr('disabled', true);
		$("#RWPnP_Section").attr('disabled', true);
		$("#IEbI_Section").attr('disabled', true);
		$("#LED0_Section").attr('disabled', true);
		$("#LED1_Section").attr('disabled', true);
		$("#LED2_Section").attr('disabled', true);
		$("#LED3_Section").attr('disabled', true);
		$("#LEDBehavior_Section").attr('disabled', true);
		$("#GPIO0_section").attr('disabled', true);
		$("#GPIO1_section").attr('disabled', true);
		$("#GPIO2_section").attr('disabled', true);
		$("#GPIO3_section").attr('disabled', true);
		$("#GPIO4_section").attr('disabled', true);
		$("#GPIO5_section").attr('disabled', true);
		$("#GPIO6_section").attr('disabled', true);
		$("#GPIO7_section").attr('disabled', true);
		$("#GPIO8_section").attr('disabled', true);
		$("#GPIO9_section").attr('disabled', true);
		$("#GPIO10_section").attr('disabled', true);
		$("#GPIO11_section").attr('disabled', true);
		$("#PM_Section").attr('disabled', true);
		$("#LU_Section").attr('disabled', true);
		$("#MemDump_Section").attr('disabled', true);
    };
})(jQuery);

(function ($) {
    enable_fields = function () {
		$("#MAC_Section").attr('disabled', false);
		$("#config_Section").attr('disabled', false);
		$("#DI_Hex_Section").attr('disabled', false);
		$("#DI_String_Section").attr('disabled', false);
		$("#RWPnP_Section").attr('disabled', false);
		$("#IEbI_Section").attr('disabled', false);
		$("#LED0_Section").attr('disabled', false);
		$("#LED1_Section").attr('disabled', false);
		$("#LED2_Section").attr('disabled', false);
		$("#LED3_Section").attr('disabled', false);
		$("#LEDBehavior_Section").attr('disabled', false);
		$("#GPIO0_section").attr('disabled', false);
		$("#GPIO1_section").attr('disabled', false);
		$("#GPIO2_section").attr('disabled', false);
		$("#GPIO3_section").attr('disabled', false);
		$("#GPIO4_section").attr('disabled', false);
		$("#GPIO5_section").attr('disabled', false);
		$("#GPIO6_section").attr('disabled', false);
		$("#GPIO7_section").attr('disabled', false);
		$("#GPIO8_section").attr('disabled', false);
		$("#GPIO9_section").attr('disabled', false);
		$("#GPIO10_section").attr('disabled', false);
		$("#GPIO11_section").attr('disabled', false);
		$("#PM_Section").attr('disabled', false);
		$("#LU_Section").attr('disabled', false);
		$("#MemDump_Section").attr('disabled', false);
		var nameofcontrol = "input[name= registerTypegroup][value=0]";
		$(nameofcontrol).prop("checked", true);
    };
})(jQuery);


var otpMem ;
var dummyoldval ;
$("#ConfigLocationGroup").change(function () {
	var oldval = get_lan_memory(LAN_ID);
	
	otpMem = oldval.split("_");
	dummyoldval = otpMem[0];
	
	var newval = $("#ConfigLocationGroup").find(':checked').val();
	
	if (dummyoldval == newval) {
		
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#macaddr").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "macaddr");
	var newval = $("#macaddr").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#usb2vid").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "usb2vid"), 10);
	var newval = parseInt($("#usb2vid").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#usb2pid").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "usb2pid"), 10);
	var newval = parseInt($("#usb2pid").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#usb2did").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "usb2did"), 10);
	var newval = parseInt($("#usb2did").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
	}
	
});

$("#langid").change(function () {
	var oldval = parseInt(getLANWidgetValue(LAN_ID, "langid"), 10);
	var newval = parseInt($("#langid").val(), 16);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});
var valTOShow;
var vallength;
var varlength_calc;
var tempvalToShow = "";
//config flag 0
$("#eepromconfigflag0").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag0");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval =  tempvalToShow;
	var newval = $("#eepromconfigflag0").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		
		$(this).css('border-color', 'red');
		
	}
	tempvalToShow = "";
});

//config flag 1
$("#eepromconfigflag1").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag1");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval = tempvalToShow;
	
	var newval = $("#eepromconfigflag1").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	tempvalToShow = "";
});

//config flag 2
$("#eepromconfigflag2").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag2");
	vallength = oldval.length;

	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval = tempvalToShow;
	
	var newval = $("#eepromconfigflag2").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	tempvalToShow = "";
});

//config flag 3
$("#eepromconfigflag3").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag3");
	vallength = oldval.length;
	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval = tempvalToShow;
	
	var newval = $("#eepromconfigflag3").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	tempvalToShow = "";
});

//config flag 4
$("#eepromconfigflag4").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag4");
	vallength = oldval.length;

	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval = tempvalToShow ;
	
	var newval = $("#eepromconfigflag4").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	tempvalToShow = "";
});


//config flag 5
$("#eepromconfigflag5").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "eepromconfigflag5");
	vallength = oldval.length;

	varlength_calc = 8-vallength;
	tempvalToShow = oldval;
	 
	if (varlength_calc > 0) {
		for (var k=varlength_calc; k>0; k--) {
			tempvalToShow = "0" + tempvalToShow;
		}
	} 
	oldval = tempvalToShow;
	
	var newval = $("#eepromconfigflag5").val();
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	tempvalToShow = "";
});

//GwidgetlistHex Ends

//GwidgetlistString Starts
$("#manufacturer").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "manufacturer");
	var newval = $("#manufacturer").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#product").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "product");
	var newval = $("#product").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#serial").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "serial");
	var newval = $("#serial").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#configstring").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "configstring");
	var newval = $("#configstring").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#interfacestring").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "interfacestring");
	var newval = $("#interfacestring").val();
	
	if (oldval == "") {
		oldval = stringnullvalue;
	}

	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
	
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});
//GwidgetlistString Ends

//GwidgetlistInt Starts
$("#HSmaxpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "HSmaxpower");
	oldval = parseInt(oldval,10) * 2;
	var newval = parseInt($("#HSmaxpower").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#FSmaxpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "FSmaxpower");
	oldval = parseInt(oldval,10);
	var newval = parseInt($("#FSmaxpower").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#SSmaxpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "SSmaxpower");
	oldval = parseInt(oldval,10) * 2;
	var newval = parseInt($("#SSmaxpower").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#FSinterruptEPinterval").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "FSinterruptEPinterval");
	oldval = parseInt(oldval,10);
	var newval = parseInt($("#FSinterruptEPinterval").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#HSinterruptEPinterval").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "HSinterruptEPinterval");
	oldval = parseInt(oldval,10) * 8;
	var newval = parseInt($("#HSinterruptEPinterval").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});

$("#SSinterruptEPinterval").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "SSinterruptEPinterval");
	oldval = parseInt(oldval,10) * 8;
	var newval = parseInt($("#SSinterruptEPinterval").val(), 10);
	
	if (oldval == newval) {
		$(this).css('border-color', 'LightGray');
		
		
	} else {
		$(this).css('border-color', 'red');
		
	}
	
});
//GwidgetlistInt Ends

//GwidgetlistCheckbox Starts
$("#enremwakeup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "enremwakeup");
	var newval = checkbox_unchecked_value;
	if($("#enremwakeup").is(':checked'))
	{
		newval = checkbox_checked_value;
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#enbuspower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "enbuspower");
	var newval = checkbox_unchecked_value;
	if($("#enbuspower").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#enselfpower").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "enselfpower");
	var newval = checkbox_unchecked_value;
	if($("#enselfpower").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});


$("#LED0Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED0Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED0Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#LED1Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED1Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED1Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#LED2Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED2Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED2Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#LED3Enable").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "LED3Enable");
	var newval = checkbox_unchecked_value;
	if($("#LED3Enable").is(':checked'))
	{
		newval = checkbox_checked_value;
	}
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
	
});

/////////Polarity///////
//GwidgetlistCheckbox Ends

//GwidgetlistRadio Starts
$("#gpio0EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#gpio0EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO0_WUSection").attr('disabled', true);
		$("#GPIO0_WUPSection").attr('disabled', true);
		$("#GPIO0_set").attr('disabled', true);
		
		$("#GPIO0_WUSection").hide();
		$("#GPIO0_WUPSection").hide();
		$("#GPIO0_set").hide();
	} else {
		$("#GPIO0_WUSection").show();
		$("#GPIO0_WUPSection").show();
		$("#GPIO0_set").show();

		$("#GPIO0_WUSection").removeAttr('disabled', false);
		$("#GPIO0_WUPSection").removeAttr('disabled', false);
		$("#GPIO0_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#gpio1EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#gpio1EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO1_WUSection").attr('disabled', true);
		$("#GPIO1_WUPSection").attr('disabled', true);
		$("#GPIO1_set").attr('disabled', true);
		
		$("#GPIO1_WUSection").hide();
		$("#GPIO1_WUPSection").hide();
		$("#GPIO1_set").hide();
	} else {
		$("#GPIO1_WUSection").show();
		$("#GPIO1_WUPSection").show();
		$("#GPIO1_set").show();

		$("#GPIO1_WUSection").removeAttr('disabled', false);
		$("#GPIO1_WUPSection").removeAttr('disabled', false);
		$("#GPIO1_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio2EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#gpio2EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO2_WUSection").attr('disabled', true);
		$("#GPIO2_WUPSection").attr('disabled', true);
		$("#GPIO2_set").attr('disabled', true);
		
		$("#GPIO2_WUSection").hide();
		$("#GPIO2_WUPSection").hide();
		$("#GPIO2_set").hide();
	} else {
		$("#GPIO2_WUSection").show();
		$("#GPIO2_WUPSection").show();
		$("#GPIO2_set").show();

		$("#GPIO2_WUSection").removeAttr('disabled', false);
		$("#GPIO2_WUPSection").removeAttr('disabled', false);
		$("#GPIO2_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio3EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#gpio3EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO3_WUSection").attr('disabled', true);
		$("#GPIO3_WUPSection").attr('disabled', true);
		$("#GPIO3_set").attr('disabled', true);
		
		$("#GPIO3_WUSection").hide();
		$("#GPIO3_WUPSection").hide();
		$("#GPIO3_set").hide();
	} else {
		$("#GPIO3_WUSection").show();
		$("#GPIO3_WUPSection").show();
		$("#GPIO3_set").show();

		$("#GPIO3_WUSection").removeAttr('disabled', false);
		$("#GPIO3_WUPSection").removeAttr('disabled', false);
		$("#GPIO3_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio4EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#gpio4EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO4_WUSection").attr('disabled', true);
		$("#GPIO4_WUPSection").attr('disabled', true);
		$("#GPIO4_set").attr('disabled', true);
		
		$("#GPIO4_WUSection").hide();
		$("#GPIO4_WUPSection").hide();
		$("#GPIO4_set").hide();
	} else {
		$("#GPIO4_WUSection").show();
		$("#GPIO4_WUPSection").show();
		$("#GPIO4_set").show();

		$("#GPIO4_WUSection").removeAttr('disabled', false);
		$("#GPIO4_WUPSection").removeAttr('disabled', false);
		$("#GPIO4_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio5EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#gpio5EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO5_WUSection").attr('disabled', true);
		$("#GPIO5_WUPSection").attr('disabled', true);
		$("#GPIO5_set").attr('disabled', true);
		
		$("#GPIO5_WUSection").hide();
		$("#GPIO5_WUPSection").hide();
		$("#GPIO5_set").hide();
	} else {
		$("#GPIO5_WUSection").show();
		$("#GPIO5_WUPSection").show();
		$("#GPIO5_set").show();

		$("#GPIO5_WUSection").removeAttr('disabled', false);
		$("#GPIO5_WUPSection").removeAttr('disabled', false);
		$("#GPIO5_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio6EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#gpio6EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO6_WUSection").attr('disabled', true);
		$("#GPIO6_WUPSection").attr('disabled', true);
		$("#GPIO6_set").attr('disabled', true);
		
		$("#GPIO6_WUSection").hide();
		$("#GPIO6_WUPSection").hide();
		$("#GPIO6_set").hide();
	} else {
		$("#GPIO6_WUSection").show();
		$("#GPIO6_WUPSection").show();
		$("#GPIO6_set").show();

		$("#GPIO6_WUSection").removeAttr('disabled', false);
		$("#GPIO6_WUPSection").removeAttr('disabled', false);
		$("#GPIO6_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio7EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#gpio7EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO7_WUSection").attr('disabled', true);
		$("#GPIO7_WUPSection").attr('disabled', true);
		$("#GPIO7_set").attr('disabled', true);
		
		$("#GPIO7_WUSection").hide();
		$("#GPIO7_WUPSection").hide();
		$("#GPIO7_set").hide();
	} else {
		$("#GPIO7_WUSection").show();
		$("#GPIO7_WUPSection").show();
		$("#GPIO7_set").show();

		$("#GPIO7_WUSection").removeAttr('disabled', false);
		$("#GPIO7_WUPSection").removeAttr('disabled', false);
		$("#GPIO7_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio8EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#gpio8EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO8_WUSection").attr('disabled', true);
		$("#GPIO8_WUPSection").attr('disabled', true);
		$("#GPIO8_set").attr('disabled', true);
		
		$("#GPIO8_WUSection").hide();
		$("#GPIO8_WUPSection").hide();
		$("#GPIO8_set").hide();
	} else {
		$("#GPIO8_WUSection").show();
		$("#GPIO8_WUPSection").show();
		$("#GPIO8_set").show();

		$("#GPIO8_WUSection").removeAttr('disabled', false);
		$("#GPIO8_WUPSection").removeAttr('disabled', false);
		$("#GPIO8_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio9EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#gpio9EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO9_WUSection").attr('disabled', true);
		$("#GPIO9_WUPSection").attr('disabled', true);
		$("#GPIO9_set").attr('disabled', true);
		
		$("#GPIO9_WUSection").hide();
		$("#GPIO9_WUPSection").hide();
		$("#GPIO9_set").hide();
	} else {
		$("#GPIO9_WUSection").show();
		$("#GPIO9_WUPSection").show();
		$("#GPIO9_set").show();

		$("#GPIO9_WUSection").removeAttr('disabled', false);
		$("#GPIO9_WUPSection").removeAttr('disabled', false);
		$("#GPIO9_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio10EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#gpio10EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO10_WUSection").attr('disabled', true);
		$("#GPIO10_WUPSection").attr('disabled', true);
		$("#GPIO10_set").attr('disabled', true);
		
		$("#GPIO10_WUSection").hide();
		$("#GPIO10_WUPSection").hide();
		$("#GPIO10_set").hide();
	} else {
		$("#GPIO10_WUSection").show();
		$("#GPIO10_WUPSection").show();
		$("#GPIO10_set").show();

		$("#GPIO10_WUSection").removeAttr('disabled', false);
		$("#GPIO10_WUPSection").removeAttr('disabled', false);
		$("#GPIO10_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio11EnableGroup").change(function () {
	var gpio_enableVal = getLANWidgetValue(LAN_ID, "GPIOEnable");
	var oldval = 0;
	if ((gpio_enableVal & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#gpio11EnableGroup").find(':checked').val();
	
	if (newval == 1) {
		$("#GPIO11_WUSection").attr('disabled', true);
		$("#GPIO11_WUPSection").attr('disabled', true);
		$("#GPIO11_set").attr('disabled', true);
		
		$("#GPIO11_WUSection").hide();
		$("#GPIO11_WUPSection").hide();
		$("#GPIO11_set").hide();
	} else {
		$("#GPIO11_WUSection").show();
		$("#GPIO11_WUPSection").show();
		$("#GPIO11_set").show();

		$("#GPIO11_WUSection").removeAttr('disabled', false);
		$("#GPIO11_WUPSection").removeAttr('disabled', false);
		$("#GPIO11_set").removeAttr('disabled', false);
	}

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

/////GPIO Enable//////
$("#gpio0BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#gpio0BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio1BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#gpio1BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio2BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#gpio2BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio3BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#gpio3BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio4BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#gpio4BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio5BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#gpio5BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio6BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#gpio6BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio7BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#gpio7BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio8BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#gpio8BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio9BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#gpio9BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio10BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#gpio10BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio11BufferGroup").change(function () {
	var gpio_bufferVal = getLANWidgetValue(LAN_ID, "GPIOBuffer");
	var oldval = 0;
	if ((gpio_bufferVal & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#gpio11BufferGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

///// GPIO Buffer ///////
$("#gpio0DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#gpio0DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio0DataSection").hide();
	} else if (newval == 1) {
		$("#gpio0DataSection").show();
	} else {
		//Do nothing
	}
	
});

$("#gpio1DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#gpio1DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio1DataSection").hide();
	} else if (newval == 1) {
		$("#gpio1DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio2DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#gpio2DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio2DataSection").hide();
	} else if (newval == 1) {
		$("#gpio2DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio3DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#gpio3DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		

	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio3DataSection").hide();
	} else if (newval == 1) {
		$("#gpio3DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio4DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#gpio4DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio4DataSection").hide();
	} else if (newval == 1) {
		$("#gpio4DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio5DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#gpio5DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio5DataSection").hide();
	} else if (newval == 1) {
		$("#gpio5DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio6DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#gpio6DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio6DataSection").hide();
	} else if (newval == 1) {
		$("#gpio6DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio7DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#gpio7DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio7DataSection").hide();
	} else if (newval == 1) {
		$("#gpio7DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio8DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#gpio8DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio8DataSection").hide();
	} else if (newval == 1) {
		$("#gpio8DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio9DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#gpio9DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio9DataSection").hide();
	} else if (newval == 1) {
		$("#gpio9DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio10DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#gpio10DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio10DataSection").hide();
	} else if (newval == 1) {
		$("#gpio10DataSection").show();
	} else {
		//Do nothing
	}
});

$("#gpio11DirectionGroup").change(function () {
	var gpio_directionVal = getLANWidgetValue(LAN_ID, "GPIODirection");
	var oldval = 0;
	if ((gpio_directionVal & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#gpio11DirectionGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
	if (newval == 0) {
		$("#gpio11DataSection").hide();
	} else if (newval == 1) {
		$("#gpio11DataSection").show();
	} else {
		//Do nothing
	}
});
////// GPIO Direction //////
$("#gpio0DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 1) == 1) {
		oldval = 0;
	}
	
	var newval = $("#gpio0DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio1DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 2) == 2) {
		oldval = 0;
	}
	
	var newval = $("#gpio1DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio2DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 4) == 4) {
		oldval = 0;
	}
	
	var newval = $("#gpio2DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio3DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 8) == 8) {
		oldval = 0;
	}
	
	var newval = $("#gpio3DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio4DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 16) == 16) {
		oldval = 0;
	}
	
	var newval = $("#gpio4DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio5DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 32) == 32) {
		oldval = 0;
	}
	
	var newval = $("#gpio5DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio6DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 64) == 64) {
		oldval = 0;
	}
	
	var newval = $("#gpio6DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio7DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 128) == 128) {
		oldval = 0;
	}
	
	var newval = $("#gpio7DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio8DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 256) == 256) {
		oldval = 0;
	}
	
	var newval = $("#gpio8DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio9DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 512) == 512) {
		oldval = 0;
	}
	
	var newval = $("#gpio9DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio10DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 1024) == 1024) {
		oldval = 0;
	}
	
	var newval = $("#gpio10DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#gpio11DataGroup").change(function () {
	var gpio_dataVal = getLANWidgetValue(LAN_ID, "GPIOData");
	var oldval = 1;
	if ((gpio_dataVal & 2048) == 2048) {
		oldval = 0;
	}
	
	var newval = $("#gpio11DataGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

// GPIO Wake Up Starts
$("#WUgpio0Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio0Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio1Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio1Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio2Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio2Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio3Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio3Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio4Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio4Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio5Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio5Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio6Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio6Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio7Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio7Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio8Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio8Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio9Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio9Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio10Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio10Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUgpio11Group").change(function () {
	var gpio_wakeup = getLANWidgetValue(LAN_ID, "GPIOWake");
	var oldval = 0;
	if ((gpio_wakeup & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#WUgpio11Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});
// GPIO Wake Up Ends

// GPIO Wake Up Polarity Starts
$("#WUPgpio0Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio0Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio1Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio1Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio2Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio2Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio3Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio3Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio4Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 16) == 16) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio4Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio5Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio5Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio6Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio6Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio7Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio7Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio8Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 256) == 256) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio8Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio9Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 512) == 512) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio9Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio10Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 1024) == 1024) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio10Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#WUPgpio11Group").change(function () {
	var gpio_wakeupPolarity = getLANWidgetValue(LAN_ID, "GPIOWakePolarity");
	var oldval = 0;
	if ((gpio_wakeupPolarity & 2048) == 2048) {
		oldval = 1;
	}
	
	var newval = $("#WUPgpio11Group").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});
// GPIO Wake Up Polarity Ends

$("#GPIOPMEEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEEnable");
	var newval = $("#GPIOPMEEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#GPIOPMEConfigurationGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEConfiguration");
	var newval = $("#GPIOPMEConfigurationGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#GPIOPMELengthGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMELength");
	var newval = $("#GPIOPMELengthGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#GPIOPMEPolarityGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEPolarity");
	var newval = $("#GPIOPMEPolarityGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#GPIOBufferTypeGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOBufferType");
	var newval = $("#GPIOBufferTypeGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#GPIOPMEWOLSelectGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "GPIOPMEWOLSelect");
	var newval = $("#GPIOPMEWOLSelectGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#PMEMagicPacketEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "PMEMagicPacketEnable");
	var newval = $("#PMEMagicPacketEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#PMEPerfectDAEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "PMEPerfectDAEnable");
	var newval = $("#PMEPerfectDAEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#PMEWUFFEnableGroup").change(function () {
	var oldval = getLANWidgetValue(LAN_ID, "PMEWUFFEnable");
	var newval = $("#PMEWUFFEnableGroup").find(':checked').val();

	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
		
	} else {
		$(this).parent().addClass("highlight");
		
	}
	
});

$("#LED0CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#LED0CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED1CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 2) == 2) {
		oldval = 1;
	}
	
	var newval = $("#LED1CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED2CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 4) == 4) {
		oldval = 1;
	}
	
	var newval = $("#LED2CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED3CombineEnableGroup").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 8) == 8) {
		oldval = 1;
	}
	
	var newval = $("#LED3CombineEnableGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED0Group").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 32) == 32) {
		oldval = 1;
	}
	
	var newval = $("#LED0Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED1Group").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 64) == 64) {
		oldval = 1;
	}
	
	var newval = $("#LED1Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED2Group").change(function () {
	var led1_behaviour = getLANWidgetValue(LAN_ID, "LED1Behavior");
	var oldval = 0;
	if ((led1_behaviour & 128) == 128) {
		oldval = 1;
	}
	
	var newval = $("#LED2Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LED3Group").change(function () {
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	var oldval = 0;
	if ((led2_behaviour & 1) == 1) {
		oldval = 1;
	}
	
	var newval = $("#LED3Group").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

$("#LEDRateGroup").change(function () {
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");
	var oldval;
	
	if ((led2_behaviour & 12) == 12) {
		oldval = 3;
	} 
	else if((led2_behaviour & 0x8) == 0x8){
		oldval = 2;
	}
	else if((led2_behaviour & 0x4) == 0x4){
		oldval = 1;
	}
	else if((led2_behaviour & 0) == 0){
		oldval = 0;
	}
		
	var newval = $("#LEDRateGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});


$("#LEDPulsingGroup").change(function () {
	var led2_behaviour = getLANWidgetValue(LAN_ID, "LED2Behavior");

	var oldval = 0;
	if ((led2_behaviour & 0x10) == 0x10) {
		oldval = 1;
	}
	
	var newval = $("#LEDPulsingGroup").find(':checked').val();
	
	if (oldval == newval) {
		$(this).parent().removeClass("highlight");
	} else {
		$(this).parent().addClass("highlight");
	}
});

///////Dropdown part/////
$('#LED0FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED0Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
		
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
		
	}
	
});

$('#LED1FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED1Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
	}
	
});

$('#LED2FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED2Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
	}
	
});

$('#LED3FunctionUL li').on('click', function(){
	var oldval = DropDownLEDFunction[getLANWidgetValue(LAN_ID, "LED3Function")];
	var newval =$(this).text();
	if(oldval == newval)
	{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'transparent');
	}
	else{
		var parent = $(this).closest('div');
        $(parent).css('border-color', 'red');
	}
	
});

(function ($) {
    set_changed_fields_border_default = function () {
        $("input[type='text']").each(function() {
            $(this).css('border-color', 'LightGray');
        });

        $("input[type='number']").each(function() {
            $(this).css('border-color', 'LightGray');
        });

        $("input[type='checkbox']").each(function() {
            $(this).parent().removeClass("highlight");
        });

        $("input[type='radio']").each(function() {
            $(this).parent().removeClass("highlight");
        });
		
		$(ConfigLocationGroup).parent().removeClass("highlight");
		
		var wid;
		//GPIO Enable for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "EnableGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Buffer for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "BufferGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Direction for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "DirectionGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Data for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#gpio" + i + "DataGroup";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Wake up for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#WUgpio" + i + "Group";
			$(wid).parent().removeClass("highlight");
		}
		
		//GPIO Wake up Polarity for 12 GPIOs
		for (var i = 0; i <= 11; i++) {
			wid = "#WUPgpio" + i + "Group";
			$(wid).parent().removeClass("highlight");
		}

		//LEDCombineEnableGroup
		for (var i = 0; i <= 3; i++) {
			wid = "#LED" + i + "CombineEnableGroup";
			$(wid).parent().removeClass("highlight");
		}	
		
		//LEDGroup
		for (var i = 0; i <= 3; i++) {
			wid = "#LED" + i + "Group";
			$(wid).parent().removeClass("highlight");
		}
		
		//LEDRate
		wid = "#LEDRate" + "Group";
		$(wid).parent().removeClass("highlight");
		
		//LEDRate
		wid = "#LEDPulsing" + "Group";
		$(wid).parent().removeClass("highlight");
		
        $(".dropdown li a").each(function () {
            var parent = $(this).closest('div');
            $(parent).css('border-color', 'transparent');
        });
		
		  $(GPIOPMEEnableGroup).parent().removeClass("highlight");
		  $(GPIOPMEConfigurationGroup).parent().removeClass("highlight");
		  $(GPIOPMELengthGroup).parent().removeClass("highlight");
		  $(GPIOPMEPolarityGroup).parent().removeClass("highlight");
		  $(GPIOBufferTypeGroup).parent().removeClass("highlight");
		  $(GPIOPMEWOLSelectGroup).parent().removeClass("highlight");
		  $(PMEMagicPacketEnableGroup).parent().removeClass("highlight");
		  $(PMEPerfectDAEnableGroup).parent().removeClass("highlight");
		  $(PMEWUFFEnableGroup).parent().removeClass("highlight");
    };
})(jQuery);
(function ($) {
    reset_file_input = function () {
        $("input[type='file']").val('');
		$("input[type='file']").css({
						background: "white",
						border: "0px"
						});
    };
})(jQuery);
