/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license
*/
//Variables to know which page has been selected: USB2.0 or USB3.1 Gen1
var Product = getProduct();
var ConfigType = getConfigType();
var portsAvailable = 0;
var hubCount;
var incval;
var hub_list;
var hceenablemanu = false;
var hceenableprod = false;
var hceenableser = false;
var enablealertmanu = false;
var enablealertprod = false;
var enablealertser = false;

// Widget ID of hex fields in the GUI
var GwidgetlistHex = [
"vid",
"pid",
"did",
"usbvcd",
"languageid",
"hce_vid",
"hce_pid",
"hce_did",
"hce_languageid",
// USB3 related
"usb3vid",
"usb3pid",
"usb3did",
"usb3vcd",
"usb3languageid"
];

//Mapping widgets to the meaningful elaborations to print while in error
var Mapping = {
//Hex
"vid": "USB2.0 Vendor ID",
"pid": "USB2.0 Product ID",
"did": "USB2.0 Device ID",
"usbvcd": "USB2.0 Version",
"languageid": "USB2.0 Language ID",
"manufacturer": "USB2.0 Manufacturer",
"manufacturerlen" :"USB2.0 Manufacturer Length",
"product" : "USB2.0 Product",
"productlen" : "USB2.0 Product Length",
"serial": "USB2.0 Serial",
"seriallen" : "USB2.0 Serial Length",
"usb3vid": "USB3.1 Gen1 Vendor ID",
"usb3pid": "USB3.1 Gen1 Product ID",
"usb3did": "USB3.1 Gen1 Device ID",
"usb3vcd": "USB3.1 Gen1 Version",
"usb3languageid": "USB3.1 Gen1 Language ID",
"usb3manufacturer": "USB3.1 Gen1 Manufacturer",
"usb3product":"USB3.1 Gen1 Product",
"usb3serial":"USB3.1 Gen1 Serial",
"usb3uuid":"Universal unique ID",
"numberofports":"Number of Enabled USB2.0 ports",
"usb3numberofports":"Number of Enabled USB3.1 Gen1 ports",
"port5splitting":"Port 5 Port Splitting",
"port6splitting":"Port 6 Port Splitting",
"prtpwr5usb3split":"USB3 Port Power for Port 5",
"prtpwr6usb3split":"USB3 Port Power for Port 6",
"pstimeout":"USB3 Port Split Link TimeOut",
"enableport1":"USB2.0 Port1 Enable/Disable State",
"enableport2":"USB2.0 Port2 Enable/Disable State",
"enableport3":"USB2.0 Port3 Enable/Disable State",
"enableport4":"USB2.0 Port4 Enable/Disable State",
"enableport5":"USB2.0 Port5 Enable/Disable State",
"enableport6":"USB2.0 Port6 Enable/Disable State",
"enableport7":"USB2.0 Port7 Enable/Disable State",
"port1mapping":"USB2.0 Port1 Logical mapping",
"port2mapping":"USB2.0 Port2 Logical mapping",
"port3mapping":"USB2.0 Port3 Logical mapping",
"port4mapping":"USB2.0 Port4 Logical mapping",
"port5mapping":"USB2.0 Port5 Logical mapping",
"port6mapping":"USB2.0 Port6 Logical mapping",
"port7mapping":"USB2.0 Port7 Logical mapping",
"nrdeviceport1":"USB2.0 Port1 Non-removable State",
"nrdeviceport2":"USB2.0 Port2 Non-removable State",
"nrdeviceport3":"USB2.0 Port3 Non-removable State",
"nrdeviceport4":"USB2.0 Port4 Non-removable State",
"nrdeviceport5":"USB2.0 Port5 Non-removable State",
"nrdeviceport6":"USB2.0 Port6 Non-removable State",
"nrdeviceport7":"USB2.0 Port7 Non-removable State",
"usb3enableport1":"USB3.1 Gen 1 Port1 Enable/Disable State",
"usb3enableport2":"USB3.1 Gen 1 Port2 Enable/Disable State",
"usb3enableport3":"USB3.1 Gen 1 Port3 Enable/Disable State",
"usb3enableport4":"USB3.1 Gen 1 Port4 Enable/Disable State",
"usb3enableport5":"USB3.1 Gen 1 Port5 Enable/Disable State",
"usb3enableport6":"USB3.1 Gen 1 Port6 Enable/Disable State",
"usb3enableport7":"USB3.1 Gen 1 Port7 Enable/Disable State",
"usb3port1mapping":"USB3.1 Gen 1 Port1 Logical mapping",
"usb3port2mapping":"USB3.1 Gen 1 Port2 Logical mapping",
"usb3port3mapping":"USB3.1 Gen 1 Port3 Logical mapping",
"usb3port4mapping":"USB3.1 Gen 1 Port4 Logical mapping",
"usb3port5mapping":"USB3.1 Gen 1 Port5 Logical mapping",
"usb3port6mapping":"USB3.1 Gen 1 Port6 Logical mapping",
"usb3port7mapping":"USB3.1 Gen 1 Port7 Logical mapping",
"usb3nrdeviceport1":"USB3.1 Gen 1 Port1 Non-removable State",
"usb3nrdeviceport2":"USB3.1 Gen 1 Port2 Non-removable State",
"usb3nrdeviceport3":"USB3.1 Gen 1 Port3 Non-removable State",
"usb3nrdeviceport4":"USB3.1 Gen 1 Port4 Non-removable State",
"usb3nrdeviceport5":"USB3.1 Gen 1 Port5 Non-removable State",
"usb3nrdeviceport6":"USB3.1 Gen 1 Port6 Non-removable State",
"usb3nrdeviceport7":"USB3.1 Gen 1 Port7 Non-removable State",
"downstreamBCsettingport1":"Port1 Battery charging State",
"downstreamBCsettingport2":"Port2 Battery charging State",
"downstreamBCsettingport3":"Port3 Battery charging State",
"downstreamBCsettingport4":"Port4 Battery charging State",
"downstreamBCsettingport5":"Port5 Battery charging State",
"downstreamBCsettingport6":"Port6 Battery charging State",
"downstreamBCsettingport7":"Port7 Battery charging State",
"swapport1dpdm":"Port1:Swap D+/D-",
"swapport2dpdm":"Port2:Swap D+/D-",
"swapport3dpdm":"Port3:Swap D+/D-",
"swapport4dpdm":"Port4:Swap D+/D-",
"swapport5dpdm":"Port5:Swap D+/D-",
"swapport6dpdm":"Port6:Swap D+/D-",
"swapport7dpdm":"Port7:Swap D+/D-",
"swapupstreamdpdm":"Upstream Port:Swap D+/D-",
"PHYBOOSTdownstreamport1":"Port1:PHYBOOST",
"PHYBOOSTdownstreamport2":"Port2:PHYBOOST",
"PHYBOOSTdownstreamport3":"Port3:PHYBOOST",
"PHYBOOSTdownstreamport4":"Port4:PHYBOOST",
"PHYBOOSTdownstreamport5":"Port5:PHYBOOST",
"PHYBOOSTdownstreamport6":"Port6:PHYBOOST",
"PHYBOOSTdownstreamport7":"Port7:PHYBOOST",
"PHYBOOST":"Upstream Port:PHYBOOST",
"SQUELCHdownstreamport1":"Port1:Varisense",
"SQUELCHdownstreamport2":"Port2:Varisense",
"SQUELCHdownstreamport3":"Port3:Varisense",
"SQUELCHdownstreamport4":"Port4:Varisense",
"SQUELCHdownstreamport5":"Port5:Varisense",
"SQUELCHdownstreamport6":"Port6:Varisense",
"SQUELCHdownstreamport7":"Port7:Varisense",
"SQUELCH":"Upstream Port:Varisense",
"upstreamHsRiseFall":"Upstream High Speed rise/fall adjust",
"downstreamport1HsRiseFall":"Port1:High Speed rise/fall adjust",
"downstreamport2HsRiseFall":"Port2:High Speed rise/fall adjust",
"downstreamport3HsRiseFall":"Port3:High Speed rise/fall adjust",
"downstreamport4HsRiseFall":"Port4:High Speed rise/fall adjust",
"downstreamport5HsRiseFall":"Port5:High Speed rise/fall adjust",
"downstreamport6HsRiseFall":"Port6:High Speed rise/fall adjust",
"downstreamport7HsRiseFall":"Port7:High Speed rise/fall adjust",
"flexconnect":"Flexconnect",
"hceenable":"Hub Controller State",
"hce_vid": "HFC Vendor ID",
"hce_pid": "HFC Product ID",
"hce_did": "HFC Device ID",
"hce_languageid": "HFC Language ID",
"hce_manufacturer":"HFC Manufacturer",
"hce_manufacturerlen":"HFC Manufacturer Length",
"hce_product":"HFC Product",
"hce_productlen":"HFC Product Length",
"hce_serial":"HFC Serial",
"hce_seriallen":"HFC Serial Length",
"hubpower":"Hub Power",
"maxpowerself":"USB2.0 Hub Max Power(Self)",
"hubcmaxpowerself":"Hub Circuit Max Power (Self)",
"maxpowerbus":"USB2.0 Hub Max Power (Bus)",
"hubcmaxpowerbus":"Hub Circuit Max Power (Bus)",
"hub3maxpowerselfbus":"USB3.1 Gen1 Max Power",
"suspendindication":"Suspendindication",
"hsdisable":"Hub Full Speed Mode",
"lpmenable":"LPM State",
"xdataentry":"Direct Register Access",
"xdataprogram":"ini File"
};

// Widget ID of string fields in the GUI
var GwidgetlistString = [
"manufacturer", 
"product",
"serial",
"hce_manufacturer",
"hce_product",
"hce_serial",
// USB3 related
"usb3manufacturer",
"usb3product",
"usb3serial",
"usb3uuid"
];

// Widget ID of decimal fields in the GUI
var GwidgetlistInt = [
"maxpowerself",
"hubcmaxpowerself",
"maxpowerbus",
"hubcmaxpowerbus",
"hub3maxpowerselfbus"
];

// Widgets that are checkboxes in GUI
var GwidgetlistCheckbox = [
"flexconnect",
"hsdisable",
"LoadFlxCfgArea",
"hceenable",
"lpmenable",
"swapupstreamdpdm",
"swapport1dpdm",
"swapport2dpdm",
"swapport3dpdm",
"swapport4dpdm",
"swapport5dpdm",
"swapport6dpdm",
"swapport7dpdm",
"enableport1",
"enableport2",
"enableport3",
"enableport4",
"enableport5",
"enableport6",
"enableport7",
"nrdeviceport1",
"nrdeviceport2",
"nrdeviceport3",
"nrdeviceport4",
"nrdeviceport5",
"nrdeviceport6",
"nrdeviceport7",
"usb3enableport1",
"usb3enableport2",
"usb3enableport3",
"usb3enableport4",
"usb3enableport5",
"usb3enableport6",
"usb3enableport7",
"usb3nrdeviceport7",
"usb3nrdeviceport6",
"usb3nrdeviceport5",
"usb3nrdeviceport4",
"usb3nrdeviceport3",
"usb3nrdeviceport2",
"usb3nrdeviceport1"
];

// Widgets that are radio buttons in GUI
var GwidgetlistRadio = [
"hubpower",
"suspendindication",
"downstreamBCsettingport1",
"downstreamBCsettingport2",
"downstreamBCsettingport3",
"downstreamBCsettingport4",
"downstreamBCsettingport5",
"downstreamBCsettingport6",
"downstreamBCsettingport7",
"port5splitting",
"port6splitting",
"pstimeout"
];

// Widgets that are used for populating the GUI and would not be used in set_wdigets_values
var GwidgetlistGUI = [
"noofdownstreamports",
"upstreamport_HSIC_USB",
"isdynamicpinavailable",
"istrefdrefavailable",
"downstreamport1_HSIC_USB",
"downstreamport2_HSIC_USB",
"downstreamport3_HSIC_USB",
"downstreamport4_HSIC_USB"
];

// Widgets that are Drop Down in GUI
var GwidgetlistDropDown = [
"PHYBOOST",
"SQUELCH",
"upstreamHsRiseFall",
"PHYBOOSTdownstreamport1",
"SQUELCHdownstreamport1",
"downstreamport1HsRiseFall",
"PHYBOOSTdownstreamport2",
"SQUELCHdownstreamport2",
"downstreamport2HsRiseFall",
"PHYBOOSTdownstreamport3",
"SQUELCHdownstreamport3",
"downstreamport3HsRiseFall",
"PHYBOOSTdownstreamport4",
"SQUELCHdownstreamport4",
"downstreamport4HsRiseFall",
"PHYBOOSTdownstreamport5",
"SQUELCHdownstreamport5",
"downstreamport5HsRiseFall",
"PHYBOOSTdownstreamport6",
"SQUELCHdownstreamport6",
"downstreamport6HsRiseFall",
"PHYBOOSTdownstreamport7",
"SQUELCHdownstreamport7",
"downstreamport7HsRiseFall",
"port1mapping",
"port2mapping",
"port3mapping",
"port4mapping",
"port5mapping",
"port6mapping",
"port7mapping",
"usb3port1mapping",
"usb3port2mapping",
"usb3port3mapping",
"usb3port4mapping",
"usb3port5mapping",
"usb3port6mapping",
"usb3port7mapping"
];

// Lookup for dropdown value selection
var DropDownDREF = [
"REFSEL0=0,REFSEL1=0 =>38.4Mhz",
"REFSEL0=1,REFSEL1=0 =>26Mhz",
"REFSEL0=0,REFSEL1=1 =>19.2Mhz",
"REFSEL0=1,REFSEL1=1 =>12Mhz"
];

// Lookup for tref dropdown value selection
var DropDownTREF = [
"12Mhz",
"13Mhz",
"19.2Mhz",
"24Mhz",
"25Mhz",
"26Mhz",
"27Mhz",
"38.4Mhz",
"50Mhz",
"52Mhz"
];

// Lookup for phyboost dropdown value selection
var DropDownPHYBOOST = [
"Nominal 17.78 mA",
"5% below nominal",
"10% above nominal",
"5% above nominal",
"20% above nominal",
"15% above nominal",
"30% above nominal",
"25% above nominal",
];

// Lookup for squelch dropdown value selection
var DropDownSQUELCH = [
"Nominal 100mV",
"12.5mV below nominal",
"25mV below nominal",
"37.5mV below nominal",
"50mV below nominal",
"62.5mV below nominal",
"25mV above nominal",
"12.5mV above nominal",
];
// Lookup for High Speed rise/fall adjust selection
var DropDownHSRiseFall =[
"Default",
"+18%",
"-18%",
"-12%"
];
// Lookup for squelch dropdown value selection
var DropDownDOI = [
"40 ohm",
"50 ohm"
];

// Lookup for squelch dropdown value selection
var DropDownSLEW = [
"Default",
"+30%"
];

// Lookup for port mapping selection
var DropDownPORTMAPPING = [
"Disabled", // Just to cover up Index 0 as the actual port mapping start with 1
"Map to Logical Port1",
"Map to Logical Port2",
"Map to Logical Port3",
"Map to Logical Port4",
"Map to Logical Port5",
"Map to Logical Port6",
"Map to Logical Port7"
];

//Set these flags if they are modified by user
var nr1UserModified = false;
var nr2UserModified = false;
var nr3UserModified = false;
var nr4UserModified = false;
var nr5UserModified = false;
var nr6UserModified = false;
var nr7UserModified = false;

//Set these flags if they are modified by user
var usb3nr1UserModified = false;
var usb3nr2UserModified = false;
var usb3nr3UserModified = false;
var usb3nr4UserModified = false;
var usb3nr5UserModified = false;
var usb3nr6UserModified = false;
var usb3nr7UserModified = false;

// values returned if a value is 1 from the backend
var checkbox_checked_value = "1";
var checkbox_unchecked_value = "0";

var stringnullvalue = "NULL STRING - NOT PROGRAMMED YET";

var HUB_ID = "";
var enableApplyButton = false;
var enableFlex = false;
var disableFlex = false;
var hubsFound = false;
var enable_swapupstreamdpdm = false;
var enable_lpm = false;

var CurrentflexLiveValue = -1;
var vid_pidModified = false;
var errorCode;
var CurrenthubProgrammed = "";
var percentage =0;

//Set this variable when Non-removable parameter of a hub is modified
var nrModified = false;
var nr1Modified = false;
var nr2Modified = false;
var nr3Modified = false;
var nr4Modified = false;
var nr5Modified = false;
var nr6Modified = false;
var nr7Modified = false;

var usb3nrModified = false;
var usb3nr1Modified = false;
var usb3nr2Modified = false;
var usb3nr3Modified = false;
var usb3nr4Modified = false;
var usb3nr5Modified = false;
var usb3nr6Modified = false;
var usb3nr7Modified = false;

//Set these flags if they are modified by user
var nr1UserModified = false;
var nr2UserModified = false;
var nr3UserModified = false;
var nr4UserModified = false;
var nr5UserModified = false;
var nr6UserModified = false;
var nr7UserModified = false;

//set this variable when enable port widget is pushed
var enableprt1 = false;
var enableprt2 = false;
var enableprt3 = false;
var enableprt4 = false;

//flags for INI file programming
var iniFile;
var iniFile_fullPath;

//Flag to send the parameter "numberofports"
var numberofportState = false;
var usb3numberofportState = false;

var currentProgrammingCount = 0;

function myAlert(str){
}
(function ($) {
    enable_all_fields = function () {
        $("#Apply").attr('disabled', true);
		$("#Preview").attr('disabled', true);
        $("#Factory").attr('disabled', true);
		$("#flexApply").attr('disabled', true);
		$("#XdataApply").attr('disabled', true);
		$("#MemdumpBtn").attr('disabled', true);
        $("#devicedescriptortab").attr('disabled', false);
        $("#stringdescriptortab").attr('disabled', false);
        $("#USB3devicedescriptortab").attr('disabled', false);
        $("#USB3stringdescriptortab").attr('disabled', false);
        $("#USB3otherdescriptortab").attr('disabled', false);
        $("#upstreamtab").attr('disabled', false);
        $("#downstreamtab").attr('disabled', false);
        $("#Bdownstreamtab").attr('disabled', false);
        $("#USB3_Bdownstreamtab").attr('disabled', false);
        $("#uchtab").attr('disabled', false);
        $("#advancedtab").attr('disabled', false);
        $("#specialtab").attr('disabled', false);
        $('#BPORT1fieldset').attr('disabled', 'disabled');
        $('#BPORT2fieldset').attr('disabled', 'disabled');
        $('#BPORT3fieldset').attr('disabled', 'disabled');
        $('#BPORT4fieldset').attr('disabled', 'disabled');
		$('#BPORT5fieldset').attr('disabled', 'disabled');
        $('#BPORT6fieldset').attr('disabled', 'disabled');
        $('#BPORT7fieldset').attr('disabled', 'disabled');

        $('#PORT1fieldset').attr('disabled', 'disabled');
        $('#PORT2fieldset').attr('disabled', 'disabled');
        $('#PORT3fieldset').attr('disabled', 'disabled');
        $('#PORT4fieldset').attr('disabled', 'disabled');
		$('#PORT5fieldset').attr('disabled', 'disabled');
        $('#PORT6fieldset').attr('disabled', 'disabled');
        $('#PORT7fieldset').attr('disabled', 'disabled');
    };
})(jQuery);

(function ($) {
    enable_all_fields_debugging = function () {
        // For Testing only
        // Basic Downstream FieldSet - USB 2.0
        $('#BPORT1fieldset').removeAttr('disabled');
        $('#BPORT2fieldset').removeAttr('disabled');
        $('#BPORT3fieldset').removeAttr('disabled');
        $('#BPORT4fieldset').removeAttr('disabled');
		$('#BPORT5fieldset').removeAttr('disabled');
		$('#BPORT6fieldset').removeAttr('disabled');
		$('#BPORT7fieldset').removeAttr('disabled');

        // Show USB configuration items
        $('#BdownstreamUSBport1').show();
        $('#BdownstreamUSBport2').show();
        $('#BdownstreamUSBport3').show();
        $('#BdownstreamUSBport4').show();
		$('#BdownstreamUSBport5').show();
		$('#BdownstreamUSBport6').show();
		$('#BdownstreamUSBport7').show();

        // Advanced Downstream FieldSet - USB 2.0
        $('#PORT1fieldset').removeAttr('disabled');
        $('#PORT2fieldset').removeAttr('disabled'); 
        $('#PORT3fieldset').removeAttr('disabled'); 
        $('#PORT4fieldset').removeAttr('disabled'); 
		$('#PORT5fieldset').removeAttr('disabled');
		$('#PORT6fieldset').removeAttr('disabled');
		$('#PORT7fieldset').removeAttr('disabled');
        $('#downstreamport1Fieldset').removeAttr('disabled');
        $('#downstreamport2Fieldset').removeAttr('disabled');
        $('#downstreamport3Fieldset').removeAttr('disabled');
        $('#downstreamport4Fieldset').removeAttr('disabled');
		$('#nr1div').removeAttr('disabled');
		$('#nr2div').removeAttr('disabled');
		$('#nr3div').removeAttr('disabled');
		$('#nr4div').removeAttr('disabled');
        // Show USB configuration items
        $('#downstreamUSBport1').show();
        $('#downstreamUSBport2').show();
        $('#downstreamUSBport3').show();
        $('#downstreamUSBport4').show();
		$('#downstreamUSBport5').show();
		$('#downstreamUSBport6').show();
		$('#downstreamUSBport7').show();

        // Show HSIC configuration items
        //$('#downstreamHSICport1').show();
        //$('#downstreamHSICport2').show();
        //$('#downstreamHSICport3').show();
        //$('#downstreamHSICport4').show();

        // Advanced upstream items
        $('#upstreamUSB').show();
        $('#upstreamHSIC').hide();
    };
})(jQuery);

(function ($) {
    get_hub_list = function () {
    	//Close previous all hub instances
		MchpUsbCloseAllHubs();
		//Call to clear previously acquired widget Map
		clearWidgetMap();
		setConfigMode(false, "NULL");
		enable_all_fields();
        enable_all_fields_debugging();
		reset_fields();
		set_changed_fields_border_default();
        // Populate the List of Hubs
		var i = 0;
		var test2  = "Fetching the hub list...";
		update_status_message(test2);
		var data = "";
		data = getHubList();
		$("#dropDownUL").empty();

		if (data) {
			enable_fields();
			hub_list = data.split("###");
			
			hubCount = hub_list.length;
			for (var k = (hub_list.length - 1); k >= 0; k--) {
				if (hub_list[k]) {
					update_status_message(hub_list[k]);
					$("#dropDownUL").append("<li> <a tabindex=\"-1\" href=\"javascript:void(0)\" align=\"left\">" + hub_list[k] + "</a> </li>");
				}
			}

			$("#selectedhubinput").val(hub_list[(hub_list.length - 2)]);
					$('.selecthub1')
					.find('[data-bind="SelectHublabel"]').text(hub_list[(hub_list.length - 2)])
					.children('.dropdown-toggle').dropdown('toggle');

			var btnValue = $("#selectedhubinput").val();
			var colonIndex = btnValue.indexOf(":");
			HUB_ID = "" + btnValue.charAt(colonIndex + 1);
			hubsFound = true;
		} else {
			enableApplyButton = false;
			if (enableFlex) {
				alert("Flex connect has been enabled for the Upstream port. \n Connect the hub with the Downstream port1 for the device to be enumerated.");
				update_status_message("Flex connect has been enabled for the Upstream port. \n Connect the hub with the Downstream port1 for the device to be enumerated.");
			}
			
			if (disableFlex) {
				alert("Flex connect has been disabled for the Upstream port. \n Connect the hub with the Upstream port for the device to be enumerated.");
				update_status_message("Flex connect has been disabled for the Upstream port. \n Connect the hub with the Upstream port for the device to be enumerated.");
			}
			
			if (enable_swapupstreamdpdm) {
				alert("The D+/D- of the upstream port have been swapped.");
				update_status_message("The D+/D- of the upstream port have been swapped.");
			}
			
			
			
			hubsFound = false;
			reset_fields();
			disable_fields();
			$("#progID").hide();
			window.alert("No hubs found");
			update_status_message("No hubs found");
		}
    };
})(jQuery);

(function ($) {
    update_status_message = function (mesg) {
        var currentdate = new Date(); 
        currentdate+''; 
        var datetime = currentdate.toLocaleString();
        $("#DSStatusMessage").append( datetime +":"+ mesg + "\n");
        $("#DSStatusMessage").animate({
            scrollTop:$("#DSStatusMessage")[0].scrollHeight - $("#DSStatusMessage").height()
            },400,function(){
          })
        };
})(jQuery);


(function ($) {
    set_selected_hub_get_widgets = function () {
        enable_all_fields();
        enable_all_fields_debugging();
		$("body").css("cursor", "wait");
		
		var isElbrus = false;
		var skuName;
		var selectindex = 0;
		
		
		if(flagforINIread) {
			
			if((HUB_ID == 0)) {
				
				selectindex =hubCount-1;
				
				for (selectindex; selectindex >= 0; selectindex--) {
					
					if(hub_list[selectindex]) {
						
						var selop = hub_list[selectindex];
						var colonIndex = selop.indexOf(":");
						incval = "" + selop.charAt(colonIndex + 1);	
						
						//incval = (selectindex).toString();
						
						skuName = set_selected_device(incval);
						
						var temp = skuName.substring(0,5);
						
						
						if((temp == "USB58") || (temp == "USB59")) {
							isElbrus = true;
							
							HUB_ID = incval;
							
							$('.selecthub1').find('[data-bind="SelectHublabel"]').text(selop)
									.children('.dropdown-toggle').dropdown('toggle');
							
							$("#selectedhubinput").val(selop);
							
							break;
						} 
						close_device(HUB_ID);
					
					}
					
				}
			} 
		} else {
			
			skuName = set_selected_device(HUB_ID);
			debugAlert("skuName"+skuName);
		}
		
		if (skuName == "") {
			skuName = "not identified";
			errorCode = getMchpUsbLastError(HUB_ID);
			update_status_message(errorMap[Dec2Hex(errorCode)] + " Check Help for troubleshooting.");
		} 

		var mesg1 = "The hub may go offline for a while. Please wait while the hub configuration is read and auto identification part number is available.";
        update_status_message(mesg1);
        mesg1="";
		update_status_message("The skuName for the hub of Index: " + HUB_ID + " is " + skuName + ".");
		
		if (skuName) {
			enable_fields();
			$("#AIPNInput").val(skuName);
			
			/* Get the last digit of the SKU Name. It decides the number of downstream ports that
			   are currently available.
			*/
			portsAvailable = skuName.substring(6);
			
			if (portsAvailable == 7) {
				$("#HubControllerSectionwithConfig").attr('disabled', true);
				$("#SpecialFeatures_Flex").attr('disabled', true);
				$("#Flex_FlexFeature").attr('disabled', true);
				$("#spiField").attr('disabled', true);
				$("#upstreamFlex").attr('disabled', true);
				//Show all 7 downstream ports
				$("#BPORT1fieldset").show();
				$("#BPORT2fieldset").show();
				$("#BPORT3fieldset").show();
				$("#BPORT4fieldset").show();
				$("#BPORT5fieldset").show();
				$("#BPORT6fieldset").show();
				$("#BPORT7fieldset").show();	
				
			} 
			else
			{
				$("#HubControllerSectionwithConfig").removeAttr('disabled');
				$("#SpecialFeatures_Flex").attr('disabled', false);
				$("#Flex_FlexFeature").removeAttr('disabled');
				$("#spiField").removeAttr('disabled');
			}
			
			if (portsAvailable == 6) {
				$("#BPORT7fieldset").hide();
	
				$("#HubControllerSectionwithConfig").removeAttr('disabled');
				$("#SpecialFeatures_Flex").attr('disabled', false);
				$("#Flex_FlexFeature").removeAttr('disabled');
				$("#spiField").removeAttr('disabled');
				
				//Advanced
				$("#PORT7fieldset").hide();
				
				
			} 
			/*else if (portsAvailable == 5) {
				$("#BPORT7fieldset").hide();
				$("#BPORT6fieldset").hide();
				
				//Advanced
				$("#PORT7fieldset").hide();
				$("#PORT6fieldset").hide();
			} else if (portsAvailable == 4) {
				$("#BPORT7fieldset").hide();
				$("#BPORT6fieldset").hide();
				$("#BPORT5fieldset").hide();
				
				//Advanced
				$("#PORT7fieldset").hide();
				$("#PORT6fieldset").hide();
				$("#PORT5fieldset").hide();
			} else {
				$("#BPORT1fieldset").show();
				$("#BPORT2fieldset").show();
				$("#BPORT3fieldset").show();
				$("#BPORT4fieldset").show();
				$("#BPORT5fieldset").show();
				$("#BPORT6fieldset").show();
				$("#BPORT7fieldset").show();
				
				//Advanced
				$("#PORT1fieldset").show();
				$("#PORT2fieldset").show();
				$("#PORT3fieldset").show();
				$("#PORT4fieldset").show();
				$("#PORT5fieldset").show();
				$("#PORT6fieldset").show();
				$("#PORT7fieldset").show();
			}*/

			var temp = skuName.substring(0,5);
			//var temp = "USB57";
			//if ((skuName === "USB5744") || (skuName === "USB5733") || (skuName === "USB5734") ||(skuName === "USB5732") ||(skuName === "USB5731")) {
			if (temp == "USB58" || temp == "USB59") 
			{
				isElbrus = true;
				$("#Apply").attr('disabled', false);
				$("#Preview").attr('disabled', false);
				$("#Factory").attr('disabled', false);
				$("#flexApply").attr('disabled', false);
				$("#XdataApply").attr('disabled', false);
				$("#MemdumpBtn").attr('disabled', false);
			}
			
			
			//if (Product == "USB3.1 Gen1") {
			if (!isElbrus) {
				reset_fields();
				disable_fields();
				update_status_message("Unable to connect to USB58XX/USB59XX family MCHP hub");
				alert("Unable to connect to USB58XX/USB59XX family MCHP hub");
				$("body").css("cursor", "default");
				//$('#ajaxBusy').hide();
				return;
			}
			//} 
			if ((skuName === "NOT MICROCHIP") || (skuName === "NOT IMPLEMENTED"))
			{
				mesg1 = "Hub is not a Microchip Hub.Please select a Microchip hub\n";
				update_status_message (mesg1);
				console.log("Hub is not a Microchip Hub.Please select a Microchip hub");
				alert("Hub is not a Microchip Hub.Please select a Microchip hub");
				update_status_message("Hub is not a Microchip Hub.Please select a Microchip hub");
				$("#Apply").attr('disabled', true);
				$("#Preview").attr('disabled', true);
				$("#Factory").attr('disabled', true);
				$("#flexApply").attr('disabled', true);
				$("#XdataApply").attr('disabled', true);
				$("#MemdumpBtn").attr('disabled', true);
				$("#devicedescriptortab").attr('disabled', true);
				$("#stringdescriptortab").attr('disabled', true);
				$("#USB3devicedescriptortab").attr('disabled', true);
				$("#USB3stringdescriptortab").attr('disabled', true);
				$("#USB3otherdescriptortab").attr('disabled', true);
				$("#upstreamtab").attr('disabled', true);
				$("#downstreamtab").attr('disabled', true);
				$("#Bdownstreamtab").attr('disabled', true);
				$("#USB3_Bdownstreamtab").attr('disabled', true);
				$("#uchtab").attr('disabled', true);
				$("#advancedtab").attr('disabled', true);
				$("#specialtab").attr('disabled', true);
				$("#OTPCR").val("");
				$("#OTPCP").val("");
				$("#FirmwareLocation").val("");
				$("#ConfigLocation").val("");
				$("#DeviceMgmtprogressbar3").css('width'," 0%");
				$("#DeviceMgmtprogressbar2").css('width', "0%");
			} else {
				update_status_message("The selected hub part number is " + skuName);
				
				enableApplyButton = true;

				// OTP Information
				var info = get_otp_info(HUB_ID);
				if (info) {
					var otp_info = info.split("###");
					var otpSize = otp_info[0];
					var ConfigBlockCnt = otp_info[1];
					var ConfigRemainCnt = otp_info[2];
					var ProgrammedByteCnt = otp_info[3];
					
					// update live apply section
					$("#xdatavalue").attr('disabled', true);
					$("#xdataaddress").val("");
					$("#xdatavalue").val("");
					var nameofcontrol = "input[name='xdataoperationgroup'][value=0]";
					$(nameofcontrol).prop("checked", true);
					
					//Configured block count
					$("#OTPCP").val(ConfigBlockCnt);
					var count = parseInt(ConfigBlockCnt,10) ;
					currentProgrammingCount = count;
					if (count >= 16)
					{
						var string = "16+";
						$("#OTPCP").val(string);
						$("#Restore").attr('disabled', true);
					}
					
					//Configured remaining count
					$("#OTPCR").val(ConfigRemainCnt);
					
					//OTP size
					var OTP = parseInt(otpSize,10);
					var PBC = parseInt(ProgrammedByteCnt, 10);
					
					
					percentage = (PBC / OTP) * 100;
					
					//if (Product == "USB3.1 Gen1") {
						$("#DeviceMgmtprogressbar3").css('width',percentage+ "%");
						$("#DeviceMgmtprogressbar3").css('color', 'black');
						if (percentage < 50){
							$("#DeviceMgmtprogressbar3").css({'background-image': 'none','background-color': 'green'});
							$("#DeviceMgmtprogressbar3").attr('aria-valuenow', 45);
						} else if (percentage < 75){
							$("#DeviceMgmtprogressbar3").css({'background-image': 'none','background-color': 'orange'});
						} else if (percentage > 75){
							$("#DeviceMgmtprogressbar3").css({'background-image': 'none','background-color': 'red'});
						}
						percenttrim = parseFloat(percentage).toFixed(2);
						$("#DeviceMgmtprogressbar3").html("<p align=\"center\">"+ percenttrim + "%" +"<p>");
					//}
					
					
				} else {
					window.alert("OTP information could not be retrieved.");
					update_status_message("OTP information could not be retrieved.");
				}
				
				//Updating firmware and config location in the UI
				var firmware_config = get_firmware_config_location(HUB_ID);
				var firmware_config_array = firmware_config.split("::");
				var firmware_loc = firmware_config_array[0];
				var config_loc = firmware_config_array[1];
				
				$("#FirmwareLocation").val(firmware_loc);
				$("#ConfigLocation").val(config_loc);
				
				//Updating the rest of the widgets.
				update_status_message ("Reading Hub Configuration ....");

				// Updating GwidgetlistHex
				$.each(GwidgetlistHex, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);

					if (widgetValue) {
						var decvalue = parseInt(widgetValue,10);
						var hexstring;
						if (value == "usbvcd" || value == "udc_usbvcd" || value == "usb3vcd") // remove the '.' added before
						{
							var dot = ".";
							var hexvalue = (decvalue.toString(16));
							var position = 1;
							var hexstring = [hexvalue.slice(0, position), dot, hexvalue.slice(position)].join('');
						} else {
							hexstring = decvalue.toString(16); //"0x" +  (decvalue.toString(16) );
						}
						$(widgetid).val(hexstring);
					}
				});
				
				// Updating GwidgetlistString
				$.each(GwidgetlistString, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);
					if(/*(widgetValue === " ") ||*/ (widgetValue === "")) {
						$(widgetid).val(stringnullvalue);
					} else {
						$(widgetid).val(widgetValue);
					}
				});

				// Updating GwidgetlistInt
				$.each(GwidgetlistInt, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);
					
					if(widgetValue === "") {
						$(widgetid).val("");
					} else {
						var decVal;
						if (value == "hub3maxpowerselfbus") {
							decVal = widgetValue & 0xff;
							decVal = parseInt(decVal,10);
							decVal = decVal * 8;
						} else if ((value == "hubcmaxpowerbus") || (value == "hubcmaxpowerself")) {
							decVal = widgetValue & 0xff;
							decVal = parseInt(decVal,10);
						} else {
							decVal = widgetValue & 0xff;
							decVal = parseInt(decVal,10);
							decVal = decVal * 2;
						}
						$(widgetid).val(decVal);
					}
				});

				// Updating GwidgetlistCheckbox
				$.each(GwidgetlistCheckbox, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);
					
					if ( widgetValue == checkbox_checked_value )
					{
						$(widgetid).prop('checked',true);     
						// If there are corresponding fieldsets - enable them 
						$(widgetid).trigger("change"); 
						set_changed_fields_border_default();
					}
					else {
						$(widgetid).prop('checked',false);
						// If there are corresponding fieldsets - disable them 
						$(widgetid).trigger("change"); 
						set_changed_fields_border_default();
					}
				});

				// Updating GwidgetlistRadio
				$.each(GwidgetlistRadio, function( index, value ) {
					var groupname = value +"group";
					var widgetValue = getWidgetValue(HUB_ID, value);
					var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
					$(nameofcontrol).prop("checked", true);
					if ( value === "hubpower")
					{
						var widgetid = "#hubpowergroup";
						// If there are corresponding fieldsets - enable them 
						$(widgetid).trigger("change"); 
						if (widgetValue == "0") { // Bus power
							// Disable the fields
							//$('#selfpowerfieldset').attr('disabled', 'disabled');
							//$('#buspowerfieldset').removeAttr('disabled');
							$('#selfpowerfieldset').hide();
							$('#buspowerfieldset').show();
						} else if (widgetValue == "1") { // Self power
							// Disable the fields
							//$('#buspowerfieldset').attr('disabled', 'disabled');
							//$('#selfpowerfieldset').removeAttr('disabled');
							$('#buspowerfieldset').hide();
							$('#selfpowerfieldset').show();
						}
						set_changed_fields_border_default();
					}
						var pstemp;
						if ( value == "port5splitting")
						{	
							
							if(widgetValue == 1)
							{
								$('#portpower5').show();
								$('#PORTSplittingfieldset').show();
								widgetValue = getWidgetValue(HUB_ID, "prtpwr5usb3split");
								
								nameofcontrol = "input[name= prtpwr5usb3splitgroup][value=" + widgetValue + "]";
								$(nameofcontrol).prop("checked", true);
							} else {
								$('#portpower5').hide();
								widgetValue = getWidgetValue(HUB_ID, "prtpwr6usb3split");
								if(widgetValue == 0) {
									$('#PORTSplittingfieldset').hide();
								}
							}
							
						}
						
						if ( value == "port6splitting")
						{	
							
							if(widgetValue == 1)
							{
								$('#portpower6').show();
								$('#PORTSplittingfieldset').show();
								widgetValue = getWidgetValue(HUB_ID, "prtpwr6usb3split");
								pstemp = Number(widgetValue);
								nameofcontrol = "input[name= prtpwr6usb3splitgroup][value=" + (pstemp.toString(16)) + "]";
								$(nameofcontrol).prop("checked", true);
								
							} else {
								$('#portpower6').hide();
								widgetValue = getWidgetValue(HUB_ID, "prtpwr5usb3split");
								if(widgetValue == 0) {
									$('#PORTSplittingfieldset').hide();
								}
							}
							
						}
						
					});

				// Updating GwidgetlistDropDown
				$.each(GwidgetlistDropDown, function( index, value ) {
					var widgetValue = getWidgetValue(HUB_ID, value);
					var decval = parseInt(widgetValue,10);
					var nameofcontrol = "." + value + "1";
					var nameofcontrol1 = "[data-bind=\"" + value + "label\"]";
					
					if (value == "port1mapping"  || value=="port2mapping"
					|| value=="port3mapping" || value=="port4mapping"
					|| value=="port5mapping" || value=="port6mapping"
					|| value=="port7mapping" || value=="usb3port1mapping"
					|| value=="usb3port2mapping" || value=="usb3port3mapping"
					|| value=="usb3port4mapping" || value=="usb3port5mapping"
					|| value=="usb3port6mapping" || value=="usb3port7mapping")
					{
						$.each(DropDownPORTMAPPING, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					if ( value == "PHYBOOST" || value=="PHYBOOSTdownstreamport1" 
					|| value=="PHYBOOSTdownstreamport2" || value=="PHYBOOSTdownstreamport3"
					|| value=="PHYBOOSTdownstreamport4" || value=="PHYBOOSTdownstreamport5"
					|| value=="PHYBOOSTdownstreamport6" || value=="PHYBOOSTdownstreamport7")
					{
						$.each(DropDownPHYBOOST, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					
					}
					if ( value == "SQUELCH" || value=="SQUELCHdownstreamport1" 
					|| value=="SQUELCHdownstreamport2" || value=="SQUELCHdownstreamport3"
					|| value=="SQUELCHdownstreamport4" || value=="SQUELCHdownstreamport5"
					|| value=="SQUELCHdownstreamport6" || value=="SQUELCHdownstreamport7")
					{
						$.each(DropDownSQUELCH, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					if (value == "upstreamHsRiseFall" || value=="downstreamport1HsRiseFall"
					|| value=="downstreamport2HsRiseFall" || value =="downstreamport3HsRiseFall"
					|| value=="downstreamport4HsRiseFall" || value=="downstreamport5HsRiseFall"
					|| value=="downstreamport6HsRiseFall" || value=="downstreamport7HsRiseFall")
					{
						$.each(DropDownHSRiseFall, function(index, valuelist) {
							if (index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					// Update fields based on obtained value
					$(nameofcontrol)
				    .find(nameofcontrol1).text(selText)
					.children('.dropdown-toggle').dropdown('toggle');
				});

				$("#ConfigMode").empty();
				var configModeAddr = "414f";
				var configModeVal = registerOperation(HUB_ID, configModeAddr, "1", true, "", false);
				configModeVal = parseInt(configModeVal, 16);

				var Mode = 0;
				if (configModeVal == 0x0A) {
					 Mode = 1;
				}
				else if (configModeVal == 0x0B) {
					 Mode = 2;
				}
				else if (configModeVal == 0x02) {
					 Mode = 3;
				}
				else if (configModeVal == 0x1B) {
					 Mode = 4;
				}
				else if (configModeVal == 0x00) {
					 Mode = 5;
				}
				else if (configModeVal == 0x1F) {
					 Mode = 6;
				}
				else {
					 Mode = 0;
				}
				$("#ConfigMode").val(Mode);

				update_status_message("Reading Hub Configuration successful.");
					
				//} // End of if (hub_is_microchip == '1')
			} // End of else ((skuName === "NOT MICROCHIP") || (skuName === "NOT IMPLEMENTED"))
			
			// To check the state of live flex connect
			var flexAddr = "318e";
			var flexLiveState = hub_xdata_read(HUB_ID, flexAddr);

			if (flexLiveState == 1) {
				$("#flexlive").prop('checked', true);
				CurrentflexLiveValue = 1;
			} else if (flexLiveState == 0) {
				$("#flexlive").prop('checked', false);
				CurrentflexLiveValue = 0;
			} else {
				// Do nothing
			}
			//$('#ajaxBusy').hide();
			$("body").css("cursor", "default");
		} else {
			reset_fields();
			disable_fields();
			$("#progID").hide();
			$("body").css("cursor", "default");
			enableApplyButton = false;
			errorCode = getMchpUsbLastError(HUB_ID);
			alert(errorMap[Dec2Hex(errorCode)] + " Check Help for troubleshooting.");
			update_status_message(errorMap[Dec2Hex(errorCode)] + " Check Help for troubleshooting.");
		}
	};
})(jQuery);

(function ($) {
    get_hub_list_set_hub_index_zero = function () {
		//$("#progID").hide();
		//$("#progID").show();

		get_hub_list();
		
		if (hubsFound) {
			set_selected_hub_get_widgets();
		}
		
    };
})(jQuery);


(function ($) {
    set_changed_widget_list = function () {
		//Array to save the widgets and their values which were changed.
		var deltaobj = [];
		var sentinel = true;
		var mismatchCheck = 0;
		
		//List of widgets to display on the alert
		var widgetsToDisplay = [];
		var modifiedWidgets = [];
		
		// language id constraint
		var stringmodified = 0;
		var udc_stringmodified = 0;
		var langid = $("#languageid").val();
		var udc_langid = $("#hce_languageid").val();
		var enableMapping = false;
		
		var usb3langid = $("#usb3languageid").val();
		var usb3stringmodified = 0;
		var usb3StringLength = 0;
		var usb3StringFlag = true;
		var currentvalue="NONE";
		
		// Check length of strings constraint
		var usb2StringLength = 0;
		var hceStringLength = 0;
		
		//Alert flags for string lengths
		var usb2StringFlag = true;
		var hceStringFlag = true;
		
		//flag for alert message
		var errorFlag = false;

		// Find out currently how many USB2.0 ports are enabled
		var bEnable1 = $('#enableport1').is(':checked');
		var bEnable2 = $('#enableport2').is(':checked');
		var bEnable3 = $('#enableport3').is(':checked');
		var bEnable4 = $('#enableport4').is(':checked');
		var bEnable5 = $('#enableport5').is(':checked');
		var bEnable6 = $('#enableport6').is(':checked');
		var bEnable7 = 0;
		if (portsAvailable == 7) {
			bEnable7 = $('#enableport7').is(':checked');
		}
		var SendNoofPorts = 0;
		//Total ports enabled 
		var bTotal = bEnable1 + bEnable2 + bEnable3 + bEnable4 + bEnable5 + bEnable6 + bEnable7;
		
		// Find out currently how many USB2.0 ports are enabled
		var usb3bEnable1 = $('#usb3enableport1').is(':checked');
		var usb3bEnable2 = $('#usb3enableport2').is(':checked');
		var usb3bEnable3 = $('#usb3enableport3').is(':checked');
		var usb3bEnable4 = $('#usb3enableport4').is(':checked');
		var usb3bEnable5 = $('#usb3enableport5').is(':checked');
		var usb3bEnable6 = $('#usb3enableport6').is(':checked');
		var usb3bEnable7 = 0;
		if (portsAvailable == 7) {
			usb3bEnable7 = $('#usb3enableport7').is(':checked');
		}
		var usb3SendNoofPorts = 0;
		//Total ports enabled 
		var usb3bTotal = usb3bEnable1 + usb3bEnable2 + usb3bEnable3 + usb3bEnable4 + 
		usb3bEnable5 + usb3bEnable6 + usb3bEnable7;

		// Check Port Disable condition
		var port1Status = $('#enableport1').is(':checked')?1:0;
		var port2Status = $('#enableport2').is(':checked')?1:0;
		var port3Status = $('#enableport3').is(':checked')?1:0;
		var port4Status = $('#enableport4').is(':checked')?1:0;
		var port5Status = $('#enableport5').is(':checked')?1:0;
		var port6Status = $('#enableport6').is(':checked')?1:0;
		
		if (portsAvailable == 7) {
			var port7Status = $('#enableport7').is(':checked')?1:0;
		}
		
		var usb3port1Status = $('#usb3enableport1').is(':checked')?1:0;
		var usb3port2Status = $('#usb3enableport2').is(':checked')?1:0;
		var usb3port3Status = $('#usb3enableport3').is(':checked')?1:0;
		var usb3port4Status = $('#usb3enableport4').is(':checked')?1:0;
		var usb3port5Status = $('#usb3enableport5').is(':checked')?1:0;
		var usb3port6Status = $('#usb3enableport6').is(':checked')?1:0;
		
		if (portsAvailable == 7) {
			var usb3port7Status = $('#usb3enableport7').is(':checked')?1:0;
		}

		var hceStatus = $('#hceenable').is(':checked')?1:0;

		if (hceStatus == 0) {
			if ((port1Status == 0) && (port2Status == 0) && (port3Status == 0) && (port4Status == 0)
				&& (port5Status == 0) && (port6Status == 0) && (port7Status == 0)) {
				alert("Hub controller is disabled. Disabling all downstream ports is not allowed.");
				update_status_message("Hub controller is disabled. Disabling all downstream ports is not allowed.");
				return;
			}
		}

		if ((port1Status == 0) && (port2Status == 0) && (port3Status == 0) && (port4Status == 0)
			&& (port5Status == 0) && (port6Status == 0) && (port7Status == 0)) {
			if (hceStatus == 0) {
				alert("All downstream ports are disabled. Disabling the Hub controller is not allowed.");
				update_status_message("All downstream ports are disabled. Disabling the Hub controller is not allowed.");
				return;
			}
		}

		//To program it to defaults when a port is disabled.
		if (bEnable1 == false) {
			var nrport1 = getWidgetValue(HUB_ID, "nrdeviceport1");
			var dpdmSwap1 = getWidgetValue(HUB_ID, "swapport1dpdm");
			var phyboost1 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport1");
			var varisense1 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport1");
			var hsrisefall1 = getWidgetValue(HUB_ID, "downstreamport1HsRiseFall");
			if (nrport1 != 0) {
				nrModified = true;
			}
			
			if (dpdmSwap1 != 0) {
				deltaobj.push("swapport1dpdm", 0);
			}
			
			if (phyboost1 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport1", 0);
			}
			
			if (varisense1 != 0) {
				deltaobj.push("SQUELCHdownstreamport1", 0);
			}
			if(hsrisefall1 !=0)
			{
				deltaobj.push("downstreamport1HsRiseFall", 0);
			}
		}

		if (bEnable2 == false) {
			var nrport2 = getWidgetValue(HUB_ID, "nrdeviceport2");
			var dpdmSwap2 = getWidgetValue(HUB_ID, "swapport2dpdm");
			var phyboost2 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport2");
			var varisense2 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport2");
			var hsrisefall2 = getWidgetValue(HUB_ID, "downstreamport2HsRiseFall");
			if (nrport2 != 0) {
				nrModified = true;
				
			}
			
			if (dpdmSwap2 != 0) {
				deltaobj.push("swapport2dpdm", 0);
			}
			
			if (phyboost2 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport2", 0);
			}
			
			if (varisense2 != 0) {
				deltaobj.push("SQUELCHdownstreamport2", 0);
			}
			if(hsrisefall2 !=0)
			{
				deltaobj.push("downstreamport2HsRiseFall", 0);
			}
		}

		if (bEnable3 == false) {
			var nrport3 = getWidgetValue(HUB_ID, "nrdeviceport3");
			var dpdmSwap3 = getWidgetValue(HUB_ID, "swapport3dpdm");
			var phyboost3 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport3");
			var varisense3 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport3");
			var hsrisefall3 = getWidgetValue(HUB_ID, "downstreamport3HsRiseFall");
			if (nrport3 != 0) {
				nrModified = true;
				
			}
			
			if (dpdmSwap3 != 0) {
				deltaobj.push("swapport3dpdm", 0);
			}
			
			if (phyboost3 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport3", 0);
			}
			
			if (varisense3 != 0) {
				deltaobj.push("SQUELCHdownstreamport3", 0);
			}
			if(hsrisefall3 !=0)
			{
				deltaobj.push("downstreamport3HsRiseFall", 0);
			}
		}

		if (bEnable4 == false) {
			var nrport4 = getWidgetValue(HUB_ID, "nrdeviceport4");
			var dpdmSwap4 = getWidgetValue(HUB_ID, "swapport4dpdm");
			var phyboost4 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport4");
			var varisense4 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport4");
			var hsrisefall4 = getWidgetValue(HUB_ID, "downstreamport4HsRiseFall");
			if (nrport4 != 0) {
				nrModified = true;
				
			}
			
			if (dpdmSwap4 != 0) {
				deltaobj.push("swapport4dpdm", 0);
			}
			
			if (phyboost4 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport4", 0);
			}
			
			if (varisense4 != 0) {
				deltaobj.push("SQUELCHdownstreamport4", 0);
			}
			if(hsrisefall4 !=0)
			{
				deltaobj.push("downstreamport4HsRiseFall", 0);
			}
		}

		if (bEnable5 == false) {
			var nrport5 = getWidgetValue(HUB_ID, "nrdeviceport5");
			var dpdmSwap5 = getWidgetValue(HUB_ID, "swapport5dpdm");
			var phyboost5 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport5");
			var varisense5 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport5");
			var hsrisefall5 = getWidgetValue(HUB_ID, "downstreamport5HsRiseFall");
			if (nrport5 != 0) {
				nrModified = true;
				
			}
			
			if (dpdmSwap5 != 0) {
				deltaobj.push("swapport5dpdm", 0);
			}
			
			if (phyboost5 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport5", 0);
			}
			
			if (varisense5 != 0) {
				deltaobj.push("SQUELCHdownstreamport5", 0);
			}
			if(hsrisefall5 !=0)
			{
				deltaobj.push("downstreamport5HsRiseFall", 0);
			}
		}
		
		if (bEnable6 == false) {
			var nrport6 = getWidgetValue(HUB_ID, "nrdeviceport6");
			var dpdmSwap6 = getWidgetValue(HUB_ID, "swapport6dpdm");
			var phyboost6 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport6");
			var varisense6 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport6");
			var hsrisefall6 = getWidgetValue(HUB_ID, "downstreamport6HsRiseFall");
			if (nrport6 != 0) {
				nrModified = true;
				
			}
			
			if (dpdmSwap6 != 0) {
				deltaobj.push("swapport6dpdm", 0);
			}
			
			if (phyboost6 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport6", 0);
			}
			
			if (varisense6 != 0) {
				deltaobj.push("SQUELCHdownstreamport6", 0);
			}
			if(hsrisefall6 !=0)
			{
				deltaobj.push("downstreamport6HsRiseFall", 0);
			}
		}
		
		if (portsAvailable == 7) {
			if (bEnable7 == false) {
				var nrport7 = getWidgetValue(HUB_ID, "nrdeviceport7");
				var dpdmSwap7 = getWidgetValue(HUB_ID, "swapport7dpdm");
				var phyboost7 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport7");
				var varisense7 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport7");
				var hsrisefall7 = getWidgetValue(HUB_ID, "downstreamport7HsRiseFall");
				if (nrport7 != 0) {
					nrModified = true;
					
				}
				
				if (dpdmSwap7 != 0) {
					deltaobj.push("swapport7dpdm", 0);
				}
				
				if (phyboost7 != 0) {
					deltaobj.push("PHYBOOSTdownstreamport7", 0);
				}
				
				if (varisense7 != 0) {
					deltaobj.push("SQUELCHdownstreamport7", 0);
				}
				if(hsrisefall7 !=0)
				{
					deltaobj.push("downstreamport7HsRiseFall", 0);
				}
			}
		}
		
		if (usb3bEnable1 == false) {
			var usb3nrport1 = getWidgetValue(HUB_ID, "usb3nrdeviceport1");

			if (usb3nrport1 != 0) {
				usb3nrModified = true;
			}
		}
		
		if (usb3bEnable2 == false) {
			var usb3nrport2 = getWidgetValue(HUB_ID, "usb3nrdeviceport2");

			if (usb3nrport2 != 0) {
				usb3nrModified = true;
			}
		}
		
		if (usb3bEnable3 == false) {
			var usb3nrport3 = getWidgetValue(HUB_ID, "usb3nrdeviceport3");

			if (usb3nrport3 != 0) {
				usb3nrModified = true;
			}
		}
		
		if (usb3bEnable4 == false) {
			var usb3nrport4 = getWidgetValue(HUB_ID, "usb3nrdeviceport4");

			if (usb3nrport4 != 0) {
				usb3nrModified = true;
			}
		}
		
		if (usb3bEnable5 == false) {
			var usb3nrport5 = getWidgetValue(HUB_ID, "usb3nrdeviceport5");

			if (usb3nrport5 != 0) {
				usb3nrModified = true;
			}
		}
		
		if (usb3bEnable6 == false) {
			var usb3nrport6 = getWidgetValue(HUB_ID, "usb3nrdeviceport6");

			if (usb3nrport6 != 0) {
				usb3nrModified = true;
			}
		}
		
		if (portsAvailable == 7) {
			if (usb3bEnable7 == false) {
				var usb3nrport7 = getWidgetValue(HUB_ID, "usb3nrdeviceport7");

				if (usb3nrport7 != 0) {
					usb3nrModified = true;
				}
			}
		}
		//TO DO: String length constraint check and coding
		//String Descriptors
		$.each(GwidgetlistString, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(HUB_ID, value1);
			//todo
			if((typeof oldval== 'undefined') || (oldval =="undefined"))
			{
				errorFlag = true;
				return;
			}
			var newval = $(widgetid).val();

			if (value1 === "usb3manufacturer" || value1 === "usb3product"|| value1 === "usb3serial")
			{
				var stringvalue = $(widgetid).val();
				// Check the widget length also
				if (stringvalue  == stringnullvalue )
				{
					// do nothing null string
				} else {
					usb3StringLength = usb3StringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
				if ((usb3StringLength > 90) && usb3StringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB3.1 Gen1 can have a max length of 90 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB3.1 Gen1 can have a max length of 90 unicode characters only");
					usb3StringFlag = false;
					errorFlag = true;
					return;
				}
			}
			
			if (value1 === "manufacturer" || value1 === "product"|| value1 === "serial")
			{
				var stringvalue = $(widgetid).val();

				// Check the widget length also
				if (stringvalue  == stringnullvalue)
				{
					// do nothing null string
				} else {
					usb2StringLength = usb2StringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
				if ((usb2StringLength > 90) && usb2StringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB2.0 can have a max length of 90 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB2.0 can have a max length of 90 unicode characters only");
					usb2StringFlag = false;
					errorFlag = true;
					return;
				}
			}
			
			if(value1 === "hce_manufacturer") {
				enablealertmanu = true;
			} else if(value1 === "hce_product") {
				enablealertprod = true;
			} else if(value1 === "hce_serial") {
				enablealertser = true;
			}
			
			if (value1 === "hce_manufacturer" || value1 === "hce_product" || value1 === "hce_serial")
			{
				var stringvalue = $(widgetid).val();

				// Check the widget length also
				if (stringvalue  == stringnullvalue)
				{
					// do nothing null string
				} else {
					hceStringLength = hceStringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
			
				if ((hceStringLength > 60) && hceStringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name and Product name) of Hub Feature Controller can have a max length of 60 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name and Product name) of Hub Feature Controller can have a max length of 60 unicode characters only");
					hceStringFlag = false;
					errorFlag = true;
					return;
				}
			}
			if (value1 === "usb3uuid") {
				var uuidVal = $(widgetid).val();
				var isOkay = /^[0-9a-fA-F]{1,32}$/i.test(uuidVal);

				if (uuidVal == "") {
					alert("Please enter a value for USB3.1 Gen1 UUID.");
					errorFlag = true;
					return;
				} else if (!isOkay) {
					alert("UUID value entered is invalid. UUID of USB3.1 Gen1 must be a 16 bytes of hexadecimal number.");
					update_status_message("UUID value entered is invalid. UUID of USB3.1 Gen1 must be a 16 bytes of hexadecimal number.");
					errorFlag = true;
					return;
				}
			}

			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if ((newval === stringnullvalue) || (newval === oldval))
			{
				// do nothing no change detected.
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				 console.log("change detected but field disabled: widget:" + value1);
			}
			else {
				//console.log("change detected : widget:" + value1); // + " current value:" + val1 + " new value:" + newval);
				if (Product == "USB3.1 Gen1") {
					if (value1 === "usb3manufacturer" || 
						value1 === "usb3product"||
						value1 === "usb3serial")
					{
						usb3stringmodified = 1;
					}
				}

				if (value1 === "hce_manufacturer" || 
					value1 === "hce_product" || value1 === "hce_serial")
				{
					udc_stringmodified = 1;
				}
				
				if (value1 === "manufacturer" || 
					value1 === "product"||
					value1 === "serial")
				{
					stringmodified = 1;
				}

				if (jQuery.isEmptyObject(newval)) {
					newval = "";
				}

				if (value1 === "manufacturer" || value1 === "product"|| 
					value1 === "serial")
				{
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
					
					// Set the widget length also
					var len = $(widgetid).val().length;
					// Now check if length constraint is met or not.
					var lenwidget = value1 + "len";
					//console.log("Also updating :" + lenwidget + " new value:" + len);
					deltaobj.push(lenwidget,len);
				}  
				
			
				if (value1 === "usb3manufacturer" || value1 === "usb3product"|| 
					value1 === "usb3serial")
				{
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
				}
				
				
				if (value1 === "hce_manufacturer") {
					hceenablemanu = true;
					
				} else if (value1 === "hce_product") {
					hceenableprod = true;
				}  else if(value1 === "hce_serial") {
					hceenableser = true;
				}
				
				
				
				if (value1 == "usb3uuid") {
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
				}
				
				
				
				  
			}
		}); //End of $.each(GwidgetlistString, function( index1, value1 )*/

		//Hex Descriptors
		$.each(GwidgetlistHex, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval;
			var newval;
			var isOk;
			
			if(value1 === "usbvcd" || value1 === "udc_usbvcd" || value1 === "usb3vcd") {
				var usbvcdVal = parseInt(getWidgetValue(HUB_ID, value1), 10);
				var dot = ".";
				var hexvalue = (usbvcdVal.toString(16));
				var position = 1;
				var hexstring = [hexvalue.slice(0, position), dot, hexvalue.slice(position)].join('');
				oldval = hexstring;
				newval = $(widgetid).val();
				if (value1 == "usbvcd") {
					isOk = /^2\.?[0-9]{0,2}$/i.test($(widgetid).val());
				}
				
				if (value1 == "usb3vcd") {
					isOk = /^3\.?[0-9]{0,2}$/i.test($(widgetid).val());
				}
				
				if (typeof isOk == 'undefined') {
					return;
				}
				if (!isOk) {
					update_status_message("The value entered for \"" + Mapping[value1] + "\" is not valid.");
					alert("The value entered for \"" + Mapping[value1] + "\" is not valid");
					errorFlag = true;
				}
			} else {
				oldval = parseInt(getWidgetValue(HUB_ID, value1), 10);
				isOk = /^[0-9A-Fa-f]{1,4}$/i.test($(widgetid).val());
				newval = parseInt($(widgetid).val(), 16);
				
				if ((value1 == "vid") || (value1 == "hce_vid") || (value1 == "usb3vid")) {
					var widID = "#" + value1;
					var widVal = $(widID).val();
					if (widVal == 0) {
						isOk = false;
					}
				}
				
				if (!isOk) {
					if (value1 == "usb3pid" || value1 == "usb3did" || value1 == "usb3vid" || value1 == "usb3languageid") {
						//if (Product == "USB3.1 Gen1") {
						update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						alert("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						errorFlag = true;
						//}
					} else {
						update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						alert("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						errorFlag = true;
					}
				}
			}
			
			if (!isOk) {
				// Do nothing. The value entered does not meet the expected pattern.
			} else {
				if ((oldval === newval) || isNaN(newval)) {
					//Do nothing
				} else {
					//Check for language ID
					if ((value1 == "languageid") || (value1 == "hce_languageid") || (value1 == "usb3languageid")) {
						if (newval == 0) {
							alert("Language ID cannot be zero. Setting it to default value (0x409)");
							newval = parseInt("0x409", 16);
						}
					}
					// Adding the VID of USB2.0 and HCE to Protouch2.ini, if they are modified.
					if ((value1 == "vid") || (value1 == "hce_vid")) {
						var valueEntered = $(widgetid).val();
						var hexEntered = "0x" + valueEntered;
						updateINI(hexEntered);
						//if vid of USB2.0 or Hub controller is modified, then increase the time out.
						vid_pidModified = true;
					}

					//if pid of USB2.0 or Hub controller is modified, then increase the time out.
					if ((value1 == "pid") || (value1 == "hce_pid")) {
						vid_pidModified = true;
					}

					// convert string to number                                        
					var decvalue = parseInt(newval,10);
					// convert number to string and then string to hex
					var valueToSet;
					if (value1 =="usbvcd" || value1 =="udc_usbvcd" || value1 == "usb3vcd") // remove the '.' added before
					{
						newval = newval.replace('.', '');
						decvalue = parseInt(newval,10);
						valueToSet = decvalue;
					}
					else {
						valueToSet = "0x" +  (decvalue.toString(16) ); 
					}
					var that = $( widgetid ), parent = that.closest('fieldset');
					var checkdisabled = $(parent).prop( "disabled" );
					if (checkdisabled)
					{
						// Change detected but field is disabled - So do nothing
						console.log("change detected but field disabled: widget:" + value1 + " new value:" + hexstring);
					}
					else {
						if ((value1 === "vid") || (value1 === "usb3vid")) {
							if (sentinel) {
								var usb3VID = $("#usb3vid").val();
								var usb2VID = $("#vid").val();
								if (usb3VID == usb2VID) {
									sentinel = false;
									deltaobj.push("vid", valueToSet);
									deltaobj.push("usb3vid", valueToSet);
									modifiedWidgets.push("vid", "usb3vid");
								} else {
									update_status_message("Mismatch in VID of USB2.0 and USB3.1 Gen1. Please make sure their VID is the same.");
									mismatchCheck++;
									if (mismatchCheck == 1) {
										alert("Mismatch in VID of USB2.0 and USB3.1 Gen1. Please make sure their VID is the same.");
										errorFlag = true;
									}
								}
							}
						} else {
							deltaobj.push(value1,valueToSet);
							modifiedWidgets.push(value1);
						}
					}
				}
			}
		});

		//Int Descriptors
		$.each(GwidgetlistInt, function(index1, value1) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(HUB_ID, value1);
			if (value1 == "hub3maxpowerselfbus") {
				//if (Product == "USB3.1 Gen1") {
					oldval = parseInt(oldval,10) * 8;
				//}
			} else if((value1 == "hubcmaxpowerbus") || (value1 == "hubcmaxpowerself")) {
				oldval = parseInt(oldval,10);
			} else {
				oldval = parseInt(oldval,10) * 2;
			}
			var that = $(widgetid), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop("disabled");
			
			var newval = $(widgetid).val();
			var newdecvalue = parseInt(newval,10);
			newdecvalue = newdecvalue & 0xff;
			if((value1 == "hub3maxpowerselfbus") || (value1 == "maxpowerself") || (value1 == "maxpowerbus"))
			{
				if ((newdecvalue & 0x01) && !checkdisabled)
				{
					currentvalue = "ODDNUM";
					return;
				}
			}
			
			if ((oldval == newval) || isNaN(newval)) {
				// do nothing - no change in value
			} 
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
			}
			else {
				if ((value1 == "maxpowerself") || (value1 == "hubcmaxpowerself")) {
					if ((newval > 100) || (newval < 0)) {
						alert ("USB2.0 max power(self) or USB2.0 hub circuit max power(self) cannot be more than 100mA or negative.");
						update_status_message("USB2.0 max power(self) or USB2.0 hub circuit max power(self) cannot be more than 100mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if (value1 == "maxpowerbus") {
					if ((newval > 500) || (newval < 0)) {
						alert ("USB2.0 max power(bus) cannot be more than 500mA or negative.");
						update_status_message("USB2.0 max power(bus) cannot be more than 500mA or negative.");
						errorFlag = true;
						return;
					}
				}
				
				if (value1 == "hubcmaxpowerbus") {
					if ((newval > 255) || (newval < 0)) {
						alert ("USB2.0 hub circuit max power(bus) cannot be more than 255mA or negative.");
						update_status_message("USB2.0 hub circuit max power(bus) cannot be more than 255mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if (value1 == "hub3maxpowerselfbus") {
					if ((newval > 900) || (newval < 0)) {
						alert ("USB3.1 Gen1 hub max power cannot be more than 900mA or negative.");
						update_status_message("USB3.1 Gen1 hub max power cannot be more than 900mA or negative.");
						errorFlag = true;
						return;
					}
				}
				var hexval;
				if (value1 == "hub3maxpowerselfbus") {
					var newdecvalue = parseInt(newval,10);
					var reminder = newdecvalue%8;
					if(reminder != 0)
					{
						alert ("Hub Max Power 3.1 Gen1 field can have multiples of 8 only");
						var mesg = "Error : Hub Max Power 3.1 Gen1 field can have multiples of 8 only";
						update_status_message(mesg);
						errorFlag = true;
						return;
					}
					newdecvalue = newdecvalue/8;
					var temp = Math.floor(newdecvalue);
					hexval = temp.toString(16);
				} else if ((value1 == "hubcmaxpowerbus") || (value1 == "hubcmaxpowerself")) {
					newdecvalue = parseInt(newval,10);
					hexval = newdecvalue.toString(16);
				} else {
					newdecvalue = parseInt(newval,10);
					newdecvalue = newdecvalue/2;
					hexval = newdecvalue.toString(16);
				}
				deltaobj.push(value1, hexval);
				modifiedWidgets.push(value1);
			}
		});
		
		if (currentvalue == "ODDNUM") {
			$("#progID").hide();
			alert ("\"Hub MaxPower(Self)\", \"Hub Circuit MaxPower(Self)\", \"HubMaxPower(Bus)\" and \"Hub Circuit MaxPower(Bus)\" fields can have even numbers only");
			var mesg = "Error : \"Hub MaxPower(Self)\", \"Hub Circuit MaxPower(Self)\", \"Hub MaxPower(Bus)\" and \"Hub Circuit MaxPower(Bus)\" fields can have even numbers only";
			update_status_message(mesg);
			currentvalue= "NONE";
			errorFlag = true;
			return;
		}

		//Radio buttons
		var portSplit5include = false;
		var portSplit6include = false;
		var portSplittimeoutinclude = false;
		
		$.each(GwidgetlistRadio, function(index2, value1) {
			var widgetgroupname = '#' + value1 +"group";
			var oldval = getWidgetValue(HUB_ID, value1);
			var newval = $(widgetgroupname).find(':checked').val();
			var that = $( widgetgroupname ), parent = that.closest('fieldset');
			var  checkdisabled = $(parent).prop( "disabled" );			
						
			if ((oldval === newval) || jQuery.isEmptyObject(newval))
			{
				// do nothing
				//If Port splitting is already enabled and only GPIO needs to be updated
				//Port 5
				if ((value1 == "port5splitting")) {
					if(newval == 1) {
						var portpower5radio = $("#prtpwr5usb3splitgroup").find(':checked').val();
						var portpower5radio_old = getWidgetValue(HUB_ID, "prtpwr5usb3split");
						var pstemp = Number(portpower5radio_old);
						var ps5oldVal = pstemp.toString(16);
						
						if ((portpower5radio == portpower5radio_old) ) {
							//Old value and new value are the same; do nothing
						} else {
							var opt = confirm("Enabling port splitting on port 5 will disable the default function of GPIO " + portpower5radio
											+ ".\n Do you wish to continue?");
							
							if (opt) {
								var dummyportpower5radio = parseInt(portpower5radio,10);
								var hexportpower5radio = dummyportpower5radio.toString(16);
								deltaobj.push("prtpwr5usb3split", hexportpower5radio);
								modifiedWidgets.push("prtpwr5usb3split");
								portSplit5include = true;
								portSplittimeoutinclude = true;
							} else {
								portSplit5include = false;
								
								//User has chosen not to program; Do nothing
							}
						}
					}
				}
				
				//Port 6
				if ((value1 == "port6splitting")) {
					if(newval == 1) {
						var portpower6radio = $("#prtpwr6usb3splitgroup").find(':checked').val();
						var portpower6radio_old = getWidgetValue(HUB_ID, "prtpwr6usb3split");
						
						if ((portpower6radio === portpower6radio_old)) {
							//Old value and new value are the same; do nothing
							
						} else {
							var opt = confirm("Enabling port splitting on port 6 will disable the default function of GPIO " + portpower6radio
											+ ".\n Do you wish to continue?");
							
							
							if (opt) {
								deltaobj.push("prtpwr6usb3split", portpower6radio);
								modifiedWidgets.push("prtpwr6usb3split");
								portSplit6include = true;
								portSplittimeoutinclude = true;
								
							} else {
								portSplit6include = false;
								
								
								//User has chosen not to program; Do nothing
							}
						}
					}
				}
			
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				console.log("change detected but field disabled: widget:" + widgetgroupname + " new value:" + newval);// + " current value:" + val1 + " new value:" + newval1);
			}
			else
			{
				if ((value1 == "port5splitting")) {
					if(newval == 1) {
						var portpower5radio = $("#prtpwr5usb3splitgroup").find(':checked').val();
						var pstimeout = $("#pstimeoutgroup").find(':checked').val();
						
						if (typeof portpower5radio == 'undefined') {
							alert("Please choose a GPIO to support Port Power control in Port5");
							update_status_message("Please choose a GPIO to support Port Power control in Port5");
							errorFlag = true;
							return;
						}
						
						var opt = confirm("Enabling port splitting on port 5 will disable the default function of GPIO " + portpower5radio
											+ ".\n Do you wish to continue?");
						
						if (opt) {
							var dummyportpower5radio = parseInt(portpower5radio,10);
							var hexportpower5radio = dummyportpower5radio.toString(16);
							deltaobj.push("prtpwr5usb3split", hexportpower5radio);
							modifiedWidgets.push("prtpwr5usb3split");
						
							portSplit5include = true;
							portSplittimeoutinclude = true;
						} else {
							portSplit5include = false;
							
							//User has chosen not to program; Do nothing
						}
					}
					else
					{
						deltaobj.push("prtpwr5usb3split", 0);
						modifiedWidgets.push("prtpwr5usb3split");
						portSplit5include = true;
						portSplit5timeoutinclude = true;
					}
				}
				
				if ((value1 == "port6splitting")) {
					if(newval == 1) {
						var portpower6radio = $("#prtpwr6usb3splitgroup").find(':checked').val();
						var pstimeout = $("#pstimeoutgroup").find(':checked').val();
						if (typeof portpower6radio == 'undefined') {
							alert("Please choose a GPIO to support Port Power control in Port6");
							update_status_message("Please choose a GPIO to support Port Power control in Port6");
							errorFlag = true;
							return;
						}
						
						var opt = confirm("Enabling port splitting on port 6 will disable the default function of GPIO " + portpower6radio
											+ ".\n Do you wish to continue?");
						
						
						if (opt) {
							deltaobj.push("prtpwr6usb3split", portpower6radio);
							modifiedWidgets.push("prtpwr6usb3split");
							portSplittimeoutinclude = true;
							portSplit6include = true;
							
						} else {
							portSplit6include = false;
							
							
							//User has chosen not to program; Do nothing
						}
					}
					else
					{
						deltaobj.push("prtpwr6usb3split", 0);
						modifiedWidgets.push("prtpwr6usb3split");
						portSplit6include = true;
						portSplittimeoutinclude = true;
					}
				}
				if (value1 == "port5splitting") {
					if (portSplit5include) {
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
					}
					
				} else if (value1 == "port6splitting") {
					if (portSplit6include) {
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
					}
					
				} else {
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
				}
				
				if (value1 == "pstimeout") {
					if (portSplittimeoutinclude) {
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
						portSplittimeoutinclude = false;
					}
					
				}			
			}
		});
		
		var usb2portMap = [];
		var usb3portMap = [];
		var portMapValues = {};
		//DropDown
		$.each(GwidgetlistDropDown, function(index2, value1) {
			var nameofcontrol = "." + value1 + "1";
			var nameofcontrol1 = "[data-bind=\"" + value1 + "label\"]";
			var selText = $(nameofcontrol).find(nameofcontrol1).text();
			var newindexofdropdownlist;
			var that = $( nameofcontrol ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );

			if (value1 === "PHYBOOST" || value1 === "PHYBOOSTdownstreamport1" ||
				value1 === "PHYBOOSTdownstreamport2" || value1 === "PHYBOOSTdownstreamport3" ||
				value1 === "PHYBOOSTdownstreamport4" || value1 === "PHYBOOSTdownstreamport5" ||
				value1 === "PHYBOOSTdownstreamport6" || value1 === "PHYBOOSTdownstreamport7")
			{
				$.each(DropDownPHYBOOST, function(index, valuelist) {
					if ( selText === valuelist)
					{
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "SQUELCH" || value1 === "SQUELCHdownstreamport1" ||
				value1 === "SQUELCHdownstreamport2" || value1 === "SQUELCHdownstreamport3" ||
				value1 === "SQUELCHdownstreamport4" || value1 === "SQUELCHdownstreamport5" ||
				value1 === "SQUELCHdownstreamport6" || value1 === "SQUELCHdownstreamport7")
			{
				$.each(DropDownSQUELCH, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if(value1 === "upstreamHsRiseFall" || value1 === "downstreamport1HsRiseFall" ||
				value1 === "downstreamport2HsRiseFall" || value1 === "downstreamport3HsRiseFall" ||
				value1 === "downstreamport4HsRiseFall" || value1 === "downstreamport5HsRiseFall" ||
				value1 === "downstreamport6HsRiseFall" || value1 === "downstreamport7HsRiseFall")
			{
				$.each(DropDownHSRiseFall, function(index, valuelist) {
					if (selText == valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			
			if (value1 == "port1mapping"  || value1=="port2mapping"
			|| value1=="port3mapping" || value1=="port4mapping"
			|| value1=="port5mapping" || value1=="port6mapping"
			|| value1=="port7mapping")
			{
				$.each(DropDownPORTMAPPING, function( index, valuelist ) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
						usb2portMap.push(newindexofdropdownlist);
						portMapValues[value1] = newindexofdropdownlist;
					}
				});
			}
			
			if (value1=="usb3port1mapping"
			|| value1=="usb3port2mapping" || value1=="usb3port3mapping"
			|| value1=="usb3port4mapping" || value1=="usb3port5mapping"
			|| value1=="usb3port6mapping" || value1=="usb3port7mapping")
			{
				$.each(DropDownPORTMAPPING, function( index, valuelist ) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
						usb3portMap.push(newindexofdropdownlist);
						portMapValues[value1] = newindexofdropdownlist;
					}
				});
			}

			
			/*if (errorFlag == false) {
				for (var i = 0; i < (usb2portMap.length - 1); i++) {
					for (var j = i + 1; j < usb2portMap.length; j++) {
						if (usb2portMap[i] == usb2portMap[j]) {
							alert("Port Mapping for USB2.0 is not unique for each port. Please verify and retry.");
							update_status_message("Port Mapping for USB2.0 is not unique for each port. Please verify and retry.");
							errorFlag = true;
							return;
						}
					}
				}
				
				for (var i = 0; i < (usb3portMap.length - 1); i++) {
					for (var j = i + 1; j < usb3portMap.length; j++) {
						if (usb3portMap[i] == usb3portMap[j]) {
							alert("Port Mapping for USB3.0 Gen1 is not unique for each port. Please verify and retry.");
							update_status_message("Port Mapping for USB3.0 Gen1 is not unique for each port. Please verify and retry.");
							errorFlag = true;
							return;
						}
					}
				}
			}*/
			var oldval = getWidgetValue(HUB_ID, value1);

			if (newindexofdropdownlist || newindexofdropdownlist == 0) {
				if ((newindexofdropdownlist == oldval))
				{
					// no change
				} else if (checkdisabled) {
					// Change detected but field is disabled - So do nothing
					console.log("change detected but field disabled: widget:" + value1); // + " current value:" + val1 + " new value:" + newindexofdropdownlist);
				} else {
					deltaobj.push(value1, newindexofdropdownlist);
					modifiedWidgets.push(value1);
				}
			}
		});
		
		//Checkbox
		var usb3port1MapTemp = false;
		var usb3port2MapTemp = false;
		var usb3port3MapTemp = false;
		var usb3port4MapTemp = false;
		var usb3port5MapTemp = false;
		var usb3port6MapTemp = false;
		var usb3port7MapTemp = false;
		
		var port1MapTemp = false;
		var port2MapTemp = false;
		var port3MapTemp = false;
		var port4MapTemp = false;
		var port5MapTemp = false;
		var port6MapTemp = false;
		var port7MapTemp = false;

		$.each(GwidgetlistCheckbox, function( index2, value1 ) {
			var widgetid = "#" + value1;
			
			var oldval = getWidgetValue(HUB_ID, value1);
			var newval = checkbox_unchecked_value;
			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if($(widgetid).is(':checked'))
			{
				newval = checkbox_checked_value;
			}
			
			// Enabled - check the previous value and determine delta                              
			if (oldval == newval) {
				// do nothing - no change in value
				//console.log("Checkbox:nochange:widget:" + widget1 + " value:" + val1 + " new value:" + newval);
			} else if (checkdisabled) {
				// Change detected but field is disabled - So do nothing
				 console.log("change detected but field disabled: widget:" + value1 + " new value:" + newval);// + " current value:" + val1 + " new value:" + newval);
			} else {
				//checking condition for USB2.0 enable
				if ((value1 == "enableport1") && (!($('#enableport1').is(':checked')))) {
					if ($('#usb3enableport1').is(':checked')) {
						alert("Usb2.0 port of Port1 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port1 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport2") && (!($('#enableport2').is(':checked')))) {
					if ($('#usb3enableport2').is(':checked')) {
						alert("Usb2.0 port of Port2 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port2 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport3") && (!($('#enableport3').is(':checked')))) {
					if ($('#usb3enableport3').is(':checked')) {
						alert("Usb2.0 port of Port3 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port3 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport4") && (!($('#enableport4').is(':checked')))) {
					if ($('#usb3enableport4').is(':checked')) {
						alert("Usb2.0 port of Port4 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port4 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if (value1 == "enableport5") {
					var portSplitState = $('#port5splittinggroup').find(':checked').val();
					if (portSplitState == 1) {
						// No need to check for USB3 enable port.
					} else {
						if (!($('#enableport5').is(':checked'))) {
							if ($('#usb3enableport5').is(':checked')) {
								alert("Port splitting has been disabled. So Usb2.0 port of Port5 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
								update_status_message("Port splitting has been disabled. So Usb2.0 port of Port5 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
								errorFlag = true;
								return;
							}
						}
					}
				}
				
				if (value1 == "enableport6") {
					var portSplitState = $('#port6splittinggroup').find(':checked').val();
					if (portSplitState == 1) {
						// No need to check for USB3 enable port.
					} else {
						if (!($('#enableport6').is(':checked'))) {
							if ($('#usb3enableport6').is(':checked')) {
								alert("Port splitting has been disabled. So Usb2.0 port of Port6 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
								update_status_message("Port splitting has been disabled. So Usb2.0 port of Port6 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
								errorFlag = true;
								return;
							}
						}
					}
				}

				if (portsAvailable == 7) {
					if ((value1 == "enableport7") && (!($('#enableport7').is(':checked')))) {
						if ($('#usb3enableport7').is(':checked')) {
							alert("Usb2.0 port of Port7 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
							update_status_message("Usb2.0 port of Port7 cannot be disabled, when USB3.1 Gen1 port is still in enabled state.");
							errorFlag = true;
							return;
						}
					}
				}

				//Check for Non-removable parameter changes for all downstream port
				if (value1 == "nrdeviceport1") {
					nr1Modified = true;
					nrModified = true;
				} 
				if(value1 == "nrdeviceport2") {
					nr2Modified = true;
					nrModified = true;
					
				} 
				if(value1 == "nrdeviceport3") {
					nr3Modified = true;
					nrModified = true;
					
				} 
				if(value1 == "nrdeviceport4") {
					nr4Modified = true;
					nrModified = true;
					
				}
				if(value1 == "nrdeviceport5") {
					nr5Modified = true;
					nrModified = true;
					
				} 
				if(value1 == "nrdeviceport6") {
					nr6Modified = true;
					nrModified = true;
					
				} 
				
				if (portsAvailable == 7) {
					if(value1 == "nrdeviceport7") {
						nr7Modified = true;
						nrModified = true;
						
					}
				}
				
				if (value1 == "usb3nrdeviceport1") {
					usb3nr1Modified = true;
					usb3nrModified = true;
				} 
				if(value1 == "usb3nrdeviceport2") {
					usb3nr2Modified = true;
					usb3nrModified = true;
				} 
				if(value1 == "usb3nrdeviceport3") {
					usb3nr3Modified = true;
					usb3nrModified = true;
				} 
				if(value1 == "usb3nrdeviceport4") {
					usb3nr4Modified = true;
					usb3nrModified = true;
				}
				if(value1 == "usb3nrdeviceport5") {
					usb3nr5Modified = true;
					usb3nrModified = true;
				} 
				if(value1 == "usb3nrdeviceport6") {
					usb3nr6Modified = true;
					usb3nrModified = true;
				} 
				
				if (portsAvailable == 7) {
					if(value1 == "usb3nrdeviceport7") {
						usb3nr7Modified = true;
						usb3nrModified = true;
					}
				}
				
				if (value1 == "enableport1") {
					//deltaobj.push("port1mapping", portMapValues["port1mapping"]);
					nrModified = true;
					
				}
				
				if (value1 == "enableport2") {
					//deltaobj.push("port2mapping", portMapValues["port2mapping"]);
					nrModified = true;
					
				}
				
				if (value1 == "enableport3") {
					//deltaobj.push("port3mapping", portMapValues["port3mapping"]);
					nrModified = true;
					
				}
				
				if (value1 == "enableport4") {
					//deltaobj.push("port4mapping", portMapValues["port4mapping"]);
					nrModified = true;
					
				}
				
				if (value1 == "enableport5") {
					//deltaobj.push("port5mapping", portMapValues["port5mapping"]);
					nrModified = true;
					
				}
				
				if (value1 == "enableport6") {
					//deltaobj.push("port6mapping", portMapValues["port6mapping"]);
					nrModified = true;
					
				}
				
				if (portsAvailable == 7) {
					if (value1 == "enableport7") {
						//deltaobj.push("port7mapping", portMapValues["port7mapping"]);
						nrModified = true;
						
					}
				}
				
				// USB2.0 enable port conditions
				if ((value1 == "enableport1")) {// || (value1 == "usb3nrdeviceport1")) {
					if (value1 == "enableport1") {
						if (newval == 0) {
							port1MapTemp = true;
						} /*else {
							usb3port1MapTemp = portMapValues["usb3port1mapping"];
						}*/
					}
					nrModified = true;
				}
				
				if ((value1 == "enableport2")) {// || (value1 == "usb3nrdeviceport2")) {
					if (value1 == "enableport2") {
						if (newval == 0) {
							port2MapTemp = true;
						} /*else {
							usb3port2MapTemp = portMapValues["usb3port2mapping"];
						}*/
					}
					nrModified = true;
				}
				
				if ((value1 == "enableport3")) {// || (value1 == "usb3nrdeviceport3")) {
					if (value1 == "enableport3") {
						if (newval == 0) {
							port3MapTemp = true;
						} /*else {
							usb3port3MapTemp = portMapValues["usb3port3mapping"];
						}*/
					}
					nrModified = true;
				}
				
				if ((value1 == "enableport4")) {// || (value1 == "usb3nrdeviceport4")) {
					if (value1 == "enableport4") {
						if (newval == 0) {
							port4MapTemp = true;
						} /*else {
							usb3port4MapTemp = portMapValues["usb3port4mapping"];
						}*/
					}
					nrModified = true;
				}
				
				if ((value1 == "enableport5")) {// || (value1 == "usb3nrdeviceport5")) {
					if (value1 == "enableport5") {
						if (newval == 0) {
							port5MapTemp = true;
						} /*else {
							usb3port5MapTemp = portMapValues["usb3port5mapping"];
						}*/
					}
					nrModified = true;
				}
				
				if ((value1 == "enableport6")) {// || (value1 == "usb3nrdeviceport6")) {
					if (value1 == "enableport6") {
						if (newval == 0) {
							port6MapTemp = true;
						} /*else {
							usb3port6MapTemp = portMapValues["usb3port6mapping"];
						}*/
					}
					nrModified = true;
				}
				
				if (portsAvailable == 7) {
					
					if ((value1 == "enableport7")) {//|| (value1 == "usb3nrdeviceport7")) {
						if (value1 == "enableport7") {
							if (newval == 0) {
								port7MapTemp = true;
							} /*else {
								usb3port7MapTemp = portMapValues["usb3port7mapping"];
							}*/
						}
						nrModified = true;
					}
				}
				
				
				
				// USB2.0 enable port condition END

				if ((value1 == "usb3enableport1")) {// || (value1 == "usb3nrdeviceport1")) {
					if (value1 == "usb3enableport1") {
						if (newval == 0) {
							usb3port1MapTemp = true;
						} /*else {
							usb3port1MapTemp = portMapValues["usb3port1mapping"];
						}*/
					}
					usb3nrModified = true;
				}
				
				if ((value1 == "usb3enableport2")) {// || (value1 == "usb3nrdeviceport2")) {
					if (value1 == "usb3enableport2") {
						if (newval == 0) {
							usb3port2MapTemp = true;
						} /*else {
							usb3port2MapTemp = portMapValues["usb3port2mapping"];
						}*/
					}
					usb3nrModified = true;
				}
				
				if ((value1 == "usb3enableport3")) {// || (value1 == "usb3nrdeviceport3")) {
					if (value1 == "usb3enableport3") {
						if (newval == 0) {
							usb3port3MapTemp = true;
						} /*else {
							usb3port3MapTemp = portMapValues["usb3port3mapping"];
						}*/
					}
					usb3nrModified = true;
				}
				
				if ((value1 == "usb3enableport4")) {// || (value1 == "usb3nrdeviceport4")) {
					if (value1 == "usb3enableport4") {
						if (newval == 0) {
							usb3port4MapTemp = true;
						} /*else {
							usb3port4MapTemp = portMapValues["usb3port4mapping"];
						}*/
					}
					usb3nrModified = true;
				}
				
				if ((value1 == "usb3enableport5")) {// || (value1 == "usb3nrdeviceport5")) {
					if (value1 == "usb3enableport5") {
						if (newval == 0) {
							usb3port5MapTemp = true;
						} /*else {
							usb3port5MapTemp = portMapValues["usb3port5mapping"];
						}*/
					}
					usb3nrModified = true;
				}
				
				if ((value1 == "usb3enableport6")) {// || (value1 == "usb3nrdeviceport6")) {
					if (value1 == "usb3enableport6") {
						if (newval == 0) {
							usb3port6MapTemp = true;
						} /*else {
							usb3port6MapTemp = portMapValues["usb3port6mapping"];
						}*/
					}
					usb3nrModified = true;
				}
				
				if (portsAvailable == 7) {
					
					if ((value1 == "usb3enableport7")) {//|| (value1 == "usb3nrdeviceport7")) {
						if (value1 == "usb3enableport7") {
							if (newval == 0) {
								usb3port7MapTemp = true;
							} /*else {
								usb3port7MapTemp = portMapValues["usb3port7mapping"];
							}*/
						}
						usb3nrModified = true;
					}
				}
				
				//Check for Flexconnect enable or disable
				if ((value1 == "flexconnect") && (newval == checkbox_checked_value)) {
					enableFlex = true;
					disableFlex = false;
				} else if ((value1 == "flexconnect") && (newval == checkbox_unchecked_value)) {
					enableFlex = false;
					disableFlex = true;
				} else {
					enableFlex = false;
					disableFlex = false;
				}
				
				//Check for Upstream D+/D- swap
				if ((value1 == "swapupstreamdpdm") && (newval == checkbox_checked_value)) {
					enable_swapupstreamdpdm = true;
				} else {
					enable_swapupstreamdpdm = false;
				}
				
				if ((value1 == "lpmenable") && (newval == checkbox_checked_value)) {
					
					enable_lpm = true;
				} else {
					enable_lpm = false;
				}
				//alert("enable_lpm"+enable_lpm);

				// Specific to USB 2.0
				if( (value1 == "enableport1") || (value1 == "enableport2") 
				|| (value1 == "enableport3")  || (value1 == "enableport4") 
				|| (value1 == "enableport5")  || (value1 == "enableport6")
				|| (value1 == "enableport7"))
				{
					if (!SendNoofPorts && !numberofportState)
					{
						if(($('#nrdeviceport1').is(':checked')) || ($('#nrdeviceport2').is(':checked')) || 
						($('#nrdeviceport3').is(':checked')) || ($('#nrdeviceport4').is(':checked')) ||
						($('#nrdeviceport5').is(':checked')) || ($('#nrdeviceport6').is(':checked')) ||
						($('#nrdeviceport7').is(':checked')))
						{
							nrModified = true;
						}
						deltaobj.push("numberofports",bTotal);
						enableMapping = true;
						SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
					}
				}
				
				// Specific to USB 3.1 Gen 1
				if( (value1 == "usb3enableport1") || (value1 == "usb3enableport2") 
				|| (value1 == "usb3enableport3")  || (value1 == "usb3enableport4") 
				|| (value1 == "usb3enableport5")  || (value1 == "usb3enableport6")
				|| (value1 == "usb3enableport7"))
				{
					if (!usb3SendNoofPorts && !usb3numberofportState)
					{
						if(($('#usb3nrdeviceport1').is(':checked')) || ($('#usb3nrdeviceport2').is(':checked')) || 
						($('#usb3nrdeviceport3').is(':checked')) || ($('#usb3nrdeviceport4').is(':checked')) ||
						($('#usb3nrdeviceport5').is(':checked')) || ($('#usb3nrdeviceport6').is(':checked')) ||
						($('#usb3nrdeviceport7').is(':checked')))
						{
							usb3nrModified = true;
						}
						deltaobj.push("usb3numberofports", usb3bTotal);
						enableMapping = true;
						usb3SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
					}
				}
				
				//Check flexconnect condition
				if (enableFlex) { //(value1 == "flexconnect") {
					if ($('#enableport1').is(':checked')) {
						alert("Enabling Flexconnect will swap Downstream port 1 with Upstream port. Please make required changes in hub for further processing after successful programming");
						deltaobj.push("flexconnect", newval);
						modifiedWidgets.push("flexconnect");
					} else {
						alert("Downstream port 1 is disabled. Flex connect cannot be done. \n Enable Downstream port 1 and try again.");
						errorFlag = true;
						return;
					}
				} else if (value1 == "swapupstreamdpdm") {
					if ($('#swapupstreamdpdm').is(':checked')) {
						alert("Programming Upstream swap will swap D+ and D- lines of Upstream port. Please make the required changes in hub for further processing after successful programming");
					}
					deltaobj.push("swapupstreamdpdm", newval);
					modifiedWidgets.push("swapupstreamdpdm");
				} else {
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
				}
			}
		});

		if(enablealertmanu && enablealertmanu && enablealertmanu) {
			var manuval = $("#hce_manufacturer").val();
			var prodval = $("#hce_product").val();
			var serval = $("#hce_serial").val();
			
			if((manuval != stringnullvalue) && (prodval != stringnullvalue) && (serval != stringnullvalue)) {
				window.alert("Only two strings can be enabled at a time for Hub Feature Controller.");
				update_status_message("Error : Only two strings can be enabled at a time for Hub Feature Controller.");
				enablealertmanu = false;
				enablealertmanu = false;
				enablealertmanu = false;
				hceenablemanu = false;
				hceenableprod = false;
				hceenableser = false;
				hceStringFlag = false;
				errorFlag = true;
				return;
			}
				
		}
		if(hceenablemanu || hceenableprod || hceenableser) {
			var manuval = $("#hce_manufacturer").val();
			var prodval = $("#hce_product").val();
			var serval = $("#hce_serial").val();
			var manlen = manuval.length;
			var prodlen = prodval.length;
			var serlen = serval.length;
			
			
			if(manuval == stringnullvalue) {
				manuval = "";
				manlen = 0;
			} else if(prodval == stringnullvalue) {
				prodval = "";
				prodlen = 0;
			} else if(serval == stringnullvalue) {
				serval = "";
				serlen = 0;
			}
			
			//console.log("Also updating :" + lenwidget + " new value:" + len);
			deltaobj.push("hce_manufacturerlen",manlen);
			deltaobj.push("hce_productlen",prodlen);
			deltaobj.push("hce_seriallen",serlen);
			deltaobj.push("hce_manufacturer", manuval);
			modifiedWidgets.push("hce_manufacturer");
			deltaobj.push("hce_product", prodval);
			modifiedWidgets.push("hce_product");
			deltaobj.push("hce_serial", serval);
			modifiedWidgets.push("hce_serial");
			hceenablemanu = false;
			hceenableprod = false;
			hceenableser = false;
			enablealertmanu = false;
			enablealertmanu = false;
			enablealertmanu = false;
		}
		
		if (enableMapping == true) {
		
		var usb3portmapcount = 1;
		var usb2portmapcount = 1;
		var usb2port1MapLaterFlag = false;
		var usb2port2MapLaterFlag = false;
		var usb2port3MapLaterFlag = false;
		var usb2port4MapLaterFlag = false;
		var usb2port5MapLaterFlag = false;
		var usb2port6MapLaterFlag = false;
		var usb2port7MapLaterFlag = false;
		var currentStartPoint = 0;

		if(!bEnable1 && !usb3bEnable1)
		{
			deltaobj.push("usb3port1mapping", 0);
			deltaobj.push("port1mapping", 0);
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}

			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port5
			if(bEnable5 && usb3bEnable5) {
				deltaobj.push("usb3port5mapping", usb3portmapcount++);
				deltaobj.push("port5mapping", usb2portmapcount++);
				currentStartPoint = 5;
			} else if(usb3bEnable5) {
				deltaobj.push("usb3port5mapping", usb3portmapcount++);
				var portSplitState = $('#port5splittinggroup').find(':checked').val();
				if (!bEnable5) {
					if (portSplitState == 1) {
						deltaobj.push("port5mapping", 0);
					}
				} else {
					if (portSplitState == 1) {
						deltaobj.push("port5mapping", (usb3portmapcount - 1));
					}
				}
				
			} else if (!usb3bEnable5){
				deltaobj.push("usb3port5mapping", 0);
				if(bEnable5) {
					usb2port5MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port5mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port6
			if(bEnable6 && usb3bEnable6) {
				deltaobj.push("usb3port6mapping", usb3portmapcount++);
				deltaobj.push("port6mapping", usb2portmapcount++);
				currentStartPoint = 6;
			} else if(usb3bEnable6) {
				deltaobj.push("usb3port6mapping", usb3portmapcount++);
				var portSplitState = $('#port6splittinggroup').find(':checked').val();
				if (!bEnable6) {
					if (portSplitState == 1) {
						deltaobj.push("port6mapping", 0);
					}
				} else {
					if (portSplitState == 1) {
						deltaobj.push("port6mapping", (usb3portmapcount - 1));
					}
				}
				
			} else if (!usb3bEnable6){
				deltaobj.push("usb3port6mapping", 0);
				if(bEnable6) {
					usb2port6MapLaterFlag = true;
				} else {
					deltaobj.push("port6mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port7
			if(bEnable7 && usb3bEnable7) {
				deltaobj.push("usb3port7mapping", usb3portmapcount++);
				deltaobj.push("port7mapping", usb2portmapcount++);
				currentStartPoint = 7;
			}else if(usb3bEnable7) {
				deltaobj.push("usb3port7mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable7){
				deltaobj.push("usb3port7mapping", 0);
				if(bEnable7) {
					usb2port7MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port7mapping", 0);
				}
			} else {
				//Do nothing
			}
			// USB2.0 Port mapping
			
			
			if (currentStartPoint == 7) {
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}
				
				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 6) {
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 5) {
				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 4) {
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
			}
			
		} else if (bEnable1 && !usb3bEnable1) {
			deltaobj.push("usb3port1mapping", 0);
			usb2port1MapLaterFlag = true;
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}

			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port5
			if(bEnable5 && usb3bEnable5) {
				deltaobj.push("usb3port5mapping", usb3portmapcount++);
				deltaobj.push("port5mapping", usb2portmapcount++);
				currentStartPoint = 5;
			} else if(usb3bEnable5) {
				deltaobj.push("usb3port5mapping", usb3portmapcount++);
				var portSplitState = $('#port5splittinggroup').find(':checked').val();
				if (!bEnable5) {
					if (portSplitState == 1) {
						deltaobj.push("port5mapping", 0);
					}
				} else {
					if (portSplitState == 1) {
						deltaobj.push("port5mapping", (usb3portmapcount - 1));
					}
				}
				
			} else if (!usb3bEnable5){
				deltaobj.push("usb3port5mapping", 0);
				if(bEnable5) {
					usb2port5MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port5mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port6
			if(bEnable6 && usb3bEnable6) {
				deltaobj.push("usb3port6mapping", usb3portmapcount++);
				deltaobj.push("port6mapping", usb2portmapcount++);
				currentStartPoint = 6;
			} else if(usb3bEnable6) {
				deltaobj.push("usb3port6mapping", usb3portmapcount++);
				var portSplitState = $('#port6splittinggroup').find(':checked').val();
				if (!bEnable6) {
					if (portSplitState == 1) {
						deltaobj.push("port6mapping", 0);
					}
				} else {
					if (portSplitState == 1) {
						deltaobj.push("port6mapping", (usb3portmapcount - 1));
					}
				}
				
			} else if (!usb3bEnable6){
				deltaobj.push("usb3port6mapping", 0);
				if(bEnable6) {
					usb2port6MapLaterFlag = true;
				} else {
					deltaobj.push("port6mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port7
			if(bEnable7 && usb3bEnable7) {
				deltaobj.push("usb3port7mapping", usb3portmapcount++);
				deltaobj.push("port7mapping", usb2portmapcount++);
				currentStartPoint = 7;
			}else if(usb3bEnable7) {
				deltaobj.push("usb3port7mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable7){
				deltaobj.push("usb3port7mapping", 0);
				if(bEnable7) {
					usb2port7MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port7mapping", 0);
				}
			} else {
				//Do nothing
			}
			// USB2.0 Port mapping
			
			
			if (currentStartPoint == 7) {
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}
				
				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 6) {
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 5) {
				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 4) {
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
			}
		} else if (bEnable1 && usb3bEnable1) {
			currentStartPoint = 1;
			deltaobj.push("usb3port1mapping", usb3portmapcount++);
			deltaobj.push("port1mapping", usb2portmapcount++);
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}

			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port5
			if(bEnable5 && usb3bEnable5) {
				deltaobj.push("usb3port5mapping", usb3portmapcount++);
				deltaobj.push("port5mapping", usb2portmapcount++);
				currentStartPoint = 5;
			} else if(usb3bEnable5) {
				deltaobj.push("usb3port5mapping", usb3portmapcount++);
				var portSplitState = $('#port5splittinggroup').find(':checked').val();
				if (!bEnable5) {
					if (portSplitState == 1) {
						deltaobj.push("port5mapping", 0);
					}
				} else {
					if (portSplitState == 1) {
						deltaobj.push("port5mapping", (usb3portmapcount - 1));
					}
				}
				
			} else if (!usb3bEnable5){
				deltaobj.push("usb3port5mapping", 0);
				if(bEnable5) {
					usb2port5MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port5mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port6
			if(bEnable6 && usb3bEnable6) {
				deltaobj.push("usb3port6mapping", usb3portmapcount++);
				deltaobj.push("port6mapping", usb2portmapcount++);
				currentStartPoint = 6;
			} else if(usb3bEnable6) {
				deltaobj.push("usb3port6mapping", usb3portmapcount++);
				var portSplitState = $('#port6splittinggroup').find(':checked').val();
				if (!bEnable6) {
					if (portSplitState == 1) {
						deltaobj.push("port6mapping", 0);
					}
				} else {
					if (portSplitState == 1) {
						deltaobj.push("port6mapping", (usb3portmapcount - 1));
					}
				}
				
			} else if (!usb3bEnable6){
				deltaobj.push("usb3port6mapping", 0);
				if(bEnable6) {
					usb2port6MapLaterFlag = true;
				} else {
					deltaobj.push("port6mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			//handling port7
			if(bEnable7 && usb3bEnable7) {
				deltaobj.push("usb3port7mapping", usb3portmapcount++);
				deltaobj.push("port7mapping", usb2portmapcount++);
				currentStartPoint = 7;
			}else if(usb3bEnable7) {
				deltaobj.push("usb3port7mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable7){
				deltaobj.push("usb3port7mapping", 0);
				if(bEnable7) {
					usb2port7MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port7mapping", 0);
				}
			} else {
				//Do nothing
			}
			// USB2.0 Port mapping
			
			
			if (currentStartPoint == 7) {
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}
				
				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 6) {
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 5) {
				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 4) {
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port5MapLaterFlag) {
					deltaobj.push("port5mapping", usb2portmapcount++);
				}

				if (usb2port6MapLaterFlag) {
					deltaobj.push("port6mapping", usb2portmapcount++);
				}
				
				if (usb2port7MapLaterFlag) {
					deltaobj.push("port7mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
			}
		}
	}
	
		
		if (enable_lpm) {
				
				alert("The change in LPM Enable will cause change in the USB bcdUSB");
				update_status_message("The change in LPM Enable will cause change in the USB bcdUSB");
			}
			//Adding non-removable state of all downstream ports depending on the state of "nrModified"
		if (nrModified) {
			//Sending all the port mapping for USB3.1 Gen1
			if (port1MapTemp) {
				deltaobj.push("port1mapping", "0");
			} else {
				if (portMapValues["port1mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 1 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 1 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("port1mapping", portMapValues["port1mapping"]);
			}
			
			if (port2MapTemp) {
				deltaobj.push("port2mapping", "0");
			} else {
				if (portMapValues["port2mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 2 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 2 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("port2mapping", portMapValues["port2mapping"]);
			}
			
			if (port3MapTemp) {
				deltaobj.push("port3mapping", "0");
			} else {
				if (portMapValues["port3mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 3 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 3 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("port3mapping", portMapValues["port3mapping"]);
			}
			
			if (port4MapTemp) {
				deltaobj.push("port4mapping", "0");
			} else {
				if (portMapValues["port4mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 4 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 4 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("port4mapping", portMapValues["port4mapping"]);
			}
			
			if (port5MapTemp) {
				deltaobj.push("port5mapping", "0");
			} else {
				if (portMapValues["port5mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 5 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 5 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("port5mapping", portMapValues["port5mapping"]);
			}
			
			if (port6MapTemp) {
				deltaobj.push("port6mapping", "0");
			} else {
				if (portMapValues["port6mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 6 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 6 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("port6mapping", portMapValues["port6mapping"]);
			}
			
			if (portsAvailable == 7) {
				if (port7MapTemp) {
					deltaobj.push("port7mapping", "0");
				} else {
					if (portMapValues["port7mapping"] == 0) {
					alert("USB2.0 Port Mapping for Port 7 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB2.0 Port Mapping for Port 7 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
					deltaobj.push("port7mapping", portMapValues["port7mapping"]);
				}
			}

			var nr1 = ($("#nrdeviceport1").is(':checked'))?"1":"0";
			var nr2 = ($("#nrdeviceport2").is(':checked'))?"1":"0";
			var nr3 = ($("#nrdeviceport3").is(':checked'))?"1":"0";
			var nr4 = ($("#nrdeviceport4").is(':checked'))?"1":"0";
			var nr5 = ($("#nrdeviceport5").is(':checked'))?"1":"0";
			var nr6 = ($("#nrdeviceport6").is(':checked'))?"1":"0";
			var nr7;
			if (portsAvailable == 7) {
				nr7 = ($("#nrdeviceport7").is(':checked'))?"1":"0";
			}
			
			if(bEnable1 === true )
			{
				if(nr1Modified === false)
				{
					deltaobj.push("nrdeviceport1", nr1);
				}else{
				}
			} else {
				if(nr1Modified === false)
				{
					if (nr1UserModified) {
						modifiedWidgets.push("nrdeviceport1");
					}
					deltaobj.push("nrdeviceport1", 0);
				}else{
				}
			}
			if(bEnable2 === true)
			{
				if(nr2Modified === false)
				{
					deltaobj.push("nrdeviceport2", nr2);
				}else{
				}
			} else {
				if(nr2Modified === false)
				{
					if (nr2UserModified) {
						modifiedWidgets.push("nrdeviceport2");
					}
					deltaobj.push("nrdeviceport2", 0);
				}else{
				}
			}
			if(bEnable3 === true )
			{
				if(nr3Modified === false)
				{
					deltaobj.push("nrdeviceport3", nr3);
				}else{
				}
			} else {
				if(nr3Modified === false)
				{
					if (nr3UserModified) {
						modifiedWidgets.push("nrdeviceport3");
					}
					deltaobj.push("nrdeviceport3", 0);
				}else{
				}
			}
			if(bEnable4 === true )
			{
				if(nr4Modified === false)
				{
					deltaobj.push("nrdeviceport4", nr4);
				}else{
				}
			}else {
				if(nr4Modified === false)
				{
					if (nr4UserModified) {
						modifiedWidgets.push("nrdeviceport4");
					}
					deltaobj.push("nrdeviceport4", 0);
				}else{
				}
			}
			
			if(bEnable5 === true)
			{
				if(nr5Modified === false)
				{
					deltaobj.push("nrdeviceport5", nr5);
				}else{
				}
			} else {
				if(nr5Modified === false)
				{
					if (nr5UserModified) {
						modifiedWidgets.push("nrdeviceport5");
					}
					deltaobj.push("nrdeviceport5", 0);
				}else{
				}
			}
			if(bEnable6 === true )
			{
				if(nr6Modified === false)
				{
					deltaobj.push("nrdeviceport6", nr6);
				}else{
				}
			} else {
				if(nr6Modified === false)
				{
					if (nr6UserModified) {
						modifiedWidgets.push("nrdeviceport6");
					}
					deltaobj.push("nrdeviceport6", 0);
				}else{
				}
			}
			
			if (portsAvailable == 7) {
				if(bEnable7 === true )
				{
					if(nr7Modified === false)
					{
						deltaobj.push("nrdeviceport7", nr7);
					}else{
					}
				}else {
					if(nr7Modified === false)
					{
						if (nr7UserModified) {
							modifiedWidgets.push("nrdeviceport7");
						}
						deltaobj.push("nrdeviceport7", 0);
					}else{
					}
				}
			}
			nrModified = false;
			nr1Modified = false;
			nr2Modified = false;
			nr3Modified = false;
			nr4Modified = false;
			nr5Modified = false;
			nr6Modified = false;
			nr7Modified = false;
		}
		
		if (usb3nrModified) {
			//Sending all the port mapping for USB3.1 Gen1
			if (usb3port1MapTemp) {
				deltaobj.push("usb3port1mapping", "0");
			} else {
				if (portMapValues["usb3port1mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 1 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 1 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("usb3port1mapping", portMapValues["usb3port1mapping"]);
			}
			
			if (usb3port2MapTemp) {
				deltaobj.push("usb3port2mapping", "0");
			} else {
				if (portMapValues["usb3port2mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 2 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 2 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("usb3port2mapping", portMapValues["usb3port2mapping"]);
			}
			
			if (usb3port3MapTemp) {
				deltaobj.push("usb3port3mapping", "0");
			} else {
				if (portMapValues["usb3port3mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 3 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 3 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("usb3port3mapping", portMapValues["usb3port3mapping"]);
			}
			
			if (usb3port4MapTemp) {
				deltaobj.push("usb3port4mapping", "0");
			} else {
				if (portMapValues["usb3port4mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 4 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 4 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("usb3port4mapping", portMapValues["usb3port4mapping"]);
			}
			
			if (usb3port5MapTemp) {
				deltaobj.push("usb3port5mapping", "0");
			} else {
				if (portMapValues["usb3port5mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 5 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 5 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("usb3port5mapping", portMapValues["usb3port5mapping"]);
			}
			
			if (usb3port6MapTemp) {
				deltaobj.push("usb3port6mapping", "0");
			} else {
				if (portMapValues["usb3port6mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 6 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 6 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
				deltaobj.push("usb3port6mapping", portMapValues["usb3port6mapping"]);
			}
			
			if (portsAvailable == 7) {
				if (usb3port7MapTemp) {
					deltaobj.push("usb3port7mapping", "0");
				} else {
					if (portMapValues["usb3port7mapping"] == 0) {
					alert("USB3.1 Gen1 Port Mapping for Port 7 cannot be \"0\". Please choose appropriate mapping.");
					update_status_message("USB3.1 Gen1 Port Mapping for Port 7 cannot be \"0\". Please choose appropriate mapping.");
					return;
				}
					deltaobj.push("usb3port7mapping", portMapValues["usb3port7mapping"]);
				}
			}

			var usb3nr1 = ($("#usb3nrdeviceport1").is(':checked'))?"1":"0";
			var usb3nr2 = ($("#usb3nrdeviceport2").is(':checked'))?"1":"0";
			var usb3nr3 = ($("#usb3nrdeviceport3").is(':checked'))?"1":"0";
			var usb3nr4 = ($("#usb3nrdeviceport4").is(':checked'))?"1":"0";
			var usb3nr5 = ($("#usb3nrdeviceport5").is(':checked'))?"1":"0";
			var usb3nr6 = ($("#usb3nrdeviceport6").is(':checked'))?"1":"0";
			var usb3nr7;
			if (portsAvailable == 7) {
				usb3nr7 = ($("#usb3nrdeviceport7").is(':checked'))?"1":"0";
			}
			
			if(usb3bEnable1 === true )
			{
				if(usb3nr1Modified === false)
				{
					deltaobj.push("usb3nrdeviceport1", usb3nr1);
				}else{
				}
			} else {
				if(usb3nr1Modified === false)
				{
					if (usb3nr1UserModified) {
						modifiedWidgets.push("usb3nrdeviceport1");
					}
					deltaobj.push("usb3nrdeviceport1", 0);
				}else{
				}
			}
			if(usb3bEnable2 === true)
			{
				if(usb3nr2Modified === false)
				{
					deltaobj.push("usb3nrdeviceport2", usb3nr2);
				}else{
				}
			} else {
				if(usb3nr2Modified === false)
				{
					if (usb3nr2UserModified) {
						modifiedWidgets.push("usb3nrdeviceport2");
					}
					deltaobj.push("usb3nrdeviceport2", 0);
				}else{
				}
			}
			if(usb3bEnable3 === true )
			{
				if(usb3nr3Modified === false)
				{
					deltaobj.push("usb3nrdeviceport3", usb3nr3);
				}else{
				}
			} else {
				if(usb3nr3Modified === false)
				{
					if (usb3nr3UserModified) {
						modifiedWidgets.push("usb3nrdeviceport3");
					}
					deltaobj.push("usb3nrdeviceport3", 0);
				}else{
				}
			}
			if(usb3bEnable4 === true )
			{
				if(usb3nr4Modified === false)
				{
					deltaobj.push("usb3nrdeviceport4", usb3nr4);
				}else{
				}
			}else {
				if(usb3nr4Modified === false)
				{
					if (usb3nr4UserModified) {
						modifiedWidgets.push("usb3nrdeviceport4");
					}
					deltaobj.push("usb3nrdeviceport4", 0);
				}else{
				}
			}
			
			if(usb3bEnable5 === true)
			{
				if(usb3nr5Modified === false)
				{
					deltaobj.push("usb3nrdeviceport5", usb3nr5);
				}else{
				}
			} else {
				if(usb3nr5Modified === false)
				{
					if (usb3nr5UserModified) {
						modifiedWidgets.push("usb3nrdeviceport5");
					}
					deltaobj.push("usb3nrdeviceport5", 0);
				}else{
				}
			}
			if(usb3bEnable6 === true )
			{
				if(usb3nr6Modified === false)
				{
					deltaobj.push("usb3nrdeviceport6", usb3nr6);
				}else{
				}
			} else {
				if(usb3nr6Modified === false)
				{
					if (usb3nr6UserModified) {
						modifiedWidgets.push("usb3nrdeviceport6");
					}
					deltaobj.push("usb3nrdeviceport6", 0);
				}else{
				}
			}
			if (portsAvailable == 7) {
				if(usb3bEnable7 === true )
				{
					if(usb3nr7Modified === false)
					{
						deltaobj.push("usb3nrdeviceport7", usb3nr7);
					}else{
					}
				}else {
					if(usb3nr7Modified === false)
					{
						if (usb3nr7UserModified) {
							modifiedWidgets.push("usb3nrdeviceport7");
						}
						deltaobj.push("usb3nrdeviceport7", 0);
					}else{
					}
				}
			}
			usb3nrModified = false;
			usb3nr1Modified = false;
			usb3nr2Modified = false;
			usb3nr3Modified = false;
			usb3nr4Modified = false;
			usb3nr5Modified = false;
			usb3nr6Modified = false;
			usb3nr7Modified = false;
		}
		
		var stringToSet = "";
		var wKey;
		var wVal;
		var flag = 0;
		
		//for (var i = 0; i < deltaobj.length; i = i + 2) {
		if (deltaobj.length != 0) {
			for (var i = deltaobj.length; i >= 0; i = i - 2) {
				wKey = deltaobj[i];
				wVal = deltaobj[i+1];
				if ((typeof wKey === 'undefined') || (typeof wVal === 'undefined')) {
					// Do nothing
				} else {
					stringToSet = wKey + ",,," + wVal + ";;;" + stringToSet;
					flag++;
				}
			}
		}

		if (iniFile) {
			iniFile_fullPath = getFullPathINI();
			modifiedWidgets.push("xdataprogram");
			stringToSet = "xdataprogram,,," + iniFile_fullPath + ";;;" + stringToSet;
			flag++;
		}
		
		if (($("#Regoperationgroup").find(':checked').val()) && ($("#Regaddress").val()) && ($("#Regvalue").val())) {
			var regOptionChosen = $("#Regoperationgroup").find(':checked').val();
			
			if (typeof regOptionChosen === 'undefined') {
				alert("Please choose an appropriate action under the Direct Register Access.");
				errorFlag = true;
				return;
			}
		
			if(regOptionChosen == 0)
			{
				Regop = "XMODE_WRITE_BYTE";
			}
			else if(regOptionChosen == 1)
			{
				Regop = "XMODE_SET_BITS";
			}
			else if(regOptionChosen == 2)
			{
				Regop = "XMODE_CLEAR_BITS"
			}
			else
			{
				Regop = "";
				//do nothing
			}
			var Regadd = $("#Regaddress").val();
			var isOKAddr = /^[0-9A-Fa-f]{4}$/i.test(Regadd);
			var RegVal = $("#Regvalue").val();
			var newRegVal = RegVal.replace(/\s+/g, "");
			var isOKVal = /^[0-9A-Fa-f]+$/i.test(newRegVal);
			
			if ((Regadd == "") || (RegVal == "")) {
				alert("Either the value of register address or the register value is not entered under the Direct Register Access.");
				errorFlag = true;
				return;
			}
			
			if (!isOKAddr) {
				alert("The Register Address entered under the Direct Register Access must be a 4 digit hexadecimal number.");
				errorFlag = true;
				return;
			}
			
			if (!isOKVal) {
				alert("The Register value entered under the Direct Register Access is not a valid hexadecimal number.");
				errorFlag = true;
				return;
			}
			
			if (isOKAddr && isOKVal) {
				if (Regop.length == 0) {
					alert("Please choose appropriate register operation.");
					errorFlag = true;
					return
				} else {
					if (Regadd && RegVal) {
						if (RegString) {
							RegString = Regop + "+" + Regadd + "+" + newRegVal + "+" + RegString;
						} else {
							RegString = Regop + "+" + Regadd + "+" + newRegVal;
						}
					} else {
						alert("Either Register address or Register value is not added.");
						errorFlag = true;
						return;
					}
				}
			}
		}

		if (RegString) {
			stringToSet = "xdataentry,,," + RegString + ";;;" + stringToSet;
			modifiedWidgets.push("xdataentry");
			flag++;
		}

		// dont call service if no change
		if (showPreview) {
			showPreview = false;
			if (flag != 0) {
				var fileSize = previewSetWidgetValue(HUB_ID, stringToSet);
				//Get Current OTP information
				var info = get_otp_info(HUB_ID);					
				if (info) {
					var otp_info = info.split("###");
					var otpSize = otp_info[0];
					//var ConfigBlockCnt = otp_info[1];
					//var ConfigRemainCnt = otp_info[2];
					//var ProgrammedByteCnt = otp_info[3];

					var previewPercentage = ((fileSize / otpSize) * 100)  + percentage;
					
					//alert("No of bytes to be programmed: " + fileSize + "% of OTP memory to be used: " + previewPercentage.toFixed(2) + "%");
					//$("#previewPrecent").val((previewPercentage).toFixed(2));
					//if (Product == "USB3.1 Gen1") {
					$("#progressbarPreview3").css('width',(previewPercentage).toFixed(2) + "%");
					$("#progressbarPreview3").css('color', 'black');
					$("#progressbarPreview3").css({'background-image': 'none','background-color': 'yellow'});
					$("#progressbarPreview3").html("<p align=\"center\">"+ (previewPercentage).toFixed(2) + "%" +"<p>");
					//}

					$("#bytesProgrammed").val(fileSize);
					$('#previewChangesField').show();
					//toggleOverlay();
				}
				update_status_message("No of bytes to be programmed: " + fileSize + ". Percentage of OTP memory to be used: " + previewPercentage.toFixed(2));
			} else {
				alert("No Changes detected. Cannot show preview.");
			}
		} else {
			//alert("99" + errorFlag);
			if (flag == 0 && errorFlag == false)
			{
				//alert("999" + errorFlag);
				window.setTimeout(function(){
				  $('#myprogress .progress-bar').css('width', 100+'%').attr('aria-valuenow', 100);
				}, 500); 
				alert("Device configuration will not be changed ; No changes detected");
				var mesg = "Device configuration will not be changed ; No changes detected";
				update_status_message(mesg);
				//$("#progID").hide();
			} else {
				//alert("100" + errorFlag);
				if(errorFlag === false)
				{
					//alert("101" + errorFlag);
					// Check langid 
					if ((langid == "0") && (stringmodified == 1) )
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}
					// Check udc_langid
					if ((udc_langid == "0") && (udc_stringmodified == 1) )
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "UCH String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "hce_languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}

					if ((usb3langid == "0") && (usb3stringmodified == 1))
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "usb3languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}
				
					var displayChange = "";
					for (var i = 0; i < modifiedWidgets.length; i++) {
						//alert("modifiedWidgets: " + modifiedWidgets[i]);
						if(i%4 == 0)
						{
							if (displayChange) {
								displayChange = "\n" +Mapping[modifiedWidgets[i]] + ", " + displayChange;
							} else {
								displayChange = Mapping[modifiedWidgets[i]];
							}
						} else {
							if (displayChange) {
								displayChange = Mapping[modifiedWidgets[i]] + ", " + displayChange;
							}
						}
					}
					//alert("102");
					nr1Modified = false;
					nr2Modified = false;
					nr3Modified = false;
					nr4Modified = false;
					
					enableprt1 = false;
					enableprt2 = false;
					enableprt3 = false;
					enableprt4 = false;
					var option = confirm("The following device settings will be changed ; Previously created JSON and Configuration files will be removed ; Do you want to continue?\n" + displayChange);
				
					if (option) {
						//alert("103");
						update_status_message("JSON and cfg files will be overwritten; and hub will be programmed with the following.\n " + displayChange);
						var mesg = "Programming in progress...Please wait";
						update_status_message(mesg);
						//$('#ajaxBusy').show();
						$("body").css("cursor", "wait");
						// call the service
						
						$('#myprogress').show();				
						$('#myprogress .progress-bar').css('width', 20+'%').attr('aria-valuenow', 20);

						var result = setWidgetValue(HUB_ID, stringToSet); // True is an input to JSON generator

						if (result) {
							//alert("104");
							//TODO error handling
							
							var mesg = "Hub is successfully programmed";
							update_status_message(mesg);
							
							//Disable apply and preview buttons before making a java call
							$("#Preview").attr('disabled', true);
							$("#Apply").attr('disabled', true);
							
							$('#myprogress .progress-bar').css('width', 90+'%').attr('aria-valuenow', 90);
							
							// Change border back to default color from red
							set_changed_fields_border_default();

							var mesg = "Waiting for device reset to finish.....";
							update_status_message(mesg);

							CurrenthubProgrammed = $("#selectedhubinput").val();
							var colonIndex = CurrenthubProgrammed.indexOf(":");
							HUB_ID = "" + CurrenthubProgrammed.charAt(colonIndex + 1);
							
							$('#myprogress .progress-bar').css('width', 100+'%').attr('aria-valuenow',100);

							if (vid_pidModified) {
								update_status_message("Vendor ID/Product ID of USB2.0/Hub controller has been modified...");
								vid_pidModified = false;
								setTimeout(function() {
									// Do something after 5 seconds
									var mesg = "Refreshing Hub List....";
									update_status_message(mesg);
									// refresh hub list and set selected device
									window.setTimeout(function() {
										$('.panel-collapse').each(function () {
											if ($(this).hasClass('in')) {
												$(this).collapse('toggle');
											}
										});
										close_device(HUB_ID);
										refresh();
										get_hub_list_set_hub_index_zero();
										$("#myprogress").hide();
										// Enable apply and preview buttons after programming is done
										$("#Preview").attr('disabled', false);
										$("#Apply").attr('disabled', false);
										
										},100);
										window.setTimeout(function(){
										  //your code to be executed after 1 seconds
										  $('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
										  $('#myprogress').hide();
										}, 5000);
									$("body").css("cursor", "default");
								}, 15000);
							} else {
								setTimeout(function() {
									// Do something after 5 seconds
									var mesg = "Refreshing Hub List....";
									update_status_message(mesg);
									// refresh hub list and set selected device
									window.setTimeout(function() {
										$('.panel-collapse').each(function () {
											if ($(this).hasClass('in')) {
												$(this).collapse('toggle');
											}
										});
										close_device(HUB_ID);
										refresh();
										get_hub_list_set_hub_index_zero();
										// Enable apply and preview buttons after programming is done
										$("#Preview").attr('disabled', false);
										$("#Apply").attr('disabled', false);
									},100);
									window.setTimeout(function(){
									  //your code to be executed after 1 seconds
									  $('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
									  $('#myprogress').hide();
									}, 2000);
									
									$("body").css("cursor", "default");
								}, 3000);
							}
							document.getElementById("myForm").reset();
						}
						else {
							errorCode = getMchpUsbLastError(HUB_ID);
							alert(errorMap[Dec2Hex(errorCode)]);
							update_status_message(errorMap[Dec2Hex(errorCode)] + "errorCode: " + errorCode);
							$("#myprogress").hide();
						}
					} else {
						update_status_message("Programming of the device was terminated by the user.");
						$("#progID").hide();
					}
				}
				else{}
			}
			//Required clean up action
			iniFile = "";
			RegString = "";
			numberofportState = false;
			errorFlag = false;
			enable_swapupstreamdpdm = false;
			enable_lpm = false;
			
			
			
		}
		$("body").css("cursor", "default");
		$("#progID").hide();
	}
})(jQuery);

(function ($) {
    set_dropdown_selected_option = function () {
        
        // Ordering is important - dont change code
        // Click of any field in  any drop down menu
        $(document).on('click', '.dropdown li a', function (event) {
            // this code is for making the current selection appear with caret
            var $target = $(event.currentTarget);

            $target.closest('.btn-group')
            .find('[data-bind]').text($target.text())
            .end()
            .children('.dropdown-toggle').dropdown('toggle');
            var selop = $(this).text();
            console.log("Selected Option - All dropdowns:" + selop);
        });

        // Click of Any hub in Select HUB drop down menu
        $(document).on('click', '.dropdown-selecthub li a', function (event) {
			var selop = $(this).text();
			
			$("#selectedhubinput").val(selop);
			var btnValue = $("#selectedhubinput").val();
			var colonIndex = btnValue.indexOf(":");
			var currentHubSelected = btnValue.charAt(colonIndex + 1);
			
			if (currentHubSelected == HUB_ID) {
				//$("#progID").show();
				setTimeout(function() {
					//Do nothing as the same hub is selected.
					get_hub_list_set_hub_index_zero();
					//$("#progID").hide();
				}, 200);
			} else {
				//get_hub_list();
				//$("#progID").show();
				setTimeout(function() {
					close_device(HUB_ID);
					refresh();
					HUB_ID = "" + currentHubSelected;
					
					set_selected_hub_get_widgets();
					//$("#progID").hide();
				}, 200);
			}
			return false;
        });

        // Click of Any sku in Force product drop down menu
        $(document).on('click', '.dropdown-forceproduct li a', function (event) {
            var selop = $(this).text();
            //console.log("Selected Option:" + selop + "hubid:" + GHubId);
            // call the service
            var data = force_part_number(HUB_ID);
            //console.log("Sending request:force_part_number:" + url);
			if (data) {
				var obj = data;
			}
			else {
				window.alert("force_part_number:Failed");
			}
            return false;
        });

        // Phase 2
        // Click of Any sku in Select product drop down menu for offline configuration
        $(document).on('click', '.dropdown-selectproduct li a', function () {
            $('.selectproduct1').text(this.innerHTML);
            var selop = $(this).text();
            console.log("SelectProduct: Selected Option:" + selop);
        });
    };
})(jQuery);