/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license
*/

//Global variables
var Product = getProduct();
var ConfigType = getConfigType();
var RegString = "";
var iniFile = "";
var offlineConfFile = "";
var LoadConfigFile = "";
var HUB_FAMILY_INDEX = "1";
var numberofportState = false;
var usb3numberofportState = false;
var noselect = false;
var dummyHubID = "1";
var stringnullvalue = "NULL STRING - NOT PROGRAMMED YET";
var hceenablemanu = false;
var hceenableprod = false;
var hceenableser = false;
var enablealertmanu = false;
var enablealertprod = false;
var enablealertser = false;

var checkbox_checked_value = "1";
var checkbox_unchecked_value = "0";

//Set this variable when Non-removable parameter of a hub is modified
var nrModified = false;
var nr1Modified = false;
var nr2Modified = false;
var nr3Modified = false;
var nr4Modified = false;

var usb3nrModified = false;
var usb3nr1Modified = false;
var usb3nr2Modified = false;
var usb3nr3Modified = false;
var usb3nr4Modified = false;

//set this variable when enable port widget is pushed
var enableprt1 = false;
var enableprt2 = false;
var enableprt3 = false;
var enableprt4 = false;

var usb3enableprt1 = false;
var usb3enableprt2 = false;
var usb3enableprt3 = false;
var usb3enableprt4 = false;

var gINIFileSelected = false;

// Widget ID of hex fields in the GUI
var GwidgetlistHex = [
"vid",
"pid",
"did",
"usbvcd",
"languageid",
"hce_vid",
"hce_pid",
"hce_did",
//"udc_usbvcd",
"hce_languageid",
// USB3 related
"usb3vid",
"usb3pid",
"usb3did",
"usb3vcd",
"usb3languageid"
];

// Widget ID of string fields in the GUI
var GwidgetlistString = [
"manufacturer", 
"product",
"serial",
"hce_manufacturer",
"hce_product",
"hce_serial",
// USB3 related
"usb3manufacturer",
"usb3product",
"usb3serial",
"usb3uuid"
];

// Widget ID of decimal fields in the GUI
var GwidgetlistInt = [
"maxpowerself",
"hubcmaxpowerself",
"maxpowerbus",
"hubcmaxpowerbus",
"hub3maxpowerselfbus"
];

// Widgets that are checkboxes in GUI
var GwidgetlistCheckbox = [
"flexconnect",
"hsdisable",
"hceenable",
"cdcenable",
"lpmenable",
"swapupstreamdpdm",
"swapupstreamhsic",
"swapport1dpdm",
"swapport2dpdm",
"swapport3dpdm",
"swapport4dpdm",
"enableport1",
"enableport2",
"enableport3",
"enableport4",
"usb3enableport1",
"usb3enableport2",
"usb3enableport3",
"usb3enableport4",
"nrdeviceport1",
"nrdeviceport2",
"nrdeviceport3",
"nrdeviceport4",
"usb3nrdeviceport1",
"usb3nrdeviceport2",
"usb3nrdeviceport3",
"usb3nrdeviceport4",
"swappin1",
"swappin2",
"swappin3",
"swappin4"
];
/*
	Hard straps related variables
*/
var StrapHashMapDefault = [];
var StrapHashMapAfterChange = [];
/*
	Hard straps list
*/
var straplistinOTP = [
"enableport1",
"enableport2",
"enableport3",
"enableport4",
"nrdeviceport1",
"nrdeviceport2",
"nrdeviceport3",
"nrdeviceport4",
"downstreamBCsettingport1",
"downstreamBCsettingport2",
"downstreamBCsettingport3",
"downstreamBCsettingport4"
];

// Widgets that are radio buttons in GUI
var GwidgetlistRadio = [
"hubpower",
"suspendindication",
"downstreamBCsettingport1",
"downstreamBCsettingport2",
"downstreamBCsettingport3",
"downstreamBCsettingport4",
"upstreambatterysettings"

];

// Widgets that are used for populating the GUI and would not be used in set_wdigets_values
var GwidgetlistGUI = [

"upstreamport_HSIC_USB",
"downstreamport1_HSIC_USB",
"downstreamport2_HSIC_USB",
"downstreamport3_HSIC_USB",
"downstreamport4_HSIC_USB"
];

// Widgets that are Drop Down in GUI
var GwidgetlistDropDown = [
"DREF",
"TREF",
"PHYBOOST",
"SQUELCH",
"upstreamHsRiseFall",
"SLEW",
"DOI",
"PHYBOOSTdownstreamport1",
"SQUELCHdownstreamport1",
"downstreamport1HsRiseFall",
"SLEWdownstreamport1",
"DOIdownstreamport1",
"PHYBOOSTdownstreamport2",
"SQUELCHdownstreamport2",
"downstreamport2HsRiseFall",
"SLEWdownstreamport2",
"DOIdownstreamport2",
"PHYBOOSTdownstreamport3",
"SQUELCHdownstreamport3",
"downstreamport3HsRiseFall",
"SLEWdownstreamport3",
"DOIdownstreamport3",
"PHYBOOSTdownstreamport4",
"SQUELCHdownstreamport4",
"downstreamport4HsRiseFall",
"SLEWdownstreamport4",
"DOIdownstreamport4"
];

function myAlert(str){
}
//Document START
$(document).ready(function () {
	//Display widgets with respect to the type of Microchip product selected.
	if (Product == "USB2.0") {
		$("#usb3DescTab").hide();
		$("#CDC_Div").hide();
		$("#HubMaxPower3Div").hide();
		$("#AthensTitle").show();
		$("#TylerTitle").hide();
		$("#suspendDisable").show();
		$("#suspendDisableLabel").show();
		$("#USB2_List").show();
		$("#USB3_List").hide();
		$("#upstreamChargerDetectionDiv_usb2").show();
		$("#superSpeed1").hide();
		$("#superSpeed1").attr('disabled', true);
		$("#superSpeed2").hide();
		$("#superSpeed2").attr('disabled', true);
		$("#superSpeed3").hide();
		$("#superSpeed3").attr('disabled', true);
		$("#superSpeed4").hide();
		$("#superSpeed4").attr('disabled', true);
		$("#memoryChoice").hide();		
		
		//Hiding strap for Athens or USB2.0
		//Port 1
		/*document.getElementById("enableport1Canbe").classList.add('hide');
		document.getElementById("enableport1Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport1Canbe").classList.add('hide');
		document.getElementById("nrdeviceport1Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport1Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport1Cannotbe").classList.add('hide');
		
		//Port 2
		document.getElementById("enableport2Canbe").classList.add('hide');
		document.getElementById("enableport2Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport2Canbe").classList.add('hide');
		document.getElementById("nrdeviceport2Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport2Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport2Cannotbe").classList.add('hide');
		
		//Port 3
		document.getElementById("enableport3Canbe").classList.add('hide');
		document.getElementById("enableport3Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport3Canbe").classList.add('hide');
		document.getElementById("nrdeviceport3Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport3Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport3Cannotbe").classList.add('hide');
		
		//Port 4
		document.getElementById("enableport4Canbe").classList.add('hide');
		document.getElementById("enableport4Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport4Canbe").classList.add('hide');
		document.getElementById("nrdeviceport4Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport4Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport4Cannotbe").classList.add('hide');*/
	} else if (Product == "USB3.1 Gen1") {
		$("#usb3DescTab").show();
		$("#CDC_Div").show();
		$("#HubMaxPower3Div").show();
		$("#AthensTitle").hide();
		$("#TylerTitle").show();
		$("#suspendDisable").hide();
		$("#suspendDisableLabel").hide();
		$("#USB2_List").hide();
		$("#USB3_List").show();
		$("#upstreamChargerDetectionDiv_usb2").hide();
		
		// Enable all port BC fields
		$('#BdownstreamUSBport1').removeAttr('disabled');
		$('#BdownstreamUSBport2').removeAttr('disabled');
		$('#BdownstreamUSBport3').removeAttr('disabled');
		$('#BdownstreamUSBport4').removeAttr('disabled');
		
		$("#superSpeed1").show();
		$("#superSpeed1").attr('disabled', false);
		$("#superSpeed2").show();
		$("#superSpeed2").attr('disabled', false);
		$("#superSpeed3").show();
		$("#superSpeed3").attr('disabled', false);
		$("#superSpeed4").show();
		$("#superSpeed4").attr('disabled', false);
		$("#memoryChoice").hide();
		//Hide the Strap widgets for the sku: USB5744
		/*if (sku == "USB5744") {
			//Port 1
			document.getElementById("enableport1Canbe").classList.add('hide');
			document.getElementById("enableport1Cannotbe").classList.add('hide');
			document.getElementById("nrdeviceport1Canbe").classList.add('hide');
			document.getElementById("nrdeviceport1Cannotbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport1Canbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport1Cannotbe").classList.add('hide');
			
			//Port 2
			document.getElementById("enableport2Canbe").classList.add('hide');
			document.getElementById("enableport2Cannotbe").classList.add('hide');
			document.getElementById("nrdeviceport2Canbe").classList.add('hide');
			document.getElementById("nrdeviceport2Cannotbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport2Canbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport2Cannotbe").classList.add('hide');
			
			//Port 3
			document.getElementById("enableport3Canbe").classList.add('hide');
			document.getElementById("enableport3Cannotbe").classList.add('hide');
			document.getElementById("nrdeviceport3Canbe").classList.add('hide');
			document.getElementById("nrdeviceport3Cannotbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport3Canbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport3Cannotbe").classList.add('hide');
			
			//Port 4
			document.getElementById("enableport4Canbe").classList.add('hide');
			document.getElementById("enableport4Cannotbe").classList.add('hide');
			document.getElementById("nrdeviceport4Canbe").classList.add('hide');
			document.getElementById("nrdeviceport4Cannotbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport4Canbe").classList.add('hide');
			document.getElementById("downstreamBCsettingport4Cannotbe").classList.add('hide');
		} else {
			document.getElementById("enableport1Canbe").classList.remove('hide');
			document.getElementById("enableport1Cannotbe").classList.remove('hide');
			document.getElementById("nrdeviceport1Canbe").classList.remove('hide');
			document.getElementById("nrdeviceport1Cannotbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport1Canbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport1Cannotbe").classList.remove('hide');
			
			//Port 2
			document.getElementById("enableport2Canbe").classList.remove('hide');
			document.getElementById("enableport2Cannotbe").classList.remove('hide');
			document.getElementById("nrdeviceport2Canbe").classList.remove('hide');
			document.getElementById("nrdeviceport2Cannotbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport2Canbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport2Cannotbe").classList.remove('hide');
			
			//Port 3
			document.getElementById("enableport3Canbe").classList.remove('hide');
			document.getElementById("enableport3Cannotbe").classList.remove('hide');
			document.getElementById("nrdeviceport3Canbe").classList.remove('hide');
			document.getElementById("nrdeviceport3Cannotbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport3Canbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport3Cannotbe").classList.remove('hide');
			
			//Port 4
			document.getElementById("enableport4Canbe").classList.remove('hide');
			document.getElementById("enableport4Cannotbe").classList.remove('hide');
			document.getElementById("nrdeviceport4Canbe").classList.remove('hide');
			document.getElementById("nrdeviceport4Cannotbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport4Canbe").classList.remove('hide');
			document.getElementById("downstreamBCsettingport4Cannotbe").classList.remove('hide');
		}*/
	} else {
	}
	
	$("#Apply").attr('disabled', true);
	$("#Reset").attr('disabled', true);
	
	$('#SaveFileField').hide();
	$('#SaveFileField').attr('disabled', 'disabled');
	$('#LoadFileField').removeAttr('disabled');
	$("#LoadFileField").attr('disabled', true);
	$('#LoadFileField').show();
	$("#LoadFileField").attr('disabled', true);

	//By default All Straps can be configured.
	//So show in GUI as "Can be Configured" 
	$.each(straplistinOTP, function (index, value) {
	    var widgetstrapsCannotbe = "#" + value + "Cannotbe";
	    var widgetstrapsCanbe = "#" + value + "Canbe";
	    $(widgetstrapsCannotbe).hide();
	    $(widgetstrapsCannotbe).attr('disabled', 'disabled');

	    $(widgetstrapsCanbe).removeAttr('disabled');
	    $(widgetstrapsCanbe).attr('disabled', true);
	    $(widgetstrapsCanbe).show();
	    $(widgetstrapsCanbe).attr('disabled', true);
	});

	update_status_message("Offline Configuration");
	clearWidgetMap();

	$("#devicedescriptortab").attr('disabled', true);
	$("#stringdescriptortab").attr('disabled', true);
	$("#USB3devicedescriptortab").attr('disabled', true);
	$("#USB3stringdescriptortab").attr('disabled', true);
	$("#USB3otherdescriptortab").attr('disabled', true);
	$("#upstreamtab").attr('disabled', true);
	$("#downstreamtab").attr('disabled', true);
	$("#Bdownstreamtab").attr('disabled', true);
	$("#USB3_Bdownstreamtab").attr('disabled', true);
	$("#uchtab").attr('disabled', true);
	$("#advancedtab").attr('disabled', true);
	$("#specialtab").attr('disabled', true);
	$("#registerVal").attr('disabled', true);
	$("#registerFile").attr('disabled', true);
	$("#cdctab").attr('disabled', true);
	
	// Setting the Hub Family Index
	if (Product == "USB2.0") {
		HUB_FAMILY_INDEX = "0";
	} else if (Product == "USB3.1 Gen1") {
		HUB_FAMILY_INDEX = "1";
	}
});
//Document END
var sku;
$('#selectsku_usb3 li').on('click', function() {
	sku = $(this).text();
	update_status_message("Selected SKU is :" + sku);
	clearWidgetMap();
	gArrConfigIndex = 0;
	LoadConfFile = "";
	changecount = 0;
	RegString="";
	document.getElementById("myForm").reset();
	$("#Reset").attr('disabled', false);
	reset_file_input();

	iniFile ="";
	offlineConfFile="";
	enable_all_fields();
	set_changed_fields_border_default();
	populateDefaultValues();
	
	if (sku == "USB5742") {
		$("#BPORT3fieldset").attr('disabled', true);
		$("#BPORT4fieldset").attr('disabled', true);
		$("#PORT3fieldset").attr('disabled', true);
		$("#PORT4fieldset").attr('disabled', true);

		$("#BPORT3fieldset").hide();
		$("#BPORT4fieldset").hide();
		$("#PORT3fieldset").hide();
		$("#PORT4fieldset").hide();
		
		$("#NoFlexForHsic").hide();
		$("#Flextooltip").show();
	}
	else
	{
		$("#NoFlexForHsic").hide();
		$("#Flextooltip").show();
	}
	
	//Hide the Strap widgets for the sku: USB5744
	/*if (sku == "USB5744") {
		//Port 1
		document.getElementById("enableport1Canbe").classList.add('hide');
		document.getElementById("enableport1Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport1Canbe").classList.add('hide');
		document.getElementById("nrdeviceport1Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport1Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport1Cannotbe").classList.add('hide');
		
		//Port 2
		document.getElementById("enableport2Canbe").classList.add('hide');
		document.getElementById("enableport2Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport2Canbe").classList.add('hide');
		document.getElementById("nrdeviceport2Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport2Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport2Cannotbe").classList.add('hide');
		
		//Port 3
		document.getElementById("enableport3Canbe").classList.add('hide');
		document.getElementById("enableport3Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport3Canbe").classList.add('hide');
		document.getElementById("nrdeviceport3Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport3Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport3Cannotbe").classList.add('hide');
		
		//Port 4
		document.getElementById("enableport4Canbe").classList.add('hide');
		document.getElementById("enableport4Cannotbe").classList.add('hide');
		document.getElementById("nrdeviceport4Canbe").classList.add('hide');
		document.getElementById("nrdeviceport4Cannotbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport4Canbe").classList.add('hide');
		document.getElementById("downstreamBCsettingport4Cannotbe").classList.add('hide');
	} else {
		document.getElementById("enableport1Canbe").classList.remove('hide');
		document.getElementById("enableport1Cannotbe").classList.remove('hide');
		document.getElementById("nrdeviceport1Canbe").classList.remove('hide');
		document.getElementById("nrdeviceport1Cannotbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport1Canbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport1Cannotbe").classList.remove('hide');
		
		//Port 2
		document.getElementById("enableport2Canbe").classList.remove('hide');
		document.getElementById("enableport2Cannotbe").classList.remove('hide');
		document.getElementById("nrdeviceport2Canbe").classList.remove('hide');
		document.getElementById("nrdeviceport2Cannotbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport2Canbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport2Cannotbe").classList.remove('hide');
		
		//Port 3
		document.getElementById("enableport3Canbe").classList.remove('hide');
		document.getElementById("enableport3Cannotbe").classList.remove('hide');
		document.getElementById("nrdeviceport3Canbe").classList.remove('hide');
		document.getElementById("nrdeviceport3Cannotbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport3Canbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport3Cannotbe").classList.remove('hide');
		
		//Port 4
		document.getElementById("enableport4Canbe").classList.remove('hide');
		document.getElementById("enableport4Cannotbe").classList.remove('hide');
		document.getElementById("nrdeviceport4Canbe").classList.remove('hide');
		document.getElementById("nrdeviceport4Cannotbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport4Canbe").classList.remove('hide');
		document.getElementById("downstreamBCsettingport4Cannotbe").classList.remove('hide');
	}*/
});

$('#selectsku_usb2 li').on('click', function() {
	sku = $(this).text();
	update_status_message("Selected SKU is :" + sku);
	clearWidgetMap();
	gArrConfigIndex = 0;
	LoadConfFile = "";
	changecount = 0;
	RegString="";
	document.getElementById("myForm").reset();
	$("#Reset").attr('disabled', false);
	reset_file_input();
	iniFile ="";
	offlineConfFile="";
	enable_all_fields();
	set_changed_fields_border_default();
	populateDefaultValues();
	
	if (sku == "USB3813" || sku == "USB3613") {
		$("#BPORT4fieldset").attr('disabled', true);
		$("#PORT4fieldset").attr('disabled', true);
		$("#flexconnect").attr('disabled', true);
		
		$("#BPORT4fieldset").hide();
		$("#PORT4fieldset").hide();
		
		$("#NoFlexForHsic").show();
		$("#Flextooltip").hide();
	
	}
	else
	{
		$("#BPORT4fieldset").attr('disabled', false);
		$("#PORT4fieldset").attr('disabled', false);
		$("#flexconnect").attr('disabled', true);
		
		$("#BPORT4fieldset").show();
		$("#PORT4fieldset").show();
		
		$("#NoFlexForHsic").hide();
		$("#Flextooltip").show();
	}
			
	
	//Hiding strap for Athens or USB2.0
	//Port 1
	/*document.getElementById("enableport1Canbe").classList.add('hide');
	document.getElementById("enableport1Cannotbe").classList.add('hide');
	document.getElementById("nrdeviceport1Canbe").classList.add('hide');
	document.getElementById("nrdeviceport1Cannotbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport1Canbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport1Cannotbe").classList.add('hide');
	
	//Port 2
	document.getElementById("enableport2Canbe").classList.add('hide');
	document.getElementById("enableport2Cannotbe").classList.add('hide');
	document.getElementById("nrdeviceport2Canbe").classList.add('hide');
	document.getElementById("nrdeviceport2Cannotbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport2Canbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport2Cannotbe").classList.add('hide');
	
	//Port 3
	document.getElementById("enableport3Canbe").classList.add('hide');
	document.getElementById("enableport3Cannotbe").classList.add('hide');
	document.getElementById("nrdeviceport3Canbe").classList.add('hide');
	document.getElementById("nrdeviceport3Cannotbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport3Canbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport3Cannotbe").classList.add('hide');
	
	//Port 4
	document.getElementById("enableport4Canbe").classList.add('hide');
	document.getElementById("enableport4Cannotbe").classList.add('hide');
	document.getElementById("nrdeviceport4Canbe").classList.add('hide');
	document.getElementById("nrdeviceport4Cannotbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport4Canbe").classList.add('hide');
	document.getElementById("downstreamBCsettingport4Cannotbe").classList.add('hide');*/
});

$("#RegEntry").click(function () {
	var regOptionChosen = $("#Regoperationgroup").find(':checked').val();
	var Regop = "";
	var Regadd = "";
	var RegVal = "";
	
	if (typeof regOptionChosen === 'undefined') {
		alert("Please choose an appropriate register operation under the Direct Register Access.");
		return;
	}

	if(regOptionChosen == 0)
	{
		Regop = "XMODE_WRITE_BYTE";
	}
	else if(regOptionChosen == 1)
	{
		Regop = "XMODE_SET_BITS";
	}
	else if(regOptionChosen == 2)
	{
		Regop = "XMODE_CLEAR_BITS"
	}
	else
	{
		Regop = "";
		//do nothing
	}
	Regadd = $("#Regaddress").val();
	var isOKAddr = /^[0-9A-Fa-f]{4}$/i.test(Regadd);
	RegVal = "" + $("#Regvalue").val();
	var newRegVal = RegVal.replace(/\s+/g, "");
	var RegValOkay = /^[0-9A-Fa-f]+$/i.test(newRegVal);
	
	if ((Regadd == "") || (RegVal == "")) {
		alert("Either the value of register address or the register value is not entered under the Direct Register Access.");
		return;
	}
	
	if (!isOKAddr) {
		alert("The Register Address entered under the Direct Register Access must be a 4 digit hexadecimal number.");
	}
	
	if (!RegValOkay) {
		alert("The Register value entered under the Direct Register Access is not a valid hexadecimal number.");
	}
	
	if (RegValOkay && isOKAddr) {
		if (Regop.length == 0) {
			alert("Please choose appropriate register operation.");
		} else {
			if (Regadd && RegVal) {
				if (RegString) {
					RegString = Regop + "+" + Regadd + "+" + newRegVal + "+" + RegString;
				} else {
					RegString = Regop + "+" + Regadd + "+" + newRegVal;
				}
				changecount = changecount+1;
				switchloadsave(changecount);
				update_status_message("Register Address: " + Regadd + " Register Value: " + RegVal + " for operation: " + Regop + " will be added in an ini file and programmed into the hub.");
			} else {
				alert("Either Register address or Register value is not added.");
			}
		}
		document.getElementById("myForm").reset();
	}
});

function setiniType() {
	setFileType("ini", 0);
}

function startRead() {
	iniFile = "";

	var file = document.getElementById("iniid").files[0];
	if (typeof file === 'undefined') {
		update_status_message("No configuration file(.ini) is selected.");
		iniFile = "";
		if (gINIFileSelected == true)
		{
			changecount = changecount-1;
			switchloadsave(changecount);
			gINIFileSelected = false;
		}
		alert("No configuration file(.ini) is selected.");
	} else {
		iniFile = file.name;
		extension = iniFile.substr(iniFile.lastIndexOf('.') + 1);
		
		if(extension != "ini")
		{
			alert("Selected File type is not supported. Please Select File type : ini");
			var mesg = ("Selected File type is not supported.Supported File type is .ini");
			update_status_message(mesg);
			iniFile ="";
			//reset_file_input();
			$("#iniid").val('');
			$("#iniid").css({
				background: "white",
				border: "0px"
			});
			errorFlag = true;
			return;
		} else {
			var mesg = ("Selected .ini file to program is :" + iniFile);
			update_status_message(mesg);
			var fileSizeInKb = file.size/1024;
			update_status_message("The size of the .ini file selected is " + fileSizeInKb.toFixed(2) + " KB");
				$("#iniid").css({
				background: "white",
				border: "0px"
				});
			update_status_message(mesg);
			changecount = changecount+1;
			
			switchloadsave(changecount);
			gINIFileSelected = true;
		}
	}
}
//Direct Register Access blocks End

//Onclick event for dropdown STARTS
$(document).on('click', '.dropdown li a', function (event) {
	// this code is for making the current selection appear with caret
	var $target = $(event.currentTarget);

	$target.closest('.btn-group')
	.find('[data-bind]').text($target.text())
	.end()
	.children('.dropdown-toggle').dropdown('toggle');
	var selop = $(this).text();
	console.log("Selected Option - All dropdowns:" + selop);
});
//Onclick event for dropdown ENDS

//Full Widget List Starts
var fullWidgetList = [
"vid",
"pid",
"did",
"usbvcd",
"usb3vid",
"usb3pid",
"usb3did",
"usb3vcd",
"usb3uuid",
"hce_vid",
"hce_pid",
"hce_did",
"hceenable",
"cdcenable",
"swapport1dpdm",
"swapport2dpdm",
"swapport3dpdm",
"swapport4dpdm",
"flexconnect",
"swapupstreamdpdm",
"hsdisable",
"lpmenable",
"powerRadio1",
"powerRadio2",
"suspendID",
"ResumeInhibit",
"hubcmaxpower",
"maxpower",
"hub3maxpowerselfbus",
"stringdescriptortab",
"USB3stringdescriptortab",
"uchfieldsetstring",
"registerVal",
"registerFile",
"PHYBOOSTULdownstreamport1Field",
"PHYBOOSTULdownstreamport2Field",
"PHYBOOSTULdownstreamport3Field",
"PHYBOOSTULdownstreamport4Field",
"PHYBOOSTULField",
"SQUELCHULdownstreamport1Field",
"SQUELCHULdownstreamport2Field",
"SQUELCHULdownstreamport3Field",
"SQUELCHULdownstreamport4Field",
"SQUELCHULField",
"upstreamHsRiseFallULField",
"downstreamport1HsRiseFallField",
"downstreamport2HsRiseFallField",
"downstreamport3HsRiseFallField",
"downstreamport4HsRiseFallField",
"Bdownstreamtab",
"BdownstreamUSBport1",
"BdownstreamUSBport2",
"BdownstreamUSBport3",
"BdownstreamUSBport4"
];

//Sentinel Checkboxes START
var sentinelCheckBoxes = [
"vidCheck",
"pidCheck",
"didCheck",
"usbvcdCheck",
"usb3vidCheck",
"usb3pidCheck",
"usb3didCheck",
"usb3uuidCheck",
"hce_vidCheck",
"hce_pidCheck",
"hce_didCheck",
"hceenableCheck",
"cdcenableCheck",
"swapport1dpdmCheck",
"swapport2dpdmCheck",
"swapport3dpdmCheck",
"swapport4dpdmCheck",
"flexconnectCheck",
"swapupstreamdpdmCheck",
"hsdisableCheck",
"lpmenableCheck",
"hubpowergroupCheck",
"suspendindicationgroupCheck",
"hubcmaxpowerCheck",
"maxpowerCheck",
"hub3maxpowerselfbusCheck",
"stringdescriptortabCheck",
"USB3stringdescriptortabCheck",
"uchfieldsetstringCheck",
"registerValCheck",
"registerFileCheck",
"PHYBOOSTULdownstreamport1Check",
"PHYBOOSTULdownstreamport2Check",
"PHYBOOSTULdownstreamport3Check",
"PHYBOOSTULdownstreamport4Check",
"PHYBOOSTULCheck",
"SQUELCHULdownstreamport1Check",
"SQUELCHULdownstreamport2Check",
"SQUELCHULdownstreamport3Check",
"SQUELCHULdownstreamport4Check",
"SQUELCHULCheck",
"DSConfigCheck",
"downstreamBCsettingport1Check",
"downstreamBCsettingport2Check",
"downstreamBCsettingport3Check",
"downstreamBCsettingport4Check"
];
//Sentinel Checkboxes ENDS

//Dropdown STARTS
// Widgets that are Drop Down in GUI
/*var GwidgetlistDropDown = [
"SLEW",
"DOI",
"PHYBOOST",
"SQUELCH",
"PHYBOOSTdownstreamport1",
"SQUELCHdownstreamport1",
"SLEWdownstreamport1",
"DOIdownstreamport1",
"PHYBOOSTdownstreamport2",
"SQUELCHdownstreamport2",
"SLEWdownstreamport2",
"DOIdownstreamport2",
"PHYBOOSTdownstreamport3",
"SQUELCHdownstreamport3",
"SLEWdownstreamport3",
"DOIdownstreamport3",
"PHYBOOSTdownstreamport4",
"SQUELCHdownstreamport4",
"upstreamHsRiseFall",
"SLEWdownstreamport4",
"DOIdownstreamport4",
"downstreamport1HsRiseFall",
"downstreamport2HsRiseFall",
"downstreamport3HsRiseFall",
"downstreamport4HsRiseFall"
];*/

var GwidgetlistGUI = [

"upstreamport_HSIC_USB",
"downstreamport1_HSIC_USB",
"downstreamport2_HSIC_USB",
"downstreamport3_HSIC_USB",
"downstreamport4_HSIC_USB"
];

// Lookup for dropdown value selection
/*var DropDownDREF = [
"REFSEL0=0,REFSEL1=0 =>38.4Mhz",
"REFSEL0=1,REFSEL1=0 =>26Mhz",
"REFSEL0=0,REFSEL1=1 =>19.2Mhz",
"REFSEL0=1,REFSEL1=1 =>12Mhz"
];

// Lookup for tref dropdown value selection
/*var DropDownTREF = [
"12Mhz",
"13Mhz",
"19.2Mhz",
"24Mhz",
"25Mhz",
"26Mhz",
"27Mhz",
"38.4Mhz",
"50Mhz",
"52Mhz"
];*/


// Lookup for phyboost dropdown value selection
var DropDownPHYBOOST = [
"Nominal 17.78 mA",
"5% below nominal",
"10% above nominal",
"5% above nominal",
"20% above nominal",
"15% above nominal",
"30% above nominal",
"25% above nominal",
];

// Lookup for squelch dropdown value selection
var DropDownSQUELCH = [
"Nominal 100mV",
"12.5mV below nominal",
"25mV below nominal",
"37.5mV below nominal",
"50mV below nominal",
"62.5mV below nominal",
"25mV above nominal",
"12.5mV above nominal",
];

// Lookup for High Speed rise/fall adjust selection
var DropDownHSRiseFall =[
"Default",
"+18%",
"-18%",
"-12%"
];

// Lookup for squelch dropdown value selection
var DropDownDOI = [
"40 ohm",
"50 ohm"
];

// Lookup for squelch dropdown value selection
var DropDownSLEW = [
"Default",
"+30%"
];
//Dropdown END

var GwidgetlistPortsCheckbox = [
//"flexconnect",
//"hsdisable",
//"hceenable", -> Special attention
//"lpmenable",
//"swapupstreamdpdm",
//"swapupstreamhsic",
//"swapport1dpdm",
//"swapport2dpdm",
//"swapport3dpdm",
//"swapport4dpdm",
"nrdeviceport1",
"nrdeviceport2",
"nrdeviceport3",
"nrdeviceport4",
"usb3nrdeviceport1",
"usb3nrdeviceport2",
"usb3nrdeviceport3",
"usb3nrdeviceport4",
//"swappin1",
//"swappin2",
//"swappin3",
//"swappin4",
"enableport1",
"enableport2",
"enableport3",
"enableport4",
"usb3enableport1",
"usb3enableport2",
"usb3enableport3",
"usb3enableport4"

];

//Battery Charging START
var GwidgetlistBatteryCharging = [
"downstreamBCsettingport1",
"downstreamBCsettingport2",
"downstreamBCsettingport3",
"downstreamBCsettingport4"
];
//Battery Charging END

//Mapping Hex widgets to the meaningful elaborations to print while in error
var Mapping = {
//Hex
"vid": "USB2.0 Vendor ID",
"pid": "USB2.0 Product ID",
"did": "USB2.0 Device ID",
"usbvcd": "USB2.0 Version",
"languageid": "USB2.0 Language ID",
"manufacturer": "USB2.0 Manufacturer",
"manufacturerlen" :"USB2.0 Manufacturer Length",
"product" : "USB2.0 Product",
"productlen" : "USB2.0 Product Length",
"serial": "USB2.0 Serial",
"seriallen" : "USB2.0 Serial Length",
"usb3vid": "USB3.1 Gen1 Vendor ID",
"usb3pid": "USB3.1 Gen1 Product ID",
"usb3did": "USB3.1 Gen1 Device ID",
"usb3vcd": "USB3.1 Version",
"usb3languageid": "USB3.1 Gen1 Language ID",
"usb3manufacturer": "USB3.1 Gen1 Manufacturer",
"usb3product":"USB3.1 Gen1 Product",
"usb3serial":"USB3.1 Gen1 Serial",
"usb3uuid":"Universal unique ID",
"numberofports":"Number of Enabled ports",
"usb3numberofports":"USB3 Number of Enabled ports",
"enableport1":"Port1 Enable/Disable State",
"enableport2":"Port2 Enable/Disable State",
"enableport3":"Port3 Enable/Disable State",
"enableport4":"Port4 Enable/Disable State",
"usb3enableport1":"USB3 Port1 Enable/Disable State",
"usb3enableport2":"USB3 Port2 Enable/Disable State",
"usb3enableport3":"USB3 Port3 Enable/Disable State",
"usb3enableport4":"USB3 Port4 Enable/Disable State",
"port1mapping":"Port1 Logical mapping",
"port2mapping":"Port2 Logical mapping",
"port3mapping":"Port3 Logical mapping",
"port4mapping":"Port4 Logical mapping",
"usb3port1mapping":"USB3 Port1 Logical mapping",
"usb3port2mapping":"USB3 Port2 Logical mapping",
"usb3port3mapping":"USB3 Port3 Logical mapping",
"usb3port4mapping":"USB3 Port4 Logical mapping",
"nrdeviceport1":"Port1 Non-removable State",
"nrdeviceport2":"Port2 Non-removable State",
"nrdeviceport3":"Port3 Non-removable State",
"nrdeviceport4":"Port4 Non-removable State",
"usb3nrdeviceport1":"USB3 Port1 Non-removable State",
"usb3nrdeviceport2":"USB3 Port2 Non-removable State",
"usb3nrdeviceport3":"USB3 Port3 Non-removable State",
"usb3nrdeviceport4":"USB3 Port4 Non-removable State",
"downstreamBCsettingport1":"Port1 Battery charging State",
"downstreamBCsettingport2":"Port2 Battery charging State",
"downstreamBCsettingport3":"Port3 Battery charging State",
"downstreamBCsettingport4":"Port4 Battery charging State",
"swapport1dpdm":"Port1:Swap D+/D-",
"swapport2dpdm":"Port2:Swap D+/D-",
"swapport3dpdm":"Port3:Swap D+/D-",
"swapport4dpdm":"Port4:Swap D+/D-",
"swapupstreamdpdm":"Upstream Port:Swap D+/D-",
"swappin1":"Port1:Swap HSIC DATA STROBE",
"swappin2":"Port2:Swap HSIC DATA STROBE",
"swappin3":"Port3:Swap HSIC DATA STROBE",
"swappin4":"Port4:Swap HSIC DATA STROBE",
"swapupstreamhsic":"Upstream Port:Swap HSIC DATA STROBE",
"SLEW":"Upstream Port:Slew Tune",
"SLEWdownstreamport1":"Port1:Slew Tune",
"SLEWdownstreamport2":"Port2:Slew Tune",
"SLEWdownstreamport3":"Port3:Slew Tune",
"SLEWdownstreamport4":"Port4:Slew Tune",
"DOIdownstreamport1":"Port1:HSIC Driver Output Impedance",
"DOIdownstreamport2":"Port2:HSIC Driver Output Impedance",
"DOIdownstreamport3":"Port3:HSIC Driver Output Impedance",
"DOIdownstreamport4":"Port4:HSIC Driver Output Impedance",
"DOI":"Upstream Port:HSIC Driver Output Impedance",
"PHYBOOSTdownstreamport1":"Port1:PHYBOOST",
"PHYBOOSTdownstreamport2":"Port2:PHYBOOST",
"PHYBOOSTdownstreamport3":"Port3:PHYBOOST",
"PHYBOOSTdownstreamport4":"Port4:PHYBOOST",
"PHYBOOST":"Upstream Port:PHYBOOST",
"SQUELCHdownstreamport1":"Port1:Varisense",
"SQUELCHdownstreamport2":"Port2:Varisense",
"SQUELCHdownstreamport3":"Port3:Varisense",
"SQUELCHdownstreamport4":"Port4:Varisense",
"SQUELCH":"Upstream Port:Varisense",
"upstreamHsRiseFall":"Upstream High Speed rise/fall adjust",
"downstreamport1HsRiseFall":"Port1:High Speed rise/fall adjust",
"downstreamport2HsRiseFall":"Port2:High Speed rise/fall adjust",
"downstreamport3HsRiseFall":"Port3:High Speed rise/fall adjust",
"downstreamport4HsRiseFall":"Port4:Hugh Speed rise/fall adjust",
"flexconnect":"Flexconnect",
"hceenable":"Hub Controller State",
"hce_vid": "HCE Vendor ID",
"hce_pid": "HCE Product ID",
"hce_did": "HCE Device ID",
"hce_languageid": "HCE Language ID",
"hce_manufacturer":"HCE Manufacturer",
"hce_manufacturerlen":"HCE Manufacturer Length",
"hce_product":"HCE Product",
"hce_productlen":"HCE Product Length",
"hce_serial":"HCE Serial",
"hce_seriallen":"HCE Serial Length",
"cdcenable":"CDC State",
"hubpower":"Hub Power",
"maxpowerself":"USB2.0 Hub Max Power(Self)",
"hubcmaxpowerself":"Hub Circuit Max Power (Self)",
"maxpowerbus":"USB2.0 Hub Max Power (Bus)",
"hubcmaxpowerbus":"Hub Circuit Max Power (Bus)",
"hub3maxpowerselfbus":"USB3.1 Gen1 Max Power",
"suspendindication":"Suspendindication",
"hsdisable":"Hub Full Speed Mode",
"lpmenable":"LPM State",
"xdataentry":"Direct Register Access",
"xdataprogram":"ini File",
"upstreambatterysettings":"Upstream Charger Detection"
};
(function ($) {
    enable_all_fields = function () {
		$("#registerVal").attr('disabled',false);
		$("#registerFile").attr('disabled',false);
        $("#devicedescriptortab").attr('disabled', false);
        $("#stringdescriptortab").attr('disabled', false);
        $("#USB3devicedescriptortab").attr('disabled', false);
        $("#USB3stringdescriptortab").attr('disabled', false);
        $("#USB3otherdescriptortab").attr('disabled', false);
        $("#upstreamtab").attr('disabled', false);
        $("#downstreamtab").attr('disabled', false);
        $("#Bdownstreamtab").attr('disabled', false);
        $("#USB3_Bdownstreamtab").attr('disabled', false);
        $("#uchtab").attr('disabled', false);
        $("#advancedtab").attr('disabled', false);
        $("#specialtab").attr('disabled', false);
        $('#BPORT1fieldset').attr('disabled', false);
        $('#BPORT2fieldset').attr('disabled', false);
        $('#BPORT3fieldset').attr('disabled', false);
        $('#BPORT4fieldset').attr('disabled', false);
        $('#USB3_BPORT1fieldset').attr('disabled', false);
        $('#USB3_BPORT2fieldset').attr('disabled', false);
        $('#USB3_BPORT3fieldset').attr('disabled', false);
        $('#USB3_BPORT4fieldset').attr('disabled', false);
        $('#PORT1fieldset').attr('disabled', false);
        $('#PORT2fieldset').attr('disabled', false);
        $('#PORT3fieldset').attr('disabled', false);
        $('#PORT4fieldset').attr('disabled',false);
        $('#USB3_PORT1fieldset').attr('disabled', false);
        $('#USB3_PORT2fieldset').attr('disabled', false);
        $('#USB3_PORT3fieldset').attr('disabled', false);
        $('#USB3_PORT4fieldset').attr('disabled', false);
		$('#cdctab').attr('disabled', false);
		
    };
})(jQuery);

function getOfflineConf() {
	offlineConfFile = "";
	var file = document.getElementById("offlineConfFileID").files[0];
	var fileSizeInKb = file.size/1024;
	update_status_message("The size of the Configuration file selected is " + fileSizeInKb + " KB");
	if (file) {
		$("#offlineConfFileID").css({
			background: "white",
			border: "0px"
		});
		offlineConfFile = file.name;
		var saveextension = offlineConfFile.substr(offlineConfFile.lastIndexOf('.') + 1);
		if(saveextension === offlineConfFile)
		{
			offlineConfFile = offlineConfFile + ".cfg";
		}
		else if(saveextension === "cfg")
		{
			var mesg = ("Selected .cfg file to save is :" + offlineConfFile);
			update_status_message(mesg);
		}else{
			alert("Selected File Type is not supported. Please Select File type : .cfg");
			update_status_message("Selected File Type is not supported.Supported File type is .cfg");
			$("#offlineConfFileID").val('');
			$("#offlineConfFileID").css({
			background: "white",
			border: "0px"
			});
			offlineConfFile="";
			return;
		}
	} else {
		$("#offlineConfFileID").css({
			background: "yellow",
			border: "3px red solid"
		});
		update_status_message("No configuration file(.cfg) is selected.");
		offlineConfFile = "";
		alert("No configuration file(.cfg) is selected.");
	}
}
var gArrConfigFilelist = [];
var gArrConfigIndex = 0;
function startReadcfg() {
	LoadConfFile = "";
	var fileextension;
	var file = document.getElementById("offlineConfload").files[0];
	var fileSizeInKb = file.size/1024;
	var Filelist = "";
	var canAllow = false;
	var fileSize = file.size;
	LoadConfFile = file.name;
	fileextension = LoadConfFile.substr(LoadConfFile.lastIndexOf('.') + 1);
	if(fileextension == "cfg" || fileextension == "dump")
	{
		update_status_message("The size of the Configuration file selected is " + fileSizeInKb.toFixed(2) + " KB");
	} else {
		alert("Selected File Type is not supported. Please Select File type : .cfg/.dump");
		//reset_file_input();
		$("#offlineConfload").val('');
		$("#offlineConfload").css({
			background: "white",
			border: "0px"
			});
		LoadConfFile ="";
		return;
	}

	if (file) {
		if (Product == "USB2.0") {
			if (fileextension == "dump") {
				if (fileSize == 2048) {
					canAllow = true;
				} else {
					update_status_message("The size of configuration file \"" + file.name + "\" should be 2KB for USB2530 hub.");
					LoadConfFile = "";
					alert("The size of configuration file \"" + file.name + "\" should be 2KB for USB2530 hub.");
					return;
				}
			} else if (fileextension == "cfg") {
				if (fileSize <= 2048) {
					canAllow = true;
				} else {
					update_status_message("The size of configuration file \"" + file.name + "\" cannot exceed 2KB for USB2530 hub.");
					LoadConfFile = "";
					alert("The size of configuration file \"" + file.name + "\" cannot exceed 2KB for USB2530 hub.");
					return;
				}
			} else {
				//Do nothing	
			}
		} else if (Product == "USB3.1 Gen1") {
			if (fileextension == "dump") {
				if (fileSize == 8192) {
					canAllow = true;
				} else {
					update_status_message("The size of configuration file \"" + file.name + "\" should be 8KB for USB57X4 hub.");
					LoadConfFile = "";
					alert("The size of configuration file \"" + file.name + "\" should be 8KB for USB57X4 hub.");
					return;
				}
			} else if (fileextension == "cfg") {
				if (fileSize <= 8192) {
					canAllow = true;
				} else {
					update_status_message("The size of configuration file \"" + file.name + "\" cannot exceed 8KB for USB57X4 hub.");
					LoadConfFile = "";
					alert("The size of configuration file \"" + file.name + "\" cannot exceed 8KB for USB57X4 hub.");
					return;
				}
			} else {
				//Do nothing	
			}
		}	
	}
	
	if (canAllow) {
		$("#offlineConfload").css({
			background: "white",
			border: "0px"
		});
	}
	/*if (file && (file.size <= 8192)) {
		$("#offlineConfload").css({
		background: "white",
		border: "0px"
		});
	}else if((file.size > 8192))
	{
		update_status_message("The configuration file size cannot exceed 8KB.");
		LoadConfFile = "";
		alert("The configuration file size cannot exceed 8KB.");
	}*/
	if (gArrConfigIndex > 15)
	{
		alert("Max configuration file count is 15");
		return;
	}
	gArrConfigFilelist[gArrConfigIndex++] = LoadConfFile;
	var Texttodisplay = "Loaded Configuration files are ";
	for(var i = 0; i < gArrConfigIndex; i++)
	{
		Filelist = Filelist + gArrConfigFilelist[i] + ",";
	}
	update_status_message(Texttodisplay + Filelist);
	//overrideDefaultOfflineConfig function will return strap values in LoadConfFile
	//Return string format is "widget:value###widget:value.."

	var StrapValues = overrideDefaultOfflineConfig(LoadConfFile);
	
	if(StrapValues == null)
	{
		alert("Not a valid file");
	}
	var Straps = StrapValues.split("###");
	$.each(Straps, function (idx, value) {
		var widgetvalpairs = value.split(":");
		//After load configuration file , there may be new values for straps.
		//Update to StrapHashMapAfterChange hashmap for later comparison
		StrapHashMapAfterChange[widgetvalpairs[0]] = widgetvalpairs[1];
	});
	populateDefaultValues();
}

function setOfflineConf() {
	setFileType("cfg", 1);
}
function getOfflineConftype() {
	setFileType("cfg_dump", 0);
}

(function ($) {
    update_status_message = function (mesg) {
        //var time = new Date($.now()); // returns huge string
        var currentdate = new Date(); 
        currentdate+''; 
        var datetime = currentdate.toLocaleString();
        $("#DSStatusMessage").append( datetime +":"+ mesg + "\n");
        $("#DSStatusMessage").animate({
            scrollTop:$("#DSStatusMessage")[0].scrollHeight - $("#DSStatusMessage").height()
            },400,function(){
          })
        };
})(jQuery);

// Reset all fields
$("#Reset").click(function() {
	clearWidgetMap();
	set_changed_fields_border_default();
	$("input[type='file']").val('');
	populateDefaultValues();
	iniFile ="";
	offlineConfFile="";
	LoadConfFile = "";
	gArrConfigIndex = 0;
	RegString="";
	document.getElementById("myForm").reset();
	changecount =0;
	$('#memoryChoice').hide();
	/*$('#SaveFileField').hide();
	$('#SaveFileField').attr('disabled', 'disabled');
	$('#LoadFileField').removeAttr('disabled');
	$("#LoadFileField").attr('disabled', true);
	$('#LoadFileField').show();
	$("#LoadFileField").attr('disabled', false);*/
	
	//After reset Straps can be configured
	$.each(straplistinOTP, function (index, value) {
	    var widgetstrapsCannotbe = "#" + value + "Cannotbe";
	    var widgetstrapsCanbe = "#" + value + "Canbe";
	    $(widgetstrapsCannotbe).hide();
	    $(widgetstrapsCannotbe).attr('disabled', 'disabled');

	    $(widgetstrapsCanbe).removeAttr('disabled');
	    $(widgetstrapsCanbe).attr('disabled', true);
	    $(widgetstrapsCanbe).show();
	    $(widgetstrapsCanbe).attr('disabled', true);
	});
	
	$("#Apply").attr('disabled',true);
	reset_file_input();
	
	// Change border back to default color from red
	
	/*$.each(sentinelCheckBoxes, function( index, value ) {
		var widgetid = "#" + value;
		$(widgetid).prop('checked', false);
		$("input[type='text']").val('');
        $("input[type='number']").val('');
        $("input[type='checkbox']").removeAttr("checked");
        $("input[type='radio']").removeAttr("checked");
		$("input[type='file']").val('');
		$("#enableport1").prop('checked', true);
		$("#enableport2").prop('checked', true);
		$("#enableport3").prop('checked', true);
		$("#enableport4").prop('checked', true);
		iniFile = "";
		offlineConfFile = "";
	});
	
	//Disabling all the widgets
	$.each(fullWidgetList, function( index, value ) {
		var widgetID = "#" + value;
		$(widgetID).attr('disabled', true);
	});*/
	
	resetVariables();
});
// End of Reset all fields


//Populating the default widget values based on the SKU
function populateDefaultValues() {
	
	if (Product == "USB3.1 Gen1") {
		dummyHubID = "1";
	} else if (Product == "USB2.0") {
		dummyHubID = "0";
	} else {
		//Do Nothing
	}
	
	var skuName = sku; //Get from the dropdown
	
	//Setting the configuration mode to offline in the backend
	setConfigMode(true, skuName);

	//gArrConfigIndex is 0 means none of config files are loaded.
	//Hashmap map should have default values.
	if (gArrConfigIndex == 0) {
	    $.each(straplistinOTP, function (index, value) {
	        StrapHashMapDefault[value] = "DEFAULT";
	        StrapHashMapAfterChange[value] = "DEFAULT"
	    });
	}
	
	// Updating GwidgetlistHex
	$.each(GwidgetlistHex, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getWidgetValue(dummyHubID, value);

		if (widgetValue) {
			var decvalue = parseInt(widgetValue,10);
			var hexstring;
			if (value == "usbvcd" || value == "udc_usbvcd" || value == "usb3vcd") // remove the '.' added before
			{
				var dot = ".";
				var hexvalue = (decvalue.toString(16));
				var position = 1;
				var hexstring = [hexvalue.slice(0, position), dot, hexvalue.slice(position)].join('');
			} else {
				hexstring = decvalue.toString(16); //"0x" +  (decvalue.toString(16) );
			}
			$(widgetid).val(hexstring);
		}
	});

	// Updating GwidgetlistString
	$.each(GwidgetlistString, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getWidgetValue(dummyHubID, value);
		if((widgetValue === " ") || (widgetValue === "")) {
			$(widgetid).val(stringnullvalue);
		} else {
			$(widgetid).val(widgetValue);
		}
	});

	// Updating GwidgetlistInt
	$.each(GwidgetlistInt, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getWidgetValue(dummyHubID, value);
		if(widgetValue === "") {
			$(widgetid).val("");
		} else {
			var decVal;
			if (value == "hub3maxpowerselfbus") {
				decVal = widgetValue & 0xff;
				decVal = parseInt(decVal,10);
				decVal = decVal * 8;
			} else if((value == "hubcmaxpowerbus") || (value == "hubcmaxpowerself")) {
				decVal = widgetValue & 0xff;
				decVal = parseInt(decVal,10);
			} else {
				decVal = widgetValue & 0xff;
				decVal = parseInt(decVal,10);
				decVal = decVal * 2;
			}
			$(widgetid).val(decVal);
		}
	});

	// Updating GwidgetlistGUI
	$.each(GwidgetlistGUI, function( index, value ) {
		//upstreamport_HSIC_USB
	if (value == "upstreamport_HSIC_USB") {
		var upstreamport_HSIC_USB = getWidgetValue(HUB_ID, "upstreamport_HSIC_USB");
		if (  upstreamport_HSIC_USB == "0" ) // 0 = usb
		{
			$('#upstreamUSB').show();
			$('#upstreamHSIC').hide();
		}
		else if (  upstreamport_HSIC_USB == "1" ) // 1 = hsic
		{
			$('#upstreamHSIC').show();
			$('#upstreamUSB').hide();
		}
		else
		{
			console.log(" Failed to retrive Upstream configuration");
		}
	}

	//downstreamport1_HSIC_USB
	if (value == "downstreamport1_HSIC_USB") {
		var downstreamport1_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport1_HSIC_USB");
		if (  downstreamport1_HSIC_USB == "0" ) // 0 = usb
		{
			$('#downstreamUSBport1').show();
			$('#BdownstreamUSBport1').show();
			$('#downstreamHSICport1').hide();
		}
		else if (  downstreamport1_HSIC_USB == "1" ) // 1 = hsic
		{
			$('#downstreamHSICport1').show();
			$('#downstreamUSBport1').hide();
			$('#BdownstreamUSBport1').hide();
		}
		else
		{
			console.log(" Failed to retrive Downstream Port 1 configuration");
		}
	}
	
	//downstreamport2_HSIC_USB
	if (value == "downstreamport2_HSIC_USB") {
		var downstreamport2_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport2_HSIC_USB");
		if (  downstreamport2_HSIC_USB == "0" ) // 0 = usb
		{
			$('#downstreamUSBport2').show();
			$('#BdownstreamUSBport2').show();
			$('#downstreamHSICport2').hide();
		}
		else if (  downstreamport2_HSIC_USB == "1" ) // 1 = hsic
		{
			$('#downstreamHSICport2').show();
			$('#downstreamUSBport2').hide();
			$('#BdownstreamUSBport2').hide();
		}
		else
		{
			console.log(" Failed to retrive Downstream Port 2 configuration");
		}
	}
	
	//downstreamport3_HSIC_USB
	if (value == "downstreamport3_HSIC_USB") {
		var downstreamport3_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport3_HSIC_USB");
		if (  downstreamport3_HSIC_USB == "0" ) // 0 = usb
		{
			$('#downstreamUSBport3').show();
			$('#BdownstreamUSBport3').show();
			$('#downstreamHSICport3').hide();
		}
		else if (  downstreamport3_HSIC_USB == "1" ) // 1 = hsic
		{
			$('#downstreamHSICport3').show();
			$('#downstreamUSBport3').hide();
			$('#BdownstreamUSBport3').hide();
		}
		else
		{
			console.log(" Failed to retrive Downstream Port 3 configuration");
		}
	}
	
	//downstreamport4_HSIC_USB
	if (value == "downstreamport4_HSIC_USB") {
		var downstreamport4_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport4_HSIC_USB");
		if (  downstreamport4_HSIC_USB == "0" ) // 0 = usb
		{
			$('#downstreamUSBport4').show();
			$('#BdownstreamUSBport4').show();
			$('#downstreamHSICport4').hide();
		}
		else if (  downstreamport4_HSIC_USB == "1" ) // 1 = hsic
		{
			$('#downstreamHSICport4').show();
			$('#downstreamUSBport4').hide();
			$('#BdownstreamUSBport4').hide();
		}
		else
		{
			console.log(" Failed to retrive Downstream Port 4 configuration");
		}
	}
	
	});

	
	// Updating GwidgetlistCheckbox
	$.each(GwidgetlistCheckbox, function( index, value ) {
		var widgetid = "#" + value;
		var widgetValue = getWidgetValue(dummyHubID, value);

			
		if ( widgetValue == checkbox_checked_value )
		{
			$(widgetid).prop('checked',true);     
			// If there are corresponding fieldsets - enable them 
			$(widgetid).trigger("change"); 
			//set_changed_fields_border_default();
		}
		else {
			$(widgetid).prop('checked',false);
			// If there are corresponding fieldsets - disable them 
			$(widgetid).trigger("change"); 
			//set_changed_fields_border_default();
		}
	});

	// Updating GwidgetlistDropDown
	$.each(GwidgetlistDropDown, function( index, value ) {
		
		var widgetValue = getWidgetValue(dummyHubID, value);
		var decval = parseInt(widgetValue,10);
		var nameofcontrol = "." + value + "1";
		var nameofcontrol1 = "[data-bind=\"" + value + "label\"]";
		var selText;
		/*if ( value == "DREF" )
		{
			$.each(DropDownDREF, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		}
		if ( value == "TREF" )
		{
			$.each(DropDownTREF, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		}*/
		/*if ( value == "port1mapping"  
		|| value=="port2mapping"
		|| value=="port3mapping"
		|| value=="port4mapping")
		{
			$.each(DropDownPORTMAPPING, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		}*/
		if ( value == "PHYBOOST" || value=="PHYBOOSTdownstreamport1" 
		|| value=="PHYBOOSTdownstreamport2" || value=="PHYBOOSTdownstreamport3"
		|| value=="PHYBOOSTdownstreamport4")
		{
			$.each(DropDownPHYBOOST, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		
		}
		if ( value == "SQUELCH" || value=="SQUELCHdownstreamport1" 
		|| value=="SQUELCHdownstreamport2" || value=="SQUELCHdownstreamport3"
		|| value=="SQUELCHdownstreamport4")
		{
			$.each(DropDownSQUELCH, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		}
		if(value == "upstreamHsRiseFall" || value=="downstreamport1HsRiseFall"
		|| value=="downstreamport2HsRiseFall" || value =="downstreamport3HsRiseFall"
		|| value=="downstreamport4HsRiseFall")
		{
			$.each(DropDownHSRiseFall, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		}
		
		if ( value == "SLEW" || value=="SLEWdownstreamport1" 
		|| value=="SLEWdownstreamport2" || value=="SLEWdownstreamport3"
		|| value=="SLEWdownstreamport4")
		{
			$.each(DropDownSLEW, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;
				}
			});
		}
		if ( value == "DOI"|| value=="DOIdownstreamport1" 
		|| value=="DOIdownstreamport2" || value=="DOIdownstreamport3"
		|| value=="DOIdownstreamport4")
		{
			$.each(DropDownDOI, function( index, valuelist ) {
				if ( index == decval)
				{   
					selText = valuelist;;
				}
			});
		}
		// Update fields based on obtained value
		$(nameofcontrol)
	   .find(nameofcontrol1).text(selText)
		.children('.dropdown-toggle').dropdown('toggle');
	});
	
	// Updating GwidgetlistRadio
	$.each(GwidgetlistRadio, function( index, value ) {
		
		
		if (Product == "USB2.0") {
			if ( value === "upstreambatterysettings") {
				var widgetValue = getWidgetValue(dummyHubID, "upstreambatterysettingsgroup");
				
			} else {
				var groupname = value +"group";
				var widgetValue = getWidgetValue(dummyHubID, value);
			}
			var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
			$(nameofcontrol).prop("checked", true);
			
		}
		else {
			if ( value === "upstreambatterysettings") {
				$("#upstreamChargerDetectionDiv_usb2").hide();
			} else {
					var groupname = value +"group";
					var widgetValue = getWidgetValue(dummyHubID, value);
					var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
					$(nameofcontrol).prop("checked", true);
			}
		}
		
		if ( value === "hubpower")
		{
			var widgetid = "#hubpowergroup";
			// If there are corresponding fieldsets - enable them 
			$(widgetid).trigger("change"); 
			if (widgetValue == "0") { // Bus power
				// Disable the fields
				//$('#selfpowerfieldset').attr('disabled', 'disabled');
				//$('#buspowerfieldset').removeAttr('disabled');
				$('#selfpowerfieldset').hide();
				$('#buspowerfieldset').show();
			} else if (widgetValue == "1") { // Self power
				// Disable the fields
				//$('#buspowerfieldset').attr('disabled', 'disabled');
				//$('#selfpowerfieldset').removeAttr('disabled');
				$('#buspowerfieldset').hide();
				$('#selfpowerfieldset').show();
			}
			//set_changed_fields_border_default();
		}
	});
		
	
	$.each(straplistinOTP, function (index, value) {
	// Backend will return as "changed" for if config file has any strap register 
	    if (StrapHashMapAfterChange[value] == "changed") {
	        var widgetstrapsCannotbe = "#" + value + "Cannotbe";
	        var widgetstrapsCanbe = "#" + value + "Canbe";
	        $(widgetstrapsCanbe).hide();
	        $(widgetstrapsCanbe).attr('disabled', 'disabled');

	        $(widgetstrapsCannotbe).removeAttr('disabled');
	        $(widgetstrapsCannotbe).attr('disabled', true);
	        $(widgetstrapsCannotbe).show();
	        $(widgetstrapsCannotbe).attr('disabled', true);
	    }
	});
	
				if ($('#enableport1').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport1Fieldset').removeAttr('disabled');
					$('#nr1div').removeAttr('disabled');
					

					if (Product == "USB2.0") {
						$('#BdownstreamUSBport1').removeAttr('disabled');
					}
				}
				if ($('#enableport2').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport2Fieldset').removeAttr('disabled');
					$('#nr2div').removeAttr('disabled');

					if (Product == "USB2.0") {
						$('#BdownstreamUSBport2').removeAttr('disabled');
					}
				}
				if ($('#enableport3').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport3Fieldset').removeAttr('disabled');
					$('#nr3div').removeAttr('disabled');
					if (Product == "USB2.0") {
						$('#BdownstreamUSBport3').removeAttr('disabled');
					}
				}
				if ($('#enableport4').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport4Fieldset').removeAttr('disabled');
					$('#nr4div').removeAttr('disabled');
					if (Product == "USB2.0") {
						$('#BdownstreamUSBport4').removeAttr('disabled');
					}
				} //BdownstreamUSBport1
				
				if ($('#usb3enableport1').is(':checked')) {
					// Enable the fieldset                    
					$('#usb3nr1div').removeAttr('disabled');
					$('#memoryChoice').removeAttr('disabled');
				}
				if ($('#usb3enableport2').is(':checked')) {
					// Enable the fieldset                    
					
					$('#usb3nr2div').removeAttr('disabled');
					
				}
				if ($('#usb3enableport3').is(':checked')) {
					// Enable the fieldset                    
					
					$('#usb3nr3div').removeAttr('disabled');
					
				}
				if ($('#usb3enableport4').is(':checked')) {
					// Enable the fieldset                    
					
					$('#usb3nr4div').removeAttr('disabled');
					
				}
}

//Apply changes function
$("#Apply").click(function() {
	//Array to save the widgets and their values which were changed.
		var productname = getProduct();
		var deltaobj = [];
		var sentinel = true;
		var mismatchCheck = 0;
		
		// language id constraint
		var stringmodified = 0;
		var udc_stringmodified = 0;
		var usb3stringmodified = 0;
		var langid = $("#languageid").val();
		var udc_langid = $("#hce_languageid").val();
		var usb3langid = $("#usb3languageid").val();
		var currentvalue="NONE";
		
		// Check length of strings constraint
		var usb2StringLength = 0;
		var usb3StringLength = 0;
		var hceStringLength = 0;
		
		//Alert flags for string lengths
		var usb2StringFlag = true;
		var usb3StringFlag = true;
		var hceStringFlag = true;
		
		//flag for alert message
		var errorFlag = false;
		
		var port1dontchange=0;
		var port2dontchange=0;
		var port3dontchange=0;
		var port4dontchange=0;
		var enableMapping = false;
		
		var usb3port1dontchange=0;
		var usb3port2dontchange=0;
		var usb3port3dontchange=0;
		var usb3port4dontchange=0;
		var usb2map = 1;
		var usb3port1disable = 0;
		var usb3port2disable = 0;
		var usb3port3disable = 0;
		var usb3port4disable = 0;
		
		// Find out currently how many ports are enabled
		var bEnable1 = $(enableport1).is(':checked');
		var bEnable2 = $(enableport2).is(':checked');
		var bEnable3 = $(enableport3).is(':checked');
		var bEnable4 = $(enableport4).is(':checked');
		var SendNoofPorts = 0;
		//Total ports enabled 
		var bTotal = bEnable1+bEnable2+bEnable3+bEnable4;
		
		var usb3bEnable1 = $(usb3enableport1).is(':checked');
		var usb3bEnable2 = $(usb3enableport2).is(':checked');
		var usb3bEnable3 = $(usb3enableport3).is(':checked');
		var usb3bEnable4 = $(usb3enableport4).is(':checked');
		var usb3SendNoofPorts = 0;
		//Total ports enabled 
		var usb3bTotal = usb3bEnable1+usb3bEnable2+usb3bEnable3+usb3bEnable4;
		
		if (offlineConfFile == "") {
			update_status_message("Please select a file to save the offline Configuration.");
			alert("Please select a file to save the offline Configuration.");
			return;
		}
		
		// Check Port Disable condition
		var port1Status = $('#enableport1').is(':checked')?1:0;
		var port2Status = $('#enableport2').is(':checked')?1:0;
		var port3Status = $('#enableport3').is(':checked')?1:0;
		var port4Status = $('#enableport4').is(':checked')?1:0;
		var hceStatus = $('#hceenable').is(':checked')?1:0;
		
		var usb3port1Status = $('#usb3enableport1').is(':checked')?1:0;
		var usb3port2Status = $('#usb3enableport2').is(':checked')?1:0;
		var usb3port3Status = $('#usb3enableport3').is(':checked')?1:0;
		var usb3port4Status = $('#usb3enableport4').is(':checked')?1:0;
		

		if (hceStatus == 0) {
			if ((port1Status == 0) && (port2Status == 0) && (port3Status == 0) && (port4Status == 0)) {
				alert("Hub controller is disabled. Disabling all 4 downstream ports is not allowed.");
				update_status_message("Hub controller is disabled. Disabling all 4 downstream ports is not allowed.");
				return;
			}
		}

		if (productname == "USB3.1 Gen1") {
			if ((usb3port1Status == 0) && (usb3port2Status == 0) && (usb3port3Status == 0) && (usb3port4Status == 0)) {
				alert("Disabling all the 4 downstream ports is not allowed.");
				update_status_message("Disabling all the 4 downstream ports is not allowed.");
				return;
			}
		}
		//To program it to defaults when a port is disabled.
		if (bEnable1 == false) {
			var nrport1 = getWidgetValue(dummyHubID, "nrdeviceport1");
			var dpdmSwap1 = getWidgetValue(dummyHubID, "swapport1dpdm");
			var phyboost1 = getWidgetValue(dummyHubID, "PHYBOOSTdownstreamport1");
			var varisense1 = getWidgetValue(dummyHubID, "SQUELCHdownstreamport1");
			var hsrisefall1 = getWidgetValue(dummyHubID, "downstreamport1HsRiseFall");
	
			if (nrport1 != 0) {
				//deltaobj.push("nrdeviceport1", 0);
				nrModified = true;
			}
			
			if (dpdmSwap1 != 0) {
				deltaobj.push("swapport1dpdm", 0);
			}
			
			if (phyboost1 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport1", 0);
			}
			
			if (varisense1 != 0) {
				deltaobj.push("SQUELCHdownstreamport1", 0);
			}
			if(hsrisefall1 !=0)
			{
				deltaobj.push("downstreamport1HsRiseFall", 0);
			}
		}

		if (bEnable2 == false) {
			var nrport2 = getWidgetValue(dummyHubID, "nrdeviceport2");
			var dpdmSwap2 = getWidgetValue(dummyHubID, "swapport2dpdm");
			var phyboost2 = getWidgetValue(dummyHubID, "PHYBOOSTdownstreamport2");
			var varisense2 = getWidgetValue(dummyHubID, "SQUELCHdownstreamport2");
			var hsrisefall2 = getWidgetValue(dummyHubID, "downstreamport2HsRiseFall");
			if (nrport2 != 0) {
				//deltaobj.push("nrdeviceport2", 0);
				nrModified = true;
				
			}
			
			if (dpdmSwap2 != 0) {
				deltaobj.push("swapport2dpdm", 0);
			}
			
			if (phyboost2 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport2", 0);
			}
			
			if (varisense2 != 0) {
				deltaobj.push("SQUELCHdownstreamport2", 0);
			}
			if(hsrisefall2 !=0)
			{
				deltaobj.push("downstreamport2HsRiseFall", 0);
			}
		}

		if (bEnable3 == false) {
			var nrport3 = getWidgetValue(dummyHubID, "nrdeviceport3");
			var dpdmSwap3 = getWidgetValue(dummyHubID, "swapport3dpdm");
			var phyboost3 = getWidgetValue(dummyHubID, "PHYBOOSTdownstreamport3");
			var varisense3 = getWidgetValue(dummyHubID, "SQUELCHdownstreamport3");
			var hsrisefall3 = getWidgetValue(dummyHubID, "downstreamport2HsRiseFall");
			if (nrport3 != 0) {
				//deltaobj.push("nrdeviceport3", 0);
				nrModified = true;
				
			}
			
			if (dpdmSwap3 != 0) {
				deltaobj.push("swapport3dpdm", 0);
			}
			
			if (phyboost3 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport3", 0);
			}
			
			if (varisense3 != 0) {
				deltaobj.push("SQUELCHdownstreamport3", 0);
			}
			if(hsrisefall3 !=0)
			{
				deltaobj.push("downstreamport3HsRiseFall", 0);
			}
		}

		if (bEnable4 == false) {
			var nrport4 = getWidgetValue(dummyHubID, "nrdeviceport4");
			var dpdmSwap4 = getWidgetValue(dummyHubID, "swapport4dpdm");
			var phyboost4 = getWidgetValue(dummyHubID, "PHYBOOSTdownstreamport4");
			var varisense4 = getWidgetValue(dummyHubID, "SQUELCHdownstreamport4");
			var hsrisefall4 = getWidgetValue(HUB_ID, "downstreamport4HsRiseFall");
			if (nrport4 != 0) {
				//deltaobj.push("nrdeviceport4", 0);
				nrModified = true;
				
			}
			
			if (dpdmSwap4 != 0) {
				deltaobj.push("swapport4dpdm", 0);
			}
			
			if (phyboost4 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport4", 0);
			}
			
			if (varisense4 != 0) {
				deltaobj.push("SQUELCHdownstreamport4", 0);
			}
			if(hsrisefall4 !=0)
			{
				deltaobj.push("downstreamport4HsRiseFall", 0);
			}
		}
		
		if (usb3bEnable1 == false) {
			var usb3nrport1 = getWidgetValue(dummyHubID, "usb3nrdeviceport1");
			
			if (usb3nrport1 != 0) {
				//deltaobj.push("nrdeviceport1", 0);
				usb3nrModified = true;
			}
			
		}
		
		if (usb3bEnable2 == false) {
			var usb3nrport2 = getWidgetValue(dummyHubID, "usb3nrdeviceport2");
			
			if (usb3nrport2 != 0) {
				//deltaobj.push("nrdeviceport1", 0);
				usb3nrModified = true;
			}
			
		}
		
		if (usb3bEnable3 == false) {
			var usb3nrport3 = getWidgetValue(dummyHubID, "usb3nrdeviceport3");
			
			if (usb3nrport3 != 0) {
				//deltaobj.push("nrdeviceport1", 0);
				usb3nrModified = true;
			}
			
		}
		
		if (usb3bEnable4 == false) {
			var usb3nrport4 = getWidgetValue(dummyHubID, "usb3nrdeviceport4");
			
			if (usb3nrport4 != 0) {
				//deltaobj.push("nrdeviceport1", 0);
				usb3nrModified = true;
			}
			
		}


		//TO DO: String length constraint check and coding
		//String Descriptors
		$.each(GwidgetlistString, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(HUB_ID, value1);
			//todo
			if((typeof oldval== 'undefined') || (oldval =="undefined"))
			{
				errorFlag = true;
				return;
			}
			var newval = $(widgetid).val();

			if (Product == "USB3.1 Gen1") {
				if (value1 === "usb3manufacturer" || value1 === "usb3product"|| value1 === "usb3serial")
				{
					var stringvalue = $(widgetid).val();
					// Check the widget length also
					if (stringvalue  == stringnullvalue )
					{
						// do nothing null string
					} else {
						usb3StringLength = usb3StringLength + $(widgetid).val().length;
					}
					//Checking the string length constraint
					if ((usb3StringLength > 90) && usb3StringFlag)
					{
						window.alert("String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB3.1 Gen1 can have a max length of 90 unicode characters only");
						update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB3.1 Gen1 can have a max length of 90 unicode characters only");
						usb3StringFlag = false;
						errorFlag = true;
						return;
					}
				}
			}
			
			if (value1 === "manufacturer" || value1 === "product"|| value1 === "serial")
			{
				var stringvalue = $(widgetid).val();

				// Check the widget length also
				if (stringvalue  == stringnullvalue)
				{
					// do nothing null string
				} else {
					usb2StringLength = usb2StringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
				if ((usb2StringLength > 90) && usb2StringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB2.0 can have a max length of 90 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB2.0 can have a max length of 90 unicode characters only");
					usb2StringFlag = false;
					errorFlag = true;
					return;
				}
			}
			
			if(value1 === "hce_manufacturer") {
				enablealertmanu = true;
			} else if(value1 === "hce_product") {
				enablealertprod = true;
			} else if(value1 === "hce_serial") {
				enablealertser = true;
			}
			
			if (value1 === "hce_manufacturer" || value1 === "hce_product" || value1 === "hce_serial")
			{
				var stringvalue = $(widgetid).val();

				// Check the widget length also
				if (stringvalue  == stringnullvalue)
				{
					// do nothing null string
				} else {
					hceStringLength = hceStringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
			
				if ((hceStringLength > 60) && hceStringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name and Product name) of Hub Feature Controller can have a max length of 60 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name and Product name) of Hub Feature Controller can have a max length of 60 unicode characters only");
					hceStringFlag = false;
					errorFlag = true;
					return;
				}
			}

			if (Product == "USB3.1 Gen1") {
				if (value1 === "usb3uuid") {
					var uuidVal = $(widgetid).val();
					var isOkay = /^[0-9a-fA-F]{1,32}$/i.test(uuidVal);

					if (uuidVal == "") {
						alert("Please enter a value for USB3.1 Gen1 UUID.");
						errorFlag = true;
						return;
					} else if (!isOkay) {
						alert("UUID value entered is invalid. UUID of USB3.1 Gen1 must be a 16 bytes of hexadecimal number.");
						update_status_message("UUID value entered is invalid. UUID of USB3.1 Gen1 must be a 16 bytes of hexadecimal number.");
						errorFlag = true;
						return;
					}
				}
			}

			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if ((newval === stringnullvalue) || (newval === oldval))
			{
				// do nothing no change detected.
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				 console.log("change detected but field disabled: widget:" + value1);
			}
			else {
				
				//console.log("change detected : widget:" + value1); // + " current value:" + val1 + " new value:" + newval);
				if (Product == "USB3.1 Gen1") {
					if (value1 === "usb3manufacturer" || 
						value1 === "usb3product"||
						value1 === "usb3serial")
					{
						usb3stringmodified = 1;
					}
				}

				if (value1 === "hce_manufacturer" || 
					value1 === "hce_product" || value1 === "hce_serial")
				{
					udc_stringmodified = 1;
				}
				
				if (value1 === "manufacturer" || 
					value1 === "product"||
					value1 === "serial")
				{
					stringmodified = 1;
				}

				if (jQuery.isEmptyObject(newval)) {
					newval = "";
				}

				if (value1 === "manufacturer" || value1 === "product"|| 
					value1 === "serial")
				{
					
					deltaobj.push(value1, newval);
					//modifiedWidgets.push(value1);
					
					// Set the widget length also
					var len = $(widgetid).val().length;
					// Now check if length constraint is met or not.
					var lenwidget = value1 + "len";
					//console.log("Also updating :" + lenwidget + " new value:" + len);
					deltaobj.push(lenwidget,len);
				}  
				
				if (Product == "USB3.1 Gen1") {
					
					if (value1 === "usb3manufacturer" || value1 === "usb3product"|| 
						value1 === "usb3serial")
					{
						deltaobj.push(value1, newval);
						//modifiedWidgets.push(value1);
					}
				}
				
				if (value1 === "hce_manufacturer") {
					hceenablemanu = true;
					
				} else if (value1 === "hce_product") {
					hceenableprod = true;
				}  else if(value1 === "hce_serial") {
					hceenableser = true;
				}
				
				if(Product == "USB3.1 Gen1" ) {
					
					if (value1 == "usb3uuid") {
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
					}
					
				}
			}
		}); //End of $.each(GwidgetlistString, function( index1, value1 )*/
		
		//Hex Descriptors
		$.each(GwidgetlistHex, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval;
			var newval;
			var isOk;
			
			if(value1 === "usbvcd" || value1 === "udc_usbvcd" || value1 === "usb3vcd") {
				var usbvcdVal = parseInt(getWidgetValue(dummyHubID, value1), 10);
				var dot = ".";
				var hexvalue = (usbvcdVal.toString(16));
				var position = 1;
				var hexstring = [hexvalue.slice(0, position), dot, hexvalue.slice(position)].join('');
				oldval = hexstring;
				newval = $(widgetid).val();
				if (value1 == "usbvcd") {
					isOk = /^2\.?[0-9]{0,2}$/i.test($(widgetid).val());
				}
				
				if (Product == "USB3.1 Gen1") {
					if (value1 == "usb3vcd") {
						isOk = /^3\.?[0-9]{0,2}$/i.test($(widgetid).val());
					}
				}
				
				if (typeof isOk == 'undefined') {
					return;
				}
				if (!isOk) {
					update_status_message("The value entered for \"" + Mapping[value1] + "\" is not valid.");
					alert("The value entered for \"" + Mapping[value1] + "\" is not valid");
					errorFlag = true;
				}
			} else {
				oldval = parseInt(getWidgetValue(dummyHubID, value1), 10);
				isOk = /^[0-9A-Fa-f]{1,4}$/i.test($(widgetid).val());
				newval = parseInt($(widgetid).val(), 16);
				
				if ((value1 == "vid") || (value1 == "hce_vid") || (value1 == "usb3vid")) {
					var widID = "#" + value1;
					var widVal = $(widID).val();
					if (widVal == 0) {
						isOk = false;
					}
				}
				
				if (!isOk) {
					if (value1 == "usb3pid" || value1 == "usb3did" || value1 == "usb3vid" || value1 == "usb3languageid") {
						if (Product == "USB3.1 Gen1") {
							update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
							alert("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
							errorFlag = true;
						}
					} else {
						update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						alert("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						errorFlag = true;
					}
				}
			}
			
			if (!isOk) {
				// Do nothing. The value entered does not meet the expected pattern.
			} else {
				if ((oldval === newval) || isNaN(newval)) {
					//Do nothing
				} else {
					//Check for language ID
					if ((value1 == "languageid") || (value1 == "hce_languageid") || (value1 == "usb3languageid")) {
						if (newval == 0) {
							alert("Language ID cannot be zero. Setting it to default value (0x409)");
							newval = parseInt("0x409", 16);
						}
					}
					// Adding the VID of USB2.0 and HCE to Protouch2.ini, if they are modified.
					if ((value1 == "vid") || (value1 == "hce_vid")) {
						var valueEntered = $(widgetid).val();
						var hexEntered = "0x" + valueEntered;
						updateINI(hexEntered);
						vidModified = true;
					}

					// convert string to number                                        
					var decvalue = parseInt(newval,10);
					// convert number to string and then string to hex
					var valueToSet;
					if (value1 =="usbvcd" || value1 =="udc_usbvcd" || value1 == "usb3vcd") // remove the '.' added before
					{
						newval = newval.replace('.', '');
						decvalue = parseInt(newval,10);
						valueToSet = decvalue;
					}
					else {
						valueToSet = "0x" +  (decvalue.toString(16) ); 
					}
					var that = $( widgetid ), parent = that.closest('fieldset');
					var  checkdisabled = $(parent).prop( "disabled" );
					if ( checkdisabled )
					{
						// Change detected but field is disabled - So do nothing
						console.log("change detected but field disabled: widget:" + value1 + " new value:" + hexstring);
					}
					else {
						if (((value1 === "vid") || (value1 === "usb3vid")) && (Product == "USB3.1 Gen1")) {
							if (sentinel) {
								var usb3VID = $("#usb3vid").val();
								var usb2VID = $("#vid").val();
								if (usb3VID == usb2VID) {
									sentinel = false;
									deltaobj.push("vid", valueToSet);
									deltaobj.push("usb3vid", valueToSet);
								} else {
									update_status_message("Mismatch in VID of USB2.0 and USB3.1 Gen1. Please make sure their VID is the same.");
									mismatchCheck++;
									if (mismatchCheck == 1) {
										alert("Mismatch in VID of USB2.0 and USB3.1 Gen1. Please make sure their VID is the same.");
										errorFlag = true;
										return;
									}
								}
							}
						} else {
				
							deltaobj.push(value1,valueToSet);
						}
					}
				}
			}
		});

		//Int Descriptors
		$.each(GwidgetlistInt, function(index1, value1) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(dummyHubID, value1);
			if (value1 == "hub3maxpowerselfbus") {
				if (Product == "USB3.1 Gen1") {
					oldval = parseInt(oldval,10) * 8;
				}
			} else if((value1 == "hubcmaxpowerbus") || (value1 == "hubcmaxpowerself")){
				oldval = parseInt(oldval,10);
			}else{
				oldval = parseInt(oldval,10) *2;
			}
			var that = $(widgetid), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop("disabled");
			
			var newval = $(widgetid).val();
			var newdecvalue = parseInt(newval,10);
			newdecvalue = newdecvalue & 0xff;
			if(((Product == "USB3.1 Gen1") && (value1 == "hub3maxpowerselfbus")) || (value1 == "maxpowerself") || (value1 == "maxpowerbus") )
			{
				if ((newdecvalue & 0x01) && !checkdisabled)
				{
					currentvalue = "ODDNUM";
					return;
				}
			}
			
			if ((oldval == newval) || isNaN(newval)) {
				// do nothing - no change in value
				//console.log("nochange:widget:" + widget1 + " value:" + val1 + " new value:" + newval);
			} 
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				console.log("change detected but field disabled: widget:" + value1 + " new value:" + newdecvalue); //+ " current value:" + val1 + " new value:" + newval);
			}
			else {
				if ((value1 == "maxpowerself") || (value1 == "hubcmaxpowerself")) {
					if ((newval > 100) || (newval < 0)) {
						alert ("USB2.0 max power(self) or USB2.0 hub circuit max power(self) cannot be more than 100mA or negative.");
						update_status_message("USB2.0 max power(self) or USB2.0 hub circuit max power(self) cannot be more than 100mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if (value1 == "maxpowerbus") {
					if ((newval > 500) || (newval < 0)) {
						alert ("USB2.0 max power(bus) cannot be more than 500mA or negative.");
						update_status_message("USB2.0 max power(bus) cannot be more than 500mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if (value1 == "hubcmaxpowerbus") {
					if ((newval > 255) || (newval < 0)) {
						alert ("USB2.0 hub circuit max power(bus) cannot be more than 255mA or negative.");
						update_status_message("USB2.0 hub circuit max power(bus) cannot be more than 255mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if ((value1 == "hub3maxpowerselfbus") && (Product == "USB3.1 Gen1")) {
					if ((newval > 900) || (newval < 0)) {
						alert ("USB3.1 Gen1 hub max power cannot be more than 900mA or negative.");
						update_status_message("USB3.1 Gen1 hub max power cannot be more than 900mA or negative.");
						errorFlag = true;
						return;
					}
				}
				var hexval;
				if ((value1 == "hub3maxpowerselfbus") && (Product == "USB3.1 Gen1")) {
					var newdecvalue = parseInt(newval,10);
					var reminder = newdecvalue%8;
					if(reminder != 0)
					{
						alert ("Hub Max Power 3.1 Gen1 field can have multiples of 8 only");
						var mesg = "Error : Hub Max Power 3.1 Gen1 field can have multiples of 8 only";
						update_status_message(mesg);
						errorFlag = true;
						return;
					}
					newdecvalue = newdecvalue/8;
					var temp = Math.floor(newdecvalue);
					hexval = temp.toString(16);
				} else if ((value1 == "hubcmaxpowerbus") || (value1 == "hubcmaxpowerself")) {
					newdecvalue = parseInt(newval,10);
					hexval = newdecvalue.toString(16);
				} else {
					newdecvalue = parseInt(newval,10);
					newdecvalue = newdecvalue/2;
					hexval = newdecvalue.toString(16);
				}
				deltaobj.push(value1, hexval);
			}
		});
		if (currentvalue == "ODDNUM") {
			$("#progID").hide();
			alert("\"Hub MaxPower(Self)\", \"Hub Circuit MaxPower(Self)\", \"HubMaxPower(Bus)\" and \"Hub Circuit MaxPower(Bus)\" fields can have even numbers only");
			var mesg = "Error : \"Hub MaxPower(Self)\", \"Hub Circuit MaxPower(Self)\", \"Hub MaxPower(Bus)\" and \"Hub Circuit MaxPower(Bus)\" fields can have even numbers only";
			update_status_message(mesg);
			currentvalue= "NONE";
			errorFlag = true;
			return;
		}

		//Radio buttons
		$.each(GwidgetlistRadio, function(index2, value1) {
			var widgetgroupname = '#' + value1 +"group";
			var oldval = getWidgetValue(dummyHubID, value1);
			var newval = $(widgetgroupname).find(':checked').val();
			var that = $( widgetgroupname ), parent = that.closest('fieldset');
			var  checkdisabled = $(parent).prop( "disabled" );
			if ((oldval === newval) || jQuery.isEmptyObject(newval))
			{
				// do nothing
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				console.log("change detected but field disabled: widget:" + widgetgroupname + " new value:" + newval);// + " current value:" + val1 + " new value:" + newval1);
			}
			else
			{
				if (value1 == "downstreamBCsettingport1") {
					var state = $("#enableport1").is(':checked');
					var valueToAdd;
					if (state) {
						valueToAdd = "1";
					} else {
						valueToAdd = "0";
					}
					deltaobj.push("enableport1", valueToAdd);
					enableprt1 = true;
				}
				
				if (value1 == "downstreamBCsettingport2") {
					var state = $("#enableport2").is(':checked');
					var valueToAdd;
					if (state) {
						valueToAdd = "1";
					} else {
						valueToAdd = "0";
					}
					deltaobj.push("enableport2", valueToAdd);
					enableprt2 = true;
				}
				
				if (value1 == "downstreamBCsettingport3") {
					var state = $("#enableport3").is(':checked');
					var valueToAdd;
					if (state) {
						valueToAdd = "1";
					} else {
						valueToAdd = "0";
					}
					deltaobj.push("enableport3", valueToAdd);
					enableprt3 = true;
				}
				
				if (value1 == "downstreamBCsettingport4") {
					var state = $("#enableport4").is(':checked');
					var valueToAdd;
					if (state) {
						valueToAdd = "1";
					} else {
						valueToAdd = "0";
					}
					deltaobj.push("enableport4", valueToAdd);
					enableprt4 = true;
				}
				console.log("widget" + value1 + " Selected option is " + newval);
				deltaobj.push(value1, newval);
			}
		});
		
		//Checkbox
		$.each(GwidgetlistCheckbox, function( index2, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(dummyHubID, value1);
			var newval = checkbox_unchecked_value;
			
			var that = $( widgetid ), parent = that.closest('fieldset');
			var  checkdisabled = $(parent).prop( "disabled" );
			if($(widgetid).is(':checked'))
			{
				newval = checkbox_checked_value;
			}

			
			// Enabled - check the previous value and determine delta                              
			if (oldval === newval) {
				// do nothing - no change in value
				//console.log("Checkbox:nochange:widget:" + widget1 + " value:" + val1 + " new value:" + newval);
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				 console.log("change detected but field disabled: widget:" + value1 + " new value:" + newval);// + " current value:" + val1 + " new value:" + newval);
			}
			else {
				//Check for Non-removable parameter changes for all downstream port
				

				if (Product == "USB3.1 Gen1") 
				{
					$('#memoryChoice').show();
					if ((value1 == "enableport1") && (!($('#enableport1').is(':checked')))) {
					
					if ($('#usb3enableport1').is(':checked')) {
						alert("Usb2.0 port of Port1 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port1 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport2") && (!($('#enableport2').is(':checked')))) {
					if ($('#usb3enableport2').is(':checked')) {
						alert("Usb2.0 port of Port2 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port2 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport3") && (!($('#enableport3').is(':checked')))) {
					if ($('#usb3enableport3').is(':checked')) {
						alert("Usb2.0 port of Port3 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port3 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport4") && (!($('#enableport4').is(':checked')))) {
					if ($('#usb3enableport4').is(':checked')) {
						alert("Usb2.0 port of Port4 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port4 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				}

				if (value1 == "nrdeviceport1") {
					nr1Modified = true;
				} 
				if(value1 == "nrdeviceport2") {
					nr2Modified = true;
				} 
				if(value1 == "nrdeviceport3") {
					nr3Modified = true;
				} 
				if(value1 == "nrdeviceport4") {
					nr4Modified = true;
				}
				
				//usb3
				if (value1 == "usb3nrdeviceport1") {
					usb3nr1Modified = true;
				} 
				if(value1 == "usb3nrdeviceport2") {
					usb3nr2Modified = true;
				} 
				if(value1 == "usb3nrdeviceport3") {
					usb3nr3Modified = true;
				} 
				if(value1 == "usb3nrdeviceport4") {
					usb3nr4Modified = true;
				}
				
					
				if (Product == "USB3.1 Gen1") {
					if (!usb3SendNoofPorts && !usb3numberofportState)
					{
						if(($(usb3nrdeviceport1).is(':checked')) || ($(usb3nrdeviceport2).is(':checked')) || ($(usb3nrdeviceport3).is(':checked')) || ($(usb3nrdeviceport4).is(':checked')))
						{
							usb3nrModified = true;
						}
						deltaobj.push("usb3numberofports",usb3bTotal);
						enableMapping = true;
						usb3SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
					}
					
					if (!SendNoofPorts && !numberofportState)
					{
						if(($(nrdeviceport1).is(':checked')) || ($(nrdeviceport2).is(':checked')) || ($(nrdeviceport3).is(':checked')) || ($(nrdeviceport4).is(':checked')))
						{
							usb3nrModified = true;
						}
						deltaobj.push("numberofports",bTotal);
						enableMapping = true;
						SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
					}
				}
					
				//2.0 mapping
				
				if(Product == "USB2.0")
					{
							if ((value1 == "enableport1") || (value1 == "enableport2")
								||(value1 == "enableport3") || (value1 == "enableport4")) 
					{
						
						
						if (!SendNoofPorts && !numberofportState)
						{
							if(($(nrdeviceport1).is(':checked')) || ($(nrdeviceport2).is(':checked')) || ($(nrdeviceport3).is(':checked')) || ($(nrdeviceport4).is(':checked')))
							{
								nrModified = true;
							}
							deltaobj.push("numberofports",bTotal);
							SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
						}
					
					var portCountTomap = 1;
					if( value1 == "enableport1")
					{
						if (oldval === newval) {
							//do nothing
						}
						else if (!port1dontchange)
						{
							//portCountTomap = 1; //Start port number
							if ( newval ==  0)
							{
								deltaobj.push("port1mapping",0);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable2)
								{
									if (!port2dontchange)
									{
										deltaobj.push("port2mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port2dontchange = 1;
										
									}
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									if (!port3dontchange)
									{
										deltaobj.push("port3mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port3dontchange = 1;
										
									}
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									if (!port4dontchange)
									{
										deltaobj.push("port4mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port4dontchange = 1;
									}
								}
							}
							else
							{
								
								deltaobj.push("port1mapping",portCountTomap++);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable2)
								{
									deltaobj.push("port2mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port2dontchange = 1;
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									deltaobj.push("port3mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port3dontchange = 1;
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									deltaobj.push("port4mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port4dontchange = 1;
								}
							}
						} else { // do nothing 
						}
					}
					if( value1 == "enableport2")
					{
						portCountTomap = bEnable1 + 1;  //Start port number
						if (oldval === newval) {
							//do nothing
						}
						else if (!port2dontchange)
						{
							if ( newval ==  0)
							{
								deltaobj.push("port2mapping",0);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									if (!port3dontchange)
									{
										deltaobj.push("port3mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port3dontchange = 1;
									}
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									if (!port4dontchange)
									{
										deltaobj.push("port4mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port4dontchange = 1;
									}
								}
							}
							else
							{
								deltaobj.push("port2mapping",portCountTomap++);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									deltaobj.push("port3mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port3dontchange = 1;
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									deltaobj.push("port4mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port4dontchange = 1;
								}
							}
						} else { // do nothing
						}
					}
					if( value1 == "enableport3")
					{
						portCountTomap = bEnable1 + bEnable2 + 1;  //Start port number
						if (oldval === newval) {
							//do nothing
						}
						else if (!port3dontchange)
						{		
							if ( newval ==  0)
							{
								deltaobj.push("port3mapping",0);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									if (!port4dontchange)
									{
										deltaobj.push("port4mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port4dontchange = 1;
									}
								}
							}
							else
							{
								deltaobj.push("port3mapping",portCountTomap++);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									deltaobj.push("port4mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port4dontchange = 1;
								}
							}
						} else { // Do nothing
						}
					}
					if( value1 == "enableport4")
					{
						portCountTomap = bEnable1 + bEnable2 + bEnable3 + 1;  //Start port number
						console.log("enableport4n" + newval);
						if (oldval === newval) {
							//do nothing
						}
						else if (!port4dontchange)
						{
							if ( newval ==  0)
							{
								//There is no next port for tyler to remap, change directly
								// No need to check for the port whether it is enabled
								// Will get into this only this port is enabled
								deltaobj.push("port4mapping",0);
							}
							else
							{
								// No need to check for the port whether it is enabled
								// Will get into this only this port is enabled
								deltaobj.push("port4mapping",portCountTomap++);
							}
						} else { // Do nothing
						}
					}
				}
			}
					//Check for Flexconnect enable or disable
					if ((value1 == "flexconnect") && (newval == checkbox_checked_value)) {
						enableFlex = true;
						disableFlex = false;
					} else if ((value1 == "flexconnect") && (newval == checkbox_unchecked_value)) {
						enableFlex = false;
						disableFlex = true;
					} else {
						enableFlex = false;
						disableFlex = false;
					}
					
					//Check for Upstream D+/D- swap
					if ((value1 == "swapupstreamdpdm") && (newval == checkbox_checked_value)) {
						enable_swapupstreamdpdm = true;
					} else {
						enable_swapupstreamdpdm = false;
					}
					
					
					
					/*if(Product == "USB3.1 Gen1") 
					{
						if((value1 == "usb3enableport1"))
						{
							if(newval == 0)	
							{
								deltaobj.push("usb3port1mapping",0);
							}	
							else if(newval == 1)	
							{
								deltaobj.push("usb3port1mapping",usb3portmapcount);
							}
							else
							{
								//do nothing
							}
						}
						
						if((value1 == "enableport1"))
						{
							if(newval == 0)	
							{
								deltaobj.push("port1mapping",0);
							}
							else if(newval == 1)	
							{
								deltaobj.push("port1mapping",usb2portmapcount);
							}
							else
							{
								//do nothing
							}
						}
						
					}*/
					
					//Check flexconnect condition
					if (value1 == "flexconnect") {
						if ($('#enableport1').is(':checked')) {
							deltaobj.push("flexconnect", newval);
						} else {
							alert("Downstream port 1 is disabled. Flex connect cannot be done. \n Enable Downstream port 1 and try again.");
							errorFlag = true;
						}
					} else if (value1 == "swapupstreamdpdm") {
						if ($('#swapupstreamdpdm').is(':checked')) {
							alert("Programming Upstream swap will swap D+ and D- lines of Upstream port. Please make require changes in hub for further processing after successful programming");
						}
						deltaobj.push("swapupstreamdpdm", newval);
					}  else if (value1 == "cdcenable") {
						if (Product == "USB3.1 Gen1") {
							deltaobj.push(value1, newval);
						}
					} else {
						deltaobj.push(value1, newval);
					}
					
					if ((value1 == "hceenable") && (Product == "USB2.0")) {
						deltaobj.push("numberofports", bTotal);
					}
				//}
			}
		});

		if(enablealertmanu && enablealertmanu && enablealertmanu) {
			var manuval = $("#hce_manufacturer").val();
			var prodval = $("#hce_product").val();
			var serval = $("#hce_serial").val();
			
			if((manuval != stringnullvalue) && (prodval != stringnullvalue) && (serval != stringnullvalue)) {
				window.alert("Only two strings can be enabled at a time for Hub Feature Controller.");
				update_status_message("Error : Only two strings can be enabled at a time for Hub Feature Controller.");
				hceStringFlag = false;
				errorFlag = true;
				return;
			}
				
		}
		if(hceenablemanu || hceenableprod || hceenableser) {
			var manuval = $("#hce_manufacturer").val();
			var prodval = $("#hce_product").val();
			var serval = $("#hce_serial").val();
			var manlen = $("#hce_manufacturer").val().length;
			var prodlen = $("#hce_product").val().length;
			var serlen = $("#hce_serial").val().length;
			
			
			if(manuval == stringnullvalue) {
				manuval = "";
				manlen = 0;
			} else if(prodval == stringnullvalue) {
				prodval = "";
				prodlen = 0;
			} else if(serval == stringnullvalue) {
				serval = "";
				serlen = 0;
			}
			
			//console.log("Also updating :" + lenwidget + " new value:" + len);
			deltaobj.push("hce_manufacturerlen",manlen);
			deltaobj.push("hce_productlen",prodlen);
			deltaobj.push("hce_seriallen",serlen);
			deltaobj.push("hce_manufacturer", manuval);
			deltaobj.push("hce_product", prodval);
			deltaobj.push("hce_serial", serval);
			
		}
		
		if ((Product == "USB3.1 Gen1") && (enableMapping == true)) {
						
		var usb3portmapcount = 1;
		var usb2portmapcount = 1;
		var usb2port1MapLaterFlag = false;
		var usb2port2MapLaterFlag = false;
		var usb2port3MapLaterFlag = false;
		var usb2port4MapLaterFlag = false;
		var currentStartPoint = 0;

		if(!bEnable1 && !usb3bEnable1)
		{
			deltaobj.push("usb3port1mapping", 0);
			deltaobj.push("port1mapping", 0);
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}
			

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			// USB2.0 Port mapping
			
			if (currentStartPoint == 4) {
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
			}
		} else if (bEnable1 && !usb3bEnable1) {
			deltaobj.push("usb3port1mapping", 0);
			usb2port1MapLaterFlag = true;
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}
			

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			// USB2.0 Port mapping
			
			if (currentStartPoint == 4) {
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
			}
		} else if (bEnable1 && usb3bEnable1) {
			currentStartPoint = 1;
			deltaobj.push("usb3port1mapping", usb3portmapcount++);
			deltaobj.push("port1mapping", usb2portmapcount++);
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}
			

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			// USB2.0 Port mapping
			
			if (currentStartPoint == 4) {
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}

				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}

				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
			}
			
		}
	}
		//DropDown
		$.each(GwidgetlistDropDown, function(index2, value1) {
			var nameofcontrol = "." + value1 + "1";
			var nameofcontrol1 = "[data-bind=\"" + value1 + "label\"]";
			var selText = $(nameofcontrol).find(nameofcontrol1).text();
			var newindexofdropdownlist;
			var that = $( nameofcontrol ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );

			/*if (value1 === "DREF")
			{
				$.each(DropDownDREF, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}*/
			/*if (value1 === "TREF")
			{
				$.each(DropDownTREF, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}*/
			if (value1 === "PHYBOOST" || value1 === "PHYBOOSTdownstreamport1" ||
				value1 === "PHYBOOSTdownstreamport2" ||value1 === "PHYBOOSTdownstreamport3" ||
				value1 === "PHYBOOSTdownstreamport4")
			{
				$.each(DropDownPHYBOOST, function(index, valuelist) {
					if ( selText === valuelist)
					{   
					
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "SQUELCH" || value1 === "SQUELCHdownstreamport1" ||
				value1 === "SQUELCHdownstreamport2" ||value1 === "SQUELCHdownstreamport3" ||
				value1 === "SQUELCHdownstreamport4")
			{
				$.each(DropDownSQUELCH, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "SLEW" || value1 === "SLEWdownstreamport1" ||
				value1 === "SLEWdownstreamport2" ||value1 === "SLEWdownstreamport3" ||
				value1 === "SLEWdownstreamport4")
			{
				$.each(DropDownSLEW, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			
			if(value1 === "upstreamHsRiseFall" || value1 === "downstreamport1HsRiseFall" ||
				value1 === "downstreamport2HsRiseFall" ||value1 === "downstreamport3HsRiseFall" ||
				value1 === "downstreamport4HsRiseFall")
			{
				$.each(DropDownHSRiseFall, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "DOI" || value1 === "DOIdownstreamport1" ||
				value1 === "DOIdownstreamport2" ||value1 === "DOIdownstreamport3" ||
				value1 === "DOIdownstreamport4")
			{
				$.each(DropDownDOI, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			
			var oldval = getWidgetValue(dummyHubID, value1);

			if (newindexofdropdownlist || newindexofdropdownlist == 0) {
				if ((newindexofdropdownlist == oldval))
				{
					// no change
				}
				else if (checkdisabled)
				{
					// Change detected but field is disabled - So do nothing
					console.log("change detected but field disabled: widget:" + value1); // + " current value:" + val1 + " new value:" + newindexofdropdownlist);
				}
				else {
					deltaobj.push(value1, newindexofdropdownlist);
				}
			}
		});
		
		//Adding non-removable state of all downstream ports depending on the state of "nrModified"
		if (nrModified) {
			var nr1 = ($("#nrdeviceport1").is(':checked'))?"1":"0";
			var nr2 = ($("#nrdeviceport2").is(':checked'))?"1":"0";
			var nr3 = ($("#nrdeviceport3").is(':checked'))?"1":"0";
			var nr4 = ($("#nrdeviceport4").is(':checked'))?"1":"0";
			
			
			if(bEnable1 === true )
			{
				if(nr1Modified === false)
				{
					deltaobj.push("nrdeviceport1", nr1);
				}else{
				}
			}else {
				if(nr1Modified === false)
				{
					deltaobj.push("nrdeviceport1", 0);
				}else{
				}
			}
			if(bEnable2 === true)
			{
				if(nr2Modified === false)
				{
					deltaobj.push("nrdeviceport2", nr2);
				}else{
				}
			}else {
				if(nr2Modified === false)
				{
					deltaobj.push("nrdeviceport2", 0);
				}else{
				}
			}
			if(bEnable3 === true )
			{
				if(nr3Modified === false)
				{
					deltaobj.push("nrdeviceport3", nr3);
				}else{
				}
			}else {
				if(nr3Modified === false)
				{
					deltaobj.push("nrdeviceport3", 0);
				}else{
				}
			}
			if(bEnable4 === true )
			{
				if(nr4Modified === false)
				{
					deltaobj.push("nrdeviceport4", nr4);
				}else{
				}
			}else {
				if(nr4Modified === false)
				{
					deltaobj.push("nrdeviceport4", 0);
				}else{
				}
			}
			nrModified = false;
			nr1Modified = false;
			nr2Modified = false;
			nr3Modified = false;
			nr4Modified = false;
		}
		
		var stringToSet = "";
		var wKey;
		var wVal;
		var flag = 0;
		var modifiedWidgets = [];

		if (deltaobj.length != 0) {
			for (var i = deltaobj.length; i >= 0; i = i - 2) {
				wKey = deltaobj[i];
				wVal = deltaobj[i+1];
				if ((typeof wKey === 'undefined') || (typeof wVal === 'undefined')) {
					// Do nothing
				} else {
					stringToSet = wKey + ",,," + wVal + ";;;" + stringToSet;
					modifiedWidgets.push(wKey);
					flag++;
				}
			}
		}

		if (iniFile) {
			iniFile_fullPath = getFullPathINI();
			modifiedWidgets.push("xdataprogram");
			stringToSet = "xdataprogram,,," + iniFile_fullPath + ";;;" + stringToSet;
			flag++;
		}
		
		//Initializing the values with "-1".
		var regOptionChosen = -1;
		var Regadd = -1;
		var RegVal = -1;
		
		//Getting the data from the respective UI fields
		regOptionChosen = $("#Regoperationgroup").find(':checked').val();
		Regadd = $("#Regaddress").val();
		RegVal = $("#Regvalue").val();
		
		if ((regOptionChosen ) && (Regadd) && (RegVal)) { //|| (regOptionChosen == 0)
			
			if (typeof regOptionChosen === 'undefined') {
				alert("Please choose an appropriate action under the Direct Register Access.");
				errorFlag = true;
				return;
			}
		
			if(regOptionChosen == 0)
			{
				Regop = "XMODE_WRITE_BYTE";
			}
			else if(regOptionChosen == 1)
			{
				Regop = "XMODE_SET_BITS";
			}
			else if(regOptionChosen == 2)
			{
				Regop = "XMODE_CLEAR_BITS"
			}
			else
			{
				Regop = "";
				//do nothing
			}
			
			var isOKAddr = /^[0-9A-Fa-f]{4}$/i.test(Regadd);
			var newRegVal = RegVal.replace(/\s+/g, "");
			var isOKVal = /^[0-9A-Fa-f]+$/i.test(newRegVal);
			
			if ((Regadd == "") || (RegVal == "")) {
				alert("Either the value of register address or the register value is not entered under the Direct Register Access.");
				errorFlag = true;
				return;
			}
			
			if (!isOKAddr) {
				alert("The Register Address entered under the Direct Register Access must be a 4 digit hexadecimal number.");
				errorFlag = true;
			}
			
			if (!isOKVal) {
				alert("The Register value entered under the Direct Register Access is not a valid hexadecimal number.");
				errorFlag = true;
			}
			
			if (isOKAddr && isOKVal) {
				if (Regop.length == 0) {
					alert("Please choose appropriate register operation.");
					errorFlag = true;
				} else {
					if (Regadd && RegVal) {
						if (RegString) {
							RegString = Regop + "," + Regadd + "," + newRegVal + "," + RegString;
						} else {
							RegString = Regop + "," + Regadd + "," + newRegVal;
						}
					} else {
						alert("Either Register address or Register value is not added.");
						errorFlag = true;
					}
				}
			}
		}
		
		if (RegString) {
			stringToSet = "xdataentry,,," + RegString + ";;;" + stringToSet;
			modifiedWidgets.push("xdataentry");
			flag++;
		}

		var displayChange = "";
		for (var i = 0; i < modifiedWidgets.length; i++) {
			if(i%4 == 0)
			{
				if (displayChange) {
					displayChange = "\n"+Mapping[modifiedWidgets[i]] + ", " + displayChange;
				} else {
					displayChange = Mapping[modifiedWidgets[i]];
				}
			} else {
				if (displayChange) {
						displayChange = Mapping[modifiedWidgets[i]] + ", " + displayChange;
				}
			}
		}
		
		if (flag == 0 && errorFlag == false) {
			alert("No changes detected for offline configuration.");
			update_status_message("No changes detected for offline configuration.");
		} else {
			if(errorFlag === false)
			{
				if ((langid == "0") && (stringmodified == 1) )
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}
					// Check udc_langid
					if ((udc_langid == "0") && (udc_stringmodified == 1) )
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "UCH String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "hce_languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}

					if ((usb3langid == "0") && (usb3stringmodified == 1))
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "usb3languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}
					var memType = "";
					if (Product == "USB3.1 Gen1") {
						//memType = $("#CfgMemory").find(':checked').val();
						if($("#otpMem").is(':checked')) {
							memType = "0";
						} else {
							memType = "1";
						}
					}
					
					var option = confirm("Configuration file will be generated with the following device settings\n" + displayChange);
					
					
				if (option) {
					
					if(memType == null || memType == "undefined")
					{
						memType = "0";
					}
					
					
					if (Product == "USB3.1 Gen1") {
					var result = setOfflineConfiguration(HUB_FAMILY_INDEX, stringToSet,memType);
					}
					else
					{
						var result = setOfflineConfiguration(HUB_FAMILY_INDEX, stringToSet,"0");
					}
					

					if (result) {
						alert("Offline configuration was created successfully");
						update_status_message("Offline configuration was created successfully for the following widgets.\n" + displayChange);
					} else {
						alert("Offline configuration failed.");
						update_status_message("Offline configuration failed.");		
					}
				} else {
					update_status_message("Generation of configuration file was terminated by the user.");
				}
				
				//clean up
				RegString = "";
				iniFile = "";
				numberofportState = false;
				
				//Variables are reverted to Zero
				resetVariables();
			}else{
			}
		}
});


function resetVariables () {
	vid_check = 0;
	pid_check = 0;
	did_check = 0;
	usb3vid_check = 0;
	usb3pid_check = 0;
	usb3did_check = 0;
	usb3vcd_check = 0;
	hce_vid_check = 0;
	hce_pid_check = 0;
	hce_did_check = 0;
	usbvcd_check = 0;
	languageid_check = 0;
	usb3languageid_check = 0;
	hce_languageid_check = 0;
	manufacturer_check = 0;
	product_check = 0;
	serial_check = 0;
	hce_manufacturer_check = 0;
	hce_product_check = 0;
	hce_serial_check = 0;
	usb3manufacturer_check = 0;
	usb3product_check = 0;
	usb3serial_check = 0;
	usb3uuid_check = 0;
	maxpowerself_check = 0;
	hubcmaxpowerself_check = 0;
	maxpowerbus_check = 0;
	hubcmaxpowerbus_check = 0;
	hub3maxpowerselfbus_check = 0;
	flexconnect_check = 0;
	hsdisable_check = 0;
	hceenable_check = 0;
	lpmenable_check = 0;
	swapupstreamdpdm_check = 0;
	swapupstreamhsic_check = 0;
	swapport1dpdm_check = 0;
	swapport2dpdm_check = 0;
	swapport3dpdm_check = 0;
	swapport4dpdm_check = 0;
	nrdeviceport1_check = 0;
	nrdeviceport2_check = 0;
	nrdeviceport3_check = 0;
	nrdeviceport4_check = 0;
	usb3nrdeviceport1_check = 0;
	usb3nrdeviceport2_check = 0;
	usb3nrdeviceport3_check = 0;
	usb3nrdeviceport4_check = 0;
	swappin1_check = 0;
	swappin2_check = 0;
	swappin3_check = 0;
	swappin4_check = 0;
	enableport1_check = 0;
	enableport2_check = 0;
	enableport3_check = 0;
	enableport4_check = 0;
	usb3enableport1_check = 0;
	usb3enableport2_check = 0;
	usb3enableport3_check = 0;
	usb3enableport4_check = 0;
	hubpowergroup_check = 0;
	upstreambatterysettingsgroup_check = 0;
	suspendindicationgroup_check = 0;
	cdcenable_check = 0;
	downstreamBCsettingport1group_check = 0;
	downstreamBCsettingport2group_check = 0;
	downstreamBCsettingport3group_check = 0;
	downstreamBCsettingport4group_check = 0;
	PHYBOOSTUL_check = 0;
	SLEWUL_check = 0;
	DOIUL_check = 0;
	SLEWULdownstreamport1_check = 0;
    DOIULdownstreamport1_check = 0;
    SLEWULdownstreamport2_check = 0;
	DOIULdownstreamport2_check = 0;
	SLEWULdownstreamport3_check = 0;
	DOIULdownstreamport3_check = 0;
	SLEWULdownstreamport4_check = 0;
	DOIULdownstreamport4_check = 0;
	PHYBOOSTULdownstreamport1_check = 0;
	PHYBOOSTULdownstreamport2_check = 0;
	PHYBOOSTULdownstreamport3_check = 0;
	PHYBOOSTULdownstreamport4_check = 0;
	SQUELCHUL_check = 0;
	SQUELCHULdownstreamport1_check = 0;
	SQUELCHULdownstreamport2_check = 0;
	SQUELCHULdownstreamport3_check = 0;
	SQUELCHULdownstreamport4_check = 0;
	downstreamport1HsRiseFallUL_check = 0;
	downstreamport2HsRiseFallUL_check = 0;
	downstreamport3HsRiseFallUL_check = 0;
	downstreamport4HsRiseFallUL_check = 0;
	upstreamHsRiseFallUL_check = 0;
	iniFileID_check = 0;
}