/*! jQuery v1.10.2 | (c) 2005, 2013 jQuery Foundation, Inc. | jquery.org/license
*/
//Variables to know which page has been selected: USB2.0 or USB3.1 Gen1
var Product = getProduct();
var ConfigType = getConfigType();
var hubCount;
var hub_list;
var incval = 0;
var hceenablemanu = false;
var hceenableprod = false;
var hceenableser = false;
var enablealertmanu = false;
var enablealertprod = false;
var enablealertser = false;

// Widget ID of hex fields in the GUI
var GwidgetlistHex = [
"vid",
"pid",
"did",
"usbvcd",
"languageid",
"hce_vid",
"hce_pid",
"hce_did",
"hce_languageid",
// USB3 related
"usb3vid",
"usb3pid",
"usb3did",
"usb3vcd",
"usb3languageid"
];

//Mapping Hex widgets to the meaningful elaborations to print while in error
var Mapping = {
//Hex
"vid": "USB2.0 Vendor ID",
"pid": "USB2.0 Product ID",
"did": "USB2.0 Device ID",
"usbvcd": "USB2.0 Version",
"languageid": "USB2.0 Language ID",
"manufacturer": "USB2.0 Manufacturer",
"manufacturerlen" :"USB2.0 Manufacturer Length",
"product" : "USB2.0 Product",
"productlen" : "USB2.0 Product Length",
"serial": "USB2.0 Serial",
"seriallen" : "USB2.0 Serial Length",
"usb3vid": "USB3.1 Gen1 Vendor ID",
"usb3pid": "USB3.1 Gen1 Product ID",
"usb3did": "USB3.1 Gen1 Device ID",
"usb3vcd": "USB3.1 Gen1 Version",
"usb3languageid": "USB3.1 Gen1 Language ID",
"usb3manufacturer": "USB3.1 Gen1 Manufacturer",
"usb3product":"USB3.1 Gen1 Product",
"usb3serial":"USB3.1 Gen1 Serial",
"usb3uuid":"Universal unique ID",
"numberofports":"Number of Enabled ports",
"enableport1":"Port1 Enable/Disable State",
"enableport2":"Port2 Enable/Disable State",
"enableport3":"Port3 Enable/Disable State",
"enableport4":"Port4 Enable/Disable State",
"usb3enableport1":"USB3 Port1 Enable/Disable State",
"usb3enableport2":"USB3 Port2 Enable/Disable State",
"usb3enableport3":"USB3 Port3 Enable/Disable State",
"usb3enableport4":"USB3 Port4 Enable/Disable State",
"port1mapping":"Port1 Logical mapping",
"port2mapping":"Port2 Logical mapping",
"port3mapping":"Port3 Logical mapping",
"port4mapping":"Port4 Logical mapping",
"usb3port1mapping":"usb3 Port1 Logical mapping",
"usb3port2mapping":"usb3 Port2 Logical mapping",
"usb3port3mapping":"usb3 Port3 Logical mapping",
"usb3port4mapping":"usb3 Port4 Logical mapping",
"nrdeviceport1":"Port1 Non-removable State",
"nrdeviceport2":"Port2 Non-removable State",
"nrdeviceport3":"Port3 Non-removable State",
"nrdeviceport4":"Port4 Non-removable State",
"usb3nrdeviceport4":"USB3 Port4 Non-removable State",
"usb3nrdeviceport3":"USB3 Port3 Non-removable State",
"usb3nrdeviceport2":"USB3 Port2 Non-removable State",
"usb3nrdeviceport1":"USB3 Port1 Non-removable State",
"downstreamBCsettingport1":"Port1 Battery charging State",
"downstreamBCsettingport2":"Port2 Battery charging State",
"downstreamBCsettingport3":"Port3 Battery charging State",
"downstreamBCsettingport4":"Port4 Battery charging State",
"swapport1dpdm":"Port1:Swap D+/D-",
"swapport2dpdm":"Port2:Swap D+/D-",
"swapport3dpdm":"Port3:Swap D+/D-",
"swapport4dpdm":"Port4:Swap D+/D-",
"swappin1":"Port1:Swap HSIC DATA STROBE",
"swappin2":"Port2:Swap HSIC DATA STROBE",
"swappin3":"Port3:Swap HSIC DATA STROBE",
"swappin4":"Port4:Swap HSIC DATA STROBE",
"swapupstreamhsic":"Upstream Port:Swap HSIC DATA STROBE",
"swapupstreamdpdm":"Upstream Port:Swap D+/D-",
"PHYBOOSTdownstreamport1":"Port1:PHYBOOST",
"PHYBOOSTdownstreamport2":"Port2:PHYBOOST",
"PHYBOOSTdownstreamport3":"Port3:PHYBOOST",
"PHYBOOSTdownstreamport4":"Port4:PHYBOOST",
"PHYBOOST":"Upstream Port:PHYBOOST",
"DOIdownstreamport1":"Port1:HSIC Driver Output Impedance",
"DOIdownstreamport2":"Port2:HSIC Driver Output Impedance",
"DOIdownstreamport3":"Port3:HSIC Driver Output Impedance",
"DOIdownstreamport4":"Port4:HSIC Driver Output Impedance",
"DOI":"Upstream Port:HSIC Driver Output Impedance",
"SLEW":"Upstream Port:Slew Tune",
"SLEWdownstreamport1":"Port1:Slew Tune",
"SLEWdownstreamport2":"Port2:Slew Tune",
"SLEWdownstreamport3":"Port3:Slew Tune",
"SLEWdownstreamport4":"Port4:Slew Tune",
"SQUELCHdownstreamport1":"Port1:Varisense",
"SQUELCHdownstreamport2":"Port2:Varisense",
"SQUELCHdownstreamport3":"Port3:Varisense",
"SQUELCHdownstreamport4":"Port4:Varisense",
"SQUELCH":"Upstream Port:Varisense",
"upstreamHsRiseFall":"Upstream High Speed rise/fall adjust",
"downstreamport1HsRiseFall":"Port1:High Speed rise/fall adjust",
"downstreamport2HsRiseFall":"Port2:High Speed rise/fall adjust",
"downstreamport3HsRiseFall":"Port3:High Speed rise/fall adjust",
"downstreamport4HsRiseFall":"Port4:High Speed rise/fall adjust",
"flexconnect":"Flexconnect",
"hceenable":"Hub Controller State",
"hce_vid": "HCE Vendor ID",
"hce_pid": "HCE Product ID",
"hce_did": "HCE Device ID",
"hce_languageid": "HCE Language ID",
"hce_manufacturer":"HCE Manufacturer",
"hce_manufacturerlen":"HCE Manufacturer Length",
"hce_product":"HCE Product",
"hce_productlen":"HCE Product Length",
"hce_serial":"HCE Serial",
"hce_seriallen":"HCE Serial Length",
"cdcenable":"CDC State",
"hubpower":"Hub Power",
"maxpowerself":"USB2.0 Hub Max Power(Self)",
"hubcmaxpowerself":"Hub Circuit Max Power (Self)",
"maxpowerbus":"USB2.0 Hub Max Power (Bus)",
"hubcmaxpowerbus":"Hub Circuit Max Power (Bus)",
"hub3maxpowerselfbus":"USB3.1 Gen1 Max Power",
"upstreambatterysettings":"Upstream Charger Detection",
"suspendindication":"Suspendindication",
"hsdisable":"Hub Full Speed Mode",
"lpmenable":"LPM State",
"xdataentry":"Direct Register Access",
"xdataprogram":"ini File"
};

// Widget ID of string fields in the GUI
var GwidgetlistString = [
"manufacturer", 
"product",
"serial",
"hce_manufacturer",
"hce_product",
"hce_serial",
// USB3 related
"usb3manufacturer",
"usb3product",
"usb3serial",
"usb3uuid"
];

// Widget ID of decimal fields in the GUI
var GwidgetlistInt = [
"maxpowerself",
"hubcmaxpowerself",
"maxpowerbus",
"hubcmaxpowerbus",
"hub3maxpowerselfbus"
];

// Widgets that are checkboxes in GUI
var GwidgetlistCheckbox = [
"flexconnect",
"hsdisable",
"hceenable",
"cdcenable",
"lpmenable",
"swapupstreamdpdm",
"swapupstreamhsic",
"swapport1dpdm",
"swapport2dpdm",
"swapport3dpdm",
"swapport4dpdm",
"enableport1",
"enableport2",
"enableport3",
"enableport4",
"usb3enableport1",
"usb3enableport2",
"usb3enableport3",
"usb3enableport4",
"nrdeviceport1",
"nrdeviceport2",
"nrdeviceport3",
"nrdeviceport4",
"usb3nrdeviceport4",
"usb3nrdeviceport3",
"usb3nrdeviceport2",
"usb3nrdeviceport1",
"swappin1",
"swappin2",
"swappin3",
"swappin4"
];

// Widgets that are radio buttons in GUI
var GwidgetlistRadio = [
"hubpower",
"upstreambatterysettings",
"suspendindication",
"downstreamBCsettingport1",
"downstreamBCsettingport2",
"downstreamBCsettingport3",
"downstreamBCsettingport4"
];

// Widgets that are used for populating the GUI and would not be used in set_wdigets_values
var GwidgetlistGUI = [
"noofdownstreamports",
"upstreamport_HSIC_USB",
"isdynamicpinavailable",
"istrefdrefavailable",
"downstreamport1_HSIC_USB",
"downstreamport2_HSIC_USB",
"downstreamport3_HSIC_USB",
"downstreamport4_HSIC_USB"
];

// Widgets that are Drop Down in GUI
var GwidgetlistDropDown = [
"DREF",
"TREF",
"PHYBOOST",
"SQUELCH",
"upstreamHsRiseFall",
"SLEW",
"DOI",
"PHYBOOSTdownstreamport1",
"SQUELCHdownstreamport1",
"downstreamport1HsRiseFall",
"SLEWdownstreamport1",
"DOIdownstreamport1",
"PHYBOOSTdownstreamport2",
"SQUELCHdownstreamport2",
"downstreamport2HsRiseFall",
"SLEWdownstreamport2",
"DOIdownstreamport2",
"PHYBOOSTdownstreamport3",
"SQUELCHdownstreamport3",
"downstreamport3HsRiseFall",
"SLEWdownstreamport3",
"DOIdownstreamport3",
"PHYBOOSTdownstreamport4",
"SQUELCHdownstreamport4",
"downstreamport4HsRiseFall",
"SLEWdownstreamport4",
"DOIdownstreamport4"
];

// Lookup for dropdown value selection
var DropDownDREF = [
"REFSEL0=0,REFSEL1=0 =>38.4Mhz",
"REFSEL0=1,REFSEL1=0 =>26Mhz",
"REFSEL0=0,REFSEL1=1 =>19.2Mhz",
"REFSEL0=1,REFSEL1=1 =>12Mhz"
];

// Lookup for tref dropdown value selection
var DropDownTREF = [
"12Mhz",
"13Mhz",
"19.2Mhz",
"24Mhz",
"25Mhz",
"26Mhz",
"27Mhz",
"38.4Mhz",
"50Mhz",
"52Mhz"
];

// Lookup for phyboost dropdown value selection
var DropDownPHYBOOST = [
"Nominal 17.78 mA",
"5% below nominal",
"10% above nominal",
"5% above nominal",
"20% above nominal",
"15% above nominal",
"30% above nominal",
"25% above nominal",
];

// Lookup for squelch dropdown value selection
var DropDownSQUELCH = [
"Nominal 100mV",
"12.5mV below nominal",
"25mV below nominal",
"37.5mV below nominal",
"50mV below nominal",
"62.5mV below nominal",
"25mV above nominal",
"12.5mV above nominal",
];
// Lookup for High Speed rise/fall adjust selection
var DropDownHSRiseFall =[
"Default",
"+18%",
"-18%",
"-12%"
];
// Lookup for squelch dropdown value selection
var DropDownDOI = [
"40 ohm",
"50 ohm"
];

// Lookup for squelch dropdown value selection
var DropDownSLEW = [
"Default",
"+30%"
];

// Lookup for port mapping selection: Not used
var DropDownPORTMAPPING = [
"Disabled",
"Mapped to Physical Port 1",
"Mapped to Physical Port 2",
"Mapped to Physical Port 3",
"Mapped to Physical Port 4"
];
// values returned if a value is 1 from the backend
var checkbox_checked_value = "1";
var checkbox_unchecked_value = "0";

var stringnullvalue = "NULL STRING - NOT PROGRAMMED YET";

var HUB_ID = "";
var enableApplyButton = false;
var enableFlex = false;
var disableFlex = false;
var hubsFound = false;
var enable_swapupstreamdpdm = false;
var CurrentflexLiveValue = -1;
var vid_pidModified = false;
var errorCode;
var CurrenthubProgrammed = "";
var percentage =0;

//Set this variable when Non-removable parameter of a hub is modified
var nrModified = false;
var nr1Modified = false;
var nr2Modified = false;
var nr3Modified = false;
var nr4Modified = false;

//Set these flags if they are modified by user
var nr1UserModified = false;
var nr2UserModified = false;
var nr3UserModified = false;
var nr4UserModified = false;

//set this variable when enable port widget is pushed
var enableprt1 = false;
var enableprt2 = false;
var enableprt3 = false;
var enableprt4 = false;

//Set this variable when Non-removable parameter of a hub is modified
var usb3nrModified = false;
var usb3nr1Modified = false;
var usb3nr2Modified = false;
var usb3nr3Modified = false;
var usb3nr4Modified = false;

//Set these flags if they are modified by user
var usb3nr1UserModified = false;
var usb3nr2UserModified = false;
var usb3nr3UserModified = false;
var usb3nr4UserModified = false;

//set this variable when enable port widget is pushed
var usb3enableprt1 = false;
var usb3enableprt2 = false;
var usb3enableprt3 = false;
var usb3enableprt4 = false;

//flags for INI file programming
var iniFile;
var iniFile_fullPath;

//Flag to send the parameter "numberofports"
var numberofportState = false;
var usb3numberofportState = false;
var currentProgrammingCount = 0;

function myAlert(str){
}
(function ($) {
    enable_all_fields = function () {
        $("#Apply").attr('disabled', true);
		$("#Preview").attr('disabled', true);
        $("#Factory").attr('disabled', true);
		$("#flexApply").attr('disabled', true);
		$("#XdataApply").attr('disabled', true);
		$("#MemdumpBtn").attr('disabled', true);
        $("#devicedescriptortab").attr('disabled', false);
        $("#stringdescriptortab").attr('disabled', false);
        $("#USB3devicedescriptortab").attr('disabled', false);
        $("#USB3stringdescriptortab").attr('disabled', false);
        $("#USB3otherdescriptortab").attr('disabled', false);
        $("#upstreamtab").attr('disabled', false);
        $("#downstreamtab").attr('disabled', false);
        $("#Bdownstreamtab").attr('disabled', false);
        $("#USB3_Bdownstreamtab").attr('disabled', false);
        $("#uchtab").attr('disabled', false);
        $("#advancedtab").attr('disabled', false);
        $("#specialtab").attr('disabled', false);
        $('#BPORT1fieldset').attr('disabled', 'disabled');
        $('#BPORT2fieldset').attr('disabled', 'disabled');
        $('#BPORT3fieldset').attr('disabled', 'disabled');
        $('#BPORT4fieldset').attr('disabled', 'disabled');
        $('#USB3_BPORT1fieldset').attr('disabled', 'disabled');
        $('#USB3_BPORT2fieldset').attr('disabled', 'disabled');
        $('#USB3_BPORT3fieldset').attr('disabled', 'disabled');
        $('#USB3_BPORT4fieldset').attr('disabled', 'disabled');
        $('#PORT1fieldset').attr('disabled', 'disabled');
        $('#PORT2fieldset').attr('disabled', 'disabled');
        $('#PORT3fieldset').attr('disabled', 'disabled');
        $('#PORT4fieldset').attr('disabled', 'disabled');
        $('#USB3_PORT1fieldset').attr('disabled', 'disabled');
        $('#USB3_PORT2fieldset').attr('disabled', 'disabled');
        $('#USB3_PORT3fieldset').attr('disabled', 'disabled');
        $('#USB3_PORT4fieldset').attr('disabled', 'disabled');
		$('#cdctab').attr('disabled', false);
    };
})(jQuery);

(function ($) {
    enable_all_fields_debugging = function () {
        // For Testing only
        // Basic Downstream FieldSet - USB 2.0
        $('#BPORT1fieldset').removeAttr('disabled');
        $('#BPORT2fieldset').removeAttr('disabled');
        $('#BPORT3fieldset').removeAttr('disabled');
        $('#BPORT4fieldset').removeAttr('disabled');

        // Show USB configuration items
        $('#BdownstreamUSBport1').show();
        $('#BdownstreamUSBport2').show();
        $('#BdownstreamUSBport3').show();
        $('#BdownstreamUSBport4').show();

        // Show HSIC configuration items - Basic HSIC items not available

        // Basic Downstream FieldSet - USB 3.1 Gen1 ( Port Enable is the only item present here)
        $('#USB3_BPORT1fieldset').removeAttr('disabled');
        $('#USB3_BPORT2fieldset').removeAttr('disabled');
        $('#USB3_BPORT3fieldset').removeAttr('disabled');
        $('#USB3_BPORT4fieldset').removeAttr('disabled');

        // Advanced Downstream FieldSet - USB 2.0
        $('#PORT1fieldset').removeAttr('disabled');
        $('#PORT2fieldset').removeAttr('disabled'); 
        $('#PORT3fieldset').removeAttr('disabled'); 
        $('#PORT4fieldset').removeAttr('disabled'); 
        $('#downstreamport1Fieldset').removeAttr('disabled');
        $('#downstreamport2Fieldset').removeAttr('disabled');
        $('#downstreamport3Fieldset').removeAttr('disabled');
        $('#downstreamport4Fieldset').removeAttr('disabled');
		$('#nr1div').removeAttr('disabled');
		$('#nr2div').removeAttr('disabled');
		$('#nr3div').removeAttr('disabled');
		$('#nr4div').removeAttr('disabled');
        // Show USB configuration items
        $('#downstreamUSBport1').show();
        $('#downstreamUSBport2').show();
        $('#downstreamUSBport3').show();
        $('#downstreamUSBport4').show();

        // Show HSIC configuration items
        //$('#downstreamHSICport1').show();
        //$('#downstreamHSICport2').show();
        //$('#downstreamHSICport3').show();
        //$('#downstreamHSICport4').show();

        // Advanced upstream items
        $('#upstreamUSB').show();
        $('#upstreamHSIC').hide();
    };
})(jQuery);

(function ($) {
    get_hub_list = function () {
    	//Close previous all hub instances
		MchpUsbCloseAllHubs();
		//Call to clear previously acquired widget Map
		clearWidgetMap();
		setConfigMode(false, "NULL");
		enable_all_fields();
        enable_all_fields_debugging();
		reset_fields();
		set_changed_fields_border_default();
        // Populate the List of Hubs
		var i = 0;
		var test2  = "Fetching the hub list...";
		update_status_message(test2);
		var data = "";
		data = getHubList();
		$("#dropDownUL").empty();

		
		if (data) {
			enable_fields();
			hub_list = data.split("###");
			hubCount = hub_list.length;
			for (var k = (hub_list.length - 1); k >= 0; k--) {
				if (hub_list[k]) {
					update_status_message(hub_list[k]);
					$("#dropDownUL").append("<li> <a tabindex=\"-1\" href=\"javascript:void(0)\" align=\"left\">" + hub_list[k] + "</a> </li>");
				}
			}

			
			$("#selectedhubinput").val(hub_list[(hub_list.length - 2)]);
					$('.selecthub1')
					.find('[data-bind="SelectHublabel"]').text(hub_list[(hub_list.length - 2)])
					.children('.dropdown-toggle').dropdown('toggle');

			var btnValue = $("#selectedhubinput").val();
			var colonIndex = btnValue.indexOf(":");
			HUB_ID = "" + btnValue.charAt(colonIndex + 1);
			
			hubsFound = true;
			
		} else {
			enableApplyButton = false;
			if (enableFlex) {
				alert("Flex connect has been enabled for the Upstream port. \n Connect the hub with the Downstream port1 for the device to be enumerated.");
				update_status_message("Flex connect has been enabled for the Upstream port. \n Connect the hub with the Downstream port1 for the device to be enumerated.");
			}
			
			if (disableFlex) {
				alert("Flex connect has been disabled for the Upstream port. \n Connect the hub with the Upstream port for the device to be enumerated.");
				update_status_message("Flex connect has been disabled for the Upstream port. \n Connect the hub with the Upstream port for the device to be enumerated.");
			}
			
			if (enable_swapupstreamdpdm) {
				alert("The D+/D- of the upstream port have been swapped.");
				update_status_message("The D+/D- of the upstream port have been swapped.");
			}
			hubsFound = false;
			reset_fields();
			disable_fields();
			$("#progID").hide();
			errorCode = getMchpUsbLastError(HUB_ID);
			if(errorCode) {
				alert(errorMap[Dec2Hex(errorCode)]);
				update_status_message(errorMap[Dec2Hex(errorCode)] + "errorCode: " + errorCode);
			} else {
				window.alert("No hubs found");
				update_status_message("No hubs found");
			}
				
			
		}
    };
})(jQuery);

(function ($) {
    update_status_message = function (mesg) {
        var currentdate = new Date(); 
        currentdate+''; 
        var datetime = currentdate.toLocaleString();
        $("#DSStatusMessage").append( datetime +":"+ mesg + "\n");
        $("#DSStatusMessage").animate({
            scrollTop:$("#DSStatusMessage")[0].scrollHeight - $("#DSStatusMessage").height()
            },400,function(){
          })
        };
})(jQuery);

(function ($) {
    set_selected_hub_get_widgets = function () {
       // window.hub_is_microchip = '0';
        //$('#ajaxBusy').hide();
        enable_all_fields();
        enable_all_fields_debugging();
		//$('#ajaxBusy').show();
		$("body").css("cursor", "wait");
		
		var isTyler = false;
		var isAthens = false;

		var skuName;
		var selectindex = 0;
		
		
		if(flagforINIread) {
			
			if((HUB_ID == 0)) {
				
				selectindex =hubCount-1;
				
				for (selectindex; selectindex >= 0; selectindex--) {
					
					if(hub_list[selectindex]) {
						
						var selop = hub_list[selectindex];
						var colonIndex = selop.indexOf(":");
						incval = "" + selop.charAt(colonIndex + 1);	
						
						//incval = (selectindex).toString();
						
						skuName = set_selected_device(incval);
						
						var temp = skuName.substring(0,5);
						
						
						if(temp == "USB57" && Product == "USB3.1 Gen1") {
							isTyler = true;
							
							HUB_ID = incval;
							
							$('.selecthub1').find('[data-bind="SelectHublabel"]').text(selop)
									.children('.dropdown-toggle').dropdown('toggle');
							
							$("#selectedhubinput").val(selop);
							
							break;
						} else if (((temp == "USB45" || temp == "USB25" || temp == "USB36" || temp == "USB38" || temp == "USB46" || skuName == "USB84604")) && (Product == "USB2.0")) {
						
							isAthens = true;
							
							HUB_ID = incval;
							
							$('.selecthub1').find('[data-bind="SelectHublabel"]').text(selop)
									.children('.dropdown-toggle').dropdown('toggle');
							
							$("#selectedhubinput").val(selop);
							
							break;
						}
						close_device(HUB_ID);
					
					}
					
				}
			} 
		} else {
			
			skuName = set_selected_device(HUB_ID);
			debugAlert("skuName"+skuName);
		}
		
		if (skuName == "") {
			skuName = "not identified";
			errorCode = getMchpUsbLastError(HUB_ID);
			update_status_message(errorMap[Dec2Hex(errorCode)] + " Check Help for troubleshooting.");
		}

		var mesg1 = "The hub may go offline for a while. Please wait while the hub configuration is read and auto identification part number is available.";
        update_status_message(mesg1);
        mesg1="";
		update_status_message("The skuName for the hub of Index: " + HUB_ID + " is " + skuName + ".");

		if (skuName) {
			enable_fields();
			$("#AIPNInput").val(skuName);
			var temp = skuName.substring(0,5);
			//var temp = "USB57";
			//if ((skuName === "USB5744") || (skuName === "USB5733") || (skuName === "USB5734") ||(skuName === "USB5732") ||(skuName === "USB5731")) {
			if (temp == "USB57") 
			{
				isTyler = true;
				$("#Apply").attr('disabled', false);
				$("#Preview").attr('disabled', false);
				$("#Factory").attr('disabled', false);
				$("#flexApply").attr('disabled', false);
				$("#XdataApply").attr('disabled', false);
				$("#MemdumpBtn").attr('disabled', false);
				$("#superSpeed1").show();
				$("#superSpeed1").attr('disabled', false);
				$("#superSpeed2").show();
				$("#superSpeed2").attr('disabled', false);
				$("#superSpeed3").show();
				$("#superSpeed3").attr('disabled', false);
				$("#superSpeed4").show();
				$("#superSpeed4").attr('disabled', false);
				
				
			}
			
			if (temp == "USB45" || temp == "USB25" || temp == "USB36" || temp == "USB38" || temp == "USB46" || skuName == "USB84604")
			{
				isAthens = true;
				$("#Apply").attr('disabled', false);
				$("#Preview").attr('disabled', false);
				$("#Factory").attr('disabled', false);
				$("#flexApply").attr('disabled', false);
				$("#XdataApply").attr('disabled', false);
				$("#MemdumpBtn").attr('disabled', false);	
				$("#superSpeed1").hide();
				$("#superSpeed1").attr('disabled', true);
				$("#superSpeed2").hide();
				$("#superSpeed2").attr('disabled', true);
				$("#superSpeed3").hide();
				$("#superSpeed3").attr('disabled', true);
				$("#superSpeed4").hide();
				$("#superSpeed4").attr('disabled', true);
				
			}
			
			if (skuName == "USB5742") {
				$("#BPORT3fieldset").attr('disabled', true);
				$("#BPORT4fieldset").attr('disabled', true);
				$("#PORT3fieldset").attr('disabled', true);
				$("#PORT4fieldset").attr('disabled', true);

				$("#BPORT3fieldset").hide();
				$("#BPORT4fieldset").hide();
				$("#PORT3fieldset").hide();
				$("#PORT4fieldset").hide();
			}
			
			var tempsku = skuName.substring(0,5);
			if (tempsku == "USB38" || tempsku == "USB36") {
				$("#BPORT4fieldset").attr('disabled', true);
				$("#PORT4fieldset").attr('disabled', true);

				$("#BPORT4fieldset").hide();
				$("#PORT4fieldset").hide();
				
				$("#NoFlexForHsic").show();
				$("#Flextooltip").hide();
				$("#flexconnect").attr('disabled', true);
				$("#flexApply").attr('disabled', true);
				$("#spiField").attr('disabled', true);
				
				
			}
			else
			{
				
				$("#BPORT4fieldset").attr('disabled', false);
				$("#PORT4fieldset").attr('disabled', false);

				$("#BPORT4fieldset").show();
				$("#PORT4fieldset").show();
				$("#NoFlexForHsic").hide();
				$("#Flextooltip").show();
				$("#flexApply").attr('disabled', false);
				$("#spiField").attr('disabled', false);
			}
			
			if (Product == "USB3.1 Gen1") {
				if (!isTyler) {
					$("#superSpeed1").show();
					$("#superSpeed1").attr('disabled', false);
					$("#superSpeed2").show();
					$("#superSpeed2").attr('disabled', false);
					$("#superSpeed3").show();
					$("#superSpeed3").attr('disabled', false);
					$("#superSpeed4").show();
					$("#superSpeed4").attr('disabled', false);
					$("#Busb2downstreamport1Display").hide();
					$("#Busb3downstreamport1Display").show();
					$("#Busb2downstreamport2Display").hide();
					$("#Busb3downstreamport2Display").show();
					$("#Busb2downstreamport3Display").hide();
					$("#Busb3downstreamport3Display").show();
					$("#Busb2downstreamport4Display").hide();
					$("#Busb3downstreamport4Display").show();
					reset_fields();
					disable_fields();
					update_status_message("Unable to connect to USB57X4 family MCHP hub");
					alert("Unable to connect to USB57X4 family MCHP hub");
					$("body").css("cursor", "default");
					//$('#ajaxBusy').hide();
					return;
				}
				else
				{
					$("#Busb2downstreamport1Display").hide();
					$("#Busb3downstreamport1Display").show();
					$("#Busb2downstreamport2Display").hide();
					$("#Busb3downstreamport2Display").show();
					$("#Busb2downstreamport3Display").hide();
					$("#Busb3downstreamport3Display").show();
					$("#Busb2downstreamport4Display").hide();
					$("#Busb3downstreamport4Display").show();
				}
			} else if (Product == "USB2.0") {
				if (!isAthens) {
					$("#superSpeed1").hide();
					$("#superSpeed1").attr('disabled', true);
					$("#superSpeed2").hide();
					$("#superSpeed2").attr('disabled', true);
					$("#superSpeed3").hide();
					$("#superSpeed3").attr('disabled', true);
					$("#superSpeed4").hide();
					$("#superSpeed4").attr('disabled', true);
					$("#Busb2downstreamport1Display").show();
					$("#Busb3downstreamport1Display").hide();
					$("#Busb2downstreamport2Display").show();
					$("#Busb3downstreamport2Display").hide();
					$("#Busb2downstreamport3Display").show();
					$("#Busb3downstreamport3Display").hide();
					$("#Busb2downstreamport4Display").show();
					$("#Busb3downstreamport4Display").hide();
					
					reset_fields();
					disable_fields();
					update_status_message("Unable to connect to USB2530 family MCHP hub");
					alert("Unable to connect to USB2530 family MCHP hub");
					$("body").css("cursor", "default");
					//$('#ajaxBusy').hide();
					return;
				}
				else
				{
					$("#Busb2downstreamport1Display").show();
					$("#Busb3downstreamport1Display").hide();
					$("#Busb2downstreamport2Display").show();
					$("#Busb3downstreamport2Display").hide();
					$("#Busb2downstreamport3Display").show();
					$("#Busb3downstreamport3Display").hide();
					$("#Busb2downstreamport4Display").show();
					$("#Busb3downstreamport4Display").hide();
				}
			}
			if ((skuName === "NOT MICROCHIP") || (skuName === "NOT IMPLEMENTED"))
			{
				mesg1 = "Hub is not a Microchip Hub.Please select a Microchip hub\n";
				update_status_message (mesg1);
				console.log("Hub is not a Microchip Hub.Please select a Microchip hub");
				alert("Hub is not a Microchip Hub.Please select a Microchip hub");
				update_status_message("Hub is not a Microchip Hub.Please select a Microchip hub");
				$("#Apply").attr('disabled', true);
				$("#Preview").attr('disabled', true);
				$("#Factory").attr('disabled', true);
				$("#flexApply").attr('disabled', true);
				$("#XdataApply").attr('disabled', true);
				$("#MemdumpBtn").attr('disabled', true);
				$("#devicedescriptortab").attr('disabled', true);
				$("#stringdescriptortab").attr('disabled', true);
				$("#USB3devicedescriptortab").attr('disabled', true);
				$("#USB3stringdescriptortab").attr('disabled', true);
				$("#USB3otherdescriptortab").attr('disabled', true);
				$("#upstreamtab").attr('disabled', true);
				$("#downstreamtab").attr('disabled', true);
				$("#Bdownstreamtab").attr('disabled', true);
				$("#USB3_Bdownstreamtab").attr('disabled', true);
				$("#uchtab").attr('disabled', true);
				$("#advancedtab").attr('disabled', true);
				$("#specialtab").attr('disabled', true);
				$("#OTPCR").val("");
				$("#OTPCP").val("");
				$("#FirmwareLocation").val("");
				$("#ConfigLocation").val("");
				$("#DeviceMgmtprogressbar3").css('width'," 0%");
				$("#DeviceMgmtprogressbar2").css('width', "0%");
				$('#cdctab').attr('disabled', true);
				

			} else {
				mesg1 = "The selected hub part number is "+ skuName;
				update_status_message (mesg1);
				
				enableApplyButton = true;

				// OTP Information
				var info = get_otp_info(HUB_ID);
				if (info) {
					var otp_info = info.split("###");
					var otpSize = otp_info[0];
					var ConfigBlockCnt = otp_info[1];
					var ConfigRemainCnt = otp_info[2];
					var ProgrammedByteCnt = otp_info[3];
					
					// update live apply section
					$("#xdatavalue").attr('disabled', true);
					$("#xdataaddress").val("");
					$("#xdatavalue").val("");
					var nameofcontrol = "input[name='xdataoperationgroup'][value=0]";
					$(nameofcontrol).prop("checked", true);
					
					//Configured block count
					$("#OTPCP").val(ConfigBlockCnt);
					var count = parseInt(ConfigBlockCnt,10) ;
					currentProgrammingCount = count;
					if (count >= 16)
					{
						var string = "16+";
						$("#OTPCP").val(string);
						$("#Restore").attr('disabled', true);
					}
					
					//Configured remaining count
					$("#OTPCR").val(ConfigRemainCnt);
					
					//OTP size
					var OTP = parseInt(otpSize,10);
					var PBC = parseInt(ProgrammedByteCnt, 10);
					
					
					percentage = (PBC / OTP) * 100;
					
					if (Product == "USB3.1 Gen1") {
						$("#DeviceMgmtprogressbar3").css('width',percentage+ "%");
						$("#DeviceMgmtprogressbar3").css('color', 'black');
						if (percentage < 50){
							$("#DeviceMgmtprogressbar3").css({'background-image': 'none','background-color': 'green'});
							$("#DeviceMgmtprogressbar3").attr('aria-valuenow', 45);
						} else if (percentage < 75){
							$("#DeviceMgmtprogressbar3").css({'background-image': 'none','background-color': 'orange'});
						} else if (percentage > 75){
							$("#DeviceMgmtprogressbar3").css({'background-image': 'none','background-color': 'red'});
						}
						percenttrim = parseFloat(percentage).toFixed(2);
						$("#DeviceMgmtprogressbar3").html("<p align=\"center\">"+ percenttrim + "%" +"<p>");
					}
					
					if (Product == "USB2.0") {
						$("#DeviceMgmtprogressbar2").css('width',percentage+ "%");
						$("#DeviceMgmtprogressbar2").css('color', 'black');
						if (percentage < 50) {
							$("#DeviceMgmtprogressbar2").css({'background-image': 'none','background-color': 'green'});
							$("#DeviceMgmtprogressbar2").attr('aria-valuenow', 45);
						} else if (percentage < 75) {
							$("#DeviceMgmtprogressbar2").css({'background-image': 'none','background-color': 'orange'});
						} else if (percentage > 75) {
							$("#DeviceMgmtprogressbar2").css({'background-image': 'none','background-color': 'red'});
						}
						percenttrim = parseFloat(percentage).toFixed(2);
						$("#DeviceMgmtprogressbar2").html("<p align=\"center\">"+ percenttrim + "%" +"<p>");
					}
				} else {
					window.alert("OTP information could not be retrieved.");
					update_status_message("OTP information could not be retrieved.");
				}
				
				//Updating firmware and config location in the UI
				var firmware_config = get_firmware_config_location(HUB_ID);
				var firmware_config_array = firmware_config.split("::");
				var firmware_loc = firmware_config_array[0];
				var config_loc = firmware_config_array[1];
				
				$("#FirmwareLocation").val(firmware_loc);
				$("#ConfigLocation").val(config_loc);
				
				if (Product == "USB2.0") {
					if (firmware_loc == "ROM") {
						$("#SpecialFeatures_Flex").attr('disabled', true);
						$("#NoFlexForUSB2").show();
						$("#Flex_FlexFeature").attr('disabled', true);
					} else {
						$("#SpecialFeatures_Flex").removeAttr('disabled', false);
						$("#NoFlexForUSB2").hide();
						$("#Flex_FlexFeature").removeAttr('disabled', false);
					}
				} else {
					$("#SpecialFeatures_Flex").removeAttr('disabled', false);
					$("#NoFlexForUSB2").hide();
					$("#Flex_FlexFeature").removeAttr('disabled', false);
				}

				//Updating the rest of the widgets.
				mesg1 = "Reading Hub Configuration ....";
				update_status_message (mesg1);

				// Updating GwidgetlistGUI
				$.each(GwidgetlistGUI, function( index, value ) {
					//upstreamport_HSIC_USB
					if (value == "upstreamport_HSIC_USB") {
						var upstreamport_HSIC_USB = getWidgetValue(HUB_ID, "upstreamport_HSIC_USB");
						if (  upstreamport_HSIC_USB == "0" ) // 0 = usb
						{
							$('#upstreamUSB').show();
							$('#upstreamHSIC').hide();
						}
						else if (  upstreamport_HSIC_USB == "1" ) // 1 = hsic
						{
							$('#upstreamHSIC').show();
							$('#upstreamUSB').hide();
						}
						else
						{
							console.log(" Failed to retrive Upstream configuration");
						}
					}
				
					//downstreamport1_HSIC_USB
					if (value == "downstreamport1_HSIC_USB") {
						var downstreamport1_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport1_HSIC_USB");
						if (  downstreamport1_HSIC_USB == "0" ) // 0 = usb
						{
							$('#downstreamUSBport1').show();
							$('#BdownstreamUSBport1').show();
							$('#downstreamHSICport1').hide();
						}
						else if (  downstreamport1_HSIC_USB == "1" ) // 1 = hsic
						{
							$('#downstreamHSICport1').show();
							$('#downstreamUSBport1').hide();
							$('#BdownstreamUSBport1').hide();
						}
						else
						{
							console.log(" Failed to retrive Downstream Port 1 configuration");
						}
					}
					
					//downstreamport2_HSIC_USB
					if (value == "downstreamport2_HSIC_USB") {
						var downstreamport2_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport2_HSIC_USB");
						if (  downstreamport2_HSIC_USB == "0" ) // 0 = usb
						{
							$('#downstreamUSBport2').show();
							$('#BdownstreamUSBport2').show();
							$('#downstreamHSICport2').hide();
						}
						else if (  downstreamport2_HSIC_USB == "1" ) // 1 = hsic
						{
							$('#downstreamHSICport2').show();
							$('#downstreamUSBport2').hide();
							$('#BdownstreamUSBport2').hide();
						}
						else
						{
							console.log(" Failed to retrive Downstream Port 2 configuration");
						}
					}
					
					//downstreamport3_HSIC_USB
					if (value == "downstreamport3_HSIC_USB") {
						var downstreamport3_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport3_HSIC_USB");
						if (  downstreamport3_HSIC_USB == "0" ) // 0 = usb
						{
							$('#downstreamUSBport3').show();
							$('#BdownstreamUSBport3').show();
							$('#downstreamHSICport3').hide();
						}
						else if (  downstreamport3_HSIC_USB == "1" ) // 1 = hsic
						{
							$('#downstreamHSICport3').show();
							$('#downstreamUSBport3').hide();
							$('#BdownstreamUSBport3').hide();
						}
						else
						{
							console.log(" Failed to retrive Downstream Port 3 configuration");
						}
					}
					
					//downstreamport4_HSIC_USB
					if (value == "downstreamport4_HSIC_USB") {
						var downstreamport4_HSIC_USB = getWidgetValue(HUB_ID, "downstreamport4_HSIC_USB");
						if (  downstreamport4_HSIC_USB == "0" ) // 0 = usb
						{
							$('#downstreamUSBport4').show();
							$('#BdownstreamUSBport4').show();
							$('#downstreamHSICport4').hide();
						}
						else if (  downstreamport4_HSIC_USB == "1" ) // 1 = hsic
						{
							$('#downstreamHSICport4').show();
							$('#downstreamUSBport4').hide();
							$('#BdownstreamUSBport4').hide();
						}
						else
						{
							console.log(" Failed to retrive Downstream Port 4 configuration");
						}
					}
					
					// noofdownstreamports
					if (value == "noofdownstreamports") {
						var noofdownstreamports = getWidgetValue(HUB_ID, "noofdownstreamports");
						var decvalue = parseInt(noofdownstreamports,10) ;
						if (decvalue >= 2 )
						{
							$('#PORT1fieldset').removeAttr('disabled');
							$('#PORT2fieldset').removeAttr('disabled'); 
							$('#BPORT1fieldset').removeAttr('disabled');
							$('#BPORT2fieldset').removeAttr('disabled');  
							$('#USB3_PORT1fieldset').removeAttr('disabled');
							$('#USB3_PORT2fieldset').removeAttr('disabled'); 
							$('#USB3_BPORT1fieldset').removeAttr('disabled');
							$('#USB3_BPORT2fieldset').removeAttr('disabled');                                                      
						}
						if (decvalue >= 3 )
						{
							$('#PORT3fieldset').removeAttr('disabled');
							$('#BPORT3fieldset').removeAttr('disabled');
							$('#USB3_PORT3fieldset').removeAttr('disabled');
							$('#USB3_BPORT3fieldset').removeAttr('disabled');
						}	
						if (decvalue >= 4 )
						{
							$('#PORT4fieldset').removeAttr('disabled');
							$('#BPORT4fieldset').removeAttr('disabled');
							$('#USB3_PORT4fieldset').removeAttr('disabled');
							$('#USB3_BPORT4fieldset').removeAttr('disabled');
						}
					}
					
					// isdynamicpinavailable
					/*if (value == "isdynamicpinavailable") {
						var isdynamicpinavailable = getWidgetValue(HUB_ID, "isdynamicpinavailable");
						if (  isdynamicpinavailable == "1" )
						{
							$('#powerRadio3').show();
							$('#dynamiclabel').show();
						}
						else{
							$('#powerRadio3').hide();
							$('#dynamiclabel').hide();
						}
					}*/
					
					// istrefdrefavailable
					if (value == "istrefdrefavailable") {
						var istrefdrefavailable = getWidgetValue(HUB_ID, "istrefdrefavailable");
						/*if (  istrefdrefavailable == "1" )
						{
							$('#TREFLabel').show();
							$('.dbTREF').show();
							$('#DREFLabel').show();
							$('.dbDREF').show();
						}
						else{*/
							$('#TREFLabel').hide();
							$('.dbTREF').hide();
							$('#DREFLabel').hide();
							$('.dbDREF').hide();
						//}
					}
				});

				// Updating GwidgetlistHex
				$.each(GwidgetlistHex, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);

					if (widgetValue) {
						var decvalue = parseInt(widgetValue,10);
						var hexstring;
						if (value == "usbvcd" || value == "udc_usbvcd" || value == "usb3vcd") // remove the '.' added before
						{
							var dot = ".";
							var hexvalue = (decvalue.toString(16));
							var position = 1;
							var hexstring = [hexvalue.slice(0, position), dot, hexvalue.slice(position)].join('');
						} else {
							hexstring = decvalue.toString(16); //"0x" +  (decvalue.toString(16) );
						}
						$(widgetid).val(hexstring);
					}
				});
				
				// Updating GwidgetlistString
				$.each(GwidgetlistString, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);
			
					if(/*(widgetValue === " ") ||*/ (widgetValue === "")) {
						$(widgetid).val(stringnullvalue);
					} else {
						$(widgetid).val(widgetValue);
					}
				});

				// Updating GwidgetlistInt
				$.each(GwidgetlistInt, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);
					
					if(widgetValue === "") {
						$(widgetid).val("");
					} else {
						var decVal;
						if (value == "hub3maxpowerselfbus") {
							decVal = widgetValue & 0xff;
							decVal = parseInt(decVal,10);
							decVal = decVal * 8;
						} else if ((value == "hubcmaxpowerbus") || (value == "hubcmaxpowerself")) {
							decVal = widgetValue & 0xff;
							decVal = parseInt(decVal,10);
						} else {
							decVal = widgetValue & 0xff;
							decVal = parseInt(decVal,10);
							decVal = decVal * 2;
						}
						$(widgetid).val(decVal);
					}
				});

				// Updating GwidgetlistCheckbox
				$.each(GwidgetlistCheckbox, function( index, value ) {
					var widgetid = "#" + value;
					var widgetValue = getWidgetValue(HUB_ID, value);
					
					if ( widgetValue == checkbox_checked_value )
					{
						$(widgetid).prop('checked',true);     
						// If there are corresponding fieldsets - enable them 
						$(widgetid).trigger("change"); 
						set_changed_fields_border_default();
					}
					else {
						$(widgetid).prop('checked',false);
						// If there are corresponding fieldsets - disable them 
						$(widgetid).trigger("change"); 
						set_changed_fields_border_default();
					}
				});

				// Updating GwidgetlistRadio
				$.each(GwidgetlistRadio, function( index, value ) {
					
						if (Product == "USB2.0") {
							if (value === "upstreambatterysettings") {
								$("#upstreamChargerDetectionDiv_usb2").show();
							} 
							var groupname = value +"group";
							var widgetValue = getWidgetValue(HUB_ID, value);
							var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
							$(nameofcontrol).prop("checked", true);
						} else {
							if ( value === "upstreambatterysettings") {
								$("#upstreamChargerDetectionDiv_usb2").hide();
							} else {
								var groupname = value +"group";
								var widgetValue = getWidgetValue(HUB_ID, value);
								var nameofcontrol = "input[name=" + groupname + "][value=" + widgetValue + "]";
								$(nameofcontrol).prop("checked", true);
							}
						}
					
						if ( value === "hubpower")
						{
							var widgetid = "#hubpowergroup";
							// If there are corresponding fieldsets - enable them 
							$(widgetid).trigger("change"); 
							if (widgetValue == "0") { // Bus power
								// Disable the fields
								//$('#selfpowerfieldset').attr('disabled', 'disabled');
								//$('#buspowerfieldset').removeAttr('disabled');
								$('#selfpowerfieldset').hide();
								$('#buspowerfieldset').show();
							} else if (widgetValue == "1") { // Self power
								// Disable the fields
								//$('#buspowerfieldset').attr('disabled', 'disabled');
								//$('#selfpowerfieldset').removeAttr('disabled');
								$('#buspowerfieldset').hide();
								$('#selfpowerfieldset').show();
							}
							set_changed_fields_border_default();
					}
				});
				
				// Updating GwidgetlistDropDown
				$.each(GwidgetlistDropDown, function( index, value ) {
					var widgetValue = getWidgetValue(HUB_ID, value);
					var decval = parseInt(widgetValue,10);
					var nameofcontrol = "." + value + "1";
					var nameofcontrol1 = "[data-bind=\"" + value + "label\"]";
					if ( value == "DREF" )
					{
						$.each(DropDownDREF, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					if ( value == "TREF" )
					{
						$.each(DropDownTREF, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					/*if ( value == "port1mapping"  
					|| value=="port2mapping"
					|| value=="port3mapping"
					|| value=="port4mapping")
					{
						$.each(DropDownPORTMAPPING, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}*/
					if ( value == "PHYBOOST" || value=="PHYBOOSTdownstreamport1" 
					|| value=="PHYBOOSTdownstreamport2" || value=="PHYBOOSTdownstreamport3"
					|| value=="PHYBOOSTdownstreamport4")
					{
						$.each(DropDownPHYBOOST, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					
					}
					if ( value == "SQUELCH" || value=="SQUELCHdownstreamport1" 
					|| value=="SQUELCHdownstreamport2" || value=="SQUELCHdownstreamport3"
					|| value=="SQUELCHdownstreamport4")
					{
						$.each(DropDownSQUELCH, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					if (value == "upstreamHsRiseFall" || value=="downstreamport1HsRiseFall"
					|| value=="downstreamport2HsRiseFall" || value =="downstreamport3HsRiseFall"
					|| value=="downstreamport4HsRiseFall")
					{
						$.each(DropDownHSRiseFall, function(index, valuelist) {
							if (index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					if ( value == "SLEW" || value=="SLEWdownstreamport1" 
					|| value=="SLEWdownstreamport2" || value=="SLEWdownstreamport3"
					|| value=="SLEWdownstreamport4")
					{
						$.each(DropDownSLEW, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;
							}
						});
					}
					if (value == "DOI"|| value=="DOIdownstreamport1" 
					|| value=="DOIdownstreamport2" || value=="DOIdownstreamport3"
					|| value=="DOIdownstreamport4")
					{
						$.each(DropDownDOI, function( index, valuelist ) {
							if ( index == decval)
							{   
								selText = valuelist;;
							}
						});
					}
					// Update fields based on obtained value
					$(nameofcontrol)
				   .find(nameofcontrol1).text(selText)
					.children('.dropdown-toggle').dropdown('toggle');
				});

				// Enable fieldsets based on obtained value - by default they are disabled
				/*if ($('#hceenable').is(':checked')) {
					// Enable the fieldset                    
					$('#uchfieldset').removeAttr('disabled');
					$('#uchfieldsetstring').removeAttr('disabled');
				}*/
				if ($('#enableport1').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport1Fieldset').removeAttr('disabled');
					$('#nr1div').removeAttr('disabled');
					if (Product == "USB2.0") {
						$('#BdownstreamUSBport1').removeAttr('disabled');
					}
				}
				if ($('#enableport2').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport2Fieldset').removeAttr('disabled');
					$('#nr2div').removeAttr('disabled');
					if (Product == "USB2.0") {
						$('#BdownstreamUSBport2').removeAttr('disabled');
					}
				}
				if ($('#enableport3').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport3Fieldset').removeAttr('disabled');
					$('#nr3div').removeAttr('disabled');
					if (Product == "USB2.0") {
						$('#BdownstreamUSBport3').removeAttr('disabled');
					}
				}
				if ($('#enableport4').is(':checked')) {
					// Enable the fieldset                    
					$('#downstreamport4Fieldset').removeAttr('disabled');
					$('#nr4div').removeAttr('disabled');
					if (Product == "USB2.0") {
						$('#BdownstreamUSBport4').removeAttr('disabled');
					}
				} //BdownstreamUSBport1
				
				if (Product === "USB3.1 Gen1") {
					$("#ConfigMode").empty();
					var configModeAddr = "414f";
					var configModeVal = registerOperation(HUB_ID, configModeAddr, "1", true, "", false);
					configModeVal = parseInt(configModeVal, 16);

					var Mode = 0;
					if (configModeVal == 0x0A) {
						 Mode = 1;
					}
					else if (configModeVal == 0x0B) {
						 Mode = 2;
					}
					else if (configModeVal == 0x02) {
						 Mode = 3;
					}
					else if (configModeVal == 0x1B) {
						 Mode = 4;
					}
					else if (configModeVal == 0x00) {
						 Mode = 5;
					}
					else if (configModeVal == 0x1F) {
						 Mode = 6;
					}
					else {
						 Mode = 0;
					}
					$("#ConfigMode").val(Mode);
				}

				mesg1 = "Reading Hub Configuration successful.";
				update_status_message (mesg1);
					
				//} // End of if (hub_is_microchip == '1')
			} // End of else ((skuName === "NOT MICROCHIP") || (skuName === "NOT IMPLEMENTED"))
			
			// To check the state of live flex connect
			var flexAddr = "318e";
			var flexLiveState = hub_xdata_read(HUB_ID, flexAddr);
			
			if (Product == "USB2.0") {
				if (flexLiveState & 3 == 3) {
					flexLiveState = 1;
				} else {
					flexLiveState = 0;
				}
			}

			if (flexLiveState == 1) {
				$("#flexlive").prop('checked', true);
				CurrentflexLiveValue = 1;
			} else if (flexLiveState == 0) {
				$("#flexlive").prop('checked', false);
				CurrentflexLiveValue = 0;
			} else {
				// Do nothing
			}
			
			
			//Updating SKU List
			$("#FPNUL").empty();
			$("#FPNUL").append("<li> <a tabindex=\"-1\" href=\"javascript:void(0)\" align=\"left\">" + "None" + "</a> </li>");
			var selText = "None";
			// Set the default value for the dropdown with caret symbol
			$('.forceproduct1')
			.find('[data-bind="FPNlabel"]').text(selText)
			.children('.dropdown-toggle').dropdown('toggle');
			
			var skuList = getSKUList(HUB_ID);

			if (skuList) {
				var skuArray = skuList.split("###");
				$.each(skuArray, function (idx, sku) {
					//$("#SelectProductUL").append("<li> <a tabindex=\"-1\" href=\"#\" align=\"left\">" + partno.SKU + "</a> </li>");
					$("#FPNUL").append("<li> <a tabindex=\"-1\" href=\"javascript:void(0)\" align=\"left\">" + sku + "</a> </li>");
				});
			}
			else { // Should never happen!!!
				window.alert("SKU List could not be obtained.");
			}
			//$('#ajaxBusy').hide();
			$("body").css("cursor", "default");
		} else {
			reset_fields();
			disable_fields();
			$("#progID").hide();
			$("body").css("cursor", "default");
			enableApplyButton = false;
			errorCode = getMchpUsbLastError(HUB_ID);
			alert(errorMap[Dec2Hex(errorCode)] + " Check Help for troubleshooting.");
			update_status_message(errorMap[Dec2Hex(errorCode)] + " Check Help for troubleshooting.");
		}
	};
})(jQuery);

(function ($) {
    get_hub_list_set_hub_index_zero = function () {
		//$("#progID").hide();
		//$("#progID").show();

		/*window.setTimeout(function(){
		  //your code to be executed after 1 seconds
		  $('#myprogress .progress-bar').css('width', 60+'%').attr('aria-valuenow', 60);
		}, 500);*/

        get_hub_list();
		
		/*window.setTimeout(function(){
		  $('#myprogress .progress-bar').css('width', 100+'%').attr('aria-valuenow',100);
		}, 500); */
		
		if (hubsFound) {
			set_selected_hub_get_widgets();
		}
		/*window.setTimeout(function(){
		$('#myprogress').hide();
		}, 500); */
		
    };
})(jQuery);

(function ($) {
    get_hub_list_set_hub_index = function () {
        get_hub_list();
		$("#selectedhubinput").val(CurrenthubProgrammed);
		var colonIndex = CurrenthubProgrammed.indexOf(":");
		HUB_ID = "" + CurrenthubProgrammed.charAt(colonIndex + 1);
		$('.selecthub1')
			.find('[data-bind="SelectHublabel"]').text(CurrenthubProgrammed)
			.children('.dropdown-toggle').dropdown('toggle');
		set_selected_hub_get_widgets();
    };
})(jQuery);

(function ($) {
    set_changed_widget_list = function () {
		
		//Array to save the widgets and their values which were changed.
		var deltaobj = [];
		var sentinel = true;
		var mismatchCheck = 0;
		
		//List of widgets to display on the alert
		var widgetsToDisplay = [];
		var modifiedWidgets = [];
		
		// language id constraint
		var stringmodified = 0;
		var udc_stringmodified = 0;
		var langid = $("#languageid").val();
		var udc_langid = $("#hce_languageid").val();
		var usb3langid;
		var usb3stringmodified;
		var usb3StringLength;
		var usb3StringFlag;
		var enableMapping = false;
		
		if (Product == "USB3.1 Gen1") {
			usb3langid = $("#usb3languageid").val();
			usb3stringmodified = 0;
			usb3StringLength = 0;
			usb3StringFlag = true;
		}
		var currentvalue="NONE";
		
		// Check length of strings constraint
		var usb2StringLength = 0;
		var hceStringLength = 0;
		
		//Alert flags for string lengths
		var usb2StringFlag = true;
		var hceStringFlag = true;
		
		//flag for alert message
		var errorFlag = false;
		
		var port1dontchange=0;
		var port2dontchange=0;
		var port3dontchange=0;
		var port4dontchange=0;
		
		
		//usb3
		var usb3port1dontchange=0;
		var usb3port2dontchange=0;
		var usb3port3dontchange=0;
		var usb3port4dontchange=0;
		
		var usb2map = 1;
		var usb3port1disable = 0;
		var usb3port2disable = 0;
		var usb3port3disable = 0;
		var usb3port4disable = 0;
		
		// Find out currently how many ports are enabled
		var bEnable1 = $('#enableport1').is(':checked');
		var bEnable2 = $('#enableport2').is(':checked');
		var bEnable3 = $('#enableport3').is(':checked');
		var bEnable4 = $('#enableport4').is(':checked');
		var SendNoofPorts = 0;
		
		//Total ports enabled 
		var bTotal = bEnable1+bEnable2+bEnable3+bEnable4;
		
		//usb3 ports
		var usb3bEnable1 = $('#usb3enableport1').is(':checked');
		var usb3bEnable2 = $('#usb3enableport2').is(':checked');
		var usb3bEnable3 = $('#usb3enableport3').is(':checked');
		var usb3bEnable4 = $('#usb3enableport4').is(':checked');
		var usb3SendNoofPorts = 0;
		
		//Total usb3 ports enabled 
		var usb3bTotal = usb3bEnable1+usb3bEnable2+usb3bEnable3+usb3bEnable4;
		
		// Check Port Disable condition
		var port1Status = $('#enableport1').is(':checked')?1:0;
		var port2Status = $('#enableport2').is(':checked')?1:0;
		var port3Status = $('#enableport3').is(':checked')?1:0;
		var port4Status = $('#enableport4').is(':checked')?1:0;
		var hceStatus = $('#hceenable').is(':checked')?1:0;

		var usb3port1Status = $('#usb3enableport1').is(':checked')?1:0;
		var usb3port2Status = $('#usb3enableport2').is(':checked')?1:0;
		var usb3port3Status = $('#usb3enableport3').is(':checked')?1:0;
		var usb3port4Status = $('#usb3enableport4').is(':checked')?1:0;
		
		if (hceStatus == 0) {
			if ((port1Status == 0) && (port2Status == 0) && (port3Status == 0) && (port4Status == 0)) {
				alert("Hub controller is disabled. Disabling all 4 downstream ports is not allowed.");
				update_status_message("Hub controller is disabled. Disabling all 4 downstream ports is not allowed.");
				return;
			}
		}

		if (Product == "USB3.1 Gen1") {
			if ((usb3port1Status == 0) && (usb3port2Status == 0) && (usb3port3Status == 0) && (usb3port4Status == 0)) {
				
				alert("All 4 downstream ports are disabled. Disabling the Hub controller is not allowed.");
				update_status_message("All 4 downstream ports are disabled. Disabling the Hub controller is not allowed.");
				return;
			}
		}
			
		//To program it to defaults when a port is disabled.
		if (bEnable1 == false) {
			var nrport1 = getWidgetValue(HUB_ID, "nrdeviceport1");
			var dpdmSwap1 = getWidgetValue(HUB_ID, "swapport1dpdm");
			var phyboost1 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport1");
			var varisense1 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport1");
			var hsrisefall1 = getWidgetValue(HUB_ID, "downstreamport1HsRiseFall");
			if (nrport1 != 0) {
				nrModified = true;
			}
			
			if (dpdmSwap1 != 0) {
				deltaobj.push("swapport1dpdm", 0);
			}
			
			if (phyboost1 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport1", 0);
			}
			
			if (varisense1 != 0) {
				deltaobj.push("SQUELCHdownstreamport1", 0);
			}
			if(hsrisefall1 !=0)
			{
				deltaobj.push("downstreamport1HsRiseFall", 0);
			}
		}

		if (bEnable2 == false) {
			var nrport2 = getWidgetValue(HUB_ID, "nrdeviceport2");
			var dpdmSwap2 = getWidgetValue(HUB_ID, "swapport2dpdm");
			var phyboost2 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport2");
			var varisense2 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport2");
			var hsrisefall2 = getWidgetValue(HUB_ID, "downstreamport2HsRiseFall");
			if (nrport2 != 0) {
				nrModified = true;
			}
			
			if (dpdmSwap2 != 0) {
				deltaobj.push("swapport2dpdm", 0);
			}
			
			if (phyboost2 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport2", 0);
			}
			
			if (varisense2 != 0) {
				deltaobj.push("SQUELCHdownstreamport2", 0);
			}
			if(hsrisefall2 !=0)
			{
				deltaobj.push("downstreamport2HsRiseFall", 0);
			}
		}

		if (bEnable3 == false) {
			var nrport3 = getWidgetValue(HUB_ID, "nrdeviceport3");
			var dpdmSwap3 = getWidgetValue(HUB_ID, "swapport3dpdm");
			var phyboost3 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport3");
			var varisense3 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport3");
			var hsrisefall3 = getWidgetValue(HUB_ID, "downstreamport3HsRiseFall");
			if (nrport3 != 0) {
				nrModified = true;
			}
			
			if (dpdmSwap3 != 0) {
				deltaobj.push("swapport3dpdm", 0);
			}
			
			if (phyboost3 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport3", 0);
			}
			
			if (varisense3 != 0) {
				deltaobj.push("SQUELCHdownstreamport3", 0);
			}
			if(hsrisefall3 !=0)
			{
				deltaobj.push("downstreamport3HsRiseFall", 0);
			}
		}

		if (bEnable4 == false) {
			var nrport4 = getWidgetValue(HUB_ID, "nrdeviceport4");
			var dpdmSwap4 = getWidgetValue(HUB_ID, "swapport4dpdm");
			var phyboost4 = getWidgetValue(HUB_ID, "PHYBOOSTdownstreamport4");
			var varisense4 = getWidgetValue(HUB_ID, "SQUELCHdownstreamport4");
			var hsrisefall4 = getWidgetValue(HUB_ID, "downstreamport4HsRiseFall");
			if (nrport4 != 0) {
				nrModified = true;
			}
			
			if (dpdmSwap4 != 0) {
				deltaobj.push("swapport4dpdm", 0);
			}
			
			if (phyboost4 != 0) {
				deltaobj.push("PHYBOOSTdownstreamport4", 0);
			}
			
			if (varisense4 != 0) {
				deltaobj.push("SQUELCHdownstreamport4", 0);
			}
			if(hsrisefall4 !=0)
			{
				deltaobj.push("downstreamport4HsRiseFall", 0);
			}
		}
		
		//usb3
		if (usb3bEnable1 == false) {
			var usb3nrport1 = getWidgetValue(HUB_ID, "usb3nrdeviceport1");
			
			if (usb3nrport1 != 0) {
				usb3nrModified = true;
			}
			
		}

		if (usb3bEnable2 == false) {
			var usb3nrport2 = getWidgetValue(HUB_ID, "usb3nrdeviceport2");
			
			if (usb3nrport2 != 0) {
				usb3nrModified = true;
			}
			
		}

		if (usb3bEnable3 == false) {
			var usb3nrport3 = getWidgetValue(HUB_ID, "usb3nrdeviceport3");
			
			if (usb3nrport3 != 0) {
				usb3nrModified = true;
			}
			
		}
		
		if (usb3bEnable4 == false) {
			var usb3nrport4 = getWidgetValue(HUB_ID, "usb3nrdeviceport4");
			
			if (usb3nrport4 != 0) {
				usb3nrModified = true;
			}
			
		}
		//TO DO: String length constraint check and coding
		//String Descriptors
		$.each(GwidgetlistString, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(HUB_ID, value1);
			//todo
			if((typeof oldval== 'undefined') || (oldval =="undefined"))
			{
				errorFlag = true;
				return;
			}
			var newval = $(widgetid).val();

			if (Product == "USB3.1 Gen1") {
				if (value1 === "usb3manufacturer" || value1 === "usb3product"|| value1 === "usb3serial")
				{
					var stringvalue = $(widgetid).val();
					// Check the widget length also
					if (stringvalue  == stringnullvalue )
					{
						// do nothing null string
					} else {
						usb3StringLength = usb3StringLength + $(widgetid).val().length;
					}
					//Checking the string length constraint
					if ((usb3StringLength > 90) && usb3StringFlag)
					{
						window.alert("String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB3.1 Gen1 can have a max length of 90 unicode characters only");
						update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB3.1 Gen1 can have a max length of 90 unicode characters only");
						usb3StringFlag = false;
						errorFlag = true;
						return;
					}
				}
			}
			
			if (value1 === "manufacturer" || value1 === "product"|| value1 === "serial")
			{
				var stringvalue = $(widgetid).val();

				// Check the widget length also
				if (stringvalue  == stringnullvalue)
				{
					// do nothing null string
				} else {
					usb2StringLength = usb2StringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
				if ((usb2StringLength > 90) && usb2StringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB2.0 can have a max length of 90 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name,Product name and Serial Number) of USB2.0 can have a max length of 90 unicode characters only");
					usb2StringFlag = false;
					errorFlag = true;
					return;
				}
			}
			
			if(value1 === "hce_manufacturer") {
				enablealertmanu = true;
			} else if(value1 === "hce_product") {
				enablealertprod = true;
			} else if(value1 === "hce_serial") {
				enablealertser = true;
			}
			
			if (value1 === "hce_manufacturer" || value1 === "hce_product" || value1 === "hce_serial")
			{
				var stringvalue = $(widgetid).val();

				// Check the widget length also
				if (stringvalue  == stringnullvalue)
				{
					// do nothing null string
				} else {
					hceStringLength = hceStringLength + $(widgetid).val().length;
				}
				//Checking the string length constraint
			
				if ((hceStringLength > 60) && hceStringFlag)
				{
					window.alert("String Descriptors(Sum of string lengths of Manufacturer name and Product name) of Hub Feature Controller can have a max length of 60 unicode characters only");
					update_status_message("Error : String Descriptors(Sum of string lengths of Manufacturer name and Product name) of Hub Feature Controller can have a max length of 60 unicode characters only");
					hceStringFlag = false;
					errorFlag = true;
					return;
				}
			}

			if (Product == "USB3.1 Gen1") {
				if (value1 === "usb3uuid") {
					var uuidVal = $(widgetid).val();
					var isOkay = /^[0-9a-fA-F]{1,32}$/i.test(uuidVal);

					if (uuidVal == "") {
						alert("Please enter a value for USB3.1 Gen1 UUID.");
						errorFlag = true;
						return;
					} else if (!isOkay) {
						alert("UUID value entered is invalid. UUID of USB3.1 Gen1 must be a 16 bytes of hexadecimal number.");
						update_status_message("UUID value entered is invalid. UUID of USB3.1 Gen1 must be a 16 bytes of hexadecimal number.");
						errorFlag = true;
						return;
					} 
				}
			}

			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if ((newval === stringnullvalue) || (newval === oldval))
			{
				// do nothing no change detected.
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				 console.log("change detected but field disabled: widget:" + value1);
			}
			else {
				
				//console.log("change detected : widget:" + value1); // + " current value:" + val1 + " new value:" + newval);
				if (Product == "USB3.1 Gen1") {
					if (value1 === "usb3manufacturer" || 
						value1 === "usb3product"||
						value1 === "usb3serial")
					{
						usb3stringmodified = 1;
					}
				}

				if (value1 === "hce_manufacturer" || 
					value1 === "hce_product" || value1 === "hce_serial")
				{
					udc_stringmodified = 1;
				}
				
				if (value1 === "manufacturer" || 
					value1 === "product"||
					value1 === "serial")
				{
					stringmodified = 1;
				}

				if (jQuery.isEmptyObject(newval)) {
					newval = "";
				}

				if (value1 === "manufacturer" || value1 === "product"|| 
					value1 === "serial")
				{
					
					deltaobj.push(value1, newval);
					modifiedWidgets.push(value1);
					
					// Set the widget length also
					var len = $(widgetid).val().length;
					// Now check if length constraint is met or not.
					var lenwidget = value1 + "len";
					//console.log("Also updating :" + lenwidget + " new value:" + len);
					deltaobj.push(lenwidget,len);
				}  
				
				if (Product == "USB3.1 Gen1") {
					if (value1 === "usb3manufacturer" || value1 === "usb3product"|| 
						value1 === "usb3serial")
					{
						
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
					}
				}
				
				if (value1 === "hce_manufacturer") {
					hceenablemanu = true;
					
				} else if (value1 === "hce_product") {
					hceenableprod = true;
				}  else if(value1 === "hce_serial") {
					hceenableser = true;
				}
				
				if(Product == "USB3.1 Gen1" ) {
					
					if (value1 == "usb3uuid") {
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
					}
					
				}
			}
		}); //End of $.each(GwidgetlistString, function( index1, value1 )*/

		//Hex Descriptors
		$.each(GwidgetlistHex, function( index1, value1 ) {
			var widgetid = "#" + value1;
			var oldval;
			var newval;
			var isOk;
			
			if(value1 === "usbvcd" || value1 === "udc_usbvcd" || value1 === "usb3vcd") {
				var usbvcdVal = parseInt(getWidgetValue(HUB_ID, value1), 10);
				var dot = ".";
				var hexvalue = (usbvcdVal.toString(16));
				var position = 1;
				var hexstring = [hexvalue.slice(0, position), dot, hexvalue.slice(position)].join('');
				oldval = hexstring;
				newval = $(widgetid).val();
				if (value1 == "usbvcd") {
					isOk = /^2\.?[0-9]{0,2}$/i.test($(widgetid).val());
				}
				
				if (Product == "USB3.1 Gen1") {
					if (value1 == "usb3vcd") {
						isOk = /^3\.?[0-9]{0,2}$/i.test($(widgetid).val());
					}
				}
				
				if (typeof isOk == 'undefined') {
					return;
				}
				if (!isOk) {
					update_status_message("The value entered for \"" + Mapping[value1] + "\" is not valid.");
					alert("The value entered for \"" + Mapping[value1] + "\" is not valid");
					errorFlag = true;
				}
			} else {
				oldval = parseInt(getWidgetValue(HUB_ID, value1), 10);
				isOk = /^[0-9A-Fa-f]{1,4}$/i.test($(widgetid).val());
				newval = parseInt($(widgetid).val(), 16);
				
				if ((value1 == "vid") || (value1 == "hce_vid") || (value1 == "usb3vid")) {
					var widID = "#" + value1;
					var widVal = $(widID).val();
					if (widVal == 0) {
						isOk = false;
					}
				}
				
				if (!isOk) {
					if (value1 == "usb3pid" || value1 == "usb3did" || value1 == "usb3vid" || value1 == "usb3languageid") {
						if (Product == "USB3.1 Gen1") {
							update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
							alert("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
							errorFlag = true;
						}
					} else {
						update_status_message("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						alert("The value entered for \"" + Mapping[value1] + "\" must be a 4 digit hexadecimal value and it cannot be Zero.");
						errorFlag = true;
					}
				}
			}
			
			if (!isOk) {
				// Do nothing. The value entered does not meet the expected pattern.
			} else {
				if ((oldval === newval) || isNaN(newval)) {
					//Do nothing
				} else {
					//Check for language ID
					if ((value1 == "languageid") || (value1 == "hce_languageid") || (value1 == "usb3languageid")) {
						if (newval == 0) {
							alert("Language ID cannot be zero. Setting it to default value (0x409)");
							newval = parseInt("0x409", 16);
						}
					}
					// Adding the VID of USB2.0 and HCE to Protouch2.ini, if they are modified.
					if ((value1 == "vid") || (value1 == "hce_vid")) {
						var valueEntered = $(widgetid).val();
						var hexEntered = "0x" + valueEntered;
						updateINI(hexEntered);
						//if vid of USB2.0 or Hub controller is modified, then increase the time out.
						vid_pidModified = true;
					}

					//if pid of USB2.0 or Hub controller is modified, then increase the time out.
					if ((value1 == "pid") || (value1 == "hce_pid")) {
						vid_pidModified = true;
					}

					// convert string to number                                        
					var decvalue = parseInt(newval,10);
					// convert number to string and then string to hex
					var valueToSet;
					if (value1 =="usbvcd" || value1 =="udc_usbvcd" || value1 == "usb3vcd") // remove the '.' added before
					{
						newval = newval.replace('.', '');
						decvalue = parseInt(newval,10);
						valueToSet = decvalue;
					}
					else {
						valueToSet = "0x" +  (decvalue.toString(16) ); 
					}
					var that = $( widgetid ), parent = that.closest('fieldset');
					var checkdisabled = $(parent).prop( "disabled" );
					if (checkdisabled)
					{
						// Change detected but field is disabled - So do nothing
						console.log("change detected but field disabled: widget:" + value1 + " new value:" + hexstring);
					}
					else {
						if (((value1 === "vid") || (value1 === "usb3vid")) && (Product == "USB3.1 Gen1")) {
							if (sentinel) {
								var usb3VID = $("#usb3vid").val();
								var usb2VID = $("#vid").val();
								if (usb3VID == usb2VID) {
									sentinel = false;
									deltaobj.push("vid", valueToSet);
									deltaobj.push("usb3vid", valueToSet);
									modifiedWidgets.push("vid", "usb3vid");
								} else {
									update_status_message("Mismatch in VID of USB2.0 and USB3.1 Gen1. Please make sure their VID is the same.");
									mismatchCheck++;
									if (mismatchCheck == 1) {
										alert("Mismatch in VID of USB2.0 and USB3.1 Gen1. Please make sure their VID is the same.");
										errorFlag = true;
									}
								}
							}
						} else {
							deltaobj.push(value1,valueToSet);
							modifiedWidgets.push(value1);
						}
					}
				}
			}
		});

		//Int Descriptors
		$.each(GwidgetlistInt, function(index1, value1) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(HUB_ID, value1);
			if (value1 == "hub3maxpowerselfbus") {
				if (Product == "USB3.1 Gen1") {
					oldval = parseInt(oldval,10) * 8;
				}
			} else if((value1 == "hubcmaxpowerbus") || (value1 == "hubcmaxpowerself")) {
				oldval = parseInt(oldval,10);
			} else {
				oldval = parseInt(oldval,10) * 2;
			}
			var that = $(widgetid), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop("disabled");
			
			var newval = $(widgetid).val();
			var newdecvalue = parseInt(newval,10);
			newdecvalue = newdecvalue & 0xff;
			if(((Product == "USB3.1 Gen1") && (value1 == "hub3maxpowerselfbus")) || (value1 == "maxpowerself") || (value1 == "maxpowerbus"))
			{
				if ((newdecvalue & 0x01) && !checkdisabled)
				{
					currentvalue = "ODDNUM";
					return;
				}
			}
			
			if ((oldval == newval) || isNaN(newval)) {
				// do nothing - no change in value
				//console.log("nochange:widget:" + widget1 + " value:" + val1 + " new value:" + newval);
			} 
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				console.log("change detected but field disabled: widget:" + value1 + " new value:" + newdecvalue); //+ " current value:" + val1 + " new value:" + newval);
			}
			else {
				if ((value1 == "maxpowerself") || (value1 == "hubcmaxpowerself")) {
					if ((newval > 100) || (newval < 0)) {
						alert ("USB2.0 max power(self) or USB2.0 hub circuit max power(self) cannot be more than 100mA or negative.");
						update_status_message("USB2.0 max power(self) or USB2.0 hub circuit max power(self) cannot be more than 100mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if (value1 == "maxpowerbus") {
					if ((newval > 500) || (newval < 0)) {
						alert ("USB2.0 max power(bus) cannot be more than 500mA or negative.");
						update_status_message("USB2.0 max power(bus) cannot be more than 500mA or negative.");
						errorFlag = true;
						return;
					}
				}
				
				if (value1 == "hubcmaxpowerbus") {
					if ((newval > 255) || (newval < 0)) {
						alert ("USB2.0 hub circuit max power(bus) cannot be more than 255mA or negative.");
						update_status_message("USB2.0 hub circuit max power(bus) cannot be more than 255mA or negative.");
						errorFlag = true;
						return;
					}
				}

				if ((value1 == "hub3maxpowerselfbus") && (Product == "USB3.1 Gen1")) {
					if ((newval > 900) || (newval < 0)) {
						alert ("USB3.1 Gen1 hub max power cannot be more than 900mA or negative.");
						update_status_message("USB3.1 Gen1 hub max power cannot be more than 900mA or negative.");
						errorFlag = true;
						return;
					}
				}
				var hexval;
				if ((value1 == "hub3maxpowerselfbus") && (Product == "USB3.1 Gen1")) {
					var newdecvalue = parseInt(newval,10);
					var reminder = newdecvalue%8;
					if(reminder != 0)
					{
						alert ("Hub Max Power 3.1 Gen1 field can have multiples of 8 only");
						var mesg = "Error : Hub Max Power 3.1 Gen1 field can have multiples of 8 only";
						update_status_message(mesg);
						errorFlag = true;
						return;
					}
					newdecvalue = newdecvalue/8;
					var temp = Math.floor(newdecvalue);
					hexval = temp.toString(16);
				} else if ((value1 == "hubcmaxpowerbus") || (value1 == "hubcmaxpowerself")) {
					newdecvalue = parseInt(newval,10);
					hexval = newdecvalue.toString(16);
				} else {
					newdecvalue = parseInt(newval,10);
					newdecvalue = newdecvalue/2;
					hexval = newdecvalue.toString(16);
				}
				deltaobj.push(value1, hexval);
				modifiedWidgets.push(value1);
			}
		});
		if (currentvalue == "ODDNUM") {
			$("#progID").hide();
			alert ("\"Hub MaxPower(Self)\", \"Hub Circuit MaxPower(Self)\", \"HubMaxPower(Bus)\" and \"Hub Circuit MaxPower(Bus)\" fields can have even numbers only");
			var mesg = "Error : \"Hub MaxPower(Self)\", \"Hub Circuit MaxPower(Self)\", \"Hub MaxPower(Bus)\" and \"Hub Circuit MaxPower(Bus)\" fields can have even numbers only";
			update_status_message(mesg);
			currentvalue= "NONE";
			errorFlag = true;
			return;
		}

		//Radio buttons
		$.each(GwidgetlistRadio, function(index2, value1) {
			var widgetgroupname = '#' + value1 +"group";
			var oldval = getWidgetValue(HUB_ID, value1);
			var newval = $(widgetgroupname).find(':checked').val();
			var that = $( widgetgroupname ), parent = that.closest('fieldset');
			var  checkdisabled = $(parent).prop( "disabled" );
			if ((oldval === newval) || jQuery.isEmptyObject(newval))
			{
				// do nothing
			}
			else if (checkdisabled)
			{
				// Change detected but field is disabled - So do nothing
				console.log("change detected but field disabled: widget:" + widgetgroupname + " new value:" + newval);// + " current value:" + val1 + " new value:" + newval1);
			}
			else
			{
				if (value1 == "downstreamBCsettingport1") {
					if (Product == "USB3.1 Gen1") {
						var state = $("#enableport1").is(':checked');
						var valueToAdd;
						if (state) {
							valueToAdd = "1";
						} else {
							valueToAdd = "0";
						}
						deltaobj.push("enableport1", valueToAdd);
						modifiedWidgets.push("enableport1");
						enableprt1 = true;
					}
				}
				
				if (value1 == "downstreamBCsettingport2") {
					if (Product == "USB3.1 Gen1") {
						var state = $("#enableport2").is(':checked');
						var valueToAdd;
						if (state) {
							valueToAdd = "1";
						} else {
							valueToAdd = "0";
						}
						deltaobj.push("enableport2", valueToAdd);
						modifiedWidgets.push("enableport2");
						enableprt2 = true;
					}
				}
				
				if (value1 == "downstreamBCsettingport3") {
					if (Product == "USB3.1 Gen1") {
						var state = $("#enableport3").is(':checked');
						var valueToAdd;
						if (state) {
							valueToAdd = "1";
						} else {
							valueToAdd = "0";
						}
						deltaobj.push("enableport3", valueToAdd);
						modifiedWidgets.push("enableport3");
						enableprt3 = true;
					}
				}
				
				if (value1 == "downstreamBCsettingport4") {
					if (Product == "USB3.1 Gen1") {
						var state = $("#enableport4").is(':checked');
						var valueToAdd;
						if (state) {
							valueToAdd = "1";
						} else {
							valueToAdd = "0";
						}
						deltaobj.push("enableport4", valueToAdd);
						modifiedWidgets.push("enableport4");
						enableprt4 = true;
					}
				}
				console.log("widget" + value1 + " Selected option is " + newval);
				deltaobj.push(value1, newval);
				modifiedWidgets.push(value1);
			}
		});

		//Checkbox
		$.each(GwidgetlistCheckbox, function( index2, value1 ) {
			var widgetid = "#" + value1;
			var oldval = getWidgetValue(HUB_ID, value1);
			var newval = checkbox_unchecked_value;
			var that = $( widgetid ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );
			if($(widgetid).is(':checked'))
			{
				newval = checkbox_checked_value;
			}
			
			// Enabled - check the previous value and determine delta                              
			if (oldval == newval) {
				// do nothing - no change in value
				//console.log("Checkbox:nochange:widget:" + widget1 + " value:" + val1 + " new value:" + newval);
			} else if (checkdisabled) {
				// Change detected but field is disabled - So do nothing
				 console.log("change detected but field disabled: widget:" + value1 + " new value:" + newval);// + " current value:" + val1 + " new value:" + newval);
			} else {
				//Check for Non-removable parameter changes for all downstream port
				if ((value1 == "enableport1") && (!($('#enableport1').is(':checked')))) {
					if ($('#usb3enableport1').is(':checked')) {
						alert("Usb2.0 port of Port1 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port1 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport2") && (!($('#enableport2').is(':checked')))) {
					if ($('#usb3enableport2').is(':checked')) {
						alert("Usb2.0 port of Port2 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port2 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport3") && (!($('#enableport3').is(':checked')))) {
					if ($('#usb3enableport3').is(':checked')) {
						alert("Usb2.0 port of Port3 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port3 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if ((value1 == "enableport4") && (!($('#enableport4').is(':checked')))) {
					if ($('#usb3enableport4').is(':checked')) {
						alert("Usb2.0 port of Port4 cannot be disabled, when USB3.1 GEN 1 port is still in enabled state.");
						update_status_message("Usb2.0 port of Port4 cannot be disabled, when USB3.0 port is still in enabled state.");
						errorFlag = true;
						return;
					}
				}
				
				if (value1 == "nrdeviceport1") {
					nr1Modified = true;
				} 
				if(value1 == "nrdeviceport2") {
					nr2Modified = true;
				} 
				if(value1 == "nrdeviceport3") {
					nr3Modified = true;
				} 
				if(value1 == "nrdeviceport4") {
					nr4Modified = true;
				}
				
				//usb3
				if (value1 == "usb3nrdeviceport1") {
					usb3nr1Modified = true;
				} 
				if(value1 == "usb3nrdeviceport2") {
					usb3nr2Modified = true;
				} 
				if(value1 == "usb3nrdeviceport3") {
					usb3nr3Modified = true;
				} 
				if(value1 == "usb3nrdeviceport4") {
					usb3nr4Modified = true;
				}
					//Check for Flexconnect enable or disable
					if ((value1 == "flexconnect") && (newval == checkbox_checked_value)) {
						enableFlex = true;
						disableFlex = false;
					} else if ((value1 == "flexconnect") && (newval == checkbox_unchecked_value)) {
						enableFlex = false;
						disableFlex = true;
					} else {
						enableFlex = false;
						disableFlex = false;
					}
					
					//Check for Upstream D+/D- swap
					if ((value1 == "swapupstreamdpdm") && (newval == checkbox_checked_value)) {
						enable_swapupstreamdpdm = true;
					} else {
						enable_swapupstreamdpdm = false;
					}

					if (Product == "USB3.1 Gen1") {
					if (!usb3SendNoofPorts && !usb3numberofportState)
					{
						if(($(usb3nrdeviceport1).is(':checked')) || ($(usb3nrdeviceport2).is(':checked')) || ($(usb3nrdeviceport3).is(':checked')) || ($(usb3nrdeviceport4).is(':checked')))
						{
							usb3nrModified = true;
						}
						deltaobj.push("usb3numberofports",usb3bTotal);
						enableMapping = true;
						usb3SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
					}
					
					if (!SendNoofPorts && !numberofportState)
					{
						if(($(nrdeviceport1).is(':checked')) || ($(nrdeviceport2).is(':checked')) || ($(nrdeviceport3).is(':checked')) || ($(nrdeviceport4).is(':checked')))
						{
							usb3nrModified = true;
						}
						deltaobj.push("numberofports",bTotal);
						enableMapping = true;
						SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
					}
				}
					
						

					if(Product == "USB2.0")
					{
							if ((value1 == "enableport1") || (value1 == "enableport2")
								||(value1 == "enableport3") || (value1 == "enableport4")) 
					{
						
						
						if (!SendNoofPorts && !numberofportState)
						{
							if(($(nrdeviceport1).is(':checked')) || ($(nrdeviceport2).is(':checked')) || ($(nrdeviceport3).is(':checked')) || ($(nrdeviceport4).is(':checked')))
							{
								nrModified = true;
							}
							deltaobj.push("numberofports",bTotal);
							SendNoofPorts = 1; // Sent no.of ports enabled one time if there is any change.So no need to send again.
						}
					
					var portCountTomap = 1;
					if( value1 == "enableport1")
					{
						if (oldval === newval) {
							//do nothing
						}
						else if (!port1dontchange)
						{
							//portCountTomap = 1; //Start port number
							if ( newval ==  0)
							{
								deltaobj.push("port1mapping",0);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable2)
								{
									if (!port2dontchange)
									{
										deltaobj.push("port2mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port2dontchange = 1;
										
									}
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									if (!port3dontchange)
									{
										deltaobj.push("port3mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port3dontchange = 1;
										
									}
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									if (!port4dontchange)
									{
										deltaobj.push("port4mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port4dontchange = 1;
									}
								}
							}
							else
							{
								
								deltaobj.push("port1mapping",portCountTomap++);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable2)
								{
									deltaobj.push("port2mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port2dontchange = 1;
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									deltaobj.push("port3mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port3dontchange = 1;
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									deltaobj.push("port4mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port4dontchange = 1;
								}
							}
						} else { // do nothing 
						}
					}
					if( value1 == "enableport2")
					{
						portCountTomap = bEnable1 + 1;  //Start port number
						if (oldval === newval) {
							//do nothing
						}
						else if (!port2dontchange)
						{
							if ( newval ==  0)
							{
								deltaobj.push("port2mapping",0);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									if (!port3dontchange)
									{
										deltaobj.push("port3mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port3dontchange = 1;
									}
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									if (!port4dontchange)
									{
										deltaobj.push("port4mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port4dontchange = 1;
									}
								}
							}
							else
							{
								deltaobj.push("port2mapping",portCountTomap++);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable3)
								{
									deltaobj.push("port3mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port3dontchange = 1;
								}
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									deltaobj.push("port4mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port4dontchange = 1;
								}
							}
						} else { // do nothing
						}
					}
					if( value1 == "enableport3")
					{
						portCountTomap = bEnable1 + bEnable2 + 1;  //Start port number
						if (oldval === newval) {
							//do nothing
						}
						else if (!port3dontchange)
						{		
							if ( newval ==  0)
							{
								deltaobj.push("port3mapping",0);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									if (!port4dontchange)
									{
										deltaobj.push("port4mapping",portCountTomap++);
										//Here setting is done, dont change it again anywhere
										port4dontchange = 1;
									}
								}
							}
							else
							{
								deltaobj.push("port3mapping",portCountTomap++);
								//If next port is available for remap then remap otherwise goto next available port
								if(bEnable4)
								{
									deltaobj.push("port4mapping",portCountTomap++);
									//Here setting is done, dont change it again anywhere
									port4dontchange = 1;
								}
							}
						} else { // Do nothing
						}
					}
					if( value1 == "enableport4")
					{
						portCountTomap = bEnable1 + bEnable2 + bEnable3 + 1;  //Start port number
						console.log("enableport4n" + newval);
						if (oldval === newval) {
							//do nothing
						}
						else if (!port4dontchange)
						{
							if ( newval ==  0)
							{
								//There is no next port for tyler to remap, change directly
								// No need to check for the port whether it is enabled
								// Will get into this only this port is enabled
								deltaobj.push("port4mapping",0);
							}
							else
							{
								// No need to check for the port whether it is enabled
								// Will get into this only this port is enabled
								deltaobj.push("port4mapping",portCountTomap++);
							}
						} else { // Do nothing
						}
					}
				}
			}

					//Check flexconnect condition
					if (enableFlex) { //(value1 == "flexconnect") {
						if ($('#enableport1').is(':checked')) {
							alert("Enabling Flexconnect will swap Downstream port 1 with Upstream port. Please make required changes in hub for further processing after successful programming");
							deltaobj.push("flexconnect", newval);
							modifiedWidgets.push("flexconnect");
						} else {
							alert("Downstream port 1 is disabled. Flex connect cannot be done. \n Enable Downstream port 1 and try again.");
							errorFlag = true;
							return;
						}
					} else if (value1 == "swapupstreamdpdm") {
						if ($('#swapupstreamdpdm').is(':checked')) {
							alert("Programming Upstream swap will swap D+ and D- lines of Upstream port. Please make the required changes in hub for further processing after successful programming");
						}
						deltaobj.push("swapupstreamdpdm", newval);
						modifiedWidgets.push("swapupstreamdpdm");
					} else if (value1 == "cdcenable") {
						if (Product == "USB3.1 Gen1") {
							deltaobj.push(value1, newval);
							modifiedWidgets.push(value1);
						}
					} else {
						deltaobj.push(value1, newval);
						modifiedWidgets.push(value1);
					}
					
					if ((value1 == "hceenable") && (Product == "USB2.0")) {
						deltaobj.push("numberofports", bTotal);
					}
			}
		});

		if(enablealertmanu && enablealertmanu && enablealertmanu) {
			var manuval = $("#hce_manufacturer").val();
			var prodval = $("#hce_product").val();
			var serval = $("#hce_serial").val();
			
			if((manuval != stringnullvalue) && (prodval != stringnullvalue) && (serval != stringnullvalue)) {
				window.alert("Only two strings can be enabled at a time for Hub Feature Controller.");
				update_status_message("Error : Only two strings can be enabled at a time for Hub Feature Controller.");
				enablealertmanu = false;
				enablealertmanu = false;
				enablealertmanu = false;
				hceenablemanu = false;
				hceenableprod = false;
				hceenableser = false;
				hceStringFlag = false;
				errorFlag = true;
				return;
			}
				
		}
		if(hceenablemanu || hceenableprod || hceenableser) {
			var manuval = $("#hce_manufacturer").val();
			var prodval = $("#hce_product").val();
			var serval = $("#hce_serial").val();
			var manlen = manuval.length;
			var prodlen = prodval.length;
			var serlen = serval.length;
			
			
			if(manuval == stringnullvalue) {
				manuval = "";
				manlen = 0;
			} else if(prodval == stringnullvalue) {
				prodval = "";
				prodlen = 0;
			} else if(serval == stringnullvalue) {
				serval = "";
				serlen = 0;
			}
			
			//console.log("Also updating :" + lenwidget + " new value:" + len);
			deltaobj.push("hce_manufacturerlen",manlen);
			deltaobj.push("hce_productlen",prodlen);
			deltaobj.push("hce_seriallen",serlen);
			deltaobj.push("hce_manufacturer", manuval);
			modifiedWidgets.push("hce_manufacturer");
			deltaobj.push("hce_product", prodval);
			modifiedWidgets.push("hce_product");
			deltaobj.push("hce_serial", serval);
			modifiedWidgets.push("hce_serial");
			hceenablemanu = false;
			hceenableprod = false;
			hceenableser = false;
			enablealertmanu = false;
			enablealertmanu = false;
			enablealertmanu = false;
		}
		
		if ((Product == "USB3.1 Gen1") && (enableMapping == true)) {
						
		var usb3portmapcount = 1;
		var usb2portmapcount = 1;
		var usb2port1MapLaterFlag = false;
		var usb2port2MapLaterFlag = false;
		var usb2port3MapLaterFlag = false;
		var usb2port4MapLaterFlag = false;
		var currentStartPoint = 0;

		if(!bEnable1 && !usb3bEnable1)
		{
			deltaobj.push("usb3port1mapping", 0);
			deltaobj.push("port1mapping", 0);
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}


			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			// USB2.0 Port mapping
			
			if (currentStartPoint == 4) {
				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
			}
		} else if (bEnable1 && !usb3bEnable1) {
			deltaobj.push("usb3port1mapping", 0);
			usb2port1MapLaterFlag = true;
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}
			

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			// USB2.0 Port mapping
			
			if (currentStartPoint == 4) {
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
				
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}
				
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
			}
		} else if (bEnable1 && usb3bEnable1) {
			currentStartPoint = 1;
			deltaobj.push("usb3port1mapping", usb3portmapcount++);
			deltaobj.push("port1mapping", usb2portmapcount++);
			
			//Handling port2
			if(bEnable2 && usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				deltaobj.push("port2mapping", usb2portmapcount++);
				currentStartPoint = 2;
			}else if(usb3bEnable2) {
				deltaobj.push("usb3port2mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable2){
				deltaobj.push("usb3port2mapping", 0);
				if(bEnable2) {
					//deltaobj.push("port2mapping", usb2portmapcount++); Must map later
					usb2port2MapLaterFlag = true;
				} else {
					deltaobj.push("port2mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			//handling port3
			if(bEnable3 && usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				deltaobj.push("port3mapping", usb2portmapcount++);
				currentStartPoint = 3;
			}else if(usb3bEnable3) {
				deltaobj.push("usb3port3mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable3){
				deltaobj.push("usb3port3mapping", 0);
				if(bEnable3) {
					usb2port3MapLaterFlag = true;
					//deltaobj.push("port3mapping", usb2portmapcount++); Must map later
				} else {
					deltaobj.push("port3mapping", 0);
				}
			} else {
				//Do nothing
			}
			

			//handling port4
			if(bEnable4 && usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				deltaobj.push("port4mapping", usb2portmapcount++);
				currentStartPoint = 4;
			}else if(usb3bEnable4) {
				deltaobj.push("usb3port4mapping", usb3portmapcount++);
				
			} else if (!usb3bEnable4){
				deltaobj.push("usb3port4mapping", 0);
				if(bEnable4) {
					usb2port4MapLaterFlag = true;
					//deltaobj.push("port4mapping", usb2portmapcount++);Must map Later
				} else {
					deltaobj.push("port4mapping", 0);
				}
			} else {
				//Do nothing
			}
			
			
			// USB2.0 Port mapping
			
			if (currentStartPoint == 4) {
				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
				
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 3) {
				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}

				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}

				if (usb2port2MapLaterFlag) {
					deltaobj.push("port2mapping", usb2portmapcount++);
				}
			}
			
			if (currentStartPoint == 2) {
				if (usb2port3MapLaterFlag) {
					deltaobj.push("port3mapping", usb2portmapcount++);
				}

				if (usb2port4MapLaterFlag) {
					deltaobj.push("port4mapping", usb2portmapcount++);
				}

				if (usb2port1MapLaterFlag) {
					deltaobj.push("port1mapping", usb2portmapcount++);
				}
			}
			
		}
	}
		
		
		//DropDown
		$.each(GwidgetlistDropDown, function(index2, value1) {
			var nameofcontrol = "." + value1 + "1";
			var nameofcontrol1 = "[data-bind=\"" + value1 + "label\"]";
			var selText = $(nameofcontrol).find(nameofcontrol1).text();
			var newindexofdropdownlist;
			var that = $( nameofcontrol ), parent = that.closest('fieldset');
			var checkdisabled = $(parent).prop( "disabled" );

			if (value1 === "DREF")
			{
				$.each(DropDownDREF, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "TREF")
			{
				$.each(DropDownTREF, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "PHYBOOST" || value1 === "PHYBOOSTdownstreamport1" ||
				value1 === "PHYBOOSTdownstreamport2" ||value1 === "PHYBOOSTdownstreamport3" ||
				value1 === "PHYBOOSTdownstreamport4")
			{
				$.each(DropDownPHYBOOST, function(index, valuelist) {
					if ( selText === valuelist)
					{
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "SQUELCH" || value1 === "SQUELCHdownstreamport1" ||
				value1 === "SQUELCHdownstreamport2" ||value1 === "SQUELCHdownstreamport3" ||
				value1 === "SQUELCHdownstreamport4")
			{
				$.each(DropDownSQUELCH, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if(value1 === "upstreamHsRiseFall" || value1 === "downstreamport1HsRiseFall" ||
				value1 === "downstreamport2HsRiseFall" ||value1 === "downstreamport3HsRiseFall" ||
				value1 === "downstreamport4HsRiseFall")
			{
				$.each(DropDownHSRiseFall, function(index, valuelist) {
					if (selText == valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "SLEW" || value1 === "SLEWdownstreamport1" ||
				value1 === "SLEWdownstreamport2" ||value1 === "SLEWdownstreamport3" ||
				value1 === "SLEWdownstreamport4")
			{
				$.each(DropDownSLEW, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			if (value1 === "DOI" || value1 === "DOIdownstreamport1" ||
				value1 === "DOIdownstreamport2" ||value1 === "DOIdownstreamport3" ||
				value1 === "DOIdownstreamport4")
			{
				$.each(DropDownDOI, function(index, valuelist) {
					if ( selText === valuelist)
					{   
						newindexofdropdownlist = index;
					}
				});
			}
			
			var oldval = getWidgetValue(HUB_ID, value1);

			if (newindexofdropdownlist || newindexofdropdownlist == 0) {
				if ((newindexofdropdownlist == oldval))
				{
					// no change
				} else if (checkdisabled) {
					// Change detected but field is disabled - So do nothing
					console.log("change detected but field disabled: widget:" + value1); // + " current value:" + val1 + " new value:" + newindexofdropdownlist);
				} else {
					deltaobj.push(value1, newindexofdropdownlist);
					modifiedWidgets.push(value1);
				}
			}
		});

		//Adding non-removable state of all downstream ports depending on the state of "nrModified"
		if (nrModified) {
			var nr1 = ($("#nrdeviceport1").is(':checked'))?"1":"0";
			var nr2 = ($("#nrdeviceport2").is(':checked'))?"1":"0";
			var nr3 = ($("#nrdeviceport3").is(':checked'))?"1":"0";
			var nr4 = ($("#nrdeviceport4").is(':checked'))?"1":"0";
			
			if(bEnable1 === true )
			{
				if(nr1Modified === false)
				{
					deltaobj.push("nrdeviceport1", nr1);
				}else{
				}
			} else {
				if(nr1Modified === false)
				{
					if (nr1UserModified) {
						modifiedWidgets.push("nrdeviceport1");
					}
					deltaobj.push("nrdeviceport1", 0);
				}else{
				}
			}
			if(bEnable2 === true)
			{
				if(nr2Modified === false)
				{
					deltaobj.push("nrdeviceport2", nr2);
				}else{
				}
			} else {
				if(nr2Modified === false)
				{
					if (nr2UserModified) {
						modifiedWidgets.push("nrdeviceport2");
					}
					deltaobj.push("nrdeviceport2", 0);
				}else{
				}
			}
			if(bEnable3 === true )
			{
				if(nr3Modified === false)
				{
					deltaobj.push("nrdeviceport3", nr3);
				}else{
				}
			} else {
				if(nr3Modified === false)
				{
					if (nr3UserModified) {
						modifiedWidgets.push("nrdeviceport3");
					}
					deltaobj.push("nrdeviceport3", 0);
				}else{
				}
			}
			if(bEnable4 === true )
			{
				if(nr4Modified === false)
				{
					deltaobj.push("nrdeviceport4", nr4);
				}else{
				}
			}else {
				if(nr4Modified === false)
				{
					if (nr4UserModified) {
						modifiedWidgets.push("nrdeviceport4");
					}
					deltaobj.push("nrdeviceport4", 0);
				}else{
				}
			}
			nrModified = false;
			nr1Modified = false;
			nr2Modified = false;
			nr3Modified = false;
			nr4Modified = false;
		}
		
		var stringToSet = "";
		var wKey;
		var wVal;
		var flag = 0;
		
		//for (var i = 0; i < deltaobj.length; i = i + 2) {
		if (deltaobj.length != 0) {
			for (var i = deltaobj.length; i >= 0; i = i - 2) {
				wKey = deltaobj[i];
				wVal = deltaobj[i+1];
				if ((typeof wKey === 'undefined') || (typeof wVal === 'undefined')) {
					// Do nothing
				} else {
					stringToSet = wKey + ",,," + wVal + ";;;" + stringToSet;
					//modifiedWidgets.push(wKey);
					flag++;
				}
			}
		}

		if (iniFile) {
			iniFile_fullPath = getFullPathINI();
			modifiedWidgets.push("xdataprogram");
			stringToSet = "xdataprogram,,," + iniFile_fullPath + ";;;" + stringToSet;
			flag++;
		}
		
		if (($("#Regoperationgroup").find(':checked').val()) && ($("#Regaddress").val()) && ($("#Regvalue").val())) {
			var regOptionChosen = $("#Regoperationgroup").find(':checked').val();
			
			if (typeof regOptionChosen === 'undefined') {
				alert("Please choose an appropriate action under the Direct Register Access.");
				errorFlag = true;
				return;
			}
		
			if(regOptionChosen == 0)
			{
				Regop = "XMODE_WRITE_BYTE";
			}
			else if(regOptionChosen == 1)
			{
				Regop = "XMODE_SET_BITS";
			}
			else if(regOptionChosen == 2)
			{
				Regop = "XMODE_CLEAR_BITS"
			}
			else
			{
				Regop = "";
				//do nothing
			}
			var Regadd = $("#Regaddress").val();
			var isOKAddr = /^[0-9A-Fa-f]{4}$/i.test(Regadd);
			var RegVal = $("#Regvalue").val();
			var newRegVal = RegVal.replace(/\s+/g, "");
			var isOKVal = /^[0-9A-Fa-f]+$/i.test(newRegVal);
			
			if ((Regadd == "") || (RegVal == "")) {
				alert("Either the value of register address or the register value is not entered under the Direct Register Access.");
				errorFlag = true;
				return;
			}
			
			if (!isOKAddr) {
				alert("The Register Address entered under the Direct Register Access must be a 4 digit hexadecimal number.");
				errorFlag = true;
				return;
			}
			
			if (!isOKVal) {
				alert("The Register value entered under the Direct Register Access is not a valid hexadecimal number.");
				errorFlag = true;
				return;
			}
			
			if (isOKAddr && isOKVal) {
				if (Regop.length == 0) {
					alert("Please choose appropriate register operation.");
					errorFlag = true;
					return
				} else {
					if (Regadd && RegVal) {
						if (RegString) {
							RegString = Regop + "+" + Regadd + "+" + newRegVal + "+" + RegString;
						} else {
							RegString = Regop + "+" + Regadd + "+" + newRegVal;
						}
					} else {
						alert("Either Register address or Register value is not added.");
						errorFlag = true;
						return;
					}
				}
			}
		}

		if (RegString) {
			stringToSet = "xdataentry,,," + RegString + ";;;" + stringToSet;
			modifiedWidgets.push("xdataentry");
			flag++;
		}

		// dont call service if no change
		if (showPreview) {
			showPreview = false;
			if (flag != 0) {
				var fileSize = previewSetWidgetValue(HUB_ID, stringToSet);
				//Get Current OTP information
				var info = get_otp_info(HUB_ID);					
				if (info) {
					var otp_info = info.split("###");
					var otpSize = otp_info[0];
					//var ConfigBlockCnt = otp_info[1];
					//var ConfigRemainCnt = otp_info[2];
					//var ProgrammedByteCnt = otp_info[3];

					var previewPercentage = ((fileSize / otpSize) * 100)  + percentage;
					
					//alert("No of bytes to be programmed: " + fileSize + "% of OTP memory to be used: " + previewPercentage.toFixed(2) + "%");
					//$("#previewPrecent").val((previewPercentage).toFixed(2));
					if (Product == "USB3.1 Gen1") {
						$("#progressbarPreview3").css('width',(previewPercentage).toFixed(2) + "%");
						$("#progressbarPreview3").css('color', 'black');
						$("#progressbarPreview3").css({'background-image': 'none','background-color': 'yellow'});
						$("#progressbarPreview3").html("<p align=\"center\">"+ (previewPercentage).toFixed(2) + "%" +"<p>");
					}

					if (Product == "USB2.0") {
						$("#progressbarPreview2").css('width',(previewPercentage).toFixed(2) + "%");
						$("#progressbarPreview2").css('color', 'black');
						$("#progressbarPreview2").css({'background-image': 'none','background-color': 'yellow'});
						$("#progressbarPreview2").html("<p align=\"center\">"+ (previewPercentage).toFixed(2) + "%" +"<p>");
					}

					$("#bytesProgrammed").val(fileSize);
					$('#previewChangesField').show();
					//toggleOverlay();
				}
				update_status_message("No of bytes to be programmed: " + fileSize + ". Percentage of OTP memory to be used: " + previewPercentage.toFixed(2));
			} else {
				alert("No Changes detected. Cannot show preview.");
			}
		} else {
			//alert("99" + errorFlag);
			if (flag == 0 && errorFlag == false)
			{
				 $('#myprogress .progress-bar').css('width', 100+'%').attr('aria-valuenow', 100);
				 //alert("999" + errorFlag);
				/*window.setTimeout(function(){
				 
				}, 500); */
				alert("Device configuration will not be changed ; No changes detected");
				var mesg = "Device configuration will not be changed ; No changes detected";
				update_status_message(mesg);
				//$("#progID").hide();
			} else {
				//alert("100" + errorFlag);
				if(errorFlag === false)
				{
					//alert("101" + errorFlag);
					// Check langid 
					if ((langid == "0") && (stringmodified == 1) )
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}
					// Check udc_langid
					if ((udc_langid == "0") && (udc_stringmodified == 1) )
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "UCH String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "hce_languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}

					if ((usb3langid == "0") && (usb3stringmodified == 1))
					{
						// print to the user that string is modified but language id is not - so english is set as default
						var mesg = "String Descriptors are changed;But languageid is not - So setting language to US English(0x0409). Please change if language is not English";
						update_status_message(mesg);
						var widgetlang = "usb3languageid";
						var englishus ="0x0409";
						stringToSet = widgetlang + ",,," + englishus + ";;;" + stringToSet;
						modifiedWidgets.push(widgetlang);
					}
					
					
					//Take away the hidden widgets from the list before displaying on screen.
					/*$.each(modifiedWidgets, function(index, value) {
						if ((value == "numberofports") || (value == "manufacturerlen") ||
						(value == "hce_manufacturerlen") || (value == "productlen") ||
						(value == "hce_productlen") || (value == "seriallen") ||
						(value == "port1mapping") || (value == "port2mapping") ||
						(value == "port3mapping") || (value == "port4mapping")) {
							// do not add the widget into the display list
						} else {
							widgetsToDisplay.push(value);
						}
					});*/
				
					var displayChange = "";
					for (var i = 0; i < modifiedWidgets.length; i++) {
						if(i%4 == 0)
						{
							if (displayChange) {
								displayChange = "\n" +Mapping[modifiedWidgets[i]] + ", " + displayChange;
							} else {
								displayChange = Mapping[modifiedWidgets[i]];
							}
						} else {
							if (displayChange) {
								displayChange = Mapping[modifiedWidgets[i]] + ", " + displayChange;
							}
						}
					}
					//alert("102");
					nr1Modified = false;
					nr2Modified = false;
					nr3Modified = false;
					nr4Modified = false;
					
					enableprt1 = false;
					enableprt2 = false;
					enableprt3 = false;
					enableprt4 = false;
					var option = confirm("The following device settings will be changed ; Previously created JSON and Configuration files will be removed ; Do you want to continue?\n" + displayChange);
				
					if (option) {
						//alert("103");
						update_status_message("JSON and cfg files will be overwritten; and hub will be programmed with the following.\n " + displayChange);
						var mesg = "Programming in progress...Please wait";
						update_status_message(mesg);
						//$('#ajaxBusy').show();
						$("body").css("cursor", "wait");
						// call the service
						$('#myprogress').show();				
						$('#myprogress .progress-bar').css('width', 20+'%').attr('aria-valuenow', 20);

						var result = setWidgetValue(HUB_ID, stringToSet); // True is an input to JSON generator

						if (result) {
							//alert("104");
							//TODO error handling
							
							var mesg = "Hub is successfully programmed";
							update_status_message(mesg);
							
							//Disable apply and preview buttons before making a java call
							$("#Preview").attr('disabled', true);
							$("#Apply").attr('disabled', true);
							
							$('#myprogress .progress-bar').css('width', 90+'%').attr('aria-valuenow', 90);
							// Change border back to default color from red
							set_changed_fields_border_default();

							var mesg = "Waiting for device reset to finish.....";
							update_status_message(mesg);

							CurrenthubProgrammed = $("#selectedhubinput").val();
							var colonIndex = CurrenthubProgrammed.indexOf(":");
							HUB_ID = "" + CurrenthubProgrammed.charAt(colonIndex + 1);
							
							$('#myprogress .progress-bar').css('width', 100+'%').attr('aria-valuenow',100);

							if (vid_pidModified) {
								update_status_message("Vendor ID/Product ID of USB2.0/Hub controller has been modified...");
								vid_pidModified = false;
								setTimeout(function() {
									// Do something after 5 seconds
									var mesg = "Refreshing Hub List....";
									update_status_message(mesg);
									// refresh hub list and set selected device
									window.setTimeout(function() {
										$('.panel-collapse').each(function () {
											if ($(this).hasClass('in')) {
												$(this).collapse('toggle');
											}
										});
										close_device(HUB_ID);
										refresh();
										get_hub_list_set_hub_index_zero();
										//$('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
										$("#myprogress").hide();
										// Enable apply and preview buttons after programming is done
										$("#Preview").attr('disabled', false);
										$("#Apply").attr('disabled', false);
									},100);
									window.setTimeout(function(){
									  //your code to be executed after 1 seconds
									  $('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
									  $('#myprogress').hide();
									}, 5000);
									$("body").css("cursor", "default");
								}, 15000);
							} else {
								setTimeout(function() {
									// Do something after 5 seconds
									var mesg = "Refreshing Hub List....";
									update_status_message(mesg);
									// refresh hub list and set selected device
									window.setTimeout(function() {
										$('.panel-collapse').each(function () {
											if ($(this).hasClass('in')) {
												$(this).collapse('toggle');
											}
										});
										close_device(HUB_ID);
										refresh();
										get_hub_list_set_hub_index_zero();
										// Enable apply and preview buttons after programming is done
										$("#Preview").attr('disabled', false);
										$("#Apply").attr('disabled', false);
									},100);
									
									window.setTimeout(function(){
									  //your code to be executed after 1 seconds
									  $('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
									  $('#myprogress').hide();
									}, 2000);
									$("body").css("cursor", "default");
								}, 3000);
							}
							
				
						document.getElementById("myForm").reset();
						}
						else {
							errorCode = getMchpUsbLastError(HUB_ID);
							alert(errorMap[Dec2Hex(errorCode)]);
							update_status_message(errorMap[Dec2Hex(errorCode)] + "errorCode: " + errorCode);
							//$('#myprogress .progress-bar').css('width', 0+'%').attr('aria-valuenow', 0);
							$("#myprogress").hide();
						}
					} else {
						update_status_message("Programming of the device was terminated by the user.");
						$("#progID").hide();
					}
				}
				else{}
			}
			//Required clean up action
			iniFile = "";
			RegString = "";
			numberofportState = false;
			errorFlag = false;
		}
		$("body").css("cursor", "default");
		$("#progID").hide();
	};
})(jQuery);

(function ($) {
    set_dropdown_selected_option = function () {
        
        // Ordering is important - dont change code
        // Click of any field in  any drop down menu
        $(document).on('click', '.dropdown li a', function (event) {
            // this code is for making the current selection appear with caret
            var $target = $(event.currentTarget);

            $target.closest('.btn-group')
            .find('[data-bind]').text($target.text())
            .end()
            .children('.dropdown-toggle').dropdown('toggle');
            var selop = $(this).text();
            console.log("Selected Option - All dropdowns:" + selop);
        });

        // Click of Any hub in Select HUB drop down menu
        $(document).on('click', '.dropdown-selecthub li a', function (event) {
			var selop = $(this).text();
			$("#selectedhubinput").val(selop);
			var btnValue = $("#selectedhubinput").val();
			var colonIndex = btnValue.indexOf(":");
			var currentHubSelected = btnValue.charAt(colonIndex + 1);

			if (currentHubSelected == HUB_ID) {
				//$("#progID").show();
				setTimeout(function() {
					//Do nothing as the same hub is selected.
					get_hub_list_set_hub_index_zero();
					//$("#progID").hide();
				}, 200);
			} else {
				//get_hub_list();
				//$("#progID").show();
				setTimeout(function() {
					close_device(HUB_ID);
					refresh();
					HUB_ID = "" + currentHubSelected;
					set_selected_hub_get_widgets();
					//$("#progID").hide();
				}, 200);
			}
			return false;
        });

        // Click of Any sku in Force product drop down menu
        $(document).on('click', '.dropdown-forceproduct li a', function (event) {
            var selop = $(this).text();
            //console.log("Selected Option:" + selop + "hubid:" + GHubId);
            // call the service
            var data = force_part_number(HUB_ID);
            //console.log("Sending request:force_part_number:" + url);
			if (data) {
				var obj = data;
			}
			else {
				window.alert("force_part_number:Failed");
			}
            return false;
        });

        // Phase 2
        // Click of Any sku in Select product drop down menu for offline configuration
        $(document).on('click', '.dropdown-selectproduct li a', function () {
            $('.selectproduct1').text(this.innerHTML);
            var selop = $(this).text();
            console.log("SelectProduct: Selected Option:" + selop);
        });
    };
})(jQuery);